static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * This program is free software: you can redistribute it and/or modify       \n"
" * it under the terms of the GNU General Public License as published by       \n"
" * the Free Software Foundation; either version 3 of the License, or          \n"
" * (at your option) any later version.                                        \n"
" *                                                                            \n"
" * This program is distributed in the hope that it will be useful,            \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              \n"
" * GNU General Public License for more details.                               \n"
" *                                                                            \n"
" * You should have received a copy of the GNU General Public License          \n"
" * along with this program.  If not, see <http://www.gnu.org/licenses/>.      \n"
" *                                                                            \n"
" *                                                                            \n"
" * Exchange one color with the other (settable threshold to convert from      \n"
" * one color-shade to another...might do wonders on certain images, or be     \n"
" * totally useless on others).                                                \n"
" *                                                                            \n"
" * Copyright (C) 1997 Xavier Bouchoux                                         \n"
" *                                                                            \n"
" * GEGL port: Thomas Manni <thomas.manni@free.fr>                             \n"
" *                                                                            \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"#include <math.h>                                                             \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_double (x_scale, _(\"X Scale\"), 15.0000)                            \n"
"    description (_(\"Scale value for x axis\"))                               \n"
"    value_range (0.0001, G_MAXDOUBLE)                                         \n"
"    ui_range    (0.0001, 100.0000)                                            \n"
"    ui_meta     (\"unit\", \"pixel-distance\")                                \n"
"    ui_meta     (\"axis\", \"x\")                                             \n"
"                                                                              \n"
"property_double (y_scale, _(\"Y Scale\"), 15.0)                               \n"
"    description (_(\"Scale value for y axis\"))                               \n"
"    value_range (0.0001, G_MAXDOUBLE)                                         \n"
"    ui_range    (0.0001, 100.0000)                                            \n"
"    ui_meta     (\"unit\", \"pixel-distance\")                                \n"
"    ui_meta     (\"axis\", \"y\")                                             \n"
"                                                                              \n"
"property_double (complexity, _(\"Complexity\"), 1.0)                          \n"
"    description (_(\"Complexity factor\"))                                    \n"
"    value_range (0.0, 15.0)                                                   \n"
"                                                                              \n"
"property_seed (seed, _(\"Random seed\"), rand)                                \n"
"                                                                              \n"
"property_boolean (tiling, _(\"Force tiling\"), TRUE)                          \n"
"    description (_(\"If set, the pattern generated will tile\"))              \n"
"                                                                              \n"
"property_boolean (perturbation, _(\"Distorted\"), TRUE)                       \n"
"    description (_(\"If set, the pattern will be a little more distorted\"))  \n"
"                                                                              \n"
"property_color  (color1, _(\"Color 1\"), \"yellow\")                          \n"
"                                                                              \n"
"property_color  (color2, _(\"Color 2\"), \"blue\")                            \n"
"                                                                              \n"
"enum_start (gegl_sinus_blend)                                                 \n"
"  enum_value (GEGL_SINUS_BLEND_LINEAR , \"linear\",   N_(\"Linear\"))         \n"
"  enum_value (GEGL_SINUS_BLEND_BILINEAR , \"bilinear\", N_(\"Bilinear\"))     \n"
"  enum_value (GEGL_SINUS_BLEND_SINUSOIDAL, \"sinusoidal\", N_(\"Sinusoidal\"))\n"
"enum_end (GeglSinusBlend)                                                     \n"
"                                                                              \n"
"property_enum (blend_mode, _(\"Blend Mode\"),                                 \n"
"    GeglSinusBlend, gegl_sinus_blend,                                         \n"
"    GEGL_SINUS_BLEND_SINUSOIDAL)                                              \n"
"                                                                              \n"
"property_double (blend_power, _(\"Exponent\"), 0.0)                           \n"
"    description (_(\"Power used to strech the blend\"))                       \n"
"    value_range (-7.5, 7.5)                                                   \n"
"                                                                              \n"
"property_int    (width, _(\"Width\"), 1024)                                   \n"
"    description (_(\"Width of the generated buffer\"))                        \n"
"    value_range (0, G_MAXINT)                                                 \n"
"    ui_range    (0, 4096)                                                     \n"
"    ui_meta     (\"unit\", \"pixel-distance\")                                \n"
"    ui_meta     (\"axis\", \"x\")                                             \n"
"    ui_meta     (\"role\", \"output-extent\")                                 \n"
"                                                                              \n"
"property_int    (height, _(\"Height\"), 768)                                  \n"
"    description (_(\"Height of the generated buffer\"))                       \n"
"    value_range (0, G_MAXINT)                                                 \n"
"    ui_range    (0, 4096)                                                     \n"
"    ui_meta     (\"unit\", \"pixel-distance\")                                \n"
"    ui_meta     (\"axis\", \"y\")                                             \n"
"    ui_meta     (\"role\", \"output-extent\")                                 \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_POINT_RENDER                                                  \n"
"#define GEGL_OP_NAME     sinus                                                \n"
"#define GEGL_OP_C_SOURCE sinus.c                                              \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"#define ROUND(x) ((int) ((x) + 0.5))                                          \n"
"                                                                              \n"
"typedef struct                                                                \n"
"{                                                                             \n"
"  gdouble c11, c12, c13, c21, c22, c23, c31, c32, c33;                        \n"
"  gdouble (*blend) (gdouble);                                                 \n"
"  gfloat  color[4];                                                           \n"
"  gfloat  dcolor[4];                                                          \n"
"} SParamsType;                                                                \n"
"                                                                              \n"
"static gdouble                                                                \n"
"linear (gdouble v)                                                            \n"
"{                                                                             \n"
"  gdouble a = v - (gint) v;                                                   \n"
"                                                                              \n"
"  return (a < 0 ? 1.0 + a : a);                                               \n"
"}                                                                             \n"
"                                                                              \n"
"static gdouble                                                                \n"
"bilinear (gdouble v)                                                          \n"
"{                                                                             \n"
"  double a = v - (int) v;                                                     \n"
"                                                                              \n"
"  a = (a < 0 ? 1.0 + a : a);                                                  \n"
"  return (a > 0.5 ? 2 - 2 * a : 2 * a);                                       \n"
"}                                                                             \n"
"                                                                              \n"
"static gdouble                                                                \n"
"cosinus (gdouble v)                                                           \n"
"{                                                                             \n"
"  return 0.5 - 0.5 * sin ((v + 0.25) * G_PI * 2);                             \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare_coef (GeglProperties *o)                                              \n"
"{                                                                             \n"
"  SParamsType *params;                                                        \n"
"  GRand       *gr;                                                            \n"
"  gfloat       color[4];                                                      \n"
"  gdouble      scalex = o->x_scale;                                           \n"
"  gdouble      scaley = o->y_scale;                                           \n"
"                                                                              \n"
"  params = (SParamsType *) o->user_data;                                      \n"
"                                                                              \n"
"  gr = g_rand_new_with_seed (o->seed);                                        \n"
"                                                                              \n"
"  switch (o->blend_mode)                                                      \n"
"    {                                                                         \n"
"    case GEGL_SINUS_BLEND_BILINEAR:                                           \n"
"      params->blend = bilinear;                                               \n"
"      break;                                                                  \n"
"    case GEGL_SINUS_BLEND_SINUSOIDAL:                                         \n"
"      params->blend = cosinus;                                                \n"
"      break;                                                                  \n"
"    case GEGL_SINUS_BLEND_LINEAR:                                             \n"
"    default:                                                                  \n"
"      params->blend = linear;                                                 \n"
"    }                                                                         \n"
"                                                                              \n"
"  if (! o->perturbation)                                                      \n"
"    {                                                                         \n"
"      /* Presumably the 0 * g_rand_int ()s are to pop random                  \n"
"       * values off the prng, I don't see why though. */                      \n"
"      params->c11= 0 * g_rand_int (gr);                                       \n"
"      params->c12= g_rand_double_range (gr, -1, 1) * scaley;                  \n"
"      params->c13= g_rand_double_range (gr, 0, 2 * G_PI);                     \n"
"      params->c21= 0 * g_rand_int (gr);                                       \n"
"      params->c22= g_rand_double_range (gr, -1, 1)  * scaley;                 \n"
"      params->c23= g_rand_double_range (gr, 0, 2 * G_PI);                     \n"
"      params->c31= g_rand_double_range (gr, -1, 1) * scalex;                  \n"
"      params->c32= 0 * g_rand_int (gr);                                       \n"
"      params->c33= g_rand_double_range (gr, 0, 2 * G_PI);                     \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      params->c11= g_rand_double_range (gr, -1, 1) * scalex;                  \n"
"      params->c12= g_rand_double_range (gr, -1, 1) * scaley;                  \n"
"      params->c13= g_rand_double_range (gr, 0, 2 * G_PI);                     \n"
"      params->c21= g_rand_double_range (gr, -1, 1) * scalex;                  \n"
"      params->c22= g_rand_double_range (gr, -1, 1) * scaley;                  \n"
"      params->c23= g_rand_double_range (gr, 0, 2 * G_PI);                     \n"
"      params->c31= g_rand_double_range (gr, -1, 1) * scalex;                  \n"
"      params->c32= g_rand_double_range (gr, -1, 1) * scaley;                  \n"
"      params->c33= g_rand_double_range (gr, 0, 2 * G_PI);                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  if (o->tiling)                                                              \n"
"    {                                                                         \n"
"      params->c11 = ROUND (params->c11 / (2 * G_PI)) * 2 * G_PI;              \n"
"      params->c12 = ROUND (params->c12 / (2 * G_PI)) * 2 * G_PI;              \n"
"      params->c21 = ROUND (params->c21 / (2 * G_PI)) * 2 * G_PI;              \n"
"      params->c22 = ROUND (params->c22 / (2 * G_PI)) * 2 * G_PI;              \n"
"      params->c31 = ROUND (params->c31 / (2 * G_PI)) * 2 * G_PI;              \n"
"      params->c32 = ROUND (params->c32 / (2 * G_PI)) * 2 * G_PI;              \n"
"    }                                                                         \n"
"                                                                              \n"
"  gegl_color_get_pixel (o->color1, babl_format (\"R'G'B'A float\"),           \n"
"                        &(params->color));                                    \n"
"                                                                              \n"
"  gegl_color_get_pixel (o->color2, babl_format (\"R'G'B'A float\"),           \n"
"                        &color);                                              \n"
"                                                                              \n"
"  params->dcolor[0] = color[0] - params->color[0];                            \n"
"  params->dcolor[1] = color[1] - params->color[1];                            \n"
"  params->dcolor[2] = color[2] - params->color[2];                            \n"
"  params->dcolor[3] = color[3] - params->color[3];                            \n"
"                                                                              \n"
"  g_rand_free (gr);                                                           \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"                                                                              \n"
"  if (o->user_data == NULL)                                                   \n"
"    o->user_data = g_slice_new0 (SParamsType);                                \n"
"                                                                              \n"
"  prepare_coef (o);                                                           \n"
"                                                                              \n"
"  gegl_operation_set_format (operation, \"output\", babl_format (\"R'G'B'A float\"));\n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_bounding_box (GeglOperation *operation)                                   \n"
"{                                                                             \n"
"  return gegl_rectangle_infinite_plane ();                                    \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         void                *out_buf,                                        \n"
"         glong                n_pixels,                                       \n"
"         const GeglRectangle *roi,                                            \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o      = GEGL_PROPERTIES (operation);                       \n"
"  SParamsType    *p;                                                          \n"
"  gint     i, j;                                                              \n"
"  gdouble  x, y, grey;                                                        \n"
"  gdouble  pow_exp;                                                           \n"
"  gfloat   *dest = out_buf;                                                   \n"
"                                                                              \n"
"  p = (SParamsType *) o->user_data;                                           \n"
"                                                                              \n"
"  pow_exp = exp (o->blend_power);                                             \n"
"                                                                              \n"
"  for (j = roi->y; j < roi->y + roi->height; j++)                             \n"
"    {                                                                         \n"
"      y = ((gdouble) j) / o->height;                                          \n"
"      for (i = roi->x; i < roi->x + roi->width; i++)                          \n"
"        {                                                                     \n"
"          gdouble c;                                                          \n"
"                                                                              \n"
"          x = ((gdouble) i) / o->width;                                       \n"
"                                                                              \n"
"          c = 0.5 * sin(p->c31 * x + p->c32 * y + p->c33);                    \n"
"                                                                              \n"
"          grey = sin (p->c11 * x + p->c12 * y + p->c13) *                     \n"
"                   (0.5 + 0.5 * c) +                                          \n"
"                   sin (p->c21 * x + p->c22 * y + p->c23) *                   \n"
"                   (0.5 - 0.5 * c);                                           \n"
"                                                                              \n"
"          grey = pow (p->blend (o->complexity * (0.5 + 0.5 * grey)), pow_exp);\n"
"                                                                              \n"
"          dest[0] = p->color[0] + grey * p->dcolor[0];                        \n"
"          dest[1] = p->color[1] + grey * p->dcolor[1];                        \n"
"          dest[2] = p->color[2] + grey * p->dcolor[2];                        \n"
"          dest[3] = p->color[3] + grey * p->dcolor[3];                        \n"
"                                                                              \n"
"          dest += 4;                                                          \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"finalize (GObject *object)                                                    \n"
"{                                                                             \n"
"  GeglOperation  *op = (void*) object;                                        \n"
"  GeglProperties *o  = GEGL_PROPERTIES (op);                                  \n"
"                                                                              \n"
"  if (o->user_data)                                                           \n"
"    {                                                                         \n"
"      g_slice_free (SParamsType, o->user_data);                               \n"
"      o->user_data = NULL;                                                    \n"
"    }                                                                         \n"
"                                                                              \n"
"  G_OBJECT_CLASS (gegl_op_parent_class)->finalize (object);                   \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GObjectClass                  *object_class;                                \n"
"  GeglOperationClass            *operation_class;                             \n"
"  GeglOperationPointRenderClass *point_render_class;                          \n"
"                                                                              \n"
"  object_class       = G_OBJECT_CLASS (klass);                                \n"
"  operation_class    = GEGL_OPERATION_CLASS (klass);                          \n"
"  point_render_class = GEGL_OPERATION_POINT_RENDER_CLASS (klass);             \n"
"                                                                              \n"
"  object_class->finalize = finalize;                                          \n"
"                                                                              \n"
"  point_render_class->process = process;                                      \n"
"                                                                              \n"
"  operation_class->get_bounding_box = get_bounding_box;                       \n"
"  operation_class->prepare = prepare;                                         \n"
"  operation_class->opencl_support = FALSE;                                    \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",               \"gegl:sinus\",                                   \n"
"    \"title\",              _(\"Sinus\"),                                     \n"
"    \"categories\",         \"render\",                                       \n"
"    \"position-dependent\", \"true\",                                         \n"
"    \"license\",            \"GPL3+\",                                        \n"
"    \"description\",        _(\"Generate complex sinusoidal textures\"),      \n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
