static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright (C) 1997 Lauri Alanko <la@iki.fi>                                \n"
" * Copyright 2011 Robert Sasu (sasu.robert@gmail.com)                         \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_double (a1, _(\"(1,1)\"), 0.0)                                       \n"
"property_double (a2, _(\"(1,2)\"), 0.0)                                       \n"
"property_double (a3, _(\"(1,3)\"), 0.0)                                       \n"
"property_double (a4, _(\"(1,4)\"), 0.0)                                       \n"
"property_double (a5, _(\"(1,5)\"), 0.0)                                       \n"
"property_double (b1, _(\"(2,1)\"), 0.0)                                       \n"
"property_double (b2, _(\"(2,2)\"), 0.0)                                       \n"
"property_double (b3, _(\"(2,3)\"), 0.0)                                       \n"
"property_double (b4, _(\"(2,4)\"), 0.0)                                       \n"
"property_double (b5, _(\"(2,5)\"), 0.0)                                       \n"
"property_double (c1, _(\"(3,1)\"), 0.0)                                       \n"
"property_double (c2, _(\"(3,2)\"), 0.0)                                       \n"
"property_double (c3, _(\"(3,3)\"), 1.0)                                       \n"
"property_double (c4, _(\"(3,4)\"), 0.0)                                       \n"
"property_double (c5, _(\"(3,5)\"), 0.0)                                       \n"
"property_double (d1, _(\"(4,1)\"), 0.0)                                       \n"
"property_double (d2, _(\"(4,2)\"), 0.0)                                       \n"
"property_double (d3, _(\"(4,3)\"), 0.0)                                       \n"
"property_double (d4, _(\"(4,4)\"), 0.0)                                       \n"
"property_double (d5, _(\"(4,5)\"), 0.0)                                       \n"
"property_double (e1, _(\"(5,1)\"), 0.0)                                       \n"
"property_double (e2, _(\"(5,2)\"), 0.0)                                       \n"
"property_double (e3, _(\"(5,3)\"), 0.0)                                       \n"
"property_double (e4, _(\"(5,4)\"), 0.0)                                       \n"
"property_double (e5, _(\"(5,5)\"), 0.0)                                       \n"
"                                                                              \n"
"property_double (divisor, _(\"Divisor\"), 1.0)                                \n"
"    ui_range    (-1000.0, 1000.0)                                             \n"
"                                                                              \n"
"property_double (offset, _(\"Offset\"), 0.0)                                  \n"
"    value_range (-1.0, 1.0)                                                   \n"
"                                                                              \n"
"property_boolean (red,   _(\"Red channel\"),   TRUE)                          \n"
"property_boolean (green, _(\"Green channel\"), TRUE)                          \n"
"property_boolean (blue,  _(\"Blue channel\"),  TRUE)                          \n"
"property_boolean (alpha, _(\"Alpha channel\"), TRUE)                          \n"
"                                                                              \n"
"property_boolean (normalize,    _(\"Normalize\"),       TRUE)                 \n"
"property_boolean (alpha_weight, _(\"Alpha-weighting\"), TRUE)                 \n"
"                                                                              \n"
"property_enum (border, _(\"Border\"),                                         \n"
"               GeglAbyssPolicy, gegl_abyss_policy,                            \n"
"               GEGL_ABYSS_CLAMP)                                              \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_AREA_FILTER                                                   \n"
"#define GEGL_OP_NAME     convolution_matrix                                   \n"
"#define GEGL_OP_C_SOURCE convolution-matrix.c                                 \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include <math.h>                                                             \n"
"#include <stdio.h>                                                            \n"
"                                                                              \n"
"#define MAX_MATRIX_SIZE 5                                                     \n"
"                                                                              \n"
"static gboolean                                                               \n"
"enough_with_3x3 (GeglProperties *o)                                           \n"
"{                                                                             \n"
"  if (o->a1 == 0.0 &&                                                         \n"
"      o->a2 == 0.0 &&                                                         \n"
"      o->a3 == 0.0 &&                                                         \n"
"      o->a4 == 0.0 &&                                                         \n"
"      o->a5 == 0.0 &&                                                         \n"
"      o->b1 == 0.0 &&                                                         \n"
"      o->b5 == 0.0 &&                                                         \n"
"      o->c1 == 0.0 &&                                                         \n"
"      o->c5 == 0.0 &&                                                         \n"
"      o->d1 == 0.0 &&                                                         \n"
"      o->d5 == 0.0 &&                                                         \n"
"      o->e1 == 0.0 &&                                                         \n"
"      o->e2 == 0.0 &&                                                         \n"
"      o->e3 == 0.0 &&                                                         \n"
"      o->e4 == 0.0 &&                                                         \n"
"      o->e5 == 0.0)                                                           \n"
"  {                                                                           \n"
"    return TRUE;                                                              \n"
"  }                                                                           \n"
"  return FALSE;                                                               \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  GeglOperationAreaFilter *op_area = GEGL_OPERATION_AREA_FILTER (operation);  \n"
"                                                                              \n"
"  GeglProperties          *o       = GEGL_PROPERTIES (operation);             \n"
"  if (enough_with_3x3 (o))                                                    \n"
"    op_area->left = op_area->right = op_area->top = op_area->bottom = 1; /* 3 */\n"
"  else                                                                        \n"
"    op_area->left = op_area->right = op_area->top = op_area->bottom = 2; /* 5 */\n"
"                                                                              \n"
"  gegl_operation_set_format (operation, \"output\",                           \n"
"                             babl_format (\"RGBA float\"));                   \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"make_matrix (GeglProperties  *o,                                              \n"
"             gfloat           matrix[MAX_MATRIX_SIZE][MAX_MATRIX_SIZE],       \n"
"             gint             matrix_size)                                    \n"
"{                                                                             \n"
"  if (matrix_size == 3)                                                       \n"
"  {                                                                           \n"
"    matrix[0][0] = o->b2;                                                     \n"
"    matrix[0][1] = o->b3;                                                     \n"
"    matrix[0][2] = o->b4;                                                     \n"
"                                                                              \n"
"    matrix[1][0] = o->c2;                                                     \n"
"    matrix[1][1] = o->c3;                                                     \n"
"    matrix[1][2] = o->c4;                                                     \n"
"                                                                              \n"
"    matrix[2][0] = o->d2;                                                     \n"
"    matrix[2][1] = o->d3;                                                     \n"
"    matrix[2][2] = o->d4;                                                     \n"
"  }                                                                           \n"
"  else                                                                        \n"
"  {                                                                           \n"
"    matrix[0][0] = o->a1;                                                     \n"
"    matrix[0][1] = o->a2;                                                     \n"
"    matrix[0][2] = o->a3;                                                     \n"
"    matrix[0][3] = o->a4;                                                     \n"
"    matrix[0][4] = o->a5;                                                     \n"
"                                                                              \n"
"    matrix[1][0] = o->b1;                                                     \n"
"    matrix[1][1] = o->b2;                                                     \n"
"    matrix[1][2] = o->b3;                                                     \n"
"    matrix[1][3] = o->b4;                                                     \n"
"    matrix[1][4] = o->b5;                                                     \n"
"                                                                              \n"
"    matrix[2][0] = o->c1;                                                     \n"
"    matrix[2][1] = o->c2;                                                     \n"
"    matrix[2][2] = o->c3;                                                     \n"
"    matrix[2][3] = o->c4;                                                     \n"
"    matrix[2][4] = o->c5;                                                     \n"
"                                                                              \n"
"    matrix[3][0] = o->d1;                                                     \n"
"    matrix[3][1] = o->d2;                                                     \n"
"    matrix[3][2] = o->d3;                                                     \n"
"    matrix[3][3] = o->d4;                                                     \n"
"    matrix[3][4] = o->d5;                                                     \n"
"                                                                              \n"
"    matrix[4][0] = o->e1;                                                     \n"
"    matrix[4][1] = o->e2;                                                     \n"
"    matrix[4][2] = o->e3;                                                     \n"
"    matrix[4][3] = o->e4;                                                     \n"
"    matrix[4][4] = o->e5;                                                     \n"
"  }                                                                           \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"normalize_o (GeglProperties  *o,                                              \n"
"             gfloat           matrix[MAX_MATRIX_SIZE][MAX_MATRIX_SIZE],       \n"
"             gint             matrix_size)                                    \n"
"{                                                                             \n"
"  gint      x, y;                                                             \n"
"  gboolean  valid = FALSE;                                                    \n"
"  gfloat    sum   = 0.0;                                                      \n"
"                                                                              \n"
"  for (y = 0; y < matrix_size; y++)                                           \n"
"    for (x = 0; x < matrix_size; x++)                                         \n"
"      {                                                                       \n"
"        sum += matrix[x][y];                                                  \n"
"        if (matrix[x][y] != 0.0)                                              \n"
"          valid = TRUE;                                                       \n"
"      }                                                                       \n"
"                                                                              \n"
"  if (sum > 0)                                                                \n"
"    {                                                                         \n"
"      o->offset  = 0.0;                                                       \n"
"      o->divisor = sum;                                                       \n"
"    }                                                                         \n"
"  else if (sum < 0)                                                           \n"
"    {                                                                         \n"
"      o->offset  = 1.0;                                                       \n"
"      o->divisor = -sum;                                                      \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      o->offset  = 0.5;                                                       \n"
"      o->divisor = 1;                                                         \n"
"    }                                                                         \n"
"                                                                              \n"
"  return valid;                                                               \n"
"}                                                                             \n"
"                                                                              \n"
"static void inline                                                            \n"
"convolve_pixel_componentwise (GeglProperties       *o,                        \n"
"                gfloat               *src_buf,                                \n"
"                gfloat               *dst_buf,                                \n"
"                const GeglRectangle  *result,                                 \n"
"                const GeglRectangle  *extended,                               \n"
"                gfloat                matrix[MAX_MATRIX_SIZE][MAX_MATRIX_SIZE],\n"
"                gint                  matrix_size,                            \n"
"                gint                  d_offset,                               \n"
"                gint                  ss_offset,                              \n"
"                gint                  xx,                                     \n"
"                gint                  yy,                                     \n"
"                gfloat                matrixsum,                              \n"
"                gfloat                inv_divisor)                            \n"
"{                                                                             \n"
"  gint   i;                                                                   \n"
"  gint   s_stride = (extended->width - matrix_size) * 4;                      \n"
"  for (i = 0; i < 4; i++)                                                     \n"
"    {                                                                         \n"
"      gfloat sum = 0.0;                                                       \n"
"      gint s_offset = ss_offset;                                              \n"
"                                                                              \n"
"      if ((i == 0 && o->red)   ||                                             \n"
"          (i == 1 && o->blue)  ||                                             \n"
"          (i == 2 && o->green) ||                                             \n"
"          (i == 3 && o->alpha))                                               \n"
"        {                                                                     \n"
"          gint x, y;                                                          \n"
"          for (y = 0; y < matrix_size; y++)                                   \n"
"          {                                                                   \n"
"            for (x = 0; x < matrix_size; x++)                                 \n"
"              {                                                               \n"
"                sum += matrix[x][y] * src_buf[s_offset + i];                  \n"
"                s_offset += 4;                                                \n"
"              }                                                               \n"
"            s_offset += s_stride;                                             \n"
"          }                                                                   \n"
"          sum = sum * inv_divisor;                                            \n"
"          sum += o->offset;                                                   \n"
"          dst_buf[d_offset + i] = sum;                                        \n"
"        }                                                                     \n"
"      else                                                                    \n"
"        {                                                                     \n"
"          dst_buf[d_offset + i] = src_buf[s_offset + i];                      \n"
"        }                                                                     \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static void inline                                                            \n"
"convolve_pixel (GeglProperties       *o,                                      \n"
"                gfloat               *src_buf,                                \n"
"                gfloat               *dst_buf,                                \n"
"                const GeglRectangle  *result,                                 \n"
"                const GeglRectangle  *extended,                               \n"
"                gfloat                matrix[MAX_MATRIX_SIZE][MAX_MATRIX_SIZE],\n"
"                gint                  matrix_size,                            \n"
"                gint                  d_offset,                               \n"
"                gint                  ss_offset,                              \n"
"                gint                  xx,                                     \n"
"                gint                  yy,                                     \n"
"                gfloat                matrixsum,                              \n"
"                gfloat                inv_divisor)                            \n"
"{                                                                             \n"
"  gint   i;                                                                   \n"
"  gint   s_stride = (extended->width - matrix_size) * 4;                      \n"
"  for (i = 0; i < 4; i++)                                                     \n"
"    {                                                                         \n"
"      gfloat sum = 0.0;                                                       \n"
"      gint s_offset = ss_offset;                                              \n"
"      gint x, y;                                                              \n"
"      for (y = 0; y < matrix_size; y++)                                       \n"
"      {                                                                       \n"
"        for (x = 0; x < matrix_size; x++)                                     \n"
"          {                                                                   \n"
"            sum += matrix[x][y] * src_buf[s_offset + i];                      \n"
"            s_offset += 4;                                                    \n"
"          }                                                                   \n"
"        s_offset += s_stride;                                                 \n"
"      }                                                                       \n"
"      sum = sum * inv_divisor;                                                \n"
"      sum += o->offset;                                                       \n"
"      dst_buf[d_offset + i] = sum;                                            \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static void inline                                                            \n"
"convolve_pixel_alpha_weight (GeglProperties       *o,                         \n"
"                             gfloat               *src_buf,                   \n"
"                             gfloat               *dst_buf,                   \n"
"                             const GeglRectangle  *result,                    \n"
"                             const GeglRectangle  *extended,                  \n"
"                             gfloat                matrix[MAX_MATRIX_SIZE][MAX_MATRIX_SIZE],\n"
"                             gint                  matrix_size,               \n"
"                             gint                  d_offset,                  \n"
"                             gint                  ss_offset,                 \n"
"                             gint                  xx,                        \n"
"                             gint                  yy,                        \n"
"                             gfloat                matrixsum,                 \n"
"                             gfloat                inv_divisor)               \n"
"{                                                                             \n"
"  gint   i;                                                                   \n"
"  gint   s_stride = (extended->width - matrix_size) * 4;                      \n"
"                                                                              \n"
"  for (i = 0; i < 3; i++)                                                     \n"
"    {                                                                         \n"
"      gfloat sum      = 0.0;                                                  \n"
"      gint   s_offset = ss_offset;                                            \n"
"      gint x, y;                                                              \n"
"      for (y = 0; y < matrix_size; y++)                                       \n"
"      {                                                                       \n"
"        for (x = 0; x < matrix_size; x++)                                     \n"
"          {                                                                   \n"
"            sum += matrix[x][y] * src_buf[s_offset + i] * src_buf[s_offset + 3];\n"
"            s_offset += 4;                                                    \n"
"          }                                                                   \n"
"        s_offset += s_stride;                                                 \n"
"      }                                                                       \n"
"      sum = sum * inv_divisor + o->offset;                                    \n"
"      dst_buf[d_offset + i] = sum;                                            \n"
"    }                                                                         \n"
"    {                                                                         \n"
"      gfloat sum      = 0.0;                                                  \n"
"      gfloat alphasum = 0.0;                                                  \n"
"      gint   s_offset = ss_offset;                                            \n"
"      gint x, y;                                                              \n"
"                                                                              \n"
"      for (y = 0; y < matrix_size; y++)                                       \n"
"      {                                                                       \n"
"        for (x = 0; x < matrix_size; x++)                                     \n"
"          {                                                                   \n"
"            float val = matrix[x][y] * src_buf[s_offset + i];                 \n"
"            sum += val;                                                       \n"
"            alphasum += fabsf (val);                                          \n"
"            s_offset += 4;                                                    \n"
"          }                                                                   \n"
"        s_offset += s_stride;                                                 \n"
"      }                                                                       \n"
"                                                                              \n"
"      if (alphasum > 0.0)                                                     \n"
"      {                                                                       \n"
"        sum = sum * inv_divisor;                                              \n"
"        sum = sum * matrixsum / alphasum + o->offset;                         \n"
"      }                                                                       \n"
"      else                                                                    \n"
"        sum = o->offset;                                                      \n"
"      dst_buf[d_offset + i] = sum;                                            \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static void inline                                                            \n"
"convolve_pixel_alpha_weight_componentwise (GeglProperties       *o,           \n"
"                             gfloat               *src_buf,                   \n"
"                             gfloat               *dst_buf,                   \n"
"                             const GeglRectangle  *result,                    \n"
"                             const GeglRectangle  *extended,                  \n"
"                             gfloat                matrix[MAX_MATRIX_SIZE][MAX_MATRIX_SIZE],\n"
"                             gint                  matrix_size,               \n"
"                             gint                  d_offset,                  \n"
"                             gint                  ss_offset,                 \n"
"                             gint                  xx,                        \n"
"                             gint                  yy,                        \n"
"                             gfloat                matrixsum,                 \n"
"                             gfloat                inv_divisor)               \n"
"{                                                                             \n"
"  gint   i;                                                                   \n"
"  gint   s_stride = (extended->width - matrix_size) * 4;                      \n"
"                                                                              \n"
"  for (i = 0; i < 3; i++)                                                     \n"
"    {                                                                         \n"
"      gfloat sum      = 0.0;                                                  \n"
"      gint   s_offset = ss_offset;                                            \n"
"                                                                              \n"
"      if ((i == 0 && o->red)   ||                                             \n"
"          (i == 1 && o->blue)  ||                                             \n"
"          (i == 2 && o->green))                                               \n"
"        {                                                                     \n"
"          gint x, y;                                                          \n"
"          for (y = 0; y < matrix_size; y++)                                   \n"
"          {                                                                   \n"
"            for (x = 0; x < matrix_size; x++)                                 \n"
"              {                                                               \n"
"                sum += matrix[x][y] * src_buf[s_offset + i] * src_buf[s_offset + 3];\n"
"                s_offset += 4;                                                \n"
"              }                                                               \n"
"            s_offset += s_stride;                                             \n"
"          }                                                                   \n"
"          sum = sum * inv_divisor + o->offset;                                \n"
"        }                                                                     \n"
"      else                                                                    \n"
"        {                                                                     \n"
"          sum = src_buf[s_offset + i];                                        \n"
"        }                                                                     \n"
"      dst_buf[d_offset + i] = sum;                                            \n"
"    }                                                                         \n"
"    {                                                                         \n"
"      gfloat sum      = 0.0;                                                  \n"
"      gfloat alphasum = 0.0;                                                  \n"
"      gint   s_offset = ss_offset;                                            \n"
"                                                                              \n"
"      if (o->alpha)                                                           \n"
"        {                                                                     \n"
"          gint x, y;                                                          \n"
"                                                                              \n"
"          for (y = 0; y < matrix_size; y++)                                   \n"
"          {                                                                   \n"
"            for (x = 0; x < matrix_size; x++)                                 \n"
"              {                                                               \n"
"                float val = matrix[x][y] * src_buf[s_offset + i];             \n"
"                sum += val;                                                   \n"
"                alphasum += fabsf (val);                                      \n"
"                s_offset += 4;                                                \n"
"              }                                                               \n"
"            s_offset += s_stride;                                             \n"
"          }                                                                   \n"
"                                                                              \n"
"                                                                              \n"
"          if (alphasum != 0)                                                  \n"
"          {                                                                   \n"
"            sum = sum * inv_divisor;                                          \n"
"            sum = sum * matrixsum / alphasum + o->offset;                     \n"
"          }                                                                   \n"
"          else                                                                \n"
"            sum = o->offset;                                                  \n"
"        }                                                                     \n"
"      else                                                                    \n"
"        {                                                                     \n"
"          sum = src_buf[s_offset + i];                                        \n"
"        }                                                                     \n"
"      dst_buf[d_offset + i] = sum;                                            \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *input,                                          \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties          *o       = GEGL_PROPERTIES (operation);             \n"
"  GeglOperationAreaFilter *op_area = GEGL_OPERATION_AREA_FILTER (operation);  \n"
"  const Babl              *format  = babl_format (\"RGBA float\");            \n"
"  GeglRectangle            rect;                                              \n"
"  gfloat                  *src_buf;                                           \n"
"  gfloat                  *dst_buf;                                           \n"
"  gfloat                   matrix[MAX_MATRIX_SIZE][MAX_MATRIX_SIZE]={{0,}};   \n"
"  gfloat                   matrixsum = 0.0;                                   \n"
"  gfloat                   inv_divisor;                                       \n"
"  gint                     x, y;                                              \n"
"  gint                     matrix_size = MAX_MATRIX_SIZE;                     \n"
"                                                                              \n"
"  if (enough_with_3x3 (o))                                                    \n"
"    matrix_size = 3;                                                          \n"
"                                                                              \n"
"  make_matrix (o, matrix, matrix_size);                                       \n"
"                                                                              \n"
"  if (o->normalize)                                                           \n"
"    normalize_o (o, matrix, matrix_size);                                     \n"
"  inv_divisor = 1.0 / o->divisor;                                             \n"
"                                                                              \n"
"  for (x = 0; x < matrix_size; x++)                                           \n"
"    for (y = 0; y < matrix_size; y++)                                         \n"
"      matrixsum += fabsf (matrix[x][y]);                                      \n"
"                                                                              \n"
"  rect.x      = result->x - op_area->left;                                    \n"
"  rect.width  = result->width + op_area->left + op_area->right;               \n"
"  rect.y      = result->y - op_area->top;                                     \n"
"  rect.height = result->height + op_area->top + op_area->bottom;              \n"
"                                                                              \n"
"  src_buf = g_new (gfloat, rect.width * rect.height * 4);                     \n"
"  dst_buf = g_new (gfloat, result->width * result->height * 4);               \n"
"                                                                              \n"
"  gegl_buffer_get (input, &rect, 1.0, format, src_buf,                        \n"
"                   GEGL_AUTO_ROWSTRIDE, o->border);                           \n"
"                                                                              \n"
"  if (o->divisor != 0)                                                        \n"
"    {                                                                         \n"
"      gint ss_offset = (result->y - matrix_size/2 - rect.y) * rect.width * 4 +\n"
"                       (result->x - matrix_size/2 - rect.x) * 4;              \n"
"      int d_offset = 0;                                                       \n"
"      if (o->alpha_weight)                                                    \n"
"        {                                                                     \n"
"          if (o->red == FALSE || o->green == FALSE || o->blue == FALSE || o->alpha == FALSE)\n"
"          {                                                                   \n"
"            gint x, y;                                                        \n"
"            for (y = result->y; y < result->height + result->y; y++)          \n"
"            {                                                                 \n"
"              for (x = result->x; x < result->width + result->x; x++)         \n"
"              {                                                               \n"
"                convolve_pixel_alpha_weight_componentwise (o, src_buf, dst_buf, result, &rect,\n"
"                                           matrix, matrix_size, d_offset, ss_offset, x, y, matrixsum, inv_divisor);\n"
"                d_offset += 4;                                                \n"
"                ss_offset += 4;                                               \n"
"              }                                                               \n"
"              ss_offset += (rect.width - result->width) * 4;                  \n"
"            }                                                                 \n"
"          }                                                                   \n"
"          else                                                                \n"
"          {                                                                   \n"
"            gint x, y;                                                        \n"
"            for (y = result->y; y < result->height + result->y; y++)          \n"
"            {                                                                 \n"
"              for (x = result->x; x < result->width + result->x; x++)         \n"
"              {                                                               \n"
"                convolve_pixel_alpha_weight (o, src_buf, dst_buf, result, &rect,\n"
"                                           matrix, matrix_size, d_offset, ss_offset, x, y, matrixsum, inv_divisor);\n"
"                d_offset += 4;                                                \n"
"                ss_offset += 4;                                               \n"
"              }                                                               \n"
"              ss_offset += (rect.width - result->width) * 4;                  \n"
"            }                                                                 \n"
"          }                                                                   \n"
"        }                                                                     \n"
"      else                                                                    \n"
"        {                                                                     \n"
"          if (o->red == FALSE || o->green == FALSE || o->blue == FALSE || o->alpha == FALSE)\n"
"          {                                                                   \n"
"            gint x, y;                                                        \n"
"            for (y = result->y; y < result->height + result->y; y++)          \n"
"            {                                                                 \n"
"              for (x = result->x; x < result->width + result->x; x++)         \n"
"              {                                                               \n"
"                convolve_pixel_componentwise (o, src_buf, dst_buf, result, &rect,\n"
"                                matrix, matrix_size, d_offset, ss_offset, x, y, matrixsum, inv_divisor);\n"
"                d_offset += 4;                                                \n"
"                ss_offset += 4;                                               \n"
"              }                                                               \n"
"              ss_offset += (rect.width - result->width) * 4;                  \n"
"            }                                                                 \n"
"          }                                                                   \n"
"          else                                                                \n"
"          {                                                                   \n"
"            gint x, y;                                                        \n"
"            for (y = result->y; y < result->height + result->y; y++)          \n"
"            {                                                                 \n"
"              for (x = result->x; x < result->width + result->x; x++)         \n"
"              {                                                               \n"
"                convolve_pixel (o, src_buf, dst_buf, result, &rect,           \n"
"                                matrix, matrix_size, d_offset, ss_offset, x, y, matrixsum, inv_divisor);\n"
"                d_offset += 4;                                                \n"
"                ss_offset += 4;                                               \n"
"              }                                                               \n"
"              ss_offset += (rect.width - result->width) * 4;                  \n"
"            }                                                                 \n"
"          }                                                                   \n"
"        }                                                                     \n"
"        gegl_buffer_set (output, result, 0, format,                           \n"
"                         dst_buf, GEGL_AUTO_ROWSTRIDE);                       \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      gegl_buffer_set (output, &rect, 0, format,                              \n"
"                       src_buf, GEGL_AUTO_ROWSTRIDE);                         \n"
"    }                                                                         \n"
"                                                                              \n"
"  g_free (src_buf);                                                           \n"
"  g_free (dst_buf);                                                           \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_bounding_box (GeglOperation *operation)                                   \n"
"{                                                                             \n"
"  GeglRectangle  result = { 0, };                                             \n"
"  GeglRectangle *in_rect;                                                     \n"
"                                                                              \n"
"  in_rect = gegl_operation_source_get_bounding_box (operation, \"input\");    \n"
"  if (!in_rect)                                                               \n"
"    return result;                                                            \n"
"                                                                              \n"
"  return *in_rect;                                                            \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_required_for_output (GeglOperation       *operation,                      \n"
"                         const gchar         *input_pad,                      \n"
"                         const GeglRectangle *roi)                            \n"
"{                                                                             \n"
"  return get_bounding_box (operation);                                        \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GeglOperationFilterClass *filter_class;                                     \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  filter_class    = GEGL_OPERATION_FILTER_CLASS (klass);                      \n"
"  filter_class->process                    = process;                         \n"
"  operation_class->prepare                 = prepare;                         \n"
"  operation_class->get_bounding_box        = get_bounding_box;                \n"
"  operation_class->get_required_for_output = get_required_for_output;         \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"categories\",  \"generic\",                                             \n"
"    \"name\",        \"gegl:convolution-matrix\",                             \n"
"    \"description\", _(\"Apply a generic 5x5 convolution matrix\"),           \n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
