/*
 * Decompiled with CFR 0.152.
 */
package com.nwalsh.saxon;

import com.icl.saxon.Context;
import com.icl.saxon.Controller;
import com.icl.saxon.expr.FragmentValue;
import com.icl.saxon.expr.NodeSetValue;
import com.icl.saxon.expr.Value;
import com.icl.saxon.functions.Extensions;
import com.icl.saxon.om.NamePool;
import com.icl.saxon.output.Emitter;
import com.nwalsh.saxon.ColumnScanEmitter;
import com.nwalsh.saxon.ColumnUpdateEmitter;
import java.util.Hashtable;
import javax.xml.transform.TransformerException;

public class Table {
    private static int pixelsPerInch = 96;
    private static int nominalWidth = 6 * pixelsPerInch;
    private static String tableWidth = "100%";
    private static boolean foStylesheet = false;
    protected static Hashtable unitHash = null;

    protected static void initializeHash() {
        unitHash = new Hashtable();
        unitHash.put("in", new Float(pixelsPerInch));
        unitHash.put("cm", new Float((double)pixelsPerInch / 2.54));
        unitHash.put("mm", new Float((double)pixelsPerInch / 25.4));
        unitHash.put("pc", new Float(pixelsPerInch / 72 * 12));
        unitHash.put("pt", new Float(pixelsPerInch / 72));
        unitHash.put("px", new Float(1.0f));
    }

    public static void setPixelsPerInch(int n) {
        if (n > 0) {
            pixelsPerInch = n;
            Table.initializeHash();
        }
    }

    public int getPixelsPerInch() {
        return pixelsPerInch;
    }

    public static int convertLength(String string) {
        int n = 1;
        String string2 = "";
        String string3 = "";
        char[] cArray = string.toCharArray();
        float f = 0.0f;
        boolean bl = false;
        int n2 = 0;
        float f2 = 1.0f;
        int n3 = 0;
        if (unitHash == null) {
            Table.initializeHash();
        }
        if (cArray[n2] == '+' || cArray[n2] == '-') {
            if (cArray[n2] == '-') {
                n = -1;
            }
            ++n2;
        }
        while (!bl) {
            if (n2 >= cArray.length) {
                bl = true;
                continue;
            }
            if ((cArray[n2] > '9' || cArray[n2] < '0') && cArray[n2] != '.') {
                bl = true;
                string3 = string.substring(n2);
                continue;
            }
            string2 = string2 + cArray[n2++];
        }
        try {
            f = Float.parseFloat(string2);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println(string2 + " is not a number; 1 used instead.");
            f = 1.0f;
        }
        Float f3 = null;
        if (!string3.equals("")) {
            f3 = (Float)unitHash.get(string3);
            if (f3 == null) {
                System.out.println(string3 + " is not a known unit; 1 used instead.");
                f2 = 1.0f;
            } else {
                f2 = f3.floatValue();
            }
        } else {
            f2 = 1.0f;
        }
        f3 = new Float(f * f2);
        n3 = f3.intValue() * n;
        return n3;
    }

    protected static String getVariable(Context context, String string) throws TransformerException {
        Value value = null;
        String string2 = null;
        try {
            value = Extensions.evaluate((Context)context, (String)("$" + string));
            string2 = value.asString();
            return string2;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.println("Undefined variable: " + string);
            return "";
        }
    }

    private static void setupColumnWidths(Context context) {
        nominalWidth = 6 * pixelsPerInch;
        tableWidth = "100%";
        String string = null;
        try {
            string = Table.getVariable(context, "stylesheet.result.type");
            foStylesheet = string.equals("fo");
            string = Table.getVariable(context, "nominal.table.width");
            nominalWidth = Table.convertLength(string);
            tableWidth = string = Table.getVariable(context, "table.width");
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
    }

    public static NodeSetValue adjustColumnWidths(Context context, NodeSetValue nodeSetValue) {
        FragmentValue fragmentValue = (FragmentValue)nodeSetValue;
        Table.setupColumnWidths(context);
        try {
            int n;
            Object object;
            int n2;
            Controller controller = context.getController();
            NamePool namePool = controller.getNamePool();
            ColumnScanEmitter columnScanEmitter = new ColumnScanEmitter(namePool);
            fragmentValue.replay((Emitter)columnScanEmitter);
            int n3 = columnScanEmitter.columnCount();
            String[] stringArray = columnScanEmitter.columnWidths();
            float f = 0.0f;
            float[] fArray = new float[n3];
            float f2 = 0.0f;
            float[] fArray2 = new float[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                object = stringArray[n2];
                n = ((String)object).indexOf("*");
                if (n >= 0) {
                    String string = ((String)object).substring(0, n);
                    String string2 = ((String)object).substring(n + 1);
                    try {
                        float f3 = Float.parseFloat(string);
                        f += f3;
                        fArray[n2] = f3;
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println(string + " is not a valid relative unit.");
                    }
                    int n4 = 0;
                    if (string2 != null && !string2.equals("")) {
                        n4 = Table.convertLength(string2);
                    }
                    f2 += (float)n4;
                    fArray2[n2] = n4;
                    continue;
                }
                fArray[n2] = 0.0f;
                int n5 = 0;
                if (object != null && !((String)object).equals("")) {
                    n5 = Table.convertLength((String)object);
                }
                f2 += (float)n5;
                fArray2[n2] = n5;
            }
            if (f == 0.0f) {
                for (n2 = 0; n2 < n3; ++n2) {
                    object = new Float(fArray2[n2]);
                    if (foStylesheet) {
                        n = ((Float)object).intValue();
                        float f4 = (float)n / (float)pixelsPerInch;
                        stringArray[n2] = f4 + "in";
                        continue;
                    }
                    stringArray[n2] = Integer.toString(((Float)object).intValue());
                }
            } else if (f2 == 0.0f) {
                for (n2 = 0; n2 < n3; ++n2) {
                    float f5 = fArray[n2] / f * 100.0f;
                    Float f6 = new Float(f5);
                    stringArray[n2] = Integer.toString(f6.intValue());
                }
                stringArray = Table.correctRoundingError(stringArray);
            } else {
                int n6;
                n2 = nominalWidth;
                if (tableWidth.indexOf("%") <= 0) {
                    n2 = Table.convertLength(tableWidth);
                }
                if ((float)n2 <= f2) {
                    System.out.println("Table is wider than table width.");
                } else {
                    n2 = (int)((float)n2 - f2);
                }
                f2 = 0.0f;
                for (n6 = 0; n6 < n3; ++n6) {
                    float f7 = fArray[n6] / f * (float)n2;
                    fArray[n6] = f7 + fArray2[n6];
                    f2 += f7 + fArray2[n6];
                }
                if (tableWidth.indexOf("%") <= 0) {
                    for (n6 = 0; n6 < n3; ++n6) {
                        Float f8 = new Float(fArray[n6]);
                        if (foStylesheet) {
                            int n7 = f8.intValue();
                            float f9 = (float)n7 / (float)pixelsPerInch;
                            stringArray[n6] = f9 + "in";
                            continue;
                        }
                        stringArray[n6] = Integer.toString(f8.intValue());
                    }
                } else {
                    for (n6 = 0; n6 < n3; ++n6) {
                        float f10 = fArray[n6] / f2 * 100.0f;
                        Float f11 = new Float(f10);
                        stringArray[n6] = Integer.toString(f11.intValue());
                    }
                    stringArray = Table.correctRoundingError(stringArray);
                }
            }
            ColumnUpdateEmitter columnUpdateEmitter = new ColumnUpdateEmitter(controller, namePool, stringArray);
            fragmentValue.replay((Emitter)columnUpdateEmitter);
            return columnUpdateEmitter.getResultTreeFragment();
        }
        catch (TransformerException transformerException) {
            System.out.println("Transformer Exception in adjustColumnWidths");
            return fragmentValue;
        }
    }

    protected static String[] correctRoundingError(String[] stringArray) {
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                int n2 = Integer.parseInt(stringArray[i]);
                n += n2;
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        float f = 100 - n;
        float f2 = f / (float)stringArray.length;
        float f3 = 0.0f;
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                int n3 = Integer.parseInt(stringArray[i]);
                f3 += f2;
                if ((double)f3 >= 1.0) {
                    int n4 = (int)Math.round(Math.floor(f3));
                    f3 -= (float)Math.floor(f3);
                    stringArray[i] = Integer.toString(n3 += n4) + "%";
                    continue;
                }
                stringArray[i] = Integer.toString(n3) + "%";
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return stringArray;
    }
}

