/*
 * Decompiled with CFR 0.152.
 */
package com.nexwave.nquindexer;

import com.nexwave.nquindexer.SaxHTMLIndex;
import com.nexwave.nquindexer.WriteJSFiles;
import com.nexwave.nsidita.DirList;
import com.nexwave.nsidita.DocFileInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;

public class IndexerMain {
    private String txt_no_inputdir = "Input directory not found:";
    private String txt_cannot_create_outputdir = "Cannot create output search directory.";
    private String txt_no_files_found = "No html files found.";
    private String txt_wrong_dita_basedir = "ERROR: Parser initialization failed. Wrong dita base dir";
    private String txt_no_relative_files_found = "No relative html files calculated.";
    private String txt_no_words_gathered = "No words have been indexed in";
    private String txt_no_html_files = "No HTML Files found in";
    private String txt_no_args = "No argument given: you must provide an htmlDir to the IndexerMain";
    private static String txt_no_lang_specified = "Language of the content is not specified. Defaults to English.";
    private String searchdir = "search";
    private File inputDir = null;
    private String outputDir = null;
    private String projectDir = null;
    public String htmlDir = null;
    public String indexerLanguage = "en";
    private String[] supportedLanguages = new String[]{"en", "de", "fr", "zh", "ja", "ko"};
    private ArrayList<String> cleanUpStrings = null;
    private ArrayList<String> cleanUpChars = null;
    private String htmlExtension = "html";
    private String tocfile;
    private boolean stem;

    public IndexerMain(String htmlDir, String indexerLanguage, String htmlExtension, String doStem, String tocfile) {
        this.setHtmlDir(htmlDir);
        this.setIndexerLanguage(indexerLanguage);
        this.setHtmlextension(htmlExtension);
        if (!doStem.toUpperCase().trim().equals("FALSE") && !doStem.toUpperCase().trim().equals("NO")) {
            System.out.println("Stemming enabled");
            this.setStem(true);
        } else {
            System.out.println("Stemming disabled");
            this.setStem(false);
        }
        this.setTocfile(tocfile);
    }

    public IndexerMain(String htmlDir, String indexerLanguage) {
        this.setHtmlDir(htmlDir);
        this.setIndexerLanguage(indexerLanguage);
    }

    public IndexerMain(String htmlDir) {
        this.setHtmlDir(htmlDir);
        this.setIndexerLanguage("en");
    }

    public void setHtmlDir(String htmlDir) {
        this.htmlDir = htmlDir;
    }

    public void setHtmlextension(String htmlExtension) {
        this.htmlExtension = htmlExtension;
        if (this.htmlExtension.startsWith(".")) {
            this.htmlExtension = this.htmlExtension.substring(1);
        }
    }

    public void setIndexerLanguage(String indexerLanguage) {
        if (indexerLanguage != null && !"".equals(indexerLanguage)) {
            int i;
            int temp = indexerLanguage.indexOf(95);
            if (temp != -1) {
                indexerLanguage = indexerLanguage.substring(0, temp);
            }
            for (i = 0; i < this.supportedLanguages.length; ++i) {
                if (!indexerLanguage.equals(this.supportedLanguages[i])) continue;
                this.indexerLanguage = this.supportedLanguages[i];
                break;
            }
            if (i >= this.supportedLanguages.length) {
                this.indexerLanguage = indexerLanguage;
            }
        } else {
            this.indexerLanguage = "@@";
        }
    }

    public static void main(String[] args) {
        if (System.getProperty("htmlDir") == null) {
            throw new RuntimeException("Specify at least the directory containing html files (htmlDir)\n ex: java -jar webhelpindexer.jar -DhtmlDir=docs/content -DindexerLanguage=en \nThe program will exit now.");
        }
        IndexerMain indexer = new IndexerMain(System.getProperty("htmlDir"), System.getProperty("indexerLanguage", "en"), System.getProperty("htmlExtension", "html"), System.getProperty("doStem", "true"), System.getProperty("tocFile"));
        indexer.execute();
    }

    public void execute() {
        DirList nsiDoc;
        boolean b;
        File tempfile;
        ArrayList<DocFileInfo> filesDescription = null;
        ArrayList<File> htmlFiles = null;
        ArrayList<String> htmlFilesPathRel = null;
        HashMap<String, String> tempDico = new HashMap<String, String>();
        String htmlList = "htmlFileList.js";
        String htmlInfoList = "htmlFileInfoList.js";
        String indexName = ".js";
        Date dateStart = new Date();
        if (this.htmlDir == null) {
            System.out.println(this.txt_no_args + ".");
            return;
        }
        this.inputDir = new File(this.htmlDir);
        if (this.inputDir == null) {
            IndexerMain.DisplayHelp();
            return;
        }
        if (!this.inputDir.exists()) {
            System.out.println(this.txt_no_inputdir + " " + this.inputDir + ".");
            return;
        }
        if (this.outputDir == null) {
            this.outputDir = this.inputDir.getPath().concat(File.separator).concat(this.searchdir);
        }
        if (!(tempfile = new File(this.outputDir)).exists() && !(b = new File(this.outputDir).mkdir())) {
            System.out.println(this.txt_cannot_create_outputdir + " " + this.outputDir + ".");
            return;
        }
        if (this.projectDir == null) {
            this.projectDir = this.inputDir.getPath();
        }
        if ((htmlFiles = (nsiDoc = new DirList(this.inputDir, "^.*\\." + this.htmlExtension + "?$", 1)).getListFiles()).isEmpty()) {
            System.out.println(this.txt_no_html_files + " " + this.inputDir + ".");
            return;
        }
        htmlFilesPathRel = nsiDoc.getListFilesRelTo(this.projectDir);
        Iterator<String> iterator = htmlFilesPathRel.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().endsWith(this.tocfile + "." + this.htmlExtension)) continue;
            iterator.remove();
        }
        if (htmlFiles == null) {
            System.out.println(this.txt_no_files_found);
            return;
        }
        if (htmlFilesPathRel == null) {
            System.out.println(this.txt_no_relative_files_found);
            return;
        }
        WriteJSFiles.WriteHTMLList(this.outputDir.concat(File.separator).concat(htmlList), htmlFilesPathRel, this.stem);
        this.RetrieveCleanUpProps();
        SaxHTMLIndex spe = new SaxHTMLIndex(this.cleanUpStrings, this.cleanUpChars);
        if (spe.init(tempDico) == 0) {
            filesDescription = new ArrayList<DocFileInfo>();
            Iterator<File> it = htmlFiles.iterator();
            while (it.hasNext()) {
                File ftemp = it.next();
                if (!ftemp.getAbsolutePath().endsWith(this.tocfile + "." + this.htmlExtension)) {
                    DocFileInfo docFileInfoTemp = new DocFileInfo(spe.runExtractData(ftemp, this.indexerLanguage, this.stem));
                    String stemp = (ftemp = docFileInfoTemp.getFullpath()).toString();
                    int i = stemp.indexOf(this.projectDir);
                    if (i != 0) {
                        System.out.println("the documentation root does not match with the documentation input!");
                        return;
                    }
                    int ad = 1;
                    if (stemp.equals(this.projectDir)) {
                        ad = 0;
                    }
                    stemp = stemp.substring(i + this.projectDir.length() + ad);
                    ftemp = new File(stemp);
                    docFileInfoTemp.setFullpath(ftemp);
                    filesDescription.add(docFileInfoTemp);
                    continue;
                }
                it.remove();
            }
            if (tempDico.containsKey("")) {
                tempDico.remove("");
            }
            if (tempDico.isEmpty()) {
                System.out.println(this.txt_no_words_gathered + " " + this.inputDir + ".");
                return;
            }
            WriteJSFiles.WriteIndex(this.outputDir.concat(File.separator).concat(indexName), tempDico, this.indexerLanguage);
            WriteJSFiles.WriteHTMLInfoList(this.outputDir.concat(File.separator).concat(htmlInfoList), filesDescription);
            Date dateEnd = new Date();
            long diff = dateEnd.getTime() - dateStart.getTime();
            if (diff < 1000L) {
                System.out.println("Delay = " + diff + " milliseconds");
            } else {
                System.out.println("Delay = " + diff / 1000L + " seconds");
            }
        } else {
            System.out.println(this.txt_wrong_dita_basedir);
        }
    }

    private static void DisplayHelp() {
        String lSep = System.getProperty("line.separator");
        StringBuilder msg = new StringBuilder();
        msg.append("USAGE:").append(lSep);
        msg.append("   java -classpath TesterIndexer inputDir outputDir projectDir").append(lSep);
        msg.append("with:").append(lSep);
        msg.append("   inputDir (mandatory) :  specify the html files ' directory to index").append(lSep);
        msg.append("   outputDir (optional) : specify where to output the index files").append(lSep);
        msg.append("   projectDir (optional) : specify the root of the documentation directory").append(lSep);
        msg.append("Example:").append(lSep);
        msg.append("   java -classpath TesterIndexer /home/$USER/DITA/doc").append(lSep);
        msg.append("Example 2:").append(lSep);
        msg.append("   java -classpath TesterIndexer /home/$USER/webhelp/docs/content /home/$USER/docs/content/search /home/$USER/webhelp/docs").append(lSep);
        System.out.println(msg.toString());
    }

    private int RetrieveCleanUpProps() {
        String[] punctuationFiles = new String[]{"punctuation.props"};
        Collection<Object> c = new ArrayList();
        DirList props = new DirList(this.inputDir, "^(?!(punctuation)).*\\.props$", 1);
        ArrayList<File> wordsList = props.getListFiles();
        Properties enProps = new Properties();
        String propsDir = this.inputDir.getPath().concat(File.separator).concat(this.searchdir);
        this.cleanUpStrings = new ArrayList();
        this.cleanUpChars = new ArrayList();
        try {
            FileInputStream input;
            File ftemp;
            for (File aWordsList : wordsList) {
                ftemp = aWordsList;
                if (!ftemp.exists()) continue;
                input = new FileInputStream(ftemp.getAbsolutePath());
                enProps.load(input);
                input.close();
                c = enProps.values();
                this.cleanUpStrings.addAll(c);
                enProps.clear();
            }
            for (String punctuationFile : punctuationFiles) {
                String tempStr = propsDir.concat(File.separator).concat(punctuationFile);
                ftemp = new File(tempStr);
                if (!ftemp.exists()) continue;
                input = new FileInputStream(tempStr);
                enProps.load(input);
                input.close();
                c = enProps.values();
                this.cleanUpChars.addAll(c);
                enProps.clear();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return 1;
        }
        return 0;
    }

    public void setTocfile(String tocfile) {
        this.tocfile = tocfile;
    }

    public void setStem(boolean stem) {
        this.stem = stem;
    }
}

