/*
 * dhcpcd - route management
 * Copyright (c) 2006-2018 Roy Marples <roy@marples.name>
 * All rights reserved

 * rEDISTRIBUTION AND USE IN SOURCE AND BINARY FORMS, WITH OR WITHOUT
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef ROUTE_H
#define ROUTE_H

#include <sys/socket.h>
#include <net/route.h>

#include <stdbool.h>

#include "dhcpcd.h"
#include "sa.h"

/* Some systems have route metrics.
 * OpenBSD route priority is not this. */
#ifndef HAVE_ROUTE_METRIC
# if defined(__linux__)
#  define HAVE_ROUTE_METRIC 1
# endif
#endif

#if defined(__OpenBSD__) || defined (__sun)
#  define ROUTE_PER_GATEWAY
/* XXX dhcpcd doesn't really support this yet.
 * But that's generally OK if only dhcpcd is managing routes. */
#endif

/* OpenBSD defines this as a "convienience" ..... we work around it. */
#ifdef __OpenBSD__
#undef rt_mtu
#endif

struct rt {
	TAILQ_ENTRY(rt)		rt_next;
	union sa_ss		rt_ss_dest;
#define rt_dest			rt_ss_dest.sa
	union sa_ss		rt_ss_netmask;
#define rt_netmask		rt_ss_netmask.sa
	union sa_ss		rt_ss_gateway;
#define rt_gateway		rt_ss_gateway.sa
	struct interface	*rt_ifp;
	union sa_ss		rt_ss_ifa;
#define rt_ifa			rt_ss_ifa.sa
	unsigned int		rt_flags;
	unsigned int		rt_mtu;
#ifdef HAVE_ROUTE_METRIC
	unsigned int		rt_metric;
#endif
	unsigned int		rt_dflags;
#define	RTDF_INIT		0x01		/* Generated by if_initrt() */
#define	RTDF_IFA_ROUTE		0x02		/* Address generated route */
#define	RTDF_FAKE		0x04		/* Maybe us on lease reboot  */
#define	RTDF_RA			0x08		/* Router Advertisement */
#define	RTDF_DHCP		0x10		/* DHCP route */
#define	RTDF_STATIC		0x20		/* Configured in dhcpcd */
};
TAILQ_HEAD(rt_head, rt);

void rt_init(struct dhcpcd_ctx *);
void rt_dispose(struct dhcpcd_ctx *);
struct rt * rt_find(struct rt_head *, const struct rt *);
void rt_free(struct rt *);
void rt_freeif(struct interface *);
void rt_headclear(struct rt_head *, int);
void rt_headfreeif(struct rt_head *);
struct rt * rt_new(struct interface *);
void rt_recvrt(int, const struct rt *);
void rt_build(struct dhcpcd_ctx *, int);

#endif
