/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.server.handle;

import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.Transaction;
import com.sleepycat.server.handle.EnvironmentDescriptor;
import com.sleepycat.server.handle.HandleDescriptor;
import com.sleepycat.server.handle.ResourceKey;
import com.sleepycat.thrift.TDurabilityPolicy;
import java.util.concurrent.atomic.AtomicReference;

public class TransactionDescriptor
extends HandleDescriptor<Transaction> {
    private final TransactionDescriptor parent;
    private AtomicReference<Status> status = new AtomicReference<Status>(Status.NOT_RESOLVED);

    public TransactionDescriptor(Transaction transaction, EnvironmentDescriptor environmentDescriptor, TransactionDescriptor transactionDescriptor) {
        super(transaction, null, environmentDescriptor, transactionDescriptor);
        this.parent = transactionDescriptor;
    }

    public boolean resolve(Status status) {
        return this.status.compareAndSet(Status.NOT_RESOLVED, status);
    }

    @Override
    public ResourceKey[] resourceOwners() {
        return new ResourceKey[0];
    }

    @Override
    protected void closeBdbHandle() throws DatabaseException {
        switch (this.getStatus()) {
            case COMMITTED: {
                ((Transaction)this.getHandle()).commit();
                break;
            }
            case COMMITTED_NO_SYNC: {
                ((Transaction)this.getHandle()).commitNoSync();
                break;
            }
            case COMMITTED_SYNC: {
                ((Transaction)this.getHandle()).commitSync();
                break;
            }
            case COMMITTED_WRITE_NO_SYNC: {
                ((Transaction)this.getHandle()).commitWriteNoSync();
                break;
            }
            default: {
                ((Transaction)this.getHandle()).abort();
            }
        }
    }

    private Status getStatus() {
        if (this.status.get() == Status.NOT_RESOLVED && this.parent != null) {
            this.resolve(this.parent.getStatus());
        }
        if (this.status.get() == Status.NOT_RESOLVED) {
            this.resolve(Status.ABORTED);
        }
        return this.status.get();
    }

    public static enum Status {
        NOT_RESOLVED,
        COMMITTED,
        COMMITTED_NO_SYNC,
        COMMITTED_SYNC,
        COMMITTED_WRITE_NO_SYNC,
        ABORTED;


        public static Status toStatus(TDurabilityPolicy tDurabilityPolicy) {
            if (tDurabilityPolicy == null) {
                return COMMITTED;
            }
            switch (tDurabilityPolicy) {
                case NO_SYNC: {
                    return COMMITTED_NO_SYNC;
                }
                case SYNC: {
                    return COMMITTED_SYNC;
                }
                case WRITE_NO_SYNC: {
                    return COMMITTED_WRITE_NO_SYNC;
                }
            }
            throw new IllegalArgumentException(tDurabilityPolicy.toString());
        }
    }
}

