/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.client.persist.impl;

import com.sleepycat.client.compat.DbCompat;
import com.sleepycat.client.persist.impl.Accessor;
import com.sleepycat.client.persist.impl.Catalog;
import com.sleepycat.client.persist.impl.EntityInput;
import com.sleepycat.client.persist.impl.EntityOutput;
import com.sleepycat.client.persist.impl.FieldInfo;
import com.sleepycat.client.persist.impl.Format;
import com.sleepycat.client.persist.impl.RefreshException;
import com.sleepycat.client.persist.impl.SimpleCatalog;
import com.sleepycat.client.persist.impl.SimpleFormat;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.List;

class ReflectionAccessor
implements Accessor {
    private static final FieldAccess[] EMPTY_KEYS = new FieldAccess[0];
    private Class type;
    private Accessor superAccessor;
    private Constructor constructor;
    private FieldAccess priKey;
    private FieldAccess[] secKeys;
    private FieldAccess[] nonKeys;

    private ReflectionAccessor(Class clazz, Accessor accessor) {
        this.type = clazz;
        this.superAccessor = accessor;
        try {
            this.constructor = clazz.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw DbCompat.unexpectedState(clazz.getName());
        }
        if (!Modifier.isPublic(clazz.getModifiers()) || !Modifier.isPublic(this.constructor.getModifiers())) {
            this.setAccessible(this.constructor, clazz.getName() + "()");
        }
    }

    ReflectionAccessor(Catalog catalog, Class clazz, Accessor accessor, FieldInfo fieldInfo, List<FieldInfo> list, List<FieldInfo> list2) {
        this(clazz, accessor);
        this.priKey = fieldInfo != null ? this.getField(catalog, fieldInfo, true) : null;
        this.secKeys = list.size() > 0 ? this.getFields(catalog, list, false) : EMPTY_KEYS;
        this.nonKeys = list2.size() > 0 ? this.getFields(catalog, list2, false) : EMPTY_KEYS;
    }

    ReflectionAccessor(Catalog catalog, Class clazz, List<FieldInfo> list) {
        this(clazz, null);
        this.priKey = null;
        this.secKeys = EMPTY_KEYS;
        this.nonKeys = this.getFields(catalog, list, true);
    }

    private FieldAccess[] getFields(Catalog catalog, List<FieldInfo> list, boolean bl) {
        int n = 0;
        FieldAccess[] fieldAccessArray = new FieldAccess[list.size()];
        for (FieldInfo fieldInfo : list) {
            fieldAccessArray[n] = this.getField(catalog, fieldInfo, bl);
            ++n;
        }
        return fieldAccessArray;
    }

    private FieldAccess getField(Catalog catalog, FieldInfo fieldInfo, boolean bl) {
        Class<?> clazz;
        Field field;
        try {
            field = this.type.getDeclaredField(fieldInfo.getName());
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw DbCompat.unexpectedException(noSuchFieldException);
        }
        if (!Modifier.isPublic(this.type.getModifiers()) || !Modifier.isPublic(field.getModifiers())) {
            this.setAccessible(field, field.getName());
        }
        if ((clazz = field.getType()).isPrimitive()) {
            assert (SimpleCatalog.isSimpleType(clazz));
            return new PrimitiveAccess(field, (SimpleFormat)catalog.getFormat(clazz.getName()));
        }
        if (bl) {
            Format format = catalog.getFormat(fieldInfo.getClassName());
            assert (format != null);
            return new KeyObjectAccess(field, format);
        }
        if (clazz == String.class) {
            return new StringAccess(field);
        }
        return new ObjectAccess(field);
    }

    private void setAccessible(AccessibleObject accessibleObject, String string) {
        try {
            accessibleObject.setAccessible(true);
        }
        catch (SecurityException securityException) {
            throw new IllegalStateException("Unable to access non-public member: " + this.type.getName() + '.' + string + ". Please configure the Java Security Manager setting:  ReflectPermission suppressAccessChecks", securityException);
        }
    }

    @Override
    public Object newInstance() {
        try {
            return this.constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw DbCompat.unexpectedException(illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw DbCompat.unexpectedException(instantiationException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw DbCompat.unexpectedException(invocationTargetException);
        }
    }

    @Override
    public Object newArray(int n) {
        return Array.newInstance(this.type, n);
    }

    @Override
    public boolean isPriKeyFieldNullOrZero(Object object) {
        try {
            if (this.priKey != null) {
                return this.priKey.isNullOrZero(object);
            }
            if (this.superAccessor != null) {
                return this.superAccessor.isPriKeyFieldNullOrZero(object);
            }
            throw DbCompat.unexpectedState("No primary key field");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw DbCompat.unexpectedException(illegalAccessException);
        }
    }

    @Override
    public void writePriKeyField(Object object, EntityOutput entityOutput) throws RefreshException {
        block4: {
            try {
                if (this.priKey != null) {
                    this.priKey.write(object, entityOutput);
                    break block4;
                }
                if (this.superAccessor != null) {
                    this.superAccessor.writePriKeyField(object, entityOutput);
                    break block4;
                }
                throw DbCompat.unexpectedState("No primary key field");
            }
            catch (IllegalAccessException illegalAccessException) {
                throw DbCompat.unexpectedException(illegalAccessException);
            }
        }
    }

    @Override
    public void readPriKeyField(Object object, EntityInput entityInput) throws RefreshException {
        block4: {
            try {
                if (this.priKey != null) {
                    this.priKey.read(object, entityInput);
                    break block4;
                }
                if (this.superAccessor != null) {
                    this.superAccessor.readPriKeyField(object, entityInput);
                    break block4;
                }
                throw DbCompat.unexpectedState("No primary key field");
            }
            catch (IllegalAccessException illegalAccessException) {
                throw DbCompat.unexpectedException(illegalAccessException);
            }
        }
    }

    @Override
    public void writeSecKeyFields(Object object, EntityOutput entityOutput) throws RefreshException {
        try {
            if (this.priKey != null && !this.priKey.isPrimitive && !this.priKey.isString) {
                entityOutput.registerPriKeyObject(this.priKey.field.get(object));
            }
            if (this.superAccessor != null) {
                this.superAccessor.writeSecKeyFields(object, entityOutput);
            }
            for (int i = 0; i < this.secKeys.length; ++i) {
                this.secKeys[i].write(object, entityOutput);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw DbCompat.unexpectedException(illegalAccessException);
        }
    }

    @Override
    public void readSecKeyFields(Object object, EntityInput entityInput, int n, int n2, int n3) throws RefreshException {
        try {
            if (this.priKey != null && !this.priKey.isPrimitive && !this.priKey.isString) {
                entityInput.registerPriKeyObject(this.priKey.field.get(object));
            } else if (this.priKey != null && this.priKey.isString) {
                entityInput.registerPriStringKeyObject(this.priKey.field.get(object));
            }
            if (n3 != 0 && this.superAccessor != null) {
                this.superAccessor.readSecKeyFields(object, entityInput, n, n2, n3 - 1);
            } else if (n3 > 0) {
                throw DbCompat.unexpectedState("Superclass does not exist");
            }
            if (n3 <= 0) {
                for (int i = n; i <= n2 && i < this.secKeys.length; ++i) {
                    this.secKeys[i].read(object, entityInput);
                }
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw DbCompat.unexpectedException(illegalAccessException);
        }
    }

    @Override
    public void writeNonKeyFields(Object object, EntityOutput entityOutput) throws RefreshException {
        try {
            if (this.superAccessor != null) {
                this.superAccessor.writeNonKeyFields(object, entityOutput);
            }
            for (int i = 0; i < this.nonKeys.length; ++i) {
                this.nonKeys[i].write(object, entityOutput);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw DbCompat.unexpectedException(illegalAccessException);
        }
    }

    @Override
    public void readNonKeyFields(Object object, EntityInput entityInput, int n, int n2, int n3) throws RefreshException {
        try {
            if (n3 != 0 && this.superAccessor != null) {
                this.superAccessor.readNonKeyFields(object, entityInput, n, n2, n3 - 1);
            } else if (n3 > 0) {
                throw DbCompat.unexpectedState("Superclass does not exist");
            }
            if (n3 <= 0) {
                for (int i = n; i <= n2 && i < this.nonKeys.length; ++i) {
                    this.nonKeys[i].read(object, entityInput);
                }
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw DbCompat.unexpectedException(illegalAccessException);
        }
    }

    @Override
    public void writeCompositeKeyFields(Object object, EntityOutput entityOutput) throws RefreshException {
        try {
            for (int i = 0; i < this.nonKeys.length; ++i) {
                this.nonKeys[i].write(object, entityOutput);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw DbCompat.unexpectedException(illegalAccessException);
        }
    }

    @Override
    public void readCompositeKeyFields(Object object, EntityInput entityInput) throws RefreshException {
        try {
            for (int i = 0; i < this.nonKeys.length; ++i) {
                this.nonKeys[i].read(object, entityInput);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw DbCompat.unexpectedException(illegalAccessException);
        }
    }

    @Override
    public Object getField(Object object, int n, int n2, boolean bl) {
        if (n2 > 0) {
            return this.superAccessor.getField(object, n, n2 - 1, bl);
        }
        try {
            Field field = bl ? this.secKeys[n].field : this.nonKeys[n].field;
            return field.get(object);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw DbCompat.unexpectedException(illegalAccessException);
        }
    }

    @Override
    public void setField(Object object, int n, int n2, boolean bl, Object object2) {
        if (n2 > 0) {
            this.superAccessor.setField(object, n, n2 - 1, bl, object2);
            return;
        }
        try {
            Field field = bl ? this.secKeys[n].field : this.nonKeys[n].field;
            field.set(object, object2);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw DbCompat.unexpectedException(illegalAccessException);
        }
    }

    @Override
    public void setPriField(Object object, Object object2) {
        block4: {
            try {
                if (this.priKey != null) {
                    this.priKey.field.set(object, object2);
                    break block4;
                }
                if (this.superAccessor != null) {
                    this.superAccessor.setPriField(object, object2);
                    break block4;
                }
                throw DbCompat.unexpectedState("No primary key field");
            }
            catch (IllegalAccessException illegalAccessException) {
                throw DbCompat.unexpectedException(illegalAccessException);
            }
        }
    }

    private static class PrimitiveAccess
    extends FieldAccess {
        private SimpleFormat format;

        PrimitiveAccess(Field field, SimpleFormat simpleFormat) {
            super(field);
            this.format = simpleFormat;
        }

        @Override
        void write(Object object, EntityOutput entityOutput) throws IllegalAccessException {
            this.format.writePrimitiveField(object, entityOutput, this.field);
        }

        @Override
        void read(Object object, EntityInput entityInput) throws IllegalAccessException, RefreshException {
            this.format.readPrimitiveField(object, entityInput, this.field);
        }

        @Override
        boolean isNullOrZero(Object object) throws IllegalAccessException {
            return this.field.getLong(object) == 0L;
        }
    }

    private static class StringAccess
    extends FieldAccess {
        StringAccess(Field field) {
            super(field);
        }

        @Override
        void write(Object object, EntityOutput entityOutput) throws IllegalAccessException, RefreshException {
            entityOutput.writeString((String)this.field.get(object));
        }

        @Override
        void read(Object object, EntityInput entityInput) throws IllegalAccessException, RefreshException {
            this.field.set(object, entityInput.readStringObject());
        }
    }

    private static class KeyObjectAccess
    extends FieldAccess {
        private Format format;

        KeyObjectAccess(Field field, Format format) {
            super(field);
            this.format = format;
        }

        @Override
        void write(Object object, EntityOutput entityOutput) throws IllegalAccessException, RefreshException {
            entityOutput.writeKeyObject(this.field.get(object), this.format);
        }

        @Override
        void read(Object object, EntityInput entityInput) throws IllegalAccessException, RefreshException {
            this.field.set(object, entityInput.readKeyObject(this.format));
        }
    }

    private static class ObjectAccess
    extends FieldAccess {
        ObjectAccess(Field field) {
            super(field);
        }

        @Override
        void write(Object object, EntityOutput entityOutput) throws IllegalAccessException, RefreshException {
            entityOutput.writeObject(this.field.get(object), null);
        }

        @Override
        void read(Object object, EntityInput entityInput) throws IllegalAccessException, RefreshException {
            this.field.set(object, entityInput.readObject());
        }
    }

    private static abstract class FieldAccess {
        Field field;
        boolean isPrimitive;
        boolean isString = false;

        FieldAccess(Field field) {
            this.field = field;
            this.isPrimitive = field.getType().isPrimitive();
            this.isString = field.getType().getName().equals(String.class.getName());
        }

        abstract void write(Object var1, EntityOutput var2) throws IllegalAccessException, RefreshException;

        abstract void read(Object var1, EntityInput var2) throws IllegalAccessException, RefreshException;

        boolean isNullOrZero(Object object) throws IllegalAccessException {
            return this.field.get(object) == null;
        }
    }
}

