/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.client.persist;

import com.sleepycat.client.SCursor;
import com.sleepycat.client.SCursorConfig;
import com.sleepycat.client.SDatabase;
import com.sleepycat.client.SDatabaseConfig;
import com.sleepycat.client.SDatabaseEntry;
import com.sleepycat.client.SDatabaseException;
import com.sleepycat.client.SEnvironment;
import com.sleepycat.client.SLockMode;
import com.sleepycat.client.SOperationStatus;
import com.sleepycat.client.STransaction;
import com.sleepycat.client.bind.EntryBinding;
import com.sleepycat.client.compat.DbCompat;
import com.sleepycat.client.persist.BasicCursor;
import com.sleepycat.client.persist.EntityCursor;
import com.sleepycat.client.persist.EntityIndex;
import com.sleepycat.client.persist.KeyValueAdapter;
import com.sleepycat.client.persist.ValueAdapter;
import com.sleepycat.client.util.keyrange.KeyRange;
import com.sleepycat.client.util.keyrange.RangeCursor;

abstract class BasicIndex<K, E>
implements EntityIndex<K, E> {
    static final SDatabaseEntry NO_RETURN_ENTRY = new SDatabaseEntry();
    SDatabase db;
    boolean transactional;
    boolean sortedDups;
    boolean locking;
    boolean concurrentDB;
    Class<K> keyClass;
    EntryBinding keyBinding;
    KeyRange emptyRange;
    ValueAdapter<K> keyAdapter;
    ValueAdapter<E> entityAdapter;

    BasicIndex(SDatabase sDatabase, Class<K> clazz, EntryBinding entryBinding, ValueAdapter<E> valueAdapter) throws SDatabaseException {
        this.db = sDatabase;
        SDatabaseConfig sDatabaseConfig = sDatabase.getConfig();
        this.transactional = sDatabaseConfig.getTransactional();
        this.sortedDups = sDatabaseConfig.getSortedDuplicates();
        this.locking = DbCompat.getInitializeLocking(sDatabase.getEnvironment().getConfig());
        SEnvironment sEnvironment = sDatabase.getEnvironment();
        this.concurrentDB = DbCompat.getInitializeCDB(sEnvironment.getConfig());
        this.keyClass = clazz;
        this.keyBinding = entryBinding;
        this.entityAdapter = valueAdapter;
        this.emptyRange = new KeyRange(sDatabaseConfig.getBtreeComparator());
        this.keyAdapter = new KeyValueAdapter<K>(clazz, entryBinding);
    }

    @Override
    public SDatabase getDatabase() {
        return this.db;
    }

    @Override
    public boolean contains(K k) throws SDatabaseException {
        return this.contains(null, k, null);
    }

    @Override
    public boolean contains(STransaction sTransaction, K k, SLockMode sLockMode) throws SDatabaseException {
        SDatabaseEntry sDatabaseEntry = new SDatabaseEntry();
        SDatabaseEntry sDatabaseEntry2 = NO_RETURN_ENTRY;
        this.keyBinding.objectToEntry(k, sDatabaseEntry);
        SOperationStatus sOperationStatus = this.db.get(sTransaction, sDatabaseEntry, sDatabaseEntry2, sLockMode);
        return sOperationStatus == SOperationStatus.SUCCESS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long count() throws SDatabaseException {
        long l = 0L;
        SDatabaseEntry sDatabaseEntry = NO_RETURN_ENTRY;
        SDatabaseEntry sDatabaseEntry2 = NO_RETURN_ENTRY;
        SCursorConfig sCursorConfig = this.locking ? SCursorConfig.READ_UNCOMMITTED : null;
        try (SCursor sCursor = this.db.openCursor(null, sCursorConfig);){
            SOperationStatus sOperationStatus = sCursor.getFirst(sDatabaseEntry, sDatabaseEntry2, null);
            while (sOperationStatus == SOperationStatus.SUCCESS) {
                l = this.sortedDups ? (l += (long)sCursor.count()) : ++l;
                sOperationStatus = sCursor.getNextNoDup(sDatabaseEntry, sDatabaseEntry2, null);
            }
        }
        return l;
    }

    @Override
    public boolean delete(K k) throws SDatabaseException {
        return this.delete(null, k);
    }

    @Override
    public boolean delete(STransaction sTransaction, K k) throws SDatabaseException {
        SDatabaseEntry sDatabaseEntry = new SDatabaseEntry();
        this.keyBinding.objectToEntry(k, sDatabaseEntry);
        SOperationStatus sOperationStatus = this.db.delete(sTransaction, sDatabaseEntry);
        return sOperationStatus == SOperationStatus.SUCCESS;
    }

    @Override
    public EntityCursor<K> keys() throws SDatabaseException {
        return this.keys(null, null);
    }

    @Override
    public EntityCursor<K> keys(STransaction sTransaction, SCursorConfig sCursorConfig) throws SDatabaseException {
        return this.cursor(sTransaction, this.emptyRange, this.keyAdapter, sCursorConfig);
    }

    @Override
    public EntityCursor<E> entities() throws SDatabaseException {
        return this.cursor(null, this.emptyRange, this.entityAdapter, null);
    }

    @Override
    public EntityCursor<E> entities(STransaction sTransaction, SCursorConfig sCursorConfig) throws SDatabaseException {
        return this.cursor(sTransaction, this.emptyRange, this.entityAdapter, sCursorConfig);
    }

    @Override
    public EntityCursor<K> keys(K k, boolean bl, K k2, boolean bl2) throws SDatabaseException {
        return this.cursor(null, k, bl, k2, bl2, this.keyAdapter, null);
    }

    @Override
    public EntityCursor<K> keys(STransaction sTransaction, K k, boolean bl, K k2, boolean bl2, SCursorConfig sCursorConfig) throws SDatabaseException {
        return this.cursor(sTransaction, k, bl, k2, bl2, this.keyAdapter, sCursorConfig);
    }

    @Override
    public EntityCursor<E> entities(K k, boolean bl, K k2, boolean bl2) throws SDatabaseException {
        return this.cursor(null, k, bl, k2, bl2, this.entityAdapter, null);
    }

    @Override
    public EntityCursor<E> entities(STransaction sTransaction, K k, boolean bl, K k2, boolean bl2, SCursorConfig sCursorConfig) throws SDatabaseException {
        return this.cursor(sTransaction, k, bl, k2, bl2, this.entityAdapter, sCursorConfig);
    }

    private <V> EntityCursor<V> cursor(STransaction sTransaction, K k, boolean bl, K k2, boolean bl2, ValueAdapter<V> valueAdapter, SCursorConfig sCursorConfig) throws SDatabaseException {
        SDatabaseEntry sDatabaseEntry = null;
        if (k != null) {
            sDatabaseEntry = new SDatabaseEntry();
            this.keyBinding.objectToEntry(k, sDatabaseEntry);
        }
        SDatabaseEntry sDatabaseEntry2 = null;
        if (k2 != null) {
            sDatabaseEntry2 = new SDatabaseEntry();
            this.keyBinding.objectToEntry(k2, sDatabaseEntry2);
        }
        KeyRange keyRange = this.emptyRange.subRange(sDatabaseEntry, bl, sDatabaseEntry2, bl2);
        return this.cursor(sTransaction, keyRange, valueAdapter, sCursorConfig);
    }

    private <V> EntityCursor<V> cursor(STransaction sTransaction, KeyRange keyRange, ValueAdapter<V> valueAdapter, SCursorConfig sCursorConfig) throws SDatabaseException {
        SCursor sCursor = this.db.openCursor(sTransaction, sCursorConfig);
        RangeCursor rangeCursor = new RangeCursor(keyRange, null, this.sortedDups, sCursor);
        return new BasicCursor<V>(rangeCursor, valueAdapter, this.isUpdateAllowed());
    }

    abstract boolean isUpdateAllowed();

    static {
        NO_RETURN_ENTRY.setPartial(0, 0, true);
    }
}

