/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.client;

import com.sleepycat.client.RemoteCallHelper;
import com.sleepycat.client.SDatabaseEntry;
import com.sleepycat.client.SDatabaseException;
import com.sleepycat.client.SOperationStatus;
import com.sleepycat.client.SSecondaryDatabase;
import com.sleepycat.client.ThriftWrapper;
import com.sleepycat.thrift.TDbt;
import com.sleepycat.thrift.TKeyDataWithSecondaryKeys;
import com.sleepycat.thrift.TPutResult;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.thrift.TException;

public interface PutHelper
extends RemoteCallHelper {
    default public TKeyDataWithSecondaryKeys calculateSKey(SDatabaseEntry sDatabaseEntry, SDatabaseEntry sDatabaseEntry2) {
        if (!this.getSecondaryDatabases().isEmpty() && sDatabaseEntry2.getPartial()) {
            throw new UnsupportedOperationException("Partial update is not supported for databases having secondary databases.");
        }
        TKeyDataWithSecondaryKeys tKeyDataWithSecondaryKeys = new TKeyDataWithSecondaryKeys();
        tKeyDataWithSecondaryKeys.setPkey((TDbt)sDatabaseEntry.getThriftObj()).setPdata((TDbt)sDatabaseEntry2.getThriftObj());
        HashMap hashMap = new HashMap();
        this.getSecondaryDatabases().forEach(sSecondaryDatabase -> {
            Set<SDatabaseEntry> set = sSecondaryDatabase.calculateSKeys(sDatabaseEntry, sDatabaseEntry2);
            List list = set.stream().map(ThriftWrapper::getThriftObj).collect(Collectors.toList());
            hashMap.put(sSecondaryDatabase.getThriftObj(), list);
        });
        tKeyDataWithSecondaryKeys.setSkeys(hashMap);
        return tKeyDataWithSecondaryKeys;
    }

    default public SOperationStatus remotePut(List<TKeyDataWithSecondaryKeys> list, SDatabaseEntry sDatabaseEntry, RemotePutFunction remotePutFunction) throws SDatabaseException {
        return this.remoteCall(() -> {
            TPutResult tPutResult = remotePutFunction.applyWithException(list);
            if (tPutResult.isSetNewRecordNumber()) {
                sDatabaseEntry.setData(tPutResult.getNewRecordNumber());
            }
            return SOperationStatus.toBdb(tPutResult.status);
        });
    }

    public Set<SSecondaryDatabase> getSecondaryDatabases();

    @FunctionalInterface
    public static interface RemotePutFunction {
        public TPutResult applyWithException(List<TKeyDataWithSecondaryKeys> var1) throws TException;
    }
}

