/* colord.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "Cd", gir_namespace = "Colord", gir_version = "1.0", lower_case_cprefix = "cd_")]
namespace Cd {
	[CCode (cheader_filename = "colord.h", type_id = "cd_client_get_type ()")]
	public class Client : GLib.Object {
		[CCode (has_construct_function = false)]
		public Client ();
		public async bool connect (GLib.Cancellable? cancellable) throws GLib.Error;
		public bool connect_sync (GLib.Cancellable? cancellable) throws GLib.Error;
		public async Cd.Device create_device (string id, Cd.ObjectScope scope, GLib.HashTable<string,string>? properties, GLib.Cancellable? cancellable) throws GLib.Error;
		public Cd.Device create_device_sync (string id, Cd.ObjectScope scope, GLib.HashTable<string,string>? properties, GLib.Cancellable? cancellable) throws GLib.Error;
		public async Cd.Profile create_profile (string id, Cd.ObjectScope scope, GLib.HashTable<string,string>? properties, GLib.Cancellable? cancellable) throws GLib.Error;
		public Cd.Profile create_profile_sync (string id, Cd.ObjectScope scope, GLib.HashTable<string,string>? properties, GLib.Cancellable? cancellable) throws GLib.Error;
		public async bool delete_device (Cd.Device device, GLib.Cancellable? cancellable) throws GLib.Error;
		public bool delete_device_sync (Cd.Device device, GLib.Cancellable? cancellable) throws GLib.Error;
		public async bool delete_profile (Cd.Profile profile, GLib.Cancellable? cancellable) throws GLib.Error;
		public bool delete_profile_sync (Cd.Profile profile, GLib.Cancellable? cancellable) throws GLib.Error;
		public static GLib.Quark error_quark ();
		public async Cd.Device find_device (string id, GLib.Cancellable? cancellable) throws GLib.Error;
		public async Cd.Device find_device_by_property (string key, string value, GLib.Cancellable? cancellable) throws GLib.Error;
		public Cd.Device find_device_by_property_sync (string key, string value, GLib.Cancellable? cancellable) throws GLib.Error;
		public Cd.Device find_device_sync (string id, GLib.Cancellable? cancellable) throws GLib.Error;
		public async Cd.Profile find_profile (string id, GLib.Cancellable? cancellable) throws GLib.Error;
		public async Cd.Profile find_profile_by_filename (string filename, GLib.Cancellable? cancellable) throws GLib.Error;
		public Cd.Profile find_profile_by_filename_sync (string filename, GLib.Cancellable? cancellable) throws GLib.Error;
		public Cd.Profile find_profile_sync (string id, GLib.Cancellable? cancellable) throws GLib.Error;
		public bool get_connected ();
		public unowned string get_daemon_version ();
		public async GLib.GenericArray<Cd.Device> get_devices (GLib.Cancellable? cancellable) throws GLib.Error;
		public async GLib.GenericArray<Cd.Device> get_devices_by_kind (Cd.DeviceKind kind, GLib.Cancellable? cancellable) throws GLib.Error;
		public GLib.GenericArray<Cd.Device> get_devices_by_kind_sync (Cd.DeviceKind kind, GLib.Cancellable? cancellable) throws GLib.Error;
		public GLib.GenericArray<Cd.Device> get_devices_sync (GLib.Cancellable? cancellable) throws GLib.Error;
		public bool get_has_server ();
		public async GLib.GenericArray<Cd.Profile> get_profiles (GLib.Cancellable? cancellable) throws GLib.Error;
		public GLib.GenericArray<Cd.Profile> get_profiles_sync (GLib.Cancellable? cancellable) throws GLib.Error;
		public async GLib.GenericArray<Cd.Sensor> get_sensors (GLib.Cancellable? cancellable) throws GLib.Error;
		public GLib.GenericArray<Cd.Sensor> get_sensors_sync (GLib.Cancellable? cancellable) throws GLib.Error;
		public async Cd.Profile get_standard_space (Cd.StandardSpace standard_space, GLib.Cancellable? cancellable) throws GLib.Error;
		public Cd.Profile get_standard_space_sync (Cd.StandardSpace standard_space, GLib.Cancellable? cancellable) throws GLib.Error;
		public async Cd.Profile import_profile (GLib.File file, GLib.Cancellable? cancellable) throws GLib.Error;
		public Cd.Profile import_profile_sync (GLib.File file, GLib.Cancellable? cancellable) throws GLib.Error;
		public string connected { get; }
		public string daemon_version { get; }
		public virtual signal void changed ();
		public virtual signal void device_added (Cd.Device device);
		public virtual signal void device_changed (Cd.Device device);
		public virtual signal void device_removed (Cd.Device device);
		public virtual signal void profile_added (Cd.Profile profile);
		public virtual signal void profile_changed (Cd.Profile profile);
		public virtual signal void profile_removed (Cd.Profile profile);
		public virtual signal void sensor_added (Cd.Sensor sensor);
		public virtual signal void sensor_changed (Cd.Sensor sensor);
		public virtual signal void sensor_removed (Cd.Sensor sensor);
	}
	[CCode (cheader_filename = "colord.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "cd_color_rgb_get_type ()")]
	[Compact]
	public class ColorRGB {
		public double B;
		public double G;
		public double R;
		public Cd.ColorRGB dup ();
	}
	[CCode (cheader_filename = "colord.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "cd_color_xyz_get_type ()")]
	[Compact]
	public class ColorXYZ {
		public double X;
		public double Y;
		public double Z;
		public Cd.ColorXYZ dup ();
	}
	[CCode (cheader_filename = "colord.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "cd_color_yxy_get_type ()")]
	[Compact]
	public class ColorYxy {
		public double Y;
		public double x;
		public double y;
		public Cd.ColorYxy dup ();
	}
	[CCode (cheader_filename = "colord.h", type_id = "cd_device_get_type ()")]
	public class Device : GLib.Object {
		[CCode (has_construct_function = false)]
		public Device ();
		public async bool add_profile (Cd.DeviceRelation relation, Cd.Profile profile, GLib.Cancellable? cancellable) throws GLib.Error;
		public bool add_profile_sync (Cd.DeviceRelation relation, Cd.Profile profile, GLib.Cancellable? cancellable) throws GLib.Error;
		public async bool connect (GLib.Cancellable? cancellable) throws GLib.Error;
		public bool connect_sync (GLib.Cancellable? cancellable) throws GLib.Error;
		public bool equal (Cd.Device device2);
		public static GLib.Quark error_quark ();
		public Cd.Colorspace get_colorspace ();
		public bool get_connected ();
		public uint64 get_created ();
		public Cd.Profile get_default_profile ();
		public unowned string get_format ();
		public unowned string get_id ();
		public Cd.DeviceKind get_kind ();
		public GLib.HashTable<string,string> get_metadata ();
		public unowned string get_metadata_item (string key);
		public Cd.DeviceMode get_mode ();
		public unowned string get_model ();
		public uint64 get_modified ();
		public unowned string get_object_path ();
		public uint get_owner ();
		public async Cd.Profile get_profile_for_qualifiers (string qualifiers, GLib.Cancellable? cancellable) throws GLib.Error;
		public Cd.Profile get_profile_for_qualifiers_sync (string qualifiers, GLib.Cancellable? cancellable) throws GLib.Error;
		public async Cd.DeviceRelation get_profile_relation (Cd.Profile profile, GLib.Cancellable? cancellable) throws GLib.Error;
		public Cd.DeviceRelation get_profile_relation_sync (Cd.Profile profile, GLib.Cancellable? cancellable) throws GLib.Error;
		public GLib.GenericArray<Cd.Profile> get_profiles ();
		[CCode (array_length = false, array_null_terminated = true)]
		public unowned string[] get_profiling_inhibitors ();
		public Cd.ObjectScope get_scope ();
		public unowned string get_serial ();
		public unowned string get_vendor ();
		public static Cd.DeviceKind kind_from_string (string kind);
		public static Cd.ProfileKind kind_to_profile_kind (Cd.DeviceKind device_kind);
		public static unowned string kind_to_string (Cd.DeviceKind kind_enum);
		public async bool make_profile_default (Cd.Profile profile, GLib.Cancellable? cancellable) throws GLib.Error;
		public bool make_profile_default_sync (Cd.Profile profile, GLib.Cancellable? cancellable) throws GLib.Error;
		public static Cd.DeviceMode mode_from_string (string device_mode);
		public static unowned string mode_to_string (Cd.DeviceMode device_mode);
		public async bool profiling_inhibit (GLib.Cancellable? cancellable) throws GLib.Error;
		public bool profiling_inhibit_sync (GLib.Cancellable? cancellable) throws GLib.Error;
		public async bool profiling_uninhibit (GLib.Cancellable? cancellable) throws GLib.Error;
		public bool profiling_uninhibit_sync (GLib.Cancellable? cancellable) throws GLib.Error;
		public static Cd.DeviceRelation relation_from_string (string device_relation);
		public static unowned string relation_to_string (Cd.DeviceRelation device_relation);
		public async bool remove_profile (Cd.Profile profile, GLib.Cancellable? cancellable) throws GLib.Error;
		public bool remove_profile_sync (Cd.Profile profile, GLib.Cancellable? cancellable) throws GLib.Error;
		public bool set_colorspace_sync (Cd.Colorspace colorspace, GLib.Cancellable? cancellable) throws GLib.Error;
		public bool set_kind_sync (Cd.DeviceKind kind, GLib.Cancellable? cancellable) throws GLib.Error;
		public bool set_mode_sync (Cd.DeviceMode mode, GLib.Cancellable? cancellable) throws GLib.Error;
		public bool set_model_sync (string value, GLib.Cancellable? cancellable) throws GLib.Error;
		public void set_object_path (string object_path);
		public async bool set_property (string key, string value, GLib.Cancellable? cancellable) throws GLib.Error;
		public bool set_property_sync (string key, string value, GLib.Cancellable? cancellable) throws GLib.Error;
		public bool set_serial_sync (string value, GLib.Cancellable? cancellable) throws GLib.Error;
		public bool set_vendor_sync (string value, GLib.Cancellable? cancellable) throws GLib.Error;
		public string to_string ();
		[CCode (has_construct_function = false)]
		public Device.with_object_path (string object_path);
		public uint colorspace { get; }
		public string connected { get; }
		public uint64 created { get; }
		public string format { get; }
		public string id { get; }
		public uint kind { get; }
		public uint mode { get; }
		public string model { get; }
		public uint64 modified { get; }
		public string object_path { get; set construct; }
		public uint owner { get; }
		[CCode (array_length = false, array_null_terminated = true)]
		public string[] profiling_inhibitors { get; }
		public uint scope { get; }
		public string serial { get; }
		public string vendor { get; }
		public virtual signal void changed ();
	}
	[CCode (cheader_filename = "colord.h", type_id = "cd_it8_get_type ()")]
	public class It8 : GLib.Object {
		[CCode (has_construct_function = false)]
		public It8 ();
		public void add_data (Cd.ColorRGB rgb, Cd.ColorXYZ xyz);
		public void add_option (string option);
		public static GLib.Quark error_quark ();
		public bool get_data_item (uint idx, Cd.ColorRGB rgb, Cd.ColorXYZ xyz);
		public uint get_data_size ();
		public unowned string get_instrument ();
		public Cd.It8Kind get_kind ();
		public Cd.Mat3x3 get_matrix ();
		public bool get_normalized ();
		public unowned string get_originator ();
		public unowned string get_reference ();
		public bool get_spectral ();
		public unowned string get_title ();
		public bool has_option (string option);
		public bool load_from_data (string data, size_t size) throws GLib.Error;
		public bool load_from_file (GLib.File file) throws GLib.Error;
		public bool save_to_file (GLib.File file) throws GLib.Error;
		public void set_instrument (string instrument);
		public void set_kind (Cd.It8Kind kind);
		public void set_matrix (Cd.Mat3x3 matrix);
		public void set_normalized (bool normalized);
		public void set_originator (string originator);
		public void set_reference (string reference);
		public void set_spectral (bool spectral);
		public void set_title (string title);
		public bool utils_calculate_ccmx (Cd.It8 it8_measured, Cd.It8 it8_ccmx) throws GLib.Error;
		[CCode (has_construct_function = false)]
		public It8.with_kind (Cd.It8Kind kind);
		public string instrument { get; }
		public uint kind { get; set; }
		public bool normalized { get; }
		public string originator { get; }
		public string reference { get; }
		public bool spectral { get; }
		public string title { get; }
	}
	[CCode (cheader_filename = "colord.h", type_id = "cd_profile_get_type ()")]
	public class Profile : GLib.Object {
		[CCode (has_construct_function = false)]
		public Profile ();
		public async bool connect (GLib.Cancellable? cancellable) throws GLib.Error;
		public bool connect_sync (GLib.Cancellable? cancellable) throws GLib.Error;
		public bool equal (Cd.Profile profile2);
		public static GLib.Quark error_quark ();
		public int64 get_age ();
		public Cd.Colorspace get_colorspace ();
		public bool get_connected ();
		public int64 get_created ();
		public unowned string get_filename ();
		public unowned string get_format ();
		public bool get_has_vcgt ();
		public unowned string get_id ();
		public bool get_is_system_wide ();
		public Cd.ProfileKind get_kind ();
		public GLib.HashTable<string,string> get_metadata ();
		public unowned string get_metadata_item (string key);
		public unowned string get_object_path ();
		public uint get_owner ();
		public unowned string get_qualifier ();
		public Cd.ObjectScope get_scope ();
		public unowned string get_title ();
		public bool has_access ();
		public async bool install_system_wide (GLib.Cancellable? cancellable) throws GLib.Error;
		public bool install_system_wide_sync (GLib.Cancellable? cancellable) throws GLib.Error;
		public static Cd.ProfileKind kind_from_string (string profile_kind);
		public static unowned string kind_to_string (Cd.ProfileKind profile_kind);
		public bool set_filename_sync (string value, GLib.Cancellable? cancellable) throws GLib.Error;
		public void set_object_path (string object_path);
		public async bool set_property (string key, string value, GLib.Cancellable? cancellable) throws GLib.Error;
		public bool set_property_sync (string key, string value, GLib.Cancellable? cancellable) throws GLib.Error;
		public bool set_qualifier_sync (string value, GLib.Cancellable? cancellable) throws GLib.Error;
		public string to_string ();
		[CCode (has_construct_function = false)]
		public Profile.with_object_path (string object_path);
		public string colorspace { get; }
		public string connected { get; }
		public int64 created { get; }
		public string filename { get; }
		public string format { get; }
		public string has_vcgt { get; }
		public string id { get; }
		public string is_system_wide { get; }
		public string kind { get; }
		public string object_path { get; set construct; }
		public uint owner { get; }
		public string qualifier { get; }
		public uint scope { get; }
		public string title { get; }
		public virtual signal void changed ();
	}
	[CCode (cheader_filename = "colord.h", type_id = "cd_sensor_get_type ()")]
	public class Sensor : GLib.Object {
		[CCode (has_construct_function = false)]
		public Sensor ();
		public static Cd.SensorCap cap_from_string (string sensor_cap);
		public static unowned string cap_to_string (Cd.SensorCap sensor_cap);
		public async bool connect (GLib.Cancellable? cancellable) throws GLib.Error;
		public bool connect_sync (GLib.Cancellable? cancellable) throws GLib.Error;
		public bool equal (Cd.Sensor sensor2);
		public static GLib.Quark error_quark ();
		public uint get_caps ();
		public bool get_connected ();
		public Cd.SensorKind get_kind ();
		public bool get_locked ();
		public Cd.SensorCap get_mode ();
		public unowned string get_model ();
		public bool get_native ();
		public unowned string get_object_path ();
		public unowned string get_option (string key);
		public GLib.HashTable<string,GLib.Variant> get_options ();
		public async Cd.ColorXYZ get_sample (Cd.SensorCap cap, GLib.Cancellable? cancellable) throws GLib.Error;
		public Cd.ColorXYZ get_sample_sync (Cd.SensorCap cap, GLib.Cancellable? cancellable) throws GLib.Error;
		public unowned string get_serial ();
		public Cd.SensorState get_state ();
		public unowned string get_vendor ();
		public bool has_cap (Cd.SensorCap cap);
		public static Cd.SensorKind kind_from_string (string sensor_kind);
		public static unowned string kind_to_string (Cd.SensorKind sensor_kind);
		public async bool @lock (GLib.Cancellable? cancellable) throws GLib.Error;
		public bool lock_sync (GLib.Cancellable? cancellable) throws GLib.Error;
		public void set_object_path (string object_path);
		public async bool set_options (GLib.HashTable<string,GLib.Variant> values, GLib.Cancellable? cancellable) throws GLib.Error;
		public bool set_options_sync (GLib.HashTable<string,GLib.Variant> values, GLib.Cancellable? cancellable) throws GLib.Error;
		public static Cd.SensorState state_from_string (string sensor_state);
		public static unowned string state_to_string (Cd.SensorState sensor_state);
		public string to_string ();
		public async bool unlock (GLib.Cancellable? cancellable) throws GLib.Error;
		public bool unlock_sync (GLib.Cancellable? cancellable) throws GLib.Error;
		[CCode (has_construct_function = false)]
		public Sensor.with_object_path (string object_path);
		public string connected { get; }
		public string kind { get; }
		public string locked { get; }
		public string mode { get; }
		public string model { get; }
		public string native { get; }
		public string object_path { get; set construct; }
		public string serial { get; }
		public string state { get; }
		public string vendor { get; }
		public virtual signal void button_pressed ();
	}
	[CCode (cheader_filename = "colord.h", has_type_id = false)]
	public struct ColorLab {
		public double L;
		public double a;
		public double b;
	}
	[CCode (cheader_filename = "colord.h", has_type_id = false)]
	public struct ColorRGB8 {
		public uint8 R;
		public uint8 G;
		public uint8 B;
	}
	[CCode (cheader_filename = "colord.h", has_type_id = false)]
	public struct Mat3x3 {
		public double m00;
		public double m01;
		public double m02;
		public double m10;
		public double m11;
		public double m12;
		public double m20;
		public double m21;
		public double m22;
	}
	[CCode (cheader_filename = "colord.h", has_type_id = false)]
	public struct Vec3 {
		public double v0;
		public double v1;
		public double v2;
		public void add (Cd.Vec3 src2, Cd.Vec3 dest);
		public void clear ();
		public void copy (Cd.Vec3 dest);
		public double get_data ();
		public void init (double v0, double v1, double v2);
		public void scalar_multiply (double value, Cd.Vec3 dest);
		public double squared_error (Cd.Vec3 src2);
		public void subtract (Cd.Vec3 src2, Cd.Vec3 dest);
		public string to_string ();
	}
	[CCode (cheader_filename = "colord.h", cprefix = "CD_CLIENT_ERROR_")]
	public enum ClientError {
		FAILED,
		ALREADY_EXISTS,
		FILE_INVALID,
		LAST
	}
	[CCode (cheader_filename = "colord.h", cprefix = "CD_COLORSPACE_")]
	public enum Colorspace {
		UNKNOWN,
		XYZ,
		LAB,
		LUV,
		YCBCR,
		YXY,
		RGB,
		GRAY,
		HSV,
		CMYK,
		CMY,
		LAST;
		public static Cd.Colorspace from_string (string colorspace);
		public static unowned string to_string (Cd.Colorspace colorspace);
	}
	[CCode (cheader_filename = "colord.h", cprefix = "CD_DEVICE_ERROR_")]
	public enum DeviceError {
		FAILED,
		LAST
	}
	[CCode (cheader_filename = "colord.h", cprefix = "CD_DEVICE_KIND_")]
	public enum DeviceKind {
		UNKNOWN,
		DISPLAY,
		SCANNER,
		PRINTER,
		CAMERA,
		WEBCAM,
		LAST
	}
	[CCode (cheader_filename = "colord.h", cprefix = "CD_DEVICE_MODE_")]
	public enum DeviceMode {
		UNKNOWN,
		PHYSICAL,
		VIRTUAL,
		LAST
	}
	[CCode (cheader_filename = "colord.h", cprefix = "CD_DEVICE_RELATION_")]
	public enum DeviceRelation {
		UNKNOWN,
		SOFT,
		HARD,
		LAST
	}
	[CCode (cheader_filename = "colord.h", cprefix = "CD_IT8_ERROR_")]
	public enum It8Error {
		FAILED,
		LAST
	}
	[CCode (cheader_filename = "colord.h", cprefix = "CD_IT8_KIND_")]
	public enum It8Kind {
		UNKNOWN,
		TI1,
		TI3,
		CCMX,
		LAST
	}
	[CCode (cheader_filename = "colord.h", cprefix = "CD_OBJECT_SCOPE_")]
	public enum ObjectScope {
		UNKNOWN,
		NORMAL,
		TEMP,
		DISK,
		LAST;
		public static Cd.ObjectScope from_string (string object_scope);
		public static unowned string to_string (Cd.ObjectScope object_scope);
	}
	[CCode (cheader_filename = "colord.h", cprefix = "CD_PROFILE_ERROR_")]
	public enum ProfileError {
		FAILED,
		LAST
	}
	[CCode (cheader_filename = "colord.h", cprefix = "CD_PROFILE_KIND_")]
	public enum ProfileKind {
		UNKNOWN,
		INPUT_DEVICE,
		DISPLAY_DEVICE,
		OUTPUT_DEVICE,
		DEVICELINK,
		COLORSPACE_CONVERSION,
		ABSTRACT,
		NAMED_COLOR,
		LAST
	}
	[CCode (cheader_filename = "colord.h", cprefix = "CD_RENDERING_INTENT_")]
	public enum RenderingIntent {
		UNKNOWN,
		PERCEPTUAL,
		RELATIVE_COLORIMETRIC,
		SATURATION,
		ABSOLUTE_COLORIMETRIC,
		LAST;
		public static Cd.RenderingIntent from_string (string rendering_intent);
		public static unowned string to_string (Cd.RenderingIntent rendering_intent);
	}
	[CCode (cheader_filename = "colord.h", cprefix = "CD_SENSOR_CAP_")]
	public enum SensorCap {
		UNKNOWN,
		LCD,
		CRT,
		PRINTER,
		SPOT,
		PROJECTOR,
		AMBIENT,
		CALIBRATION,
		LED,
		LAST
	}
	[CCode (cheader_filename = "colord.h", cprefix = "CD_SENSOR_ERROR_")]
	public enum SensorError {
		FAILED,
		LAST
	}
	[CCode (cheader_filename = "colord.h", cprefix = "CD_SENSOR_KIND_")]
	public enum SensorKind {
		UNKNOWN,
		DUMMY,
		HUEY,
		COLOR_MUNKI,
		SPYDER,
		DTP20,
		DTP22,
		DTP41,
		DTP51,
		DTP94,
		SPECTRO_SCAN,
		I1_PRO,
		COLORIMTRE_HCFR,
		I1_DISPLAY3,
		COLORHUG,
		SPYDER2,
		SPYDER3,
		LAST
	}
	[CCode (cheader_filename = "colord.h", cprefix = "CD_SENSOR_STATE_")]
	public enum SensorState {
		UNKNOWN,
		STARTING,
		IDLE,
		MEASURING,
		BUSY,
		LAST
	}
	[CCode (cheader_filename = "colord.h", cprefix = "CD_STANDARD_SPACE_")]
	public enum StandardSpace {
		UNKNOWN,
		SRGB,
		ADOBE_RGB,
		PROPHOTO_RGB,
		LAST;
		public static Cd.StandardSpace from_string (string standard_space);
		public static unowned string to_string (Cd.StandardSpace standard_space);
	}
	[CCode (cheader_filename = "colord.h", cname = "CD_CLIENT_PROPERTY_DAEMON_VERSION")]
	public const string CLIENT_PROPERTY_DAEMON_VERSION;
	[CCode (cheader_filename = "colord.h", cname = "CD_DEVICE_METADATA_XRANDR_NAME")]
	public const string DEVICE_METADATA_XRANDR_NAME;
	[CCode (cheader_filename = "colord.h", cname = "CD_DEVICE_PROPERTY_COLORSPACE")]
	public const string DEVICE_PROPERTY_COLORSPACE;
	[CCode (cheader_filename = "colord.h", cname = "CD_DEVICE_PROPERTY_CREATED")]
	public const string DEVICE_PROPERTY_CREATED;
	[CCode (cheader_filename = "colord.h", cname = "CD_DEVICE_PROPERTY_FORMAT")]
	public const string DEVICE_PROPERTY_FORMAT;
	[CCode (cheader_filename = "colord.h", cname = "CD_DEVICE_PROPERTY_ID")]
	public const string DEVICE_PROPERTY_ID;
	[CCode (cheader_filename = "colord.h", cname = "CD_DEVICE_PROPERTY_KIND")]
	public const string DEVICE_PROPERTY_KIND;
	[CCode (cheader_filename = "colord.h", cname = "CD_DEVICE_PROPERTY_METADATA")]
	public const string DEVICE_PROPERTY_METADATA;
	[CCode (cheader_filename = "colord.h", cname = "CD_DEVICE_PROPERTY_MODE")]
	public const string DEVICE_PROPERTY_MODE;
	[CCode (cheader_filename = "colord.h", cname = "CD_DEVICE_PROPERTY_MODEL")]
	public const string DEVICE_PROPERTY_MODEL;
	[CCode (cheader_filename = "colord.h", cname = "CD_DEVICE_PROPERTY_MODIFIED")]
	public const string DEVICE_PROPERTY_MODIFIED;
	[CCode (cheader_filename = "colord.h", cname = "CD_DEVICE_PROPERTY_OWNER")]
	public const string DEVICE_PROPERTY_OWNER;
	[CCode (cheader_filename = "colord.h", cname = "CD_DEVICE_PROPERTY_PROFILES")]
	public const string DEVICE_PROPERTY_PROFILES;
	[CCode (cheader_filename = "colord.h", cname = "CD_DEVICE_PROPERTY_PROFILING_INHIBITORS")]
	public const string DEVICE_PROPERTY_PROFILING_INHIBITORS;
	[CCode (cheader_filename = "colord.h", cname = "CD_DEVICE_PROPERTY_SCOPE")]
	public const string DEVICE_PROPERTY_SCOPE;
	[CCode (cheader_filename = "colord.h", cname = "CD_DEVICE_PROPERTY_SERIAL")]
	public const string DEVICE_PROPERTY_SERIAL;
	[CCode (cheader_filename = "colord.h", cname = "CD_DEVICE_PROPERTY_VENDOR")]
	public const string DEVICE_PROPERTY_VENDOR;
	[CCode (cheader_filename = "colord.h", cname = "CD_MAJOR_VERSION")]
	public const int MAJOR_VERSION;
	[CCode (cheader_filename = "colord.h", cname = "CD_MICRO_VERSION")]
	public const int MICRO_VERSION;
	[CCode (cheader_filename = "colord.h", cname = "CD_MINOR_VERSION")]
	public const int MINOR_VERSION;
	[CCode (cheader_filename = "colord.h", cname = "CD_PROFILE_METADATA_ACCURACY_DE76_AVG")]
	public const string PROFILE_METADATA_ACCURACY_DE76_AVG;
	[CCode (cheader_filename = "colord.h", cname = "CD_PROFILE_METADATA_ACCURACY_DE76_MAX")]
	public const string PROFILE_METADATA_ACCURACY_DE76_MAX;
	[CCode (cheader_filename = "colord.h", cname = "CD_PROFILE_METADATA_ACCURACY_DE76_RMS")]
	public const string PROFILE_METADATA_ACCURACY_DE76_RMS;
	[CCode (cheader_filename = "colord.h", cname = "CD_PROFILE_METADATA_CMF_BINARY")]
	public const string PROFILE_METADATA_CMF_BINARY;
	[CCode (cheader_filename = "colord.h", cname = "CD_PROFILE_METADATA_CMF_PRODUCT")]
	public const string PROFILE_METADATA_CMF_PRODUCT;
	[CCode (cheader_filename = "colord.h", cname = "CD_PROFILE_METADATA_CMF_VERSION")]
	public const string PROFILE_METADATA_CMF_VERSION;
	[CCode (cheader_filename = "colord.h", cname = "CD_PROFILE_METADATA_CONNECTION_TYPE")]
	public const string PROFILE_METADATA_CONNECTION_TYPE;
	[CCode (cheader_filename = "colord.h", cname = "CD_PROFILE_METADATA_CONNECTION_TYPE_DISPLAYPORT")]
	public const string PROFILE_METADATA_CONNECTION_TYPE_DISPLAYPORT;
	[CCode (cheader_filename = "colord.h", cname = "CD_PROFILE_METADATA_CONNECTION_TYPE_DVI")]
	public const string PROFILE_METADATA_CONNECTION_TYPE_DVI;
	[CCode (cheader_filename = "colord.h", cname = "CD_PROFILE_METADATA_CONNECTION_TYPE_HDMI")]
	public const string PROFILE_METADATA_CONNECTION_TYPE_HDMI;
	[CCode (cheader_filename = "colord.h", cname = "CD_PROFILE_METADATA_CONNECTION_TYPE_INTERNAL")]
	public const string PROFILE_METADATA_CONNECTION_TYPE_INTERNAL;
	[CCode (cheader_filename = "colord.h", cname = "CD_PROFILE_METADATA_CONNECTION_TYPE_VGA")]
	public const string PROFILE_METADATA_CONNECTION_TYPE_VGA;
	[CCode (cheader_filename = "colord.h", cname = "CD_PROFILE_METADATA_DATA_SOURCE")]
	public const string PROFILE_METADATA_DATA_SOURCE;
	[CCode (cheader_filename = "colord.h", cname = "CD_PROFILE_METADATA_DATA_SOURCE_CALIB")]
	public const string PROFILE_METADATA_DATA_SOURCE_CALIB;
	[CCode (cheader_filename = "colord.h", cname = "CD_PROFILE_METADATA_DATA_SOURCE_EDID")]
	public const string PROFILE_METADATA_DATA_SOURCE_EDID;
	[CCode (cheader_filename = "colord.h", cname = "CD_PROFILE_METADATA_DATA_SOURCE_STANDARD")]
	public const string PROFILE_METADATA_DATA_SOURCE_STANDARD;
	[CCode (cheader_filename = "colord.h", cname = "CD_PROFILE_METADATA_DATA_SOURCE_TEST")]
	public const string PROFILE_METADATA_DATA_SOURCE_TEST;
	[CCode (cheader_filename = "colord.h", cname = "CD_PROFILE_METADATA_EDID_MD5")]
	public const string PROFILE_METADATA_EDID_MD5;
	[CCode (cheader_filename = "colord.h", cname = "CD_PROFILE_METADATA_EDID_MNFT")]
	public const string PROFILE_METADATA_EDID_MNFT;
	[CCode (cheader_filename = "colord.h", cname = "CD_PROFILE_METADATA_EDID_MODEL")]
	public const string PROFILE_METADATA_EDID_MODEL;
	[CCode (cheader_filename = "colord.h", cname = "CD_PROFILE_METADATA_EDID_SERIAL")]
	public const string PROFILE_METADATA_EDID_SERIAL;
	[CCode (cheader_filename = "colord.h", cname = "CD_PROFILE_METADATA_EDID_VENDOR")]
	public const string PROFILE_METADATA_EDID_VENDOR;
	[CCode (cheader_filename = "colord.h", cname = "CD_PROFILE_METADATA_FILE_CHECKSUM")]
	public const string PROFILE_METADATA_FILE_CHECKSUM;
	[CCode (cheader_filename = "colord.h", cname = "CD_PROFILE_METADATA_MAPPING_DEVICE_ID")]
	public const string PROFILE_METADATA_MAPPING_DEVICE_ID;
	[CCode (cheader_filename = "colord.h", cname = "CD_PROFILE_METADATA_MAPPING_FORMAT")]
	public const string PROFILE_METADATA_MAPPING_FORMAT;
	[CCode (cheader_filename = "colord.h", cname = "CD_PROFILE_METADATA_MAPPING_QUALIFIER")]
	public const string PROFILE_METADATA_MAPPING_QUALIFIER;
	[CCode (cheader_filename = "colord.h", cname = "CD_PROFILE_METADATA_MEASUREMENT_DEVICE")]
	public const string PROFILE_METADATA_MEASUREMENT_DEVICE;
	[CCode (cheader_filename = "colord.h", cname = "CD_PROFILE_METADATA_SCREEN_BRIGHTNESS")]
	public const string PROFILE_METADATA_SCREEN_BRIGHTNESS;
	[CCode (cheader_filename = "colord.h", cname = "CD_PROFILE_METADATA_SCREEN_SURFACE")]
	public const string PROFILE_METADATA_SCREEN_SURFACE;
	[CCode (cheader_filename = "colord.h", cname = "CD_PROFILE_METADATA_SCREEN_SURFACE_GLOSSY")]
	public const string PROFILE_METADATA_SCREEN_SURFACE_GLOSSY;
	[CCode (cheader_filename = "colord.h", cname = "CD_PROFILE_METADATA_SCREEN_SURFACE_MATTE")]
	public const string PROFILE_METADATA_SCREEN_SURFACE_MATTE;
	[CCode (cheader_filename = "colord.h", cname = "CD_PROFILE_METADATA_STANDARD_SPACE")]
	public const string PROFILE_METADATA_STANDARD_SPACE;
	[CCode (cheader_filename = "colord.h", cname = "CD_PROFILE_PROPERTY_COLORSPACE")]
	public const string PROFILE_PROPERTY_COLORSPACE;
	[CCode (cheader_filename = "colord.h", cname = "CD_PROFILE_PROPERTY_CREATED")]
	public const string PROFILE_PROPERTY_CREATED;
	[CCode (cheader_filename = "colord.h", cname = "CD_PROFILE_PROPERTY_FILENAME")]
	public const string PROFILE_PROPERTY_FILENAME;
	[CCode (cheader_filename = "colord.h", cname = "CD_PROFILE_PROPERTY_FORMAT")]
	public const string PROFILE_PROPERTY_FORMAT;
	[CCode (cheader_filename = "colord.h", cname = "CD_PROFILE_PROPERTY_HAS_VCGT")]
	public const string PROFILE_PROPERTY_HAS_VCGT;
	[CCode (cheader_filename = "colord.h", cname = "CD_PROFILE_PROPERTY_ID")]
	public const string PROFILE_PROPERTY_ID;
	[CCode (cheader_filename = "colord.h", cname = "CD_PROFILE_PROPERTY_IS_SYSTEM_WIDE")]
	public const string PROFILE_PROPERTY_IS_SYSTEM_WIDE;
	[CCode (cheader_filename = "colord.h", cname = "CD_PROFILE_PROPERTY_KIND")]
	public const string PROFILE_PROPERTY_KIND;
	[CCode (cheader_filename = "colord.h", cname = "CD_PROFILE_PROPERTY_METADATA")]
	public const string PROFILE_PROPERTY_METADATA;
	[CCode (cheader_filename = "colord.h", cname = "CD_PROFILE_PROPERTY_OWNER")]
	public const string PROFILE_PROPERTY_OWNER;
	[CCode (cheader_filename = "colord.h", cname = "CD_PROFILE_PROPERTY_QUALIFIER")]
	public const string PROFILE_PROPERTY_QUALIFIER;
	[CCode (cheader_filename = "colord.h", cname = "CD_PROFILE_PROPERTY_SCOPE")]
	public const string PROFILE_PROPERTY_SCOPE;
	[CCode (cheader_filename = "colord.h", cname = "CD_PROFILE_PROPERTY_TITLE")]
	public const string PROFILE_PROPERTY_TITLE;
	[CCode (cheader_filename = "colord.h")]
	public static void color_clear_xyz (Cd.ColorXYZ dest);
	[CCode (cheader_filename = "colord.h")]
	public static void color_convert_rgb8_to_rgb (Cd.ColorRGB8 src, Cd.ColorRGB dest);
	[CCode (cheader_filename = "colord.h")]
	public static void color_convert_rgb_to_rgb8 (Cd.ColorRGB src, Cd.ColorRGB8 dest);
	[CCode (cheader_filename = "colord.h")]
	public static void color_convert_xyz_to_yxy (Cd.ColorXYZ src, Cd.ColorYxy dest);
	[CCode (cheader_filename = "colord.h")]
	public static void color_convert_yxy_to_xyz (Cd.ColorYxy src, Cd.ColorXYZ dest);
	[CCode (cheader_filename = "colord.h")]
	public static void color_copy_rgb (Cd.ColorRGB src, Cd.ColorRGB dest);
	[CCode (cheader_filename = "colord.h")]
	public static void color_copy_xyz (Cd.ColorXYZ src, Cd.ColorXYZ dest);
	[CCode (cheader_filename = "colord.h")]
	public static void color_copy_yxy (Cd.ColorYxy src, Cd.ColorYxy dest);
	[CCode (cheader_filename = "colord.h")]
	public static void color_set_rgb (Cd.ColorRGB dest, double R, double G, double B);
	[CCode (cheader_filename = "colord.h")]
	public static void color_set_xyz (Cd.ColorXYZ dest, double X, double Y, double Z);
	[CCode (cheader_filename = "colord.h")]
	public static void color_set_yxy (Cd.ColorYxy dest, double Y, double x, double y);
	[CCode (cheader_filename = "colord.h")]
	public static void mat33_clear (Cd.Mat3x3 src);
	[CCode (cheader_filename = "colord.h")]
	public static void mat33_copy (Cd.Mat3x3 src, Cd.Mat3x3 dest);
	[CCode (cheader_filename = "colord.h")]
	public static double mat33_determinant (Cd.Mat3x3 src);
	[CCode (cheader_filename = "colord.h")]
	public static double mat33_get_data (Cd.Mat3x3 src);
	[CCode (cheader_filename = "colord.h")]
	public static void mat33_matrix_multiply (Cd.Mat3x3 mat_src1, Cd.Mat3x3 mat_src2, Cd.Mat3x3 mat_dest);
	[CCode (cheader_filename = "colord.h")]
	public static void mat33_normalize (Cd.Mat3x3 src, Cd.Mat3x3 dest);
	[CCode (cheader_filename = "colord.h")]
	public static bool mat33_reciprocal (Cd.Mat3x3 src, Cd.Mat3x3 dest);
	[CCode (cheader_filename = "colord.h")]
	public static void mat33_scalar_multiply (Cd.Mat3x3 mat_src, double value, Cd.Mat3x3 mat_dest);
	[CCode (cheader_filename = "colord.h")]
	public static void mat33_set_identity (Cd.Mat3x3 src);
	[CCode (cheader_filename = "colord.h")]
	public static string mat33_to_string (Cd.Mat3x3 src);
	[CCode (cheader_filename = "colord.h")]
	public static void mat33_vector_multiply (Cd.Mat3x3 mat_src, Cd.Vec3 vec_src, Cd.Vec3 vec_dest);
}
