/*
            Copyright Oliver Kowalke 2009.
   Distributed under the Boost Software License, Version 1.0.
      (See accompanying file LICENSE_1_0.txt or copy at
          http://www.boost.org/LICENSE_1_0.txt)
*/

/*******************************************************************
 *                                                                 *
 *  -------------------------------------------------------------  *
 *  |  0  |  1  |  2  |  3  |  4  |  5  |  6  |  7  |  8  |  9  |  *
 *  -------------------------------------------------------------  *
 *  |  0  |  4  |   8 |  12 |  16 |  20 |  24 |  28 |  32 |  36 |  *
 *  -------------------------------------------------------------  *
 *  |    R13    |    R14    |    R15    |    R16    |    R17    |  *
 *  -------------------------------------------------------------  *
 *  -------------------------------------------------------------  *
 *  |  10 |  11 |  12 |  13 |  14 |  15 |  16 |  17 |  18 |  19 |  *
 *  -------------------------------------------------------------  *
 *  |  40 |  44 |  48 |  52 |  56 |  60 |  64 |  68 |  72 |  76 |  *
 *  -------------------------------------------------------------  *
 *  |    R18    |    R19    |    R20    |    R21    |    R22    |  *
 *  -------------------------------------------------------------  *
 *  -------------------------------------------------------------  *
 *  |  20 |  21 |  22 |  23 |  24 |  25 |  26 |  27 |  28 |  29 |  *
 *  -------------------------------------------------------------  *
 *  |  80 |  84 |  88 |  92 |  96 | 100 | 104 | 108 | 112 | 116 |  *
 *  -------------------------------------------------------------  *
 *  |    R23    |    R24    |    R25    |    R26    |    R27    |  *
 *  -------------------------------------------------------------  *
 *  -------------------------------------------------------------  *
 *  |  30 |  31 |  32 |  33 |  34 |  35 |  36 |  37 |  38 |  39 |  *
 *  -------------------------------------------------------------  *
 *  | 120 | 124 | 128 | 132 | 136 | 140 | 144 | 148 | 152 | 156 |  *
 *  -------------------------------------------------------------  *
 *  |    R28    |    R29    |    R30    |    R31    |     SP    |  *
 *  -------------------------------------------------------------  *
 *  -------------------------------------------------------------  *
 *  |  40 |  41 |  42 |  43 |  44 |  45 |                       |  *
 *  -------------------------------------------------------------  *
 *  | 160 | 164 | 168 | 172 | 176 | 180 |                       |  *
 *  -------------------------------------------------------------  *
 *  |    CR     |    LR     |     PC    |                       |  *
 *  -------------------------------------------------------------  *
 *  -------------------------------------------------------------  *
 *  |  46 |  47 |  48 |  49 |                                   |  *
 *  -------------------------------------------------------------  *
 *  | 184 | 188 | 192 | 196 |                                   |  *
 *  -------------------------------------------------------------  *
 *  |    sp     |    size   |                                   |  *
 *  -------------------------------------------------------------  *
 *  -------------------------------------------------------------  *
 *  |  50 |  51 |  52 |  53 |  54 |  55 |  56 |  57 |  58 |  59 |  *
 *  -------------------------------------------------------------  *
 *  | 200 | 204 | 208 | 212 | 216 | 220 | 224 | 228 | 232 | 236 |  *
 *  -------------------------------------------------------------  *
 *  |    F14    |    F15    |    F16    |    F17    |    F18    |  *
 *  -------------------------------------------------------------  *
 *  -------------------------------------------------------------  *
 *  |  60 |  61 |  62 |  63 |  64 |  65 |  66 |  67 |  68 |  69 |  *
 *  -------------------------------------------------------------  *
 *  | 240 | 244 | 248 | 252 | 256 | 260 | 264 | 268 | 272 | 276 |  *
 *  -------------------------------------------------------------  *
 *  |    F19    |    F20    |    F21    |    F22    |    F23    |  *
 *  -------------------------------------------------------------  *
 *  -------------------------------------------------------------  *
 *  |  70 |  71 |  72 |  73 |  74 |  75 |  76 |  77 |  78 |  79 |  *
 *  -------------------------------------------------------------  *
 *  | 280 | 284 | 288 | 292 | 296 | 300 | 304 | 308 | 312 | 316 |  *
 *  -------------------------------------------------------------  *
 *  |    F24    |    F25    |    F26    |    F27    |    F28    |  *
 *  -------------------------------------------------------------  *
 *  -------------------------------------------------------------  *
 *  |  80 |  81 |  82 |  83 |  84 |  85 |  86 |  87 |           |  *
 *  -------------------------------------------------------------  *
 *  | 320 | 324 | 328 | 332 | 336 | 340 | 344 | 348 |           |  *
 *  -------------------------------------------------------------  *
 *  |    F29    |    F30    |    F31    |   fpscr   |           |  *
 *  -------------------------------------------------------------  *
 *                                                                 *
 * *****************************************************************/

.section ".text"
.align 2
.globl jump_fcontext
.section ".opd","aw"
.align 3
jump_fcontext:
.quad .jump_fcontext,.TOC.@tocbase,0
.previous
.size jump_fcontext,24
.type .jump_fcontext,@function
.globl .jump_fcontext
.jump_fcontext:
    std     %r13,  0(%r3)       # save R13
    std     %r14,  8(%r3)       # save R14
    std     %r15,  16(%r3)      # save R15
    std     %r16,  24(%r3)      # save R16
    std     %r17,  32(%r3)      # save R17
    std     %r18,  40(%r3)      # save R18
    std     %r19,  48(%r3)      # save R19
    std     %r20,  56(%r3)      # save R20
    std     %r21,  64(%r3)      # save R21
    std     %r22,  72(%r3)      # save R22
    std     %r23,  80(%r3)      # save R23
    std     %r24,  88(%r3)      # save R24
    std     %r25,  96(%r3)      # save R25
    std     %r26,  104(%r3)     # save R26
    std     %r27,  112(%r3)     # save R27
    std     %r28,  120(%r3)     # save R28
    std     %r29,  128(%r3)     # save R29
    std     %r30,  136(%r3)     # save R30
    std     %r31,  144(%r3)     # save R31
    std     %r1,   152(%r3)     # save SP

    mfcr    %r0                 # load CR
    std     %r0,   160(%r3)     # save CR
    mflr    %r0                 # load LR
    std     %r0,   168(%r3)     # save LR
    std     %r0,   176(%r3)     # save LR as PC

    cmpwi   cr7,   %r6,  0      # test if fpu env should be preserved
    beq     cr7,   1f

    stfd    %f14,  200(%r3)     # save F14
    stfd    %f15,  208(%r3)     # save F15
    stfd    %f16,  216(%r3)     # save F16
    stfd    %f17,  224(%r3)     # save F17
    stfd    %f18,  232(%r3)     # save F18
    stfd    %f19,  240(%r3)     # save F19
    stfd    %f20,  248(%r3)     # save F20
    stfd    %f21,  256(%r3)     # save F21
    stfd    %f22,  264(%r3)     # save F22
    stfd    %f23,  272(%r3)     # save F23
    stfd    %f24,  280(%r3)     # save F24
    stfd    %f25,  288(%r3)     # save F25
    stfd    %f26,  296(%r3)     # save F26
    stfd    %f27,  304(%r3)     # save F27
    stfd    %f28,  312(%r3)     # save F28
    stfd    %f29,  320(%r3)     # save F29
    stfd    %f30,  328(%r3)     # save F30
    stfd    %f31,  336(%r3)     # save F31
    mffs    %f0                 # load FPSCR
    stfd    %f0,   344(%r3)     # save FPSCR

    lfd     %f14,  200(%r4)     # restore F14
    lfd     %f15,  208(%r4)     # restore F15
    lfd     %f16,  216(%r4)     # restore F16
    lfd     %f17,  224(%r4)     # restore F17
    lfd     %f18,  232(%r4)     # restore F18
    lfd     %f19,  240(%r4)     # restore F19
    lfd     %f20,  248(%r4)     # restore F20
    lfd     %f21,  256(%r4)     # restore F21
    lfd     %f22,  264(%r4)     # restore F22
    lfd     %f23,  272(%r4)     # restore F23
    lfd     %f24,  280(%r4)     # restore F24
    lfd     %f25,  288(%r4)     # restore F25
    lfd     %f26,  296(%r4)     # restore F26
    lfd     %f27,  304(%r4)     # restore F27
    lfd     %f28,  312(%r4)     # restore F28
    lfd     %f29,  320(%r4)     # restore F29
    lfd     %f30,  328(%r4)     # restore F30
    lfd     %f31,  336(%r4)     # restore F31
    lfd     %f0,   344(%r4)     # load FPSCR
    mtfsf   0xff,  %f0          # restore FPSCR
1:

    ld      %r13,  0(%r4)       # restore R13
    ld      %r14,  8(%r4)       # restore R14
    ld      %r15,  16(%r4)      # restore R15
    ld      %r16,  24(%r4)      # restore R16
    ld      %r17,  32(%r4)      # restore R17
    ld      %r18,  40(%r4)      # restore R18
    ld      %r19,  48(%r4)      # restore R19
    ld      %r20,  56(%r4)      # restore R20
    ld      %r21,  64(%r4)      # restore R21
    ld      %r22,  72(%r4)      # restore R22
    ld      %r23,  80(%r4)      # restore R23
    ld      %r24,  88(%r4)      # restore R24
    ld      %r25,  96(%r4)      # restore R25
    ld      %r26,  104(%r4)     # restore R26
    ld      %r27,  112(%r4)     # restore R27
    ld      %r28,  120(%r4)     # restore R28
    ld      %r29,  128(%r4)     # restore R29
    ld      %r30,  136(%r4)     # restore r30
    ld      %r31,  144(%r4)     # restore r31
    ld      %r1,   152(%r4)     # restore SP

    ld      %r0,   160(%r4)     # load CR
    mtcr    %r0                 # restore CR
    ld      %r0,   168(%r4)     # load LR
    mtlr    %r0                 # restore LR

    mr.     %r3,   %r5          # use third arg as return value after jump
                                # and as first arg in context function

    ld      %r0,   176(%r4)     # load PC
    mtctr   %r0                 # restore CTR

    bctr                        # jump to context
.size .jump_fcontext, .-.jump_fcontext
