//  (C) Copyright John Maddock 2006.
//  Use, modification and distribution are subject to the
//  Boost Software License, Version 1.0. (See accompanying file
//  LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

   static const boost::array<boost::array<typename table_type<T>::type, 6>, 700> igamma_med_data = { {
      {{ SC_(0.9759566783905029296875), SC_(0.009759566746652126312255859375), SC_(1.003339192007827076679495082852814844336347745360235976200689788561799007730110137330271807878843422), SC_(0.9890348932311204142405476428315735322132825375129739181325170152149560168983641202727073881868421137), SC_(0.01112369385656880593053787042266942213006008594885039559843996330162391632861423778173725952365124566), SC_(0.01096510676887958575945235716842646778671746248702608186748298478504398310163587972729261181315788632) }}, 
      {{ SC_(0.9759566783905029296875), SC_(0.48797833919525146484375), SC_(0.6107075742899761923771199703161020169732161418698525715736270035568544567698769445946517198087313906), SC_(0.60200090392622800556746880021527940973985765617427715855663599678855269649431562996389062378697249), SC_(0.4037553115744196902329129829593822494931916894392338002255027483065684672888474305173573475937632775), SC_(0.39799909607377199443253119978472059026014234382572284144336400321144730350568437003610937621302751) }}, 
      {{ SC_(0.9759566783905029296875), SC_(0.8783609867095947265625), SC_(0.4103188243195825736649265764483608742565650301514019080978258727846258380934756822777647401521337079), SC_(0.4044690348331089562847173039266064850324957624072768224521011340506874965505832795400716939018472498), SC_(0.6041440615448133089451063768271233922098428011576844637013038790787970859652486928342443272503609601), SC_(0.5955309651668910437152826960733935149675042375927231775478988659493125034494167204599283060981527502) }}, 
      {{ SC_(0.9759566783905029296875), SC_(0.9759566783905029296875), SC_(0.3716156455565117999679764359314206771522167659503088545148165288456984447337491300360711644068227913), SC_(0.3663176354055262891120913532650947355579995910412343114483952548046833846145392929954730440121592797), SC_(0.6428472403078840826420565173440635893141910653587775172843132230177244793249752450759379029956718767), SC_(0.6336823645944737108879086467349052644420004089587656885516047451953166153854607070045269559878407203) }}, 
      {{ SC_(0.9759566783905029296875), SC_(1.0735523700714111328125), SC_(0.3365957734341682416974116339033939077306129158759127039900907555371173447101305942124236590906355356), SC_(0.331797030846884313930450730877113627495191936019305203409885944607670085443529202208539000516429768), SC_(0.6778671124302276409126213193720903587357949154331736678090389963263055793485937808995854083118591324), SC_(0.668202969153115686069549269122886372504808063980694796590114055392329914556470797791460999483570232) }}, 
      {{ SC_(0.9759566783905029296875), SC_(1.951913356781005859375), SC_(0.1385088659605976262491193813236600847409759615506046462442726458845512900567187865481680178692283672), SC_(0.1365341875889111868905471971345765310104098007339706625166294395122010561441478434485743781967094833), SC_(0.8759540199037982563609135719518241817254318697584817255548571059788716340020055885638410495332663008), SC_(0.8634658124110888131094528028654234689895901992660293374833705604877989438558521565514256218032905167) }}, 
      {{ SC_(0.9759566783905029296875), SC_(100), SC_(0.3329367866516218882556933190525174260789494242751242200806022302568879706613898466339952656223149765e-43), SC_(0.3281902091153740166486606492940994602463196281189732879787170311504671582868285770684776274764428056e-43), SC_(1.014462885864395882610032953275484266466407798015407706636940926294091018806981767406982208969380557), SC_(0.9999999999999999999999999999999999999999999671809790884625983351339350705900539753680371881026712021) }}, 
      {{ SC_(3.6673679351806640625), SC_(0.03667367994785308837890625), SC_(4.015456203482594363703108922457754241931144753022213644581757557362565251633751067204031319947614119), SC_(0.9999996416031942390887720081336876066391718689312749653540593938756701333363441103622007068271772676), SC_(0.1439127192779586379672567684497393093482122996236962325320321035788002657163475408231449064922934748e-5), SC_(0.3583968057609112279918663123933608281310687250346459406061243298666636558896377992931728227323669815e-6) }}, 
      {{ SC_(3.6673679351806640625), SC_(1.83368396759033203125), SC_(3.385019930725903437101102788992704693233898009050769147408163022452742444496498683915469724406386969), SC_(0.8429972949548684405745767660490086691148623810631514321669785188982553992208514843501333648638513432), SC_(0.6304377118838837061883858060327340460903402260944407341359198552308585951399095467639698269902920728), SC_(0.1570027050451315594254232339509913308851376189368485678330214811017446007791485156498666351361486568) }}, 
      {{ SC_(3.6673679351806640625), SC_(3.300631046295166015625), SC_(2.042636694164828921905502083385700066735693044660836778705857972635214071130121556552436672447216837), SC_(0.5086933734500178903640699120946947210401396612791668913147219471061294630383430188409151403350782137), SC_(1.972820948444958221383986511639738672588545190484373102838224905048386968506286674127002878949462205), SC_(0.4913066265499821096359300879053052789598603387208331086852780528938705369616569811590848596649217863) }}, 
      {{ SC_(3.6673679351806640625), SC_(3.6673679351806640625), SC_(1.728735745904876644611421612335214154871948437794169498245863240719631120462386158739239016328353788), SC_(0.4305202295151868380055049423689706093538316338471304831830580882615064594948400767660055044416881203), SC_(2.286721896704910498678066982690224584452289797351040383298219636963969919174022071940200535068325254), SC_(0.5694797704848131619944950576310293906461683661528695168169419117384935405051599232339944955583118797) }}, 
      {{ SC_(3.6673679351806640625), SC_(4.034104824066162109375), SC_(1.444516814327011000070882393866730351220066002187575174421871857951121331631687572841352290352819824), SC_(0.3597390242642850341727041436017742040531479500883038068894793884921274228917627066755248387784064007), SC_(2.570940828282776143218606201158708388104172232957634707122211019732479708004720657838087261043859218), SC_(0.6402609757357149658272958563982257959468520499116961931105206115078725771082372933244751612215935993) }}, 
      {{ SC_(3.6673679351806640625), SC_(7.334735870361328125), SC_(0.1928842173031202025225624838692485746218833743579218885223983296392167688850553059225165015834992419), SC_(0.04803542571495237241980779345714029329653710992944984439518803096715759866423134446016679398725604201), SC_(3.822573425306666940766926111156190164702354860787287993021684548044384270751352884171158251598726148), SC_(0.951964574285047627580192206542859706703462890070550155604811969032842401335768655539833206012743958) }}, 
      {{ SC_(3.6673679351806640625), SC_(366.736785888671875), SC_(0.372800134674871004133305800038544316286141292939638700513746479143277577659533359615901901430435418e-152), SC_(0.9284125692646457240171069953349802726912792879264744141937156428280981577209798205498168718568776692e-153), SC_(4.015457642609787143289488595025438739324238235145209881544082877683601039636408230679439551396679042), SC_(1) }}, 
      {{ SC_(3.927384853363037109375), SC_(0.0392738468945026397705078125), SC_(5.481066062312759609088467038496268309673263041819793219043840830040297205342994832270601061056033285), SC_(0.9999998644970030817287440986146656923084586349422512633027737770225692386615800459657372422641664819), SC_(0.7427009783886154185672763382162962257956018203370314581397997422675096103629829713614292219536073734e-6), SC_(0.1355029969182712559013853343076915413650577487366972262229774307613384199540342627577358335181356689e-6) }}, 
      {{ SC_(3.927384853363037109375), SC_(1.9636924266815185546875), SC_(4.681812913714047542283856210321072659033064415174669810637868258672116849915694109286206104312772615), SC_(0.8541791370671521729901850166624917295981362963337091768339429521680602021206356329487839388666490246), SC_(0.7992538912996904554200293954515338669364244222469437454374307111679226229369110859673663181724826232), SC_(0.1458208629328478270098149833375082704018637036662908231660570478319397978793643670512160611333509754) }}, 
      {{ SC_(3.927384853363037109375), SC_(3.5346462726593017578125), SC_(2.816382129373238431622360210900121113984870409677894964310059270076658015588413570675787110723304341), SC_(0.5138383146136784446720548677781035602174821016872781850577578962283277420194842365544178296035766061), SC_(2.664684675640499566081525394872485411984618427743718591765239699763381457264191624577785311761950897), SC_(0.4861616853863215553279451322218964397825178983127218149422421037716722579805157634455821703964233939) }}, 
      {{ SC_(3.927384853363037109375), SC_(3.927384853363037109375), SC_(2.372524524117176265960547286995208847829504338216474626443140132870682887519485551770239936222341945), SC_(0.4328581658495639630270840755675107928235764222751457590954583968179864712767674894422404906165588576), SC_(3.108542280896561731743338318777397678139984499205138929632158836969356585333119643483332486262913293), SC_(0.5671418341504360369729159244324892071764235777248542409045416031820135287232325105577595093834411424) }}, 
      {{ SC_(3.927384853363037109375), SC_(4.320123195648193359375), SC_(1.970611625388247978708850134084306947654318148394020488479689347566403177940610018095263177207347023), SC_(0.3595306708514582221331302218158069672828911270152191991137293925439419946034877363340407656533313991), SC_(3.510455179625490018995035471688299578315170689027593067595609622273636294911995177158309245277908216), SC_(0.6404693291485417778668697781841930327171088729847808008862706074560580053965122636659592343466686009) }}, 
      {{ SC_(3.927384853363037109375), SC_(7.85476970672607421875), SC_(0.238706275514383026709028032263691077278567144774320344670291470842396455092581594240259417847732045), SC_(0.04355106113576820787009967250010306075903743361159344036127233964378152216248958038694036508132089635), SC_(5.242360529499354970994857573508915448690921692647293211405007498997643017760023507401906976198864705), SC_(0.9564489388642317921299003274998969392409625663884065596387276603562184778375104196130596349186791037) }}, 
      {{ SC_(3.927384853363037109375), SC_(392.738494873046875), SC_(0.1078993903281671896766902458293491839848722367396818902919765955362752479299554076754789326345029705e-162), SC_(0.1968583747774567503864275752806505701451497730718605463389743484952827957146229484595624495962975282e-163), SC_(5.481066805013737997703885605772606525969488837421613556075298969840039472852605195253572422485255239), SC_(1) }}, 
      {{ SC_(4.0533123016357421875), SC_(0.0405331216752529144287109375), SC_(6.41813285759464991786370353876022753573157877461535817238850166391366463955791959530384794100190872), SC_(0.9999999153376853984885845524839724176593964442100629723951601696835883369687013798502558587978588299), SC_(0.5433740291472787177259642030841127451712424954512787213858894935800380943446964607803762001476194369e-6), SC_(0.8466231460151141544751602758234060355578993702760483983031641166303129862014974414120214117007469975e-7) }}, 
      {{ SC_(4.0533123016357421875), SC_(2.02665615081787109375), SC_(5.514707456930929301459079955313869438197604073116501578585214366340025188854030716468633857798384298), SC_(0.8592385219195666661138078362450122638220024524868804909958062167776733168925557829786689630134192895), SC_(0.9034259440377497636833413094105611816467198727413520450820086834631330307419832235316748635797245696), SC_(0.1407614780804333338861921637549877361779975475131195090041937832223266831074442170213310369865807105) }}, 
      {{ SC_(4.0533123016357421875), SC_(3.647981166839599609375), SC_(3.31312004338382642184449230231977509243273512126776674881440136854727850356190389201660465913190857), SC_(0.516212399524725097994684175184876436874372793206907921261581372871952489632052496592045138421516394), SC_(3.105013357584852643297928962404655527411588824590086874852821681255879716034110047983704062246200297), SC_(0.483787600475274902005315824815123563125627206793092078738418627128047510367947503407954861578483606) }}, 
      {{ SC_(4.0533123016357421875), SC_(4.0533123016357421875), SC_(2.784885343934578513149804339717137368299390408067016796848041900953216841366437030241554499406837817), SC_(0.4339089217924731861183993826512701012093309775829357321262802724234704087971362274687905192149369188), SC_(3.633248057034100551992616925007293251544933537790836826819181148849941378229576909758754221971271051), SC_(0.5660910782075268138816006173487298987906690224170642678737197275765295912028637725312094807850630812) }}, 
      {{ SC_(4.0533123016357421875), SC_(4.458643436431884765625), SC_(2.306553712479142633820833960152698687620756933527776352577981760649736926199934255571033388056820818), SC_(0.3593807682668325353265411226551952864628632629455109728805051026664326234974500588222530217351917741), SC_(4.11157968848953643132158730457173193222356701233007727108924128915342129339607968442927533332128805), SC_(0.6406192317331674646734588773448047135371367370544890271194948973335673765025499411777469782648082259) }}, 
      {{ SC_(4.0533123016357421875), SC_(8.106624603271484375), SC_(0.2666208775089865235658723894506298859889618919139046778832877954885433336210504108700118485172825721), SC_(0.04154180987711253275131159150161436117019650310762690095170282803753763611183019192983825306101724165), SC_(6.151512523459692541576548875273800733855362053943948945783935254314614885974963388715345260029002709), SC_(0.9584581901228874672486884084983856388298034968923730990482971719624623638881698080701617469389827584) }}, 
      {{ SC_(4.0533123016357421875), SC_(405.33123779296875), SC_(0.856277210194896595630413928210981825918823933239296642465635762524914381120581031266134384044083328e-168), SC_(0.1334153026588166560974220666148576952626885376443753701545306845816344804832677337563827322024911951e-168), SC_(6.418133400968679065142421264724430619844323945857853623667223049803158219596013940000308721378108868), SC_(1) }}, 
      {{ SC_(4.125904560089111328125), SC_(0.0412590466439723968505859375), SC_(7.043701108728780223687961843391756553125884985884330252942520360436988162021941273534800312450456719), SC_(0.9999999354299987690775889622689157338228537326556764531411371319964512403841325237126723152152525859), SC_(0.4548118186280665790814208397404344920716063177183303025540785365853082955621661932085259124362671874e-6), SC_(0.6457000123092241103773108426617714626734432354685886286800354875961586747628732768478474741412221914e-7) }}, 
      {{ SC_(4.125904560089111328125), SC_(2.0629522800445556640625), SC_(6.072072191835942345003502395331628487796947075384854346503939861579817399707683543874382853055509126), SC_(0.8620569933379949084958144772211332547216342276449289652619682285641417368272372653640214768414358773), SC_(0.9716293717046565067510385294809678057634299821057936247688830529357073476225532918266106679208600285), SC_(0.1379430066620050915041855227788667452783657723550710347380317714358582631727627346359785231585641227) }}, 
      {{ SC_(4.125904560089111328125), SC_(3.713314056396484375), SC_(3.645460819462813679506809267954671376912867065616234453478114473126983778850729102493984996098169322), SC_(0.517549016887986978339058286692363497387152223601701127971415378456062142503029155666791422528985886), SC_(3.398240744077785172247731656857924916647509991874413517794708441388540968479507733207008524878199833), SC_(0.482450983112013021660941713307636502612847776398298872028584621543937857496970844333208577471014114) }}, 
      {{ SC_(4.125904560089111328125), SC_(4.125904560089111328125), SC_(3.060437018394927204205753747690008049935223919046361115453354046814747587291189903564916268552459642), SC_(0.4344927153410745578456098812651452153289051685042500852197589537423872535948793029632960570229939795), SC_(3.983264545145671647548787177122588243625153138444286855819468867700777160039046932136077252423909513), SC_(0.5655072846589254421543901187348547846710948314957499147802410462576127464051206970367039429770060205) }}, 
      {{ SC_(4.125904560089111328125), SC_(4.53849506378173828125), SC_(2.53067166889025350190244243571991561404324655614760134290664128572613080628587924183262210511980194), SC_(0.3592815007934807835237693104942265218080115344798406819595849604339747790292814616129198747747177498), SC_(4.513029894650345349852098489092680679517130501343046628366181628789393941044357593868371415856567215), SC_(0.6407184992065192164762306895057734781919884655201593180404150395660252209707185383870801252252822502) }}, 
      {{ SC_(4.125904560089111328125), SC_(8.25180912017822265625), SC_(0.2847671704591532210212992508182019504542348463951231766726582961911245322997866584102488204616215587), SC_(0.04042862518951068067360068919978890036257988112029108744002473477277769872227048076109444781316316523), SC_(6.758934393081445630733241673994394343106142211095524794600164618324400215030449999868027066943372826), SC_(0.9595713748104893193263993108002110996374201188797089125599752652272223012777295192389055521868368348) }}, 
      {{ SC_(4.125904560089111328125), SC_(412.5904541015625), SC_(0.9849192524234776299068794846278154032022691748510917397291620486958650212318203702782351817912528128e-171), SC_(0.1398297817615652167353884353734910667012437119857548398337840556682567999355250879796445061410496292e-171), SC_(7.043701563540598851754540924812596293560377057490647971272822914515524747330236835700993520976369155), SC_(1) }}, 
      {{ SC_(5.0940532684326171875), SC_(0.0509405322372913360595703125), SC_(27.67920294027928923880958239390404343442040936899815307478598799340574231811557367409116092396038856), SC_(0.9999999982379693902044640226314365343521271029087308730060359246592570889283931854443539268908129371), SC_(0.4877160292145176564781609346656380162653242308676730589954979956027538802650302642256952953547903483e-7), SC_(0.1762030609795535977368563465647872897091269126993964075340742911071606814555646073109187062913416189e-8) }}, 
      {{ SC_(5.0940532684326171875), SC_(2.54702663421630859375), SC_(24.74117379934670885485935851992100343082362193634847845591339750099791646326335667650716993806822169), SC_(0.8938542706281541291842093703813781663719803706713169378020847920356047543953828832584130123038596963), SC_(2.938029189704183305401989521799133470160589059182097705639896391957625415127605024087017408461696412), SC_(0.1061457293718458708157906296186218336280196293286830621979152079643952456046171167415869876961403037) }}, 
      {{ SC_(5.0940532684326171875), SC_(4.58464813232421875), SC_(14.7675729987104578095439138929485472282856177526532559945486889320051407963321233374742042261580975), SC_(0.533525947425295841907088598191442498030625003421091351895084173752215277026432917855884840150812328), SC_(12.9116299903404343507174341487715896726985932428773201670046049609504010820588383631199831203718206), SC_(0.466474052574704158092911401808557501969374996578908648104915826247784722973567082144115159849187672) }}, 
      {{ SC_(5.0940532684326171875), SC_(5.0940532684326171875), SC_(12.2077823592235985003120696793331736918834158602172392466220471092575502398077890469114806062483926), SC_(0.4410452990302015213950895634100686065935382954619870959119191902708416268312625047813299941800307603), SC_(15.4714206298272936599492783623869632091007951353133369149312467836979916385831726536827067402815255), SC_(0.5589547009697984786049104365899313934064617045380129040880808097291583731687374952186700058199692397) }}, 
      {{ SC_(5.0940532684326171875), SC_(5.603458404541015625), SC_(9.889218349233061197877388817321731640408509396976489163081870258238303847158703369099418745543914618), SC_(0.3572797364557409966350802086721683228140681945237226616673898786823074886738611252458152925379220831), SC_(17.78998463981783096238395922439840526057570159855408699847142363471723803123225833149476860098600348), SC_(0.6427202635442590033649197913278316771859318054762773383326101213176925113261388747541847074620779169) }}, 
      {{ SC_(5.0940532684326171875), SC_(10.188106536865234375), SC_(0.7822639090209128469017740014404389278213317993585533146649871947711294107004337683013750571158629812), SC_(0.02826179313509692702070705503881066214744470133414852372658706264644174732638031855325556636515647396), SC_(26.89693908002997931335957404027969797316287919617202284688830669818441246769052793229281228941405512), SC_(0.971738206864903072979292944961189337852555298665851476273412937353558252673619681446744433634843526) }}, 
      {{ SC_(5.0940532684326171875), SC_(509.40533447265625), SC_(0.7152104781583126172577145380526976040514099585854760760296929839567558638220447646872943192480272666e-210), SC_(0.2583927284471411991649181400315680779298102709841549255602666891812445052621672738125161953683807107e-211), SC_(27.6792029890508921602613480417201369009842109955305761615532938929555418783909617005941873465299181), SC_(1) }}, 
      {{ SC_(5.596034526824951171875), SC_(0.0559603460133075714111328125), SC_(61.15722298035936537017631415308397274094789448016853597795214965840284033719264656727655832204443666), SC_(0.9999999997257414964174877578408388041720660119221931882256703080064742903832273083681210101174925492), SC_(0.1677288846245549632144093838722156507107886394056152268018954428714206090657606391814637409180190668e-7), SC_(0.2742585035825122421591611958279339880778068117743296919935257096167726916318789898825074508024511567e-9) }}, 
      {{ SC_(5.596034526824951171875), SC_(2.7980172634124755859375), SC_(55.46393259928605398529060926253574732815503627091789196500276832668377548368528636291175384881761946), SC_(0.9069073100635526558798059992027420822892194195122167747431420995473747342347831577133123881324620939), SC_(5.693290397846199847341201211989163800014423280329507953510904011908609140649421110940868391373191292), SC_(0.09309268993644734412019400079725791771078058048778322525685790045262526576521684228668761186753790609) }}, 
      {{ SC_(5.596034526824951171875), SC_(5.03643131256103515625), SC_(33.06999514374162703858384175791605334015778919486040062421563603498081622981834289402299137207575168), SC_(0.540737357307612291724814748021271665690168505397520383106887245752994682792873843998172538751374452), SC_(28.08722785339062679404796871660885778801167035638699929429803630361156839451636457982963086811505907), SC_(0.459262642692387708275185251978728334309831494602479616893112754247005317207126156001827461248625548) }}, 
      {{ SC_(5.596034526824951171875), SC_(5.596034526824951171875), SC_(27.13866373600460678031845259439722547760861637796306913755584505521252241888403927165288899075121503), SC_(0.4437523877968948326787741867613129330637102551518554802656301099528107574898532377937055841574056371), SC_(34.01855926112764705231335788012768565056084317328433078095782728337986220545066820219973324943959573), SC_(0.5562476122031051673212258132386870669362897448481445197343698900471892425101467622062944158425943629) }}, 
      {{ SC_(5.596034526824951171875), SC_(6.155638217926025390625), SC_(21.76560826597825775813388197172226288040312333241899565785904138891289832424017292540738182267709586), SC_(0.3558959547100246363088689929831473651825033493608960519357567107283879526378383673378203376307166769), SC_(39.39161473115399607449792850280264824776633621882840426065463094967948630009453454844524041751371489), SC_(0.6441040452899753636911310070168526348174966506391039480642432892716120473621616326621796623692833231) }}, 
      {{ SC_(5.596034526824951171875), SC_(11.19206905364990234375), SC_(1.439537901002514156618214155186974257624221351786322250188529023352495566195413144729463286616539014), SC_(0.02353831371758027773053258284343068010883900114479589930362450438816623513130470385989369552255442408), SC_(59.71768509612973967601359631933793687054523819946107766832514331523988905813929432912315895357427174), SC_(0.9764616862824197222694674171565693198911609988552041006963754956118337648686952961401063044774455759) }}, 
      {{ SC_(5.596034526824951171875), SC_(559.60345458984375), SC_(0.3983234659181026903111274462700552641513723834582819185339327841139441160602206309682112473658483409e-230), SC_(0.651310583439638233092076574184467552529925632573274100844292568873582641191086352985401355931335791e-232), SC_(61.15722299713225383263181047452491112816945955124739991851367233859238462433470747385262224019081075), SC_(1) }}, 
      {{ SC_(10.16461181640625), SC_(0.101646117866039276123046875), SC_(526448.7517568289326110671748510600657971966253053947023808993666002906407096023537805535160810892685), SC_(0.9999999999999999862329405727010614237121156955436061306289155513366940944973015989290727877130269392), SC_(0.7247651250863610508447105825162161128155794519669560025006923071554784515195617094058138920506057017e-11), SC_(0.1376705942729893857628788430445639386937108444866330590550269840107092721228697306082545409586221235e-16) }}, 
      {{ SC_(10.16461181640625), SC_(5.082305908203125), SC_(510322.9302643930829189712815409463837708346310819194595468756491664935321137893514321335165070003787), SC_(0.9693686775044638948930091763509897559191009201137438746311935914342605022120771270176313690471277963), SC_(16125.82149243585693974714417372419047346781938563637098981823710335713360273607390320451476970598384), SC_(0.0306313224955361051069908236490102440808990798862561253688064085657394977879228729823686309528722037) }}, 
      {{ SC_(10.16461181640625), SC_(9.14815044403076171875), SC_(309968.4341614876446448332739272161205883835978589370895483864634223256229622694639843445566624856873), SC_(0.5887912795444610424180501080193144141510684557554702797492628985066881626745530757318797160171077655), SC_(216480.3175953412952138851517874544536559188526086187409883074228475250427542559613509934746142206752), SC_(0.4112087204555389575819498919806855858489315442445297202507371014933118373254469242681202839828922345) }}, 
      {{ SC_(10.16461181640625), SC_(10.16461181640625), SC_(241256.7047700055017897072029796756492117395946188754112428022558826674974871019242969791298393214097), SC_(0.4582719665777533873524111830161408363528108382771615842424631439789215288234234671384465952290754492), SC_(285192.0469868234380690112227349949250325628558486804192938916303871831682294235010383589014373849529), SC_(0.5417280334222466126475888169838591636471891617228384157575368560210784711765765328615534047709245508) }}, 
      {{ SC_(10.16461181640625), SC_(11.18107318878173828125), SC_(178942.1777796453571690127175124224988678522659240040265896878601138154683469866109080855101605355064), SC_(0.3399042683309471278708545053913110708272442887424368187756502758173278088205879154522251908513691296), SC_(347506.5739771835826897057082022480753764501845435518039470060261560351973695388144272525211161708562), SC_(0.6600957316690528721291454946086889291727557112575631812243497241826721911794120845477748091486308704) }}, 
      {{ SC_(10.16461181640625), SC_(20.3292236328125), SC_(2485.195013467645101936126206725504402616278686263740815967196583615169019487481725321208547786293062), SC_(0.004720677948564264738297012343425614540389100171646133722525726370697436134069646508149238537023878915), SC_(523963.5567433612947567822995079450698416861717812920897207266896862354966970379436100168227289200695), SC_(0.9952793220514357352617029876565743854596108998283538662774742736293025638659303534918507614629761211) }}, 
      {{ SC_(10.16461181640625), SC_(1016.461181640625), SC_(0.1316034062561936442010407628172436633248840383182737471639489492599344416496848609453262970601035471e-413), SC_(0.2499833190163633494640443799689533877375622476756834298036337428098160854559625455157155261437961898e-419), SC_(526448.7517568289398587184257146705742443024504675558305366938862698506657165254253353380312767063626), SC_(1) }}, 
      {{ SC_(10.20526981353759765625), SC_(0.102052696049213409423828125), SC_(577373.2306846846427549334134715517585780256766692203486186052483423835657439070864386632630415473474), SC_(0.9999999999999999881380840833286780649242379976641395794604783446096901891113163248466984120192341719), SC_(0.6848752714918603737059034404508144842114313361494961762164489761147249616550722765380537590095751718e-11), SC_(0.1186191591667132193507576200233586042053952165539030981088868367515330158798076582805259918447900967e-16) }}, 
      {{ SC_(10.20526981353759765625), SC_(5.102634906768798828125), SC_(559853.9016749728948664889804306760919895279094938352780099902896618071406942326153743697118411159219), SC_(0.9696568388026298724571840350939331650882365861759024141348056816418178953439691167122162876175433685), SC_(17519.3290097117547371971479594794036475321716835299127229283201755381872141642322115431677511541908), SC_(0.03034316119737012754281596490606683491176341382409758586519431835818210465603088328778371238245663146) }}, 
      {{ SC_(10.20526981353759765625), SC_(9.18474292755126953125), SC_(340147.9462823947749012509541247636967506308559672224065950062576671962159915495947335122182088642714), SC_(0.5891300950669750348303000724524594141538414517925522781976587063475430962359440531500812541019011577), SC_(237225.2844022898747024351742653917988864292252101427841379123521701491119168472528524006613834058414), SC_(0.4108699049330249651696999275475405858461585482074477218023412936524569037640559468499187458980988423) }}, 
      {{ SC_(10.20526981353759765625), SC_(10.20526981353759765625), SC_(264642.0355283880203354293582319738606772548833999212092816412356457170370548472871640485965341000375), SC_(0.458355222348218734574721395669230340113102133148116484166472456571094271633807629470156631602057135), SC_(312731.1951562966292682567701581816349598051977774439814512773741916282908535495604218642830581700752), SC_(0.541644777651781265425278604330769659886897866851883515833527543428905728366192370529843368397942865) }}, 
      {{ SC_(10.20526981353759765625), SC_(11.22579669952392578125), SC_(196165.1943714897001070837876769128811521133449935447128366760236479837696847141804665530610309415742), SC_(0.3397545711270073270001418665061276945171161175678639012711536412399231965503301884012220485465706226), SC_(381208.0363131949494966023407132426144849467361838204778962425861893615582236826671193598185613285386), SC_(0.6602454288729926729998581334938723054828838824321360987288463587600768034496698115987779514534293774) }}, 
      {{ SC_(10.20526981353759765625), SC_(20.4105396270751953125), SC_(2687.807494956632209305226925263539027707814430482777438134001803826256877532124652263840735300645464), SC_(0.00465523400135691249187809344920426062408119894589239915961933246326731876789921752461035407957902137), SC_(574685.4231897280173943809014648919566093522667468824132947846080335190710308647229336490388569694673), SC_(0.9953447659986430875081219065507957393759188010541076008403806675367326812321007824753896459204209786) }}, 
      {{ SC_(10.20526981353759765625), SC_(1020.5269775390625), SC_(0.310268388782846312556113793189296201730642609204061744839707355617600836642995498294123949804615074e-415), SC_(0.5373792415261632321738888075178751878408184659845876901847706207467620051062405280412592787379049203e-421), SC_(577373.2306846846496036861283901554956370600811773651907329186098373453279083968475859128795922701127), SC_(1) }}, 
      {{ SC_(11.43124485015869140625), SC_(0.114312447607517242431640625), SC_(10092714.27309532865006107109984160134119234856106351823087953061069644032877254771706374464745498706), SC_(0.9999999999999999998666174677841348871581941134561745067532121430792042081738322222250547480632532191), SC_(0.1346191786676659318338674079302806447239984506476369087821979614833382259967443019093939770966916552e-11), SC_(0.1333825322158651128418058865438254932467878569207957918261677777749452519367467809248161582099366587e-18) }}, 
      {{ SC_(11.43124485015869140625), SC_(5.715622425079345703125), SC_(9861857.89770996609832128396408583707303095590511419947407646424015770697972718340652782972235297002), SC_(0.9771264330745230394774993912717105823318898449977215560791859715857993651357963116304442071641029835), SC_(230856.375385362553085978922432423586500066735252125204043050877015102436867343925369297185069460058), SC_(0.02287356692547696052250060872828941766811015500227844392081402841420063486420368836955579283589701649) }}, 
      {{ SC_(11.43124485015869140625), SC_(10.288120269775390625), SC_(6044328.351701444163117136726935374422948885961562834124412634550509169251766297134653929432409387567), SC_(0.5988803594503931822638682857302466014155135206406258678784897866848793983791726668665245270529145337), SC_(4048385.92139388448829012615958288623658213667880349055370688056666364016482823019724319747501304251), SC_(0.4011196405496068177361317142697533985844864793593741321215102133151206016208273331334754729470854663) }}, 
      {{ SC_(11.43124485015869140625), SC_(11.43124485015869140625), SC_(4649239.343730333416785270770745004484050098527993233900794668999765895229232415000629557944691295372), SC_(0.4606530233521077294152024750299237055842955337979822338527585311794384579895769952369289167626081443), SC_(5443474.929364995234621992115773256175480924112373090777324846117406914187362112331267568962731134705), SC_(0.5393469766478922705847975249700762944157044662020177661472414688205615420104230047630710832373918557) }}, 
      {{ SC_(11.43124485015869140625), SC_(12.5743694305419921875), SC_(3383643.259017955796656659800421550658071647827116022061323174865995550559638743908600655129998019828), SC_(0.3352560240447813866302950168902559329877251310883796302241206663571916768101959060721830654067811942), SC_(6709071.01407737285475060308609671000145937481325030261679634025117725885695578342329647177742441025), SC_(0.6647439759552186133697049831097440670122748689116203697758793336428083231898040939278169345932188058) }}, 
      {{ SC_(11.43124485015869140625), SC_(22.8624897003173828125), SC_(30903.23819404242335935936940603101334889108464504016271537068360076922751316540958525260106484009169), SC_(0.003061935308762558208178728021795206614635030454948539057317932317318345947846257896724761649811585573), SC_(10061811.03490128622804790351711222964618213155572128451540414443357204018908136192231187430635758999), SC_(0.9969380646912374417918212719782047933853649695450514609426820676826816540521537421032752383501884144) }}, 
      {{ SC_(11.43124485015869140625), SC_(1143.12451171875), SC_(0.2825091954340953009223059204899029922029808650851997121188393575907468437445133167654127981344263404e-464), SC_(0.2799139931932827031436483629166505964509166426649585944925188286961163103917655940175015718274800062e-471), SC_(10092714.27309532865140726288651826065953102264036632467811951511717280941659452733189712690742243008), SC_(1) }}, 
      {{ SC_(11.690219879150390625), SC_(0.1169022023677825927734375), SC_(18808650.09647313719510484406379451190987476255652989262673651261747569800509024507405117261863593745), SC_(0.9999999999999999999482740410833571655579119508141820216007520043338661674579848313795238343269759304), SC_(0.9728954621676797791931442327068294215572730291035264661698800172338583782500576230469904563164771399e-12), SC_(0.5172595891664283444208804918581797839924799566613383254201516862047616567302406961212107454491705266e-19) }}, 
      {{ SC_(11.690219879150390625), SC_(5.8451099395751953125), SC_(18403136.32293801297862003201902408909834415774760242627319828965105147433679686168281916722125529121), SC_(0.9784400384155605487060520174330022751307330330759436520601522975594544824581516995082778940800448561), SC_(405513.7735351242174577075069381025907237490416342957750954959955277501344632634084658637756307038608), SC_(0.02155996158443945129394798256699772486926696692405634793984770244054551754184830049172210591995514393) }}, 
      {{ SC_(11.690219879150390625), SC_(10.521198272705078125), SC_(11300880.43696190252412840183812525987009577873512453086890997708560684499549236858946077668992759675), SC_(0.6008342108018141266570377919053377860276755642851878451502716798990410627223006118782210055474487012), SC_(7507769.659511234671949337687836931818972128054112191179383808560972379475767756501824254306958398325), SC_(0.3991657891981858733429622080946622139723244357148121548497283201009589372776993881217789944525512988) }}, 
      {{ SC_(11.690219879150390625), SC_(11.690219879150390625), SC_(8672509.587204027141047449650776982999738766147950698614692257038746897122992915467614482619093048385), SC_(0.4610915479165745005058792025348932322301556237469077614037776843609409871777916052071130909569703745), SC_(10136140.50926911005503028987518520868932914064128602343360152860783232734826720962367054837779294669), SC_(0.5389084520834254994941207974651067677698443762530922385962223156390590128222083947928869090430296255) }}, 
      {{ SC_(11.690219879150390625), SC_(12.859241485595703125), SC_(6287954.452547948509208548248214985257796689301980330059387321687317937525963079472467938262956331912), SC_(0.3343118416417890887558019505752886442912001812613510817941400655214992910141971185748270762169440714), SC_(12520695.64392518868686919127774720643127121748725639198890646395926128694529704561881709273392966316), SC_(0.6656881583582109112441980494247113557087998187386489182058599344785007089858028814251729237830559286) }}, 
      {{ SC_(11.690219879150390625), SC_(23.38043975830078125), SC_(52737.51434305912576323185862500387385932919089021157164745379299882357348980714607562137085667999636), SC_(0.00280389682792536425523049315988273139570015031106610400530594250374235193086174809886542601431038023), SC_(18755912.58213007807031450766733718781520857759834651047664633185358040089777031794520940962602931508), SC_(0.9971961031720746357447695068401172686042998496889338959946940574962576480691382519011345739856896198) }}, 
      {{ SC_(11.690219879150390625), SC_(1169.02197265625), SC_(0.1258615995440589928894183874007422367750084251989841842081504821900762607529866900998826187957908956e-474), SC_(0.6691687010949268225465318941737153385818662177946591999560276217475180189765295773415664733761718407e-482), SC_(18808650.09647313719607773952596219168906790678923672204829378564657922447126012509128503099688599507), SC_(1) }}, 
      {{ SC_(12.955684661865234375), SC_(0.12955684959888458251953125), SC_(428307852.9299610352603272531082713661888583896816721467285635713930220656308480438015333066490233856), SC_(0.9999999999999999999994931466175300998756585605008867059180111770451931648396874370987015073892720435), SC_(0.2170892839959712731982318236572811524135888980905680524672678879721525025563824491887194028197413803e-12), SC_(0.5068533824699001243414394991132940819888229548068351603125629012984926107279565026351600154505463801e-21) }}, 
      {{ SC_(12.955684661865234375), SC_(6.4778423309326171875), SC_(421374733.0132156786323395479536985347385054384758892122222388740186536130714245698919518873402614582), SC_(0.9838127648855434508747718544662632241604964065002861046456693601242792566621453902265899448045645527), SC_(6933119.916745356628204794438568802723551183029440215658738286272459020611890741797553571811318309833), SC_(0.01618723511445654912522814553373677583950359349971389535433063987572074333785460977341005519543544731) }}, 
      {{ SC_(12.955684661865234375), SC_(11.6601161956787109375), SC_(261236298.1802810712987621880492469341863720184791952589453116572293797457059112363561962554804359674), SC_(0.6099264731973048601765626963152049375033628810929236912032334489202859499894588556091532155300537837), SC_(167071554.7496799639617821543430204032756846030261341689356655030617328879774040753333092036711438006), SC_(0.3900735268026951398234373036847950624966371189070763087967665510797140500105411443908467844699462163) }}, 
      {{ SC_(12.955684661865234375), SC_(12.955684661865234375), SC_(198324381.4075037895099229974788883561027751227741976333555245513098366363563827914775435905585750081), SC_(0.463041665126636723998208693638109693540497596502913514966430552698722979583809022802525261569028313), SC_(229983471.5224572457506213449133789813592814987311317945254526089812759973269325202119618685930047599), SC_(0.536958334873363276001791306361890306459502403497086485033569447301277020416190977197474738430971687) }}, 
      {{ SC_(12.955684661865234375), SC_(14.2512531280517578125), SC_(141230735.8874254973009250665663136967557618612703682420576794746955312856987659231137965544806836993), SC_(0.3297411778030607998826961047847508828762412676958433501823084815947456559906204692400882833540571914), SC_(287077117.0425355379596192758259536407062947602349611858232976855955813479845493885757089046708960687), SC_(0.6702588221969392001173038952152491171237587323041566498176915184052543440093795307599117166459428086) }}, 
      {{ SC_(12.955684661865234375), SC_(25.91136932373046875), SC_(782663.7179885857699463656633848430264031052969771539557675230756095485493336709682441798241628222402), SC_(0.001827339173527996727830528639480721240580411776852898202182852341611686756472171024979973209292115479), SC_(427525189.2119724494905979767288824944356535162083522739252096372155030851339816407212612793274169458), SC_(0.9981726608264720032721694713605192787594195882231471017978171476583883132435278289750200267907078845) }}, 
      {{ SC_(12.955684661865234375), SC_(1295.5684814453125), SC_(0.3608905612956014718728360841492827803469208542262913410930444827586924022284529876190332295426303354e-525), SC_(0.8425961812906942803681327965776686513602182735742397059258730975433205218108675823256993369297423774e-534), SC_(428307852.929961035260544342392267337462056621505329427880977160291112633683315311689505459151579768), SC_(1) }}, 
      {{ SC_(13.02671527862548828125), SC_(0.13026715815067291259765625), SC_(512456131.8985713439314859419608942682232163312465814764055829216540810809686139697165303818929464912), SC_(0.9999999999999999999996089876375785556082730797020993512933501586157431890909903416996448292097006065), SC_(0.2003766827710156884109668719700088927792368234308933522173719858336365747396436227576944718509904221e-12), SC_(0.3910123624214443917269202979006487066498413842568109090096583003551707902993935349855742150116524265e-21) }}, 
      {{ SC_(13.02671527862548828125), SC_(6.513357639312744140625), SC_(504292381.474701294755093414572451066507117979650827675327943247721717397051500332708321678088535672), SC_(0.9840693672771079811296047831348781934315010146617578374281868772416224693552294962586520546484570965), SC_(8163750.423870049176592904071214217404509318467723809970418910755794577269331008994042340379150462875), SC_(0.01593063272289201887039521686512180656849898533824216257181312275837753064477050374134794535154290351) }}, 
      {{ SC_(13.02671527862548828125), SC_(11.72404384613037109375), SC_(312811511.370335737099981249504067629884221760261211771521346728405536483503354994366811296188166823), SC_(0.6104161739882340392601054170315919816474360234103221597660888635095434009477428140163224523528671548), SC_(199644620.5282356068317050691395976540274055378573397137770154300719754908174763473355527222795193118), SC_(0.3895838260117659607398945829684080183525639765896778402339111364904565990522571859836775476471328452) }}, 
      {{ SC_(13.02671527862548828125), SC_(13.02671527862548828125), SC_(237340275.6027451556138298054657455871810468338727042152922779419653686854991039505324284434247676821), SC_(0.4631426200783974405370941094794755868570526389877988716806381827967014116363337785340168914481043737), SC_(275115856.2958261883178565131779196967305804642458472700060842165121432888217273911699355750429184527), SC_(0.5368573799216025594629058905205244131429473610122011283193618172032985883636662214659831085518956263) }}, 
      {{ SC_(13.02671527862548828125), SC_(14.32938671112060546875), SC_(168847646.3349317777841126601706798558420196115600418111455114346072639519130067900201172194868835417), SC_(0.3294870249856844408300641114781382399843859209915639742593184635620302309477771038338395768606135993), SC_(343608485.5636395661475736584729854280696076865585096741528507238702480224078245516822467989808025932), SC_(0.6705129750143155591699358885218617600156140790084360257406815364379697690522228961661604231393864007) }}, 
      {{ SC_(13.02671527862548828125), SC_(26.0534305572509765625), SC_(914280.5548544152313447697527713571522430738687645775272692644719732005123160962050476620622257883637), SC_(0.001784114771867683680926146018659266869823838208792181637779845196865282058025525019741183868065175688), SC_(511541851.3437169287003415488908939267593842242497869077710928940055387738085152454973163564054603465), SC_(0.9982158852281323163190738539813407331301761617912078183622201548031347179419744749802588161319348243) }}, 
      {{ SC_(13.02671527862548828125), SC_(1302.6715087890625), SC_(0.5274845075196482758038095191814406458190839939289614665512784576361913542768287604269607416957925801e-528), SC_(0.1029326169959951705444305337097507872401946111420602895456564021725725915339783433545496866599037744e-536), SC_(512456131.8985713439316863186436652839116272981185514852983621584775119743208313417023640184676861348), SC_(1) }}, 
      {{ SC_(13.13518810272216796875), SC_(0.131351888179779052734375), SC_(674462743.149046021333390617481295959023056986603542715040607449857491437739458385055464991102676626), SC_(0.9999999999999999999997369080074745518228972214981883535468573358653548249895577011421471030914587901), SC_(0.1774457469792620895637286596897675892819508337779648920502389182467829092033972469924933804244251644e-12), SC_(0.2630919925254481771027785018116464531426641346451750104422988578528969085412098813617471539843505748e-21) }}, 
      {{ SC_(13.13518810272216796875), SC_(6.567594051361083984375), SC_(663976926.1089374238943691132089675858087901675766470056460066856592084102466099092517459591908307117), SC_(0.9844530818838848876935027066618934383202331954767309237438114406387621679702882223974106888092838142), SC_(10485817.04010859743919895001930763530383054768658547698388271503206099238489871472196581482104931156), SC_(0.01554691811611511230649729333810656167976680452326907625618855936123783202971177760258931119071618575) }}, 
      {{ SC_(13.13518810272216796875), SC_(11.82166957855224609375), SC_(412204696.8307228050226802056656929347987682947430983234210100097034419624393912194117092522454628402), SC_(0.6111600692814426197272298752058182998679453431437421326863094888154883792517219522694163434483279862), SC_(262258046.3183232163108878575625822863138524205201341592088793909878274401921174045620025217664171831), SC_(0.3888399307185573802727701247941817001320546568562578673136905111845116207482780477305836565516720138) }}, 
      {{ SC_(13.13518810272216796875), SC_(13.13518810272216796875), SC_(312475356.5824610108259197670087841857841677515456614597483364235579229992958904626165438099339229377), SC_(0.4632952075655403599296609250301929956592682160503649373632741625393833157586404593759340018391217222), SC_(361987386.5665850105076482962194910353284529637175710228815529771333464033356181613571679640779570856), SC_(0.5367047924344596400703390749698070043407317839496350626367258374606166842413595406240659981608782778) }}, 
      {{ SC_(13.13518810272216796875), SC_(14.44870662689208984375), SC_(221965306.4670367895193649944193082058184659433738135892152877254368739610191574173118140847631220421), SC_(0.3290994331735620100541463324249882725381274772589466481096043917775520409559812138661513849624454252), SC_(452497436.6820092318142030688089670152941547718894188934146016752543954416123512066618976892487579812), SC_(0.6709005668264379899458536675750117274618725227410533518903956082224479590440187861338486150375545748) }}, 
      {{ SC_(13.13518810272216796875), SC_(26.2703762054443359375), SC_(1160144.237126138624187141036000326831571587831367159333885546778122263569600144913457664578892051587), SC_(0.00172010129382308129961759508663594167621919741616388826502029075371462769318294133239408670606225463), SC_(673302598.9119198827093809221922748942810491274318653232960038539131471390619084790602541094329879717), SC_(0.9982798987061769187003824049133640583237808025838361117349797092462853723068170586676059132939377454) }}, 
      {{ SC_(13.13518810272216796875), SC_(1313.518798828125), SC_(0.2470999421474821597235308289076325123722724994380264375823050668524525489555593662545862037094478454e-532), SC_(0.366365591958096973621356895786731892565071702842932462698171708959737407171613677057820056708003288e-541), SC_(674462743.1490460213335680632282752211126207152632324826298894006912694026315086239737117740118800232), SC_(1) }}, 
      {{ SC_(13.97996234893798828125), SC_(0.1397996246814727783203125), SC_(5910654223.190215788712221244871743080011197576752925099373275489303262915640348520934061734994150573), SC_(0.9999999999999999999999879657225377205875821928652771785191473449506712055920921533669426197462676218), SC_(0.7113045290546464179234042403712777588894648193088517664505293313012094595346443734096983315932600523e-13), SC_(0.1203427746227941241780713472282148085265504932879440790784663305738025373237822347500872273073455932e-22) }}, 
      {{ SC_(13.97996234893798828125), SC_(6.989981174468994140625), SC_(5834591455.204726395692966509334949983448949816609165568973206349678278441343056643384796214613337078), SC_(0.987131243833032871289435934724229856545636807331228828080240151990052328357325478870385325351915856), SC_(76062767.9854893930193258659896985612040401005677966581759580861069153594739369304823956413267669592), SC_(0.01286875616696712871056406527577014345436319266877117191975984800994767164267452112961467464808414404) }}, 
      {{ SC_(13.97996234893798828125), SC_(12.581966400146484375), SC_(3645682417.055270454909039050896463482121995407579205967853528083906892713884167560195360975199787665), SC_(0.6167984590862346659620227837574966526888365201825142428286346309357175181938035409936078191562891425), SC_(2264971806.134945333803253324428185062530994509597756259295636351878301086932826013671830880740316372), SC_(0.3832015409137653340379772162425033473111634798174857571713653690642824818061964590063921808437108575) }}, 
      {{ SC_(13.97996234893798828125), SC_(13.97996234893798828125), SC_(2745038337.187854045315426210338854801937918819786231725118964785963145351775581938865427692338810608), SC_(0.4644220814707457863066850889417751896925992503532795557288541594665052367354920088452455876392165752), SC_(3165615886.002361743396866164985793742715071097390730502030199649822048449041411635001764163601293429), SC_(0.5355779185292542136933149110582248103074007496467204442711458405334947632645079911547544123607834248) }}, 
      {{ SC_(13.97996234893798828125), SC_(15.3779582977294921875), SC_(1927484556.644093124630203748371939369194765925990182162651410153287629164154294410760321585479953314), SC_(0.3261034200041146790989240264695734427314492477291489582445757583647475157176232002651402312794889128), SC_(3983169666.546122664082088626952709175458223991186780064497754282497564636662699163106870270460150724), SC_(0.6738965799958853209010759735304265572685507522708510417554242416352524842823767997348597687205110872) }}, 
      {{ SC_(13.97996234893798828125), SC_(27.9599246978759765625), SC_(7654483.186801090100537714035584375193497829795309590853892322241194318416741649436494892589707636116), SC_(0.001295031463144812467127192586077620504138884124885789866256689374017177058012435430963859346037459526), SC_(5902999740.003414698611754661289064169459492087381652636295272113543999482400251924430696963350396401), SC_(0.9987049685368551875328728074139223794958611158751142101337433106259828229419875645690361406539625405) }}, 
      {{ SC_(13.97996234893798828125), SC_(1397.9962158203125), SC_(0.4904055013445335192081644569377050869408725751456187962087537739151806712693260228909162408012585564e-566), SC_(0.8296974968023795406403636046332098503901341147128570365381899499874129277768061303222081786262785186e-576), SC_(5910654223.190215788712292375324648544652989917176962227149164435785193800816993573867191855940104038), SC_(1) }}, 
      {{ SC_(14.6176910400390625), SC_(0.1461769044399261474609375), SC_(31519660692.46732869024507548930255355037911967853982013619073232752287228676685262808266616357023475), SC_(0.9999999999999999999999988262022081047083637867115105431672767937099294804939606827117361373440617719), SC_(0.3699770812210696935052738468272719392639976126676660909447300836125736319652385357274634161244738223e-13), SC_(0.1173797791895291636213288489456832723206290070519506039317288263862655938228112823005203089694088953e-23) }}, 
      {{ SC_(14.6176910400390625), SC_(7.30884552001953125), SC_(31167676066.53819320268775033554383183668915678842267327077390827766233702619851138225770041728674243), SC_(0.9888328548532486607187315154742385428946975992906366683009569310574627106952660842066882798361149288), SC_(351984625.9291354875573621514668438206593134175018295926107504496218020271774357188333270036466888455), SC_(0.01116714514675133928126848452576145710530240070936333169904306894253728930473391579331172016388507115) }}, 
      {{ SC_(14.6176910400390625), SC_(13.15592193603515625), SC_(19570099125.17619591839157549727399135699664622021454089386800376892678575276928964259150260565678158), SC_(0.6208854630802901388078823599882107695046878069749612390348018710748344169356894334952666853220906794), SC_(11949561567.2911327718535369897366843003518239857099619695166549583573533006066574584995248152766497), SC_(0.3791145369197098611921176400117892304953121930250387609651981289251655830643105665047333146779093206) }}, 
      {{ SC_(14.6176910400390625), SC_(14.6176910400390625), SC_(14663174041.62329589286157476555665532316684047736790110136618108283672007259962930914321076294643401), SC_(0.4652072300108087472989370315496163171674553210918711166218977367743499765120963404563966124119965452), SC_(16856486650.84403279738353772145402033418162972855660176201847764444741898077631779194781665798699727), SC_(0.5347927699891912527010629684503836828325446789081288833781022632256500234879036595436033875880034548) }}, 
      {{ SC_(14.6176910400390625), SC_(16.07946014404296875), SC_(10208254949.95474011323030351891374929422125927587483711019999378034427865583445953237712100199414539), SC_(0.3238694429345282315849777562083497540056373466077788064582305202611175575489044591459168374933849395), SC_(21311405742.51258857701480896809692636312721093004966575318466494693986039754148756871390641893928588), SC_(0.6761305570654717684150222437916502459943626533922211935417694797388824424510955408540831625066150605) }}, 
      {{ SC_(14.6176910400390625), SC_(29.235382080078125), SC_(32971860.19730178971973540202322703289367756075704569326375433484278668485265826215878064441900777299), SC_(0.001046072815281971369803623292538810967586955544013035650202721488810712223514607317283434291440339657), SC_(31486688832.2700269005253770849874486244547926451674571701209043924413523685232888389322467765144235), SC_(0.9989539271847180286301963767074611890324130444559869643497972785111892877764853926827165657085596603) }}, 
      {{ SC_(14.6176910400390625), SC_(1461.76904296875), SC_(0.1837274079575618742766879005299834658627116636844600755320690895283356083117515247134201226837863009e-591), SC_(0.582897797505382567251331463700908656294340864527281077988266795290426761472904565814301996724821859e-602), SC_(31519660692.46732869024511248701067565734847020592450286338465872728413905337594710109102742093343128), SC_(1) }}, 
      {{ SC_(15.336841583251953125), SC_(0.153368413448333740234375), SC_(215436787840.6498033688917411866254554010770010131069213759384360723674889461686630652718805258804018), SC_(0.9999999999999999999999999148485315207308540004075712638988833762504006371042308450906072774722223372), SC_(0.1834475884908808615605608835896651292613264330272229633202545339026271260427924082770171227467220434e-13), SC_(0.8515146847926914599959242873610111662374959936289576915490939272252777766282781701203107405425700438e-25) }}, 
      {{ SC_(15.336841583251953125), SC_(7.6684207916259765625), SC_(213384824992.9052364637114384909819338645548208970293503896610050350679660061831289096487146448490807), SC_(0.9904753367875948658270835237141575556584719960813703255231980192119260412752367578246294012965590539), SC_(2051962847.744566905180321040402370624608336172165929952790357169942825662281866181076556143743925379), SC_(0.009524663212405134172916476285842444341528003918629674476801980788073958724763242175370598703440946086) }}, 
      {{ SC_(15.336841583251953125), SC_(13.803157806396484375), SC_(134720211860.4548611287388876929883995204139312197219408661949178622718381989099790865809877468741051), SC_(0.6253352234350158986935261816939058679169668330549521716353734259576857532926282315296200027359765981), SC_(80716575980.19494224015287183839590496874922584947333947625644434273895346955501600414428304171890089), SC_(0.3746647765649841013064738183060941320830331669450478283646265740423142467073717684703799972640234019) }}, 
      {{ SC_(15.336841583251953125), SC_(15.336841583251953125), SC_(100400688935.4222160975494486837492402074062990767741539099850036046124232390446875671072780594417965), SC_(0.4660331689018901135802494246196675916860931081624262487549716442041703786207708749685033937059692576), SC_(115036098905.2275872713423108476350642817568579924211264324663586003983684294203075236179927291512095), SC_(0.5339668310981098864197505753803324083139068918375737512450283557958296213792291250314966062940307424) }}, 
      {{ SC_(15.336841583251953125), SC_(16.870525360107421875), SC_(69237106647.76667230123541673252468882864012136830942283792768861865827159001615589439706354373051019), SC_(0.3213801474749923490073107293069496826347224116190437754824150484504253858384552328328361273362056147), SC_(146199681192.8831310676563427988596156605230357008858575045236735863525200784488391963282072448624958), SC_(0.6786198525250076509926892706930503173652775883809562245175849515495746141615447671671638726637943853) }}, 
      {{ SC_(15.336841583251953125), SC_(30.67368316650390625), SC_(177275987.6165810846503610228623973761521339712590722174965710791805742989978957836823604406599922882), SC_(0.0008228677627133264929670679883746045178882045392737923039990478413887702709616184713423333253791173162), SC_(215259511853.0332222842413985085219071130110230979362081249547911258302173694670993070429103479330137), SC_(0.9991771322372866735070329320116253954821117954607262076960009521586112297290383815286576666746208827) }}, 
      {{ SC_(15.336841583251953125), SC_(1533.6842041015625), SC_(0.404464971677354272300312220400653389892978951222954756005578734194759082033914650851922271652032288e-620), SC_(0.1877418317137745528841881453283099269043893205561465806855915096531083786826342825765137005225113593e-631), SC_(215436787840.649803368891759531384304489163157069195280342451362205010791668464995090725270788593006), SC_(1) }}, 
      {{ SC_(16.18250274658203125), SC_(0.1618250310420989990234375), SC_(2158821770372.760492818531138994384948323849490402693726980347001345582980390894754178152171031601257), SC_(0.9999999999999999999999999961010732691950286045901776596055486399684852587368833826176713268209631473), SC_(0.8417087907550067722276208204313839886834638697186402224853742973341766008353683275179408690029515547e-14), SC_(0.3898926730804971395409822340394451360031514741263116617382328673179036852725515582430054001252022724e-26) }}, 
      {{ SC_(16.18250274658203125), SC_(8.091251373291015625), SC_(2141750209371.305202091498934496242286308211662574211398048139906248448123258204898804563229174115229), SC_(0.9920921860082467252095808788320879153859780477499772959531205779656919515545937024681454219890877306), SC_(17071561001.45529072703221291523056956570555010469053324604698193177355431909208022733191519925203623), SC_(0.007907813991753274790419121167912084614021952250022704046879422034308048445406297531854578010912269402) }}, 
      {{ SC_(16.18250274658203125), SC_(14.5642528533935546875), SC_(1360858112519.11770959272117011110830051237670082704028845884983028217042655756237417415371631155484), SC_(0.6303707564910003644000428910349335363366072855445841823546700278535404517411162913828376104377948771), SC_(797963657853.6427832258099773003645553615405118518616428353370578980512510197346048577414280618124251), SC_(0.3696292435089996355999571089650664636633927144554158176453299721464595482588837086171623895622051229) }}, 
      {{ SC_(16.18250274658203125), SC_(16.18250274658203125), SC_(1008025207970.736016611948955570053217411708930912428823729132515630634645797146716506518297999359619), SC_(0.4669330381065602405955418804269019949740065661653284725645578514064708368349014252152857519514215627), SC_(1150796562402.024476206582191841419638462208281766473107565054372549587031780150262525376846374007646), SC_(0.5330669618934397594044581195730980050259934338346715274354421485935291631650985747847142480485784373) }}, 
      {{ SC_(16.18250274658203125), SC_(17.8007526397705078125), SC_(687572394496.3031782527459531220190303451118625676319160738265510184883521202155279934965281443755715), SC_(0.3184942842120686470147880341335042298919296648800830120898213997841380658494716464595008296937157405), SC_(1471249375876.457314565785194289453825528805350111270015220360337161733325457081451038398616228991694), SC_(0.6815057157879313529852119658664957701080703351199169879101786002158619341505283535404991703062842595) }}, 
      {{ SC_(16.18250274658203125), SC_(32.3650054931640625), SC_(1340862835.725343546823295587257195519136834019322215899876049580106186155682030269341039343331260904), SC_(0.000621108631628176876872856832760800140394059673621695572899081410018010235255016938583221304233983816), SC_(2157480907537.035149271707851824215660354780378659579715394310838600115491421614948762554105030036004), SC_(0.9993788913683718231231271431672391998596059403263783044271009185899819897647449830614167786957660162) }}, 
      {{ SC_(16.18250274658203125), SC_(1618.250244140625), SC_(0.8477830782213465246834241939733263939261338923487334014954714154489361608016838198284525527372969536e-654), SC_(0.3927063780142262979318856942808714825925943568720830323175673050066581928234662944018129377557184899e-666), SC_(2158821770372.760492818531147411472855873917212678901931294186888180221677577296979031895144373367265), SC_(1) }}, 
      {{ SC_(17.5330753326416015625), SC_(0.17533075809478759765625), SC_(94051279987102.18240100970431758631441533829310428405713805017162899803812623206166505735813511025627), SC_(0.9999999999999999999999999999716034587743025834800824170171602368605198026245240473954300019197475383), SC_(0.2670731049483357507220140573333117984431086609013328724469456734788177791595601485431326302655048162e-14), SC_(0.2839654122569741651991758298283976313948019737547595260456999808025246171320964993773699874743842056e-28) }}, 
      {{ SC_(17.5330753326416015625), SC_(8.76653766632080078125), SC_(93497547863659.07722039785226223028714331545562702021759056200180857223823978275130959130428261619045), SC_(0.9941124445779042901218357810374043201815580779053361690362653129258981513148183766689522504912880174), SC_(553732123443.1051806118520580267583215061949844839801208212878048568864954626390799355105872822436161), SC_(0.005887555422095709878164218962595679818441922094663830963734687074101848685181623331047749508711982648) }}, 
      {{ SC_(17.5330753326416015625), SC_(15.7797679901123046875), SC_(60006363191958.3292818654714899614130430648346482739289287159800255661862984512939543376891681604771), SC_(0.6380175070470849807968725056236757821464310875191331742100862408557012330808747477813289851549781403), SC_(34044916795143.85311914423283029563242175681596323026878266730958786293843679409643518912570173795697), SC_(0.3619824929529150192031274943763242178535689124808668257899137591442987669191252522186710148450218597) }}, 
      {{ SC_(17.5330753326416015625), SC_(17.5330753326416015625), SC_(44037888978906.34684387846920881212924616053256036287639647433879321031866848102807760372923542128727), SC_(0.4682327447850313932993828335410870586032071435047259332378295727500660901707161112470028546600613071), SC_(50013391008195.83555713123511144491621866111805114132131490895082021880606676436231192308563447714679), SC_(0.5317672552149686067006171664589129413967928564952740667621704272499339098292838887529971453399386929) }}, 
      {{ SC_(17.5330753326416015625), SC_(19.2863826751708984375), SC_(29530141813960.42656850685810703152052830500714463230437061872585081744272408591424715281482663234952), SC_(0.3139791592204813426677123217826187660692401178453588792006692049305906342075970449768646948919463738), SC_(64521138173141.75583250284621322552493651664346687189334076456376261168201115947614237400004326608454), SC_(0.6860208407795186573322876782173812339307598821546411207993307950694093657924029550231353051080536262) }}, 
      {{ SC_(17.5330753326416015625), SC_(35.066150665283203125), SC_(37346685887.93827009294925888421582759248665981153275145062666956660207048145812234463982422912873696), SC_(0.0003970885446009862461399919517100665674364097972275273057162087441642416739350927905627756072859887306), SC_(94013933301214.24413091675506137282963722916395169266495993266294386252266476393226718217504566930533), SC_(0.9996029114553990137538600080482899334325635902027724726942837912558357583260649072094372243927140113) }}, 
      {{ SC_(17.5330753326416015625), SC_(1753.3074951171875), SC_(0.1525078674926712724325046135741316924285483407797196656709319277016079224940323060664025421446207901e-707), SC_(0.1621539520925027212845478789663506069130441581883635322256007695028305593694715194917682290402460012e-721), SC_(94051279987102.18240100970432025704546482165061150419771138328961342912473524539038952681486989843406), SC_(1) }}, 
      {{ SC_(17.79958343505859375), SC_(0.1779958307743072509765625), SC_(200646434548288.1803732973648961756822217969899666454361919174953042770888400047118860268601562133222), SC_(0.9999999999999999999999999999892454348802443717831552661537772430284126739903635373642751586509937069), SC_(0.2157865146396350693356620837526451991071983648079243830231212124951443152724517908855699547463650661e-14), SC_(0.1075456511975562821684473384622275697158732600963646263572484134900629308198853962196314394464478562e-28) }}, 
      {{ SC_(17.79958343505859375), SC_(8.899791717529296875), SC_(199531613707392.420295729526162639748722194516455867844793882680954915912649536831507942385837030595), SC_(0.9944438542184637529261020525075591701925199375937988328943008080172006538667582596992366567184852758), SC_(1114820840895.760077567838735693798645998824204134212235561266340433159838547124208315686444134170286), SC_(0.00555614578153624707389794749244082980748006240620116710569919198279934613324174030076334328151472422) }}, 
      {{ SC_(17.79958343505859375), SC_(16.0196247100830078125), SC_(128308172215146.9082888540822000688521035773074374380083354439536973477570117441495750735201969422105), SC_(0.6394739707386520932461292690760976255973410271066454985062704736291831592470151764994413295070242544), SC_(72338262333141.27208444328269826469526461603322256404869399999359800131547633980614118455208422255483), SC_(0.3605260292613479067538707309239023744026589728933545014937295263708168407529848235005586704929757456) }}, 
      {{ SC_(17.79958343505859375), SC_(17.79958343505859375), SC_(93997151021443.71328197824764512308243094877481642668850193518342693734196547989100964529017163657909), SC_(0.4684715740554167356222208384955043010759465579672255407962438903792897989589173368784890741660060397), SC_(106649283526844.4670913191172532104649372445658435753685275087638684117305226040647066127821095281862), SC_(0.5315284259445832643777791615044956989240534420327744592037561096207102010410826631215109258339939603) }}, 
      {{ SC_(17.79958343505859375), SC_(19.5795421600341796875), SC_(62822753804144.17601615406480343788265946264743062279962351628667799379086001085251637107778842382228), SC_(0.3131017700143834914270597043128924556480747470294779182930053239846043011264116005124142060364253504), SC_(137823680744144.004357143300094895664708730693229379257405927660617355281628073103199886994492740943), SC_(0.6868982299856165085729402956871075443519252529705220817069946760153956988735883994875857939635746496) }}, 
      {{ SC_(17.79958343505859375), SC_(35.5991668701171875), SC_(72961078040.61425158004818541310957182039210099959885814982678790179322047742655887173823939436135636), SC_(0.0003636300749867310347343015995928063130823651645686545844986292907129182227159103343325792832558191183), SC_(200573473470247.566121717316712920437796372948559002458171294120507447279267606529157386334041770404), SC_(0.9996363699250132689652656984004071936869176348354313454155013707092870817772840896656674207167441809) }}, 
      {{ SC_(17.79958343505859375), SC_(1779.9583740234375), SC_(0.3833077727689090440442197603122110810470910413352603510498977710837199705333820052849363068763279513e-718), SC_(0.1910364236632677523143350442450627110286028423745128398727891350021040842917926379486406410372408591e-732), SC_(200646434548288.1803732973648983335473681933406600020570294439472953490724880839557162580722811647653), SC_(1) }}, 
      {{ SC_(19.0938243865966796875), SC_(0.19093824923038482666015625), SC_(8420554991157188.622117441589298392239929979579651790644845706657614936299648483183291532515113833871), SC_(0.9999999999999999999999999999999035097147668922316044591924481748386859242891570852861242692222360591), SC_(0.8125017529178263925874543405159918263431563290973423565824164184553393998473459664322214972276802618e-15), SC_(0.9649028523310776839554080755182516131407571084291471387573077776394088495776256660776941454172484893e-31) }}, 
      {{ SC_(19.0938243865966796875), SC_(9.54691219329833984375), SC_(8385201272724382.68546065520869263213751421631459844371769498644098772157435311761895932726283502618), SC_(0.9958014978264576979252494756949449800479635061284621136295897294488942078199256252363065371529112978), SC_(35353718432805.93665678638060657260416868109144593438149123620845355788162446290668878766869726303042), SC_(0.004198502173542302074750524305055019952036493871537886370410270551105792180074374763693462847088702226) }}, 
      {{ SC_(19.0938243865966796875), SC_(17.1844425201416015625), SC_(5442403854975547.720138801765720501736563708768580729209495067288277403216769713131776749613276713112), SC_(0.6463236521453592863088470647933202536217943254964650256271813657109922628322831807423097872821133995), SC_(2978151136181640.901978639823578703005119188637463648889691155361163876239207867393871365318255576098), SC_(0.3536763478546407136911529352066797463782056745035349743728186342890077371677168192576902127178866005) }}, 
      {{ SC_(19.0938243865966796875), SC_(19.0938243865966796875), SC_(3953950392845518.673914055855861565915481212881042711148188138494710502216249245571393873043320444407), SC_(0.4695593576667741620927637372758890247156458143610874105297122246958103199068566455714092515132956316), SC_(4466604598311669.948203385733437638826201684525001666950998084154730777239728334954254241888211844804), SC_(0.5304406423332258379072362627241109752843541856389125894702877753041896800931433544285907484867043684) }}, 
      {{ SC_(19.0938243865966796875), SC_(21.0032062530517578125), SC_(2601146605661370.641672635311073248847566616975198349337624254336189260418619173464950543110725118264), SC_(0.3089044140668820652630859920083949304594747006273677663242119384848088219995792270946218097439270492), SC_(5819408385495817.980444806278225955894116280430846028761561968313252019037358407060697571820807170947), SC_(0.6910955859331179347369140079916050695405252993726322336757880615151911780004207729053781902560729508) }}, 
      {{ SC_(19.0938243865966796875), SC_(38.187648773193359375), SC_(1999053759679.564972373240387984591540801142416633090734820183985585999106626058006740475524514130264), SC_(0.0002374016631657726955698024479273050293551709771839963340497860640248008475706025592191812399818887277), SC_(8418555937397509.05714506834891122015014209626362774500845140246545569345687095446764137445600777508), SC_(0.9997625983368342273044301975520726949706448290228160036659502139359751991524293974407808187600181113) }}, 
      {{ SC_(19.0938243865966796875), SC_(1909.3824462890625), SC_(0.1360733516606079588038269985399818714801767774194133654815920263827438527585305061735104663204259128e-769), SC_(0.1615966546189708783008559120800700270335519388348121960241325600976405816373252643533128864683136716e-785), SC_(8420554991157188.622117441589299204741682897406044378099186222649441279455977580525648114931532289211), SC_(1) }}, 
      {{ SC_(19.2440052032470703125), SC_(0.19244004786014556884765625), SC_(13069110641816150.3089434811630667756967353692600753672076252015144340755982652498049001752167375191), SC_(0.9999999999999999999999999999999441520588384130978199003752936786676413101430836332446149341137773325), SC_(0.7298829221584175981610526121546044339042398556150649586818554471146774289377984346124737601805167021e-15), SC_(0.5584794116158690218009962470632133235868985691636675538506588622266753747314459400875018285411934269e-31) }}, 
      {{ SC_(19.2440052032470703125), SC_(9.62200260162353515625), SC_(13015988822643621.78579271188567536709723836383436344908166519117107297777955023022180950431470347737), SC_(0.9959353149094507593771652152507084116713191756674345391294137025403474019425159238700342659705648733), SC_(53121819172528.52315076927739213848241916384331007917857216494779500205857063464804935275748115640221), SC_(0.00406468509054924062283478474929158832868082433256546087058629745965259805748407612996573402943512673) }}, 
      {{ SC_(19.2440052032470703125), SC_(17.3196048736572265625), SC_(8456967416687222.510426831494319897463223822973254467022837672035207206070091511438453352245531882014), SC_(0.6470958620266144721146187618525383336428262946094855322381705095559628781131224878034600750806836747), SC_(4612143225128927.798516649668747608116433704704419061237399684083660773768029353431405504826652751762), SC_(0.3529041379733855278853812381474616663571737053905144677618294904440371218868775121965399249193163253) }}, 
      {{ SC_(19.2440052032470703125), SC_(19.2440052032470703125), SC_(6138279273650026.415028984756172784378581695921527331247681119707043186315129168707920013272823387391), SC_(0.4696784228002388234702590328550799422410372364188997363359818163396204888210813105347086476526344755), SC_(6930831368166123.893914496406894721201075831756146197012556236411824793522991696161938843799361246386), SC_(0.5303215771997611765297409671449200577589627635811002636640181836603795111789186894652913523473655245) }}, 
      {{ SC_(19.2440052032470703125), SC_(21.1684055328369140625), SC_(4030828044735867.37884957879726243520334205996203475132177936182672833902623422104762056486379730542), SC_(0.3084240508178698029348923333144799163671134468781880964846137144684650208070169431371142202784441316), SC_(9038282597080282.930093902365805070376315467715638776938457994292139640811886643822238292208387328356), SC_(0.6915759491821301970651076666855200836328865531218119035153862855315349791929830568628857797215558684) }}, 
      {{ SC_(19.2440052032470703125), SC_(38.488010406494140625), SC_(2953180921674.746802955943278264540059550458310508566621762262633670725792099426951970839069856789339), SC_(0.0002259664794806846712437218310717178154627222780711796677094948858206874466548651950840976303445936347), SC_(13066157460894475.56214052521978924103959797721936301969361559385623430911232876544290688623311477699), SC_(0.9997740335205193153287562781689282821845372777219288203322905051141793125533451348049159023696554064) }}, 
      {{ SC_(19.2440052032470703125), SC_(1924.4005126953125), SC_(0.1466609950283553788446384788489708049238072785060906049463106594174037106216256843002105464382538672e-775), SC_(0.1122195679934764241436958705141835112427296627087805355770888659886154622261761769611565474651347825e-791), SC_(13069110641816150.30894348116306750557965752767767352826023735611886797983812086486985885707218463378), SC_(1) }}, 
      {{ SC_(21.415802001953125), SC_(0.21415801346302032470703125), SC_(8578100717704568958.950750579193544917015876855009838268353140359095818665346877826082916544400362727), SC_(0.9999999999999999999999999999999999793854805915313516418244276012262407972237650053285737086176164576), SC_(0.1768334237329196788321815486225929115876308756269492387003445914405926488960985050397152851710879457e-15), SC_(0.2061451940846864835817557239877375920277623499467142629138238354236700066865252477198346432974660145e-34) }}, 
      {{ SC_(21.415802001953125), SC_(10.7079010009765625), SC_(8556219969859071202.942823532050255083404391359585458284576918395999601844674596387414742473343624908), SC_(0.9974492316463086634327235747476015372975205174402555282668015656239023129142979298229118421800396269), SC_(21880747845497756.00792704714329001044490922834405881595777058568912840830315706561741277140132925895), SC_(0.00255076835369133656727642525239846270247948255974447173319843437609768708570207017708815781996037308) }}, 
      {{ SC_(21.415802001953125), SC_(19.415802001953125), SC_(5538865683370335292.295376928284531802603651071079443655352875677176341168953414060741170607210641392), SC_(0.6456983737598841556361249125807783897458640120095432967022330551108070386392127589927515056886264504), SC_(3039235034334233666.655373650909013291245649516850073445181813304512389084024339392290984637534312775), SC_(0.3543016262401158443638750874192216102541359879904567032977669448891929613607872410072484943113735496) }}, 
      {{ SC_(21.415802001953125), SC_(21.415802001953125), SC_(4042495476106347398.294017957424417412754963065287157014015596761378936187605883027986358316018979076), SC_(0.4712576372253282201042473456698877375385491227661972555332527962603208542876169820813140428437371982), SC_(4535605241598221560.656732621769127681094337522642360086519092220309794065371870425045796928725975092), SC_(0.5287423627746717798957526543301122624614508772338027444667472037396791457123830179186859571562628018) }}, 
      {{ SC_(21.415802001953125), SC_(23.415802001953125), SC_(2673968890830578422.058367201050951723352515671960335239029170215767145963242887903494491846749684106), SC_(0.311720388793256216117540305541549884099043555829254586252886254957529582541265342749542669955078227), SC_(5904131826873990536.892383378142593370496784915969181861505518765921584289734865549537663397995270061), SC_(0.688279611206743783882459694458450115900956444170745413747113745042470417458734657250457330044921773) }}, 
      {{ SC_(21.415802001953125), SC_(42.83160400390625), SC_(951451812956222.6472243729039496310027883903245646555775681429973370726675922206629398402219944193385), SC_(0.0001109163723145026829663592413499705715148479728656815606384723869380652672857771408680624626611632234), SC_(8577149265891612736.303526206289595462846512197604952444957120838691393180310161232369215404522959748), SC_(0.9998890836276854973170336407586500294284851520271343184393615276130619347327142228591319375373388368) }}, 
      {{ SC_(21.415802001953125), SC_(2141.580078125), SC_(0.8459796636187519800418145873795062251467281610474861875349573565744753185353255818108959162374209711e-862), SC_(0.9862085926232040811098033295689058289712120988868448187364677975736340132742113289638000844236226325e-881), SC_(8578100717704568958.950750579193545093849300587929517100534688981688730252977753453032155244744954167), SC_(1) }}, 
      {{ SC_(21.5864715576171875), SC_(0.215864717960357666015625), SC_(14423296405753588374.31622060821671685071129398016123777268665736650024318310125439716647851132748548), SC_(0.9999999999999999999999999999999999889208787698677032130816214395302005948074986110680724121518084306), SC_(0.1597974494174754308778206243140915550845390395821100976846141713492205016872754808257971880891925677e-15), SC_(0.1107912123013229678691837856046979940519250138893192758784819156939127090654746689755410156227589298e-34) }}, 
      {{ SC_(21.5864715576171875), SC_(10.79323577880859375), SC_(14387822199074430186.87755724699870662757552572659477474303694643515589932286116664676615520412427879), SC_(0.9975404924310501451468881464595852302854521319942516024246469084468227494829716736002163294809025083), SC_(35474206679158187.43866336121801038293321767104189390747033524543589894477912733251042099181737803857), SC_(0.002459507568949854853111853540414769714547868005748397575353091553177250517028326399783670519097491657) }}, 
      {{ SC_(21.5864715576171875), SC_(19.5864715576171875), SC_(9304544345262910887.717303030280171678486278436868264725213433930560031430843201747960622719952920889), SC_(0.6451052577378386799696222899748343841016458891199933849234545602262598928371001079962881938018215962), SC_(5118752060490677486.598917577936545332022464960768403925293847750031766836797092231315953475988735941), SC_(0.3548947422621613200303777100251656158983541108800066150765454397737401071628998920037118061981784038) }}, 
      {{ SC_(21.5864715576171875), SC_(21.5864715576171875), SC_(6798731326972677099.902162856104311991684091028600360440988413299366457091493040475287577287958719379), SC_(0.4713715322567037679352113072240563206011946337854579156489628256083353908928398870472795342258263785), SC_(7624565078780911274.414057752112405018824652369036308209518868381225341176147253503988998907982937451), SC_(0.5286284677432962320647886927759436793988053662145420843510371743916646091071601129527204657741736215) }}, 
      {{ SC_(21.5864715576171875), SC_(23.5864715576171875), SC_(4505454584308582032.507647659020312015392697546368261694685418172426081404589312887182692775805326342), SC_(0.312373430980126976491665160933586417387678955045636924697508666679270127258021889605691137597158818), SC_(9917841821445006341.808572949196404995116045851268406955821863508165716863050981092093883420136330488), SC_(0.687626569019873023508334839066413582612321044954363075302491333320729872741978110394308862402841182) }}, 
      {{ SC_(21.5864715576171875), SC_(43.172943115234375), SC_(1513029361880580.902228477847806409180932847665297124409112963705204028868513011157388497245176298484), SC_(0.000104901772751270595956247924767189218209312480123275352067837133211371218089014732065313036242688236), SC_(14421783376391707793.41399213036891060132781054997137152609816871688659423877178096811918769869648053), SC_(0.9998950982272487294040437520752328107817906875198767246479321628667886287819109852679346869637573118) }}, 
      {{ SC_(21.5864715576171875), SC_(2158.647216796875), SC_(0.1427648233502627959496585660087676101080514976426381347155595034526767776129415400541405530355360755e-868), SC_(0.9898210459941221711342321295923195685805006437127147382161768965795277929692200357084730639836213432e-888), SC_(14423296405753588374.31622060821671701050874339763666865050728168059179826764029397927657619594165683), SC_(1) }}, 
      {{ SC_(22.4928874969482421875), SC_(0.22492887079715728759765625), SC_(233098849551075865909.5219273596764853282414017704925733939182004213277285076356681267884387926839414), SC_(0.9999999999999999999999999999999999995902382644161135711592314958480001374454490998034931763961912647), SC_(0.9551498915465607276298231993497285552429842391698728775935233439205820751146358484384285537826251796e-16), SC_(0.4097617355838864288407685041519998625545509001965068236038087352614722903784953342151684399843292495e-36) }}, 
      {{ SC_(22.4928874969482421875), SC_(11.24644374847412109375), SC_(232626210271430785587.4831851160044087660372447629218825917484720295593639402181079757338286574882907), SC_(0.9979723654554480453069430870728453265704300432368733160470276236620279964087875385997742803412115584), SC_(472639279645080322.0387422436720766577191461622267635651520483267412200917159840680418978945479851381), SC_(0.002027634544551954693056912927154673429569956763126683952972376337972003591212461400225719658788441576) }}, 
      {{ SC_(22.4928874969482421875), SC_(20.4928874969482421875), SC_(149666294797804717369.1414901435349358094585038767669253728218646917466291084618683339121532017932808), SC_(0.6420722156546307749070890329436715732822454058549210058761503888535899429008821794639361541712107524), SC_(83432554753271148540.38043721614154961429788704838172078407865566455395492347222370986357335024299501), SC_(0.3579277843453692250929109670563284267177545941450789941238496111464100570991178205360638458287892476) }}, 
      {{ SC_(22.4928874969482421875), SC_(22.4928874969482421875), SC_(110012057613202911310.980067577295036208179363747203392415042632514826487976318413219324136953446032), SC_(0.4719545284117647483387905549151521064170726804878337974316965704138170068447133550864995545921450276), SC_(123086791937872954598.5418597823814492155770271779452537418578878414740960556156788244515895985902438), SC_(0.5280454715882352516612094450848478935829273195121662025683034295861829931552866449135004454078549724) }}, 
      {{ SC_(22.4928874969482421875), SC_(24.4928874969482421875), SC_(73596654410339793320.16698769515655147647656375595404541052511140899587371004211961115443376851015751), SC_(0.3157315214214025216312278817071697813211476676867346556571833886482845723375362496896867203409386668), SC_(159502195140736072589.3549396645199339472798271691946007463754089473047103218919724326212927835261183), SC_(0.6842684785785974783687721182928302186788523323132653443428166113517154276624637503103132796590613332) }}, 
      {{ SC_(22.4928874969482421875), SC_(44.985774993896484375), SC_(18192580016803568.98339405390590602337741213743633239167202937185878273748883674818583416323941737536), SC_(0.7804663151208418854762718726422370443692937526168145959428757124340835008118172234590722760657034012e-4), SC_(233080656971059062340.5385333057705794003789787877123137652284909844418012944452552955898923887968585), SC_(0.9999219533684879158114523728127357762955630706247383185404057124287565916499188182776540927723934297) }}, 
      {{ SC_(22.4928874969482421875), SC_(2249.288818359375), SC_(0.1568833336621902570020366846489865687945210704188898330999168557130384593942102761459263399670369862e-904), SC_(0.6730334961512304178060720014327721663719727764134073825836090692963692587263351540589523224202972032e-925), SC_(233098849551075865909.5219273596764854237563909251486461569005203563005840319340920437757265520362758), SC_(1) }}, 
      {{ SC_(28.0538349151611328125), SC_(0.2805383503437042236328125), SC_(13016472338795340864664462105.71336711468853331730440114768018693498605643792353168998716302832137117), SC_(0.9999999999999999999999999999999999999999999993177303170307216457230323141415178142973714281217257956), SC_(0.888074445596827836185544815545410682822787386903319575404261023659654369707081334324013108790543015e-17), SC_(0.6822696829692783542769676858584821857026285718782742044398483647022377252442298463360949755901334172e-45) }}, 
      {{ SC_(28.0538349151611328125), SC_(14.02691745758056640625), SC_(13008297730060067004160158935.39983984286451578774600570528738318647496191266374283006811093893719343), SC_(0.9993719797098243278037005094434595639815735135031567450729018248266312085436512022611759417513473682), SC_(8174608735273860504303170.313527271824017538439139898361082110366542680713895688146925958417373495896), SC_(0.0006280202901756721962994905565404360184264864968432549270981751733687914563487977388240582486526318029) }}, 
      {{ SC_(28.0538349151611328125), SC_(26.0538349151611328125), SC_(8159760722143660844277247719.957031160083574272344585354505472266327094210104913243552288721773020997), SC_(0.6268795807158636852250188550135852607372300166363965630106924363036497354054055025561399460346211535), SC_(4856711616651680020387214385.756335954604959053840560249142993030514410383272725274662748175581545927), SC_(0.3731204192841363147749811449864147392627699833636034369893075636963502645945944974438600539653788465) }}, 
      {{ SC_(28.0538349151611328125), SC_(28.0538349151611328125), SC_(6181373660551204248658414434.227667565267633915312811828998936935726105037277050612081608515616386518), SC_(0.4748885488833822603380585394117637546589972534585818236587871263478620162938973458887121399466902973), SC_(6835098678244136616006047671.485699549420899410872333774649528361115399556100587906133428381738180406), SC_(0.5251114511166177396619414605882362453410027465414181763412128736521379837061026541112878600533097027) }}, 
      {{ SC_(28.0538349151611328125), SC_(30.0538349151611328125), SC_(4334664970468520260458883537.311127295557982255868255677744748778845854433995304467756925337852455601), SC_(0.3330138041740492325933826573103160030786870023398759765529241889225481700183478423834684141807917733), SC_(8681807368326820604205578568.402239819130551070316889925903716517995650159382334050458111559502111323), SC_(0.6669861958259507674066173426896839969213129976601240234470758110774518299816521576165315858192082267) }}, 
      {{ SC_(28.0538349151611328125), SC_(56.107669830322265625), SC_(167522406810849340438294.7816712301681616282244463884632695362625248464413051818002839220147056630157), SC_(0.1287003133034378969474674225209564271478529891974352215534482385183499320651538935723467004533913475e-4), SC_(13016304816388530015324023810.93169588452037169796069921518519576057897974693633333641475297533986126), SC_(0.9999871299686696562103052532577479043572852147010802564778446551761481650067934846106427653299546609) }}, 
      {{ SC_(28.0538349151611328125), SC_(2805.383544921875), SC_(0.8375808751313834428308966132045551916984390355221461935110998403861107897297390570657875592842740142e-1125), SC_(0.6434776284469871682454384730763281220946748862619746060422267822913440203668755774461446847109472175e-1153), SC_(13016472338795340864664462105.71336711468853332618514560364846529684150459337763851821503689735456692), SC_(1) }}, 
      {{ SC_(28.2105731964111328125), SC_(0.282105743885040283203125), SC_(21898880550056087068968035017.59416941780136486571433175547658781294427446592383248702557164470340528), SC_(0.9999999999999999999999999999999999999999999996139282857719128389730879280942656608896007590725826153), SC_(0.8454538353636269825179481028802528021893470080517673827466031735159184154422098980551745505475876308e-17), SC_(0.3860717142280871610269120719057343391103992409274173847090024779040342362394720372905923391922869608e-45) }}, 
      {{ SC_(28.2105731964111328125), SC_(14.10528659820556640625), SC_(21885570976025369328112028737.69826354190672918994894772302626517805590936530992948558159566149576381), SC_(0.9993922258263250057965172845329206209035083082149061051813680717695947200899972589220233076104730815), SC_(13309574030717740856006279.8959058758946356842199223860865924600678461294164310233374460637253153021), SC_(0.000607774173674994203482715467079379096491691785093894818631928230405279910002741077976692389526918475) }}, 
      {{ SC_(28.2105731964111328125), SC_(26.2105731964111328125), SC_(13720067509675558873959292369.08099460613013360800699931616588510938354384779470961600620792762935032), SC_(0.6265191263231224507734672472442363727301014406921633041260299583158768073078653602459238294899416418), SC_(8178813040380528195008742648.51317481167123126616187079294697252874021164693165089291283379759172879), SC_(0.3734808736768775492265327527557636272698985593078366958739700416841231926921346397540761705100583582) }}, 
      {{ SC_(28.2105731964111328125), SC_(28.2105731964111328125), SC_(10401057901876465747305537667.68504177010797475790348486843467753528193252803432883528342198797407188), SC_(0.4749584289526537794254474170027959914657938131002753676446858742159062226972312223385711560090583274), SC_(11497822648179621321662497349.90912764769339011626538524067818010284182296669203167363561973724700723), SC_(0.5250415710473462205745525829972040085342061868997246323553141257840937773027687776614288439909416726) }}, 
      {{ SC_(28.2105731964111328125), SC_(30.2105731964111328125), SC_(7301809930976113853730149066.320407614550964811616801156820883523247959076512783262131632363041298592), SC_(0.3334330224910703288347527898452622100398967524554017163459220316912367929480297811622444274667543315), SC_(14597070619079973215237885951.27376180325040006255206895229197411487579641821357724678740936217978052), SC_(0.6665669775089296711652472101547377899601032475445982836540779683087632070519702188377555725332456685) }}, 
      {{ SC_(28.2105731964111328125), SC_(56.421146392822265625), SC_(267946564709036710471756.5284428460347671829927143190882765811708334876926494085672881871937895397723), SC_(0.122356283964638754074585246940066876712921646138102380197275979481465503817657951397451201722947896e-4), SC_(21898612603491378032257563261.06572657176659769117615579002458105695292200703371110035175353802728957), SC_(0.9999877643716035361245925414753059933123287078353861897619802724020518534496182342048602548798277052) }}, 
      {{ SC_(28.2105731964111328125), SC_(2821.057373046875), SC_(0.5275257237991324125218565753928236252506872123663506084087843539695188643810439168162205617325491417e-1131), SC_(0.2408916394576988191856445728086465820896433922843433314497769550718002612864736936932726956056510062e-1159), SC_(21898880550056087068968035017.59416941780136487416887010911285763812375549472636050891904172522107911), SC_(1) }}, 
      {{ SC_(30.0544281005859375), SC_(0.3005442917346954345703125), SC_(10630687771914156232192522990611.66667924454995714139881457097700388414217517357019771306054631935899), SC_(0.999999999999999999999999999999999999999999999999523496846153063620678068212341170375568864490521835), SC_(0.5065556250879156501221247004640051982429757838907001969446439966555904012942616055792550404643351327e-17), SC_(0.4765031538469363793219317876588296244311355094781650050057589850584780746435754859969723430881978368e-48) }}, 
      {{ SC_(30.0544281005859375), SC_(15.02721405029296875), SC_(10626289475468348291892398624261.3137097882218921770593544869432359470206711363529328455974578918585), SC_(0.9995862641683985809245921297689007183962490308476994378806988966128113170066940590059085674947605952), SC_(4398296445807940300124366350.352969456328064969405016334912924438342751041857316849892846266407493841), SC_(0.0004137358316014190754078702310992816037509691523005621193011033871886829933059409940914325052394047864) }}, 
      {{ SC_(30.0544281005859375), SC_(28.0544281005859375), SC_(6617571477131695205924751951310.914360479658252249109655117208748625035003045867945688986949184769617), SC_(0.6224970217463304024992288057729766180469000983101496979431198684380443903248256270035513270287112756), SC_(4013116294782461026267771039300.752318764891704897354715704647411760328419132342304006503354973496379), SC_(0.3775029782536695975007711942270233819530999016898503020568801315619556096751743729964486729712887244) }}, 
      {{ SC_(30.0544281005859375), SC_(30.0544281005859375), SC_(5057432674955197628248810746272.516427030808472514321350400639156523906034160847086352123303030583263), SC_(0.475738991066667257936178346973772274305223872588010478008237248782717814613025991177852317934602844), SC_(5573255096958958603943712244339.150252213741484632143020421217003861457388017363163343367001127682733), SC_(0.524261008933332742063821653026227725694776127411989521991762751217282185386974008822147682065397156) }}, 
      {{ SC_(30.0544281005859375), SC_(32.0544281005859375), SC_(3594651411312654984354910178187.669555577983800201676737292477233757779206987900735621890688181694257), SC_(0.3381391202937572382390191801518397931134172276602009028391127187902769337080613236003651771896237114), SC_(7036036360601501247837612812423.997123666566156944787633529378926627584215190309514073599615976571739), SC_(0.6618608797062427617609808198481602068865827723397990971608872812097230662919386763996348228103762886) }}, 
      {{ SC_(30.0544281005859375), SC_(60.108856201171875), SC_(71830926550022368739160864.1549330881569974852363286113993864374563634871882440705602102583317945106), SC_(0.6756940669426558527005153388969285418796228099523822290005761371112542054043543075595207414857536131e-5), SC_(10630615940987606209823783829747.5117461563929596612280422104567739479070586910220056249300938999342), SC_(0.9999932430593305734414729948466110307145812037719004761777099942386288874579459564569244047925851425) }}, 
      {{ SC_(30.0544281005859375), SC_(3005.44287109375), SC_(0.6391527195245049025413093179558230079188094384012206330962942146840926431426512530775297468530536636e-1204), SC_(0.6012336485068448106739821397729627476807906457390751616958028995501634222109472524489597132633102005e-1235), SC_(10630687771914156232192522990611.666679244549957146464370821856160385363422178210249695490304158266), SC_(1) }}, 
      {{ SC_(30.5403537750244140625), SC_(0.305403530597686767578125), SC_(55323542538198664629008006807946.54428687634080173736167777365188318815509486676117772514834417734427), SC_(0.9999999999999999999999999999999999999999999999999184025276459341154818149297049679325027824257759316), SC_(0.4514261232789653490969618961903151339482817752508086614682397407864259088092804522998499404057721921e-17), SC_(0.8159747235406588451818507029503206749721757422406836575553885196967947470609632268971724278240177342e-49) }}, 
      {{ SC_(30.5403537750244140625), SC_(15.27017688751220703125), SC_(55302853839860222166198586806368.81539415744782500419116309768217581150131107179696411265204297147692), SC_(0.9996260416923923887406182377865544022389061754871340424846900555538489894507643607309397549538019988), SC_(20688698338442462809420001577.7288927188929767376847759087593608676234027568673649519791189583754309), SC_(0.000373958307607611259381762213445597761093824512865957515309944446151010549235639269060245046198001236) }}, 
      {{ SC_(30.5403537750244140625), SC_(28.5403537750244140625), SC_(34383546252121214206917852301252.88984011454685951895533652396117056057206788134549036719509931218776), SC_(0.621499359488426985793184603790969450020073269076592138184145110900525820658429590195441116932913502), SC_(20939996286077450422090154506693.6544467617939422229206024824803661185526459473188386974360626176646), SC_(0.378500640511573014206815396209030549979926730923407861815854889099474179341570409804558883067086498) }}, 
      {{ SC_(30.5403537750244140625), SC_(30.5403537750244140625), SC_(26330290328526345844084130397228.3541540333735952440845277108287629507477594758367547501390226656153), SC_(0.4759328329408108161664521667310343436109256340616918372887474914855057834498301516156908166176271368), SC_(28993252209672318784923876410718.19013284296720649779141129561277372837695435282757431449213926423706), SC_(0.5240671670591891838335478332689656563890743659383081627112525085144942165501698483843091833823728632) }}, 
      {{ SC_(30.5403537750244140625), SC_(32.54035186767578125), SC_(18772082740947083819880984263251.1107093867959726414180315160973691819128620122791948095998992334882), SC_(0.3393145463883792556965654371397306895857639412163940813527488691639789166612794328550718897854791964), SC_(36551459797251580809127022544695.43357748954482910045790749034416749721185181638513425503126269636416), SC_(0.6606854536116207443034345628602693104142360587836059186472511308360210833387205671449281102145208036) }}, 
      {{ SC_(30.5403537750244140625), SC_(61.080707550048828125), SC_(319750323893161501547364871.9471324441271532775826666381053065114146222455009560919394791163942737225), SC_(0.5779642973375879860404401701327458421116422508373668948833372781514111241715798106032773118594522845e-5), SC_(55323222787874771467506459443074.59715443221364846429327236833623016771009158316337297269168281345808), SC_(0.9999942203570266241201395955982986725415788835774916263310511666272184858887582842018939672268814055) }}, 
      {{ SC_(30.5403537750244140625), SC_(3054.035400390625), SC_(0.3961965192787088984378813914974873969117566017019571029955121349210008593552086028374670167947824519e-1223), SC_(0.7161445220272206072300793452176234815783276759662760025607804603387748936425726088632166714558739941e-1255), SC_(55323542538198664629008006807946.54428687634080174187593900644153667912471382866432906463116192985235), SC_(1) }}, 
      {{ SC_(31.16262054443359375), SC_(0.3116261959075927734375), SC_(462624699113536846626017964322050.649795271710471005992846910940200142218543513602870177746629176643), SC_(0.9999999999999999999999999999999999999999999999999914820705735093686211754549779174556362394141508231), SC_(0.3940604538000569814815372089763812896188968295852802534369064254725795864375460623004512660433445425e-17), SC_(0.851792942649063137882454502208254436376058584917693031771280152106125612010327710841990555290851904e-50) }}, 
      {{ SC_(31.16262054443359375), SC_(15.581310272216796875), SC_(462472679022930944149999456680562.1306105485603427156764842032800000136313582701687717914585428655053), SC_(0.9996713965101794232737366783645916467900204715247164813334845460874316518996447350687063567484021154), SC_(152020090605902476018507641488.5191847231501282942569672456607699434025573331979112824770546069904561), SC_(0.0003286034898205767262633216354083532099795284752835186665154539125683481003552649312936432515978846218) }}, 
      {{ SC_(31.16262054443359375), SC_(29.16262054443359375), SC_(286946049873905810015180277182786.1464574167194882882489814121725489111366603067646804307929701108701), SC_(0.6202566582020814780235590166968321221400109807688055430887100332528169469320428807570689614241158865), SC_(175678649239631036610837687139264.5033378549909827216844700367682210458972552966020026431426273616256), SC_(0.3797433417979185219764409833031678778599890192311944569112899667471830530679571192429310385758841135) }}, 
      {{ SC_(31.16262054443359375), SC_(31.16262054443359375), SC_(220290042968042406374974814947222.8095473829577341359711594853072205747672082037667306935872993126172), SC_(0.476174409602758942761661147551475181775264029268271962657270752444394359227020415739092631410077918), SC_(242334656145494440251043149374827.8402478887527368739622919636335493822667073995999523803482981598786), SC_(0.523825590397241057238338852448524818224735970731728037342729247555605640772979584260907368589922082) }}, 
      {{ SC_(31.16262054443359375), SC_(33.16262054443359375), SC_(157654541578516148308646650651632.2951976448619167431172265215886965104983850165282499539154206582642), SC_(0.3407828027353652890497680640062128634244574604446298344895961975907000988843356219592519766777621756), SC_(304970157535020698317371313670418.3545976268485542668162249273520734465355305868384331200201768142316), SC_(0.6592171972646347109502319359937871365755425395553701655104038024092999011156643780407480233222378244) }}, 
      {{ SC_(31.16262054443359375), SC_(62.3252410888671875), SC_(2189310528184656785283050037.843196407451515748345696540993716032241786317858830857836694202382519624), SC_(0.4732368445480163597816816189318208582557462605760362740641908553054689158798284682823277539388591067e-5), SC_(462622509803008661969232681272012.8065988642589552615877549079470539247921292855078522160989032701133), SC_(0.9999952676315545198364021831838106817914174425373942396372593580914469453108412017153171767224606114) }}, 
      {{ SC_(31.16262054443359375), SC_(3116.261962890625), SC_(0.1013919443759329192692218628975848528482816536544267588192958557394280842230221240818421160246154661e-1247), SC_(0.2191667340075360295553155695217247481431906133894579613057691001221515578083520290277880482861073039e-1280), SC_(462624699113536846626017964322050.6497952717104710099334514489407699570339156033666830739355974724958), SC_(1) }}, 
      {{ SC_(31.996768951416015625), SC_(0.319967687129974365234375), SC_(8131687260818805862245797820874541.721649761415405030755407418994569883627242661436334086413390859908), SC_(0.9999999999999999999999999999999999999999999999999995879227931512656110115521739097127909502731361732), SC_(0.3350882973405649410726863419053300130357013862326157163284966274439845101072486414613665552382985803e-17), SC_(0.4120772068487343889884478260902872090497268638267653147339322162452153031976748137223232810773565659e-51) }}, 
      {{ SC_(31.996768951416015625), SC_(15.9983844757080078125), SC_(8129439785636440597403650712505420.639050901677298327344910029550456944532458250343252392481521176987), SC_(0.999723615147720405653566091809971319116875855673455609646448352264151517410556716897680064815473706), SC_(2247475182365264842147108369121.082598859738106706761380362849762349821647830146381824288883545246905), SC_(0.0002763848522795943464339081900286808831241443265443903535516477358484825894432831023199351845262940115) }}, 
      {{ SC_(31.996768951416015625), SC_(29.996768951416015625), SC_(5030660939716144494990365515138840.049120816436136707464189074209960005346290094688681426207171577273), SC_(0.618649091924077635008542039031859800931879068100503637381030751433958543327863337093338028285629916), SC_(3101026321102661367255432305735701.672528944979268326642101318190259289007815985800952790563233144962), SC_(0.381350908075922364991457960968140199068120931899496362618969248566041456672136662906661971714370084) }}, 
      {{ SC_(31.996768951416015625), SC_(31.996768951416015625), SC_(3874644227718806677497967114342847.816130085832855443765330676782997537227469326660232000590880198953), SC_(0.4764871180410664529124225629254370242257817306879099084512541146226349247396397481631249409954350422), SC_(4257043033099999184747830706531693.905519675582549590340959715617221757126636753829402216179524523281), SC_(0.5235128819589335470875774370745629757742182693120900915487458853773650752603602518368750590045649578) }}, 
      {{ SC_(31.996768951416015625), SC_(33.996768951416015625), SC_(2786643940817371536441585713377836.793511032003262701271843316192119518636999426324391506815632093708), SC_(0.3426895122054626772399508130487163734138308659612294674415426488148719531583766081766494000982831144), SC_(5345043320001434325804212107496704.928138729412142332834447076208099775717106654165242709954772628526), SC_(0.6573104877945373227600491869512836265861691340387705325584573511851280468416233918233505999017168856) }}, 
      {{ SC_(31.996768951416015625), SC_(63.99353790283203125), SC_(29442987317192965566728245708.84014112014619973032980766155911971510528018931425416707227032574873801), SC_(0.362077221772400726205487523182727472465292314585680163890154637266853685108861864353603192662640749e-5), SC_(8131657817831488669280231092628832.881508641269205303776482730841099579248825891175380049698134396485), SC_(0.9999963792277822759927379451247681727252753470768541431983610984536273314631489113813564639680733736) }}, 
      {{ SC_(31.996768951416015625), SC_(3199.677001953125), SC_(0.1119762009638676714302046624197882089173119539217445349737201580054624865895556463979852751733105453e-1280), SC_(0.1377035261838050889097804901648914306214864152567979357671443381818466611457123269059549866491213953e-1314), SC_(8131687260818805862245797820874541.721649761415405034106290392400219294354106080489634216770404722234), SC_(1) }}, 
      {{ SC_(32.05139923095703125), SC_(0.3205139935016632080078125), SC_(9818675716055357228155203818677279.285256945198103332492245808102812674592080605634867478315732705061), SC_(0.9999999999999999999999999999999999999999999999999996620610304345820966860690344443966206097465324844), SC_(0.331811315398073920530089721434668430411075002373773608414156223246795294768347163626334762856514246e-17), SC_(0.3379389695654179033139309655556033793902534675155903088494387993844377990933661909125439046096719795e-51) }}, 
      {{ SC_(32.05139923095703125), SC_(16.025699615478515625), SC_(9815992539490497621590662655533830.032212296575553051737720920350835346450307211576541210063009732466), SC_(0.9997267272448491078221606403386774910108349082393710917755543222432822802621476490253077975955922758), SC_(2683176564859606564541163143449.253044648622550284072638041732716533442670608405010572363472996332674), SC_(0.0002732727551508921778393596613225089891650917606289082244456777567177197378523509746922024044077242358) }}, 
      {{ SC_(32.05139923095703125), SC_(30.05139923095703125), SC_(6073303024560840658530975896530421.265480151513796851744905238861090622061746884035134402922359753882), SC_(0.6185460443132736276256735065385282025387056993061891718744085602196197532130049805368108310212120092), SC_(3745372691494516569624227922146858.019776793684306484065453723222461257831230935946417379504122974917), SC_(0.3814539556867263723743264934614717974612943006938108281255914397803802467869950194631891689787879908) }}, 
      {{ SC_(32.05139923095703125), SC_(32.05139923095703125), SC_(4678669387719540278612423224451050.768137047368336968785924830610348881987815957111753963967391353122), SC_(0.4765071709282594421141341686730183212502035595546146038374903558461429885630667825728516648077503354), SC_(5140006328335816949542780594226228.517119897829766367024434131473202997905161862869797818459091375677), SC_(0.5234928290717405578858658313269816787497964404453853961625096441538570114369332174271483351922496646) }}, 
      {{ SC_(32.05139923095703125), SC_(34.05139923095703125), SC_(3365959972731823332609113054894362.082494817925516232963516514081742638109004541116316374271321718434), SC_(0.3428120115249202115387170085641820173445661430816344363477117870587273142568357225870758321730054538), SC_(6452715743323533895546090763782917.202762127272587102846842448001809241783973278865235408155161010365), SC_(0.6571879884750797884612829914358179826554338569183655636522882129412726857431642774129241678269945462) }}, 
      {{ SC_(32.05139923095703125), SC_(64.1027984619140625), SC_(34933576489643598627658350324.95005438750111341914848309327867955325552160022783305451344768029843887), SC_(0.355787048069229102745855493000967403320047426057697126500260818047854209781158956042733366277932277e-5), SC_(9818640782478867584556576160326954.335202557696989916661875868804872326637456219753718727913035048501), SC_(0.9999964421295193077089725414450699903259667995257394230287349973918195214579021884104395726663372207) }}, 
      {{ SC_(32.05139923095703125), SC_(3205.139892578125), SC_(0.7782373393559598965981747130732658364753868663457687446985337237977346471146436976890013042085303316e-1283), SC_(0.7926092701925142502357565925376385947899297820341263599295539228188224717616815405859583881721623736e-1317), SC_(9818675716055357228155203818677279.285256945198103335810358962083551879892977819981551782426482728799), SC_(1) }}, 
      {{ SC_(36.44875335693359375), SC_(0.36448752880096435546875), SC_(51420445329652109014719459254376563172188.32366319245704729763363307630270870350604200323760830740377), SC_(0.9999999999999999999999999999999999999999999999999999999999604621528329854642446028882912584308766297), SC_(0.2033053708703611454518923311581406170645213325893876433947373848438158114894159371143476560895229522e-17), SC_(0.39537847167014535755397111708741569123370272514212617752145993215148237020868341487906296324676533e-58) }}, 
      {{ SC_(36.44875335693359375), SC_(18.224376678466796875), SC_(51414776814402041673283991251670059227937.03686947501492506443464226574597328875919899795145699746404), SC_(0.999889761451622463176503202008568401950448379465384649529918324281208838529578900721599500075107085), SC_(5668515250067341435468002706503944251.286793717442122235232044519260346869265766316867557480584945096), SC_(0.000110238548377536823496797991431598049551620534615350470081675718791161470421099278400499924892914981) }}, 
      {{ SC_(36.44875335693359375), SC_(34.44875335693359375), SC_(31419961216887244186891196057259357744056.14989478323963364758080349466277437402325862146629359297562), SC_(0.6110402392561274143631005300563093577972117730879944658665792838707094563165162003582587225740326937), SC_(20000484112764864827828263197117205428132.17376840921741365208588329034354578400170669335272088507337), SC_(0.3889597607438725856368994699436906422027882269120055341334207161292905436834837996417412774259673063) }}, 
      {{ SC_(36.44875335693359375), SC_(36.44875335693359375), SC_(24577443048176826290807425729125280009989.89806914115785861854608908164525660040289464046415377829471), SC_(0.4779702488108168982985547789404222036232251733980413390161813024950437400378683177514884972375117106), SC_(26843002281475282723912033525251283162198.42559405129918868112059770336106355762207067435486069975428), SC_(0.5220297511891831017014452210595777963767748266019586609838186975049562599621316822485115027624882894) }}, 
      {{ SC_(36.44875335693359375), SC_(38.44875335693359375), SC_(18090890995770080236169389671579583132029.73847835026012061784890419554242085396940114132168126763483), SC_(0.3518229155696905018794243453022403618689316334967674745046502945047768724581195390144413925922183878), SC_(33329554333882028778550069582796980040158.58518484219692668181778258946389930405556417349733321041416), SC_(0.6481770844303094981205756546977596381310683665032325254953497054952231275418804609855586074077816122) }}, 
      {{ SC_(36.44875335693359375), SC_(72.8975067138671875), SC_(44794680330610173790325904871286231.4620528231519159945977388426491694323930467505355470404843506488), SC_(0.8711453205711323891838789066843775586996671839701640699167707900947970508081024297207206827005633679e-6), SC_(51420400534971778404545668928471691885956.86161036930513130506894794235715072563191856428346743756464), SC_(0.9999991288546794288676108161210933156224413003328160298359300832292099052029491918975702792793172994) }}, 
      {{ SC_(36.44875335693359375), SC_(3644.875244140625), SC_(0.2052333634608248219980577195057580211016968449761099685665601238068322199794065980732846098630791333e-1456), SC_(0.399127938595418913141037228785291251911102190488312264491205030828651058011038455881523456296831284e-1497), SC_(51420445329652109014719459254376563172188.32366319245704729966668678500632015802496531481901447804899), SC_(1) }}, 
      {{ SC_(38.46506500244140625), SC_(0.384650647640228271484375), SC_(74476097961717736707311283690297342332640635.36828527513831761263423020098285675319043072376838506452), SC_(0.9999999999999999999999999999999999999999999999999999999999999737171591666092260969748612110146801584), SC_(0.1957443428619846316633847000085545945278630730464330492832414282635303960636943114598488847353331592e-17), SC_(0.2628284083339077390302513878898531984157013156072764487802905004186189368583596223709956211045867208e-61) }}, 
      {{ SC_(38.46506500244140625), SC_(19.232532501220703125), SC_(74470671615104430708019858002669903107825265.43541100343301703784190837164882341226188891290728507243), SC_(0.9999271397567566542717257180570594693345157632435967577481630263036187764612216531692693658186431452), SC_(5426346613305999291425687627439224815369.932874271705300576749765257953879657562388810946645937368386), SC_(0.7286024324334572827428194294053066548423675640324225183697369638122353877834683073063418135685483289e-4) }}, 
      {{ SC_(38.46506500244140625), SC_(36.46506500244140625), SC_(45284764068480704266436983806916789500344890.34333950265956591896839074526771939756199637058151093573), SC_(0.6080442626271587808203732945953276193884525828877170814104986257359448216684380012490224834049623064), SC_(29191333893237032440874299883380552832295745.02494577247875169562328288433498367226228135327242007407), SC_(0.3919557373728412191796267054046723806115474171122829185895013742640551783315619987509775165950376936) }}, 
      {{ SC_(38.46506500244140625), SC_(38.46506500244140625), SC_(35640951011207567576511223496938478818114920.08854367148220352219252461742135974563330277014306819674), SC_(0.4785555632832396462325558547156730388446319349095560891771750900522238183809963254426455682172064331), SC_(38835146950510169130800060193358863514525715.27974160365611409239914901218134332419097495371086281306), SC_(0.5214444367167603537674441452843269611553680650904439108228249099477761816190036745573544317827935669) }}, 
      {{ SC_(38.46506500244140625), SC_(40.46506500244140625), SC_(26473831399532651160030688980409433397456023.5388010732147518462983916570177583732676013476938272969), SC_(0.3554674872083222069089889485735308279452981834706649299929936062561219738535502425333916621181020558), SC_(48002266562185085547280594709887908935184611.8294842019235657682932819725849446965566763761601037129), SC_(0.6445325127916777930910110514264691720547018165293350700070063937438780261464497574666083378818979442) }}, 
      {{ SC_(38.46506500244140625), SC_(76.9301300048828125), SC_(34104300946544617920962692297574039275.85730427191012670106412036032404395874777953899771382520592097), SC_(0.4579227682427043627144211522493769523300348756892813630883230360181496589572891134745259522852117399e-6), SC_(74476063857416790162693362727605044758601359.51098100322819091352755326927865911107649818485621718459), SC_(0.9999995420772317572956372855788477506230476699651243107186369116769639818503410427108865254740477148) }}, 
      {{ SC_(38.46506500244140625), SC_(3846.506591796875), SC_(0.6344698375148891978318953694464850822255164730179298739810260812671355972495791867411120280975535882e-1536), SC_(0.8519106866219278699362768240955413679390366943000933299898028077399325357167063246778052166325384945e-1580), SC_(74476097961717736707311283690297342332640635.3682852751383176145916736296027030698242777238539310098), SC_(1) }}, 
      {{ SC_(39.52658843994140625), SC_(0.395265877246856689453125), SC_(3588963314116707873190446531102509723131836488.566699586405422159688100732294410319129725282925294645), SC_(0.9999999999999999999999999999999999999999999999999999999999999994413425037442482559090495542064250511), SC_(0.2005001259218185099263846061650302487405890709034819657867246183956963807422721600712381503343952107e-17), SC_(0.5586574962557517440909504457935749489254593778564333127652828107846518527700077379392333322331169109e-63) }}, 
      {{ SC_(39.52658843994140625), SC_(19.763294219970703125), SC_(3588752942961210623579147228611774569788300390.173615040926411068669762348749528382088966070267968551), SC_(0.9999413838657336555190727057480746442916662079890450472838459587230914719720212116869946926785590296), SC_(210371155497249611299302490735153343536098.3930845454790110930233396427630670363046052743076285820272), SC_(0.5861613426634448092729425192535570833379201095495271615404127690852802797878831300530732144097042883e-4) }}, 
      {{ SC_(39.52658843994140625), SC_(37.52658843994140625), SC_(2176926332123041471652359455849982518759650439.664746147586599923793277400021946569116111917367862322), SC_(0.6065613219172211883500503201931108646583852309925343298117418343317772491146614395752639792377229902), SC_(1412036981993666401538087075252527204372186048.901953438818822237899824591490648849277459427207734811), SC_(0.3934386780827788116499496798068891353416147690074656701882581656682227508853385604247360207622770098) }}, 
      {{ SC_(39.52658843994140625), SC_(39.52658843994140625), SC_(1718559114930389402365116545582781030067050069.670905329737336887065422344272857700882033772416932418), SC_(0.478845550794756426018221647797646042795415707871750662265780850038803276415249164853764818320195487), SC_(1870404199186318470825329985519728693064786418.895794256668085274627679647239737717511537572158664715), SC_(0.521154449205243573981778352202353957204584292128249337734219149961196723584750835146235181679804513) }}, 
      {{ SC_(39.52658843994140625), SC_(41.52658843994140625), SC_(1282269703300467478998957438405346680980309491.471855691358950660836887984542870737672895404348891523), SC_(0.3572813626310502685276829446211331746156740790347101192649689399707434825724495595398828412020051764), SC_(2306693610816240394191489092697163042151526997.09484389504647150085621400696972468072067594022670561), SC_(0.6427186373689497314723170553788668253843259209652898807350310600292565174275504404601171587979948236) }}, 
      {{ SC_(39.52658843994140625), SC_(79.0531768798828125), SC_(1171984262615086272436925774213134455225.080561852545683875484950190010014226695613974410537154834002), SC_(0.3265523105252267972305331530905466429660756200777455296446363626766092337625348242932184525276610451e-6), SC_(3588962142132445258104174094176735509997381263.486137733859738286208151801502581191697957370165059978), SC_(0.9999996734476894747732027694668469094533570339243799222544703553636373233907662374651757067815474723) }}, 
      {{ SC_(39.52658843994140625), SC_(3952.658935546875), SC_(0.9165655452725188131936353964945234196751456316829463618558966733914701143200131653887872022563731868e-1578), SC_(0.2553844843348859690185933024039368127233065990964138730843062737185193776991267902666556619314473834e-1623), SC_(3588963314116707873190446531102509723131836488.566699586405422161693101991512595418393571344575597133), SC_(1) }}, 
      {{ SC_(40.1744842529296875), SC_(0.401744842529296875), SC_(38755671301264757235165505802180986445852673110.63366908473899680511163068596862378918614753221667189), SC_(0.9999999999999999999999999999999999999999999999999999999999999999467396388930498977140988253765012606), SC_(0.2064141048447623736751307197431756738511310678385305427209004540018544626350349336944306873171657679e-17), SC_(0.5326036110695010228590117462349873943473287993051473068627989413701510220976334195069405084875790471e-64) }}, 
      {{ SC_(40.1744842529296875), SC_(20.08724212646484375), SC_(38753681739688963742162950174895334141999519136.43348007739953815561603152538016865585883935029703771), SC_(0.9999486639888049477442293162512901782233651407941165877100024494719547560529604638924021331177915066), SC_(1989561575793493002555627285652303853153974.20018900733945865155974020903607887007861537935139091987), SC_(0.5133601119505225577068374870982177663485920588341228999755052804524394703953610759786688220849341566e-4) }}, 
      {{ SC_(40.1744842529296875), SC_(38.1744842529296875), SC_(23473754866981740564555486055108018485222914840.89532642432922923677689389951361970679094125439301889), SC_(0.6056856733175899143047735897428789338443720945815721939828003090822229775480176381535315155613375295), SC_(15281916434283016670610019747072967960629758269.73834266040976757039887783490262781914651347525540974), SC_(0.3943143266824100856952264102571210661556279054184278060171996909177770224519823618464684844386624705) }}, 
      {{ SC_(40.1744842529296875), SC_(40.1744842529296875), SC_(18564620196126416583824924960812700619298333372.43503017151698110378592881334042054748819013683566141), SC_(0.4790168657334178736602681696601428580148630898071515336667084778109915747025016755472166027968034456), SC_(20191051105138340651340580841368285826554339738.19863891322201570338984292107582697844926459281276722), SC_(0.5209831342665821263397318303398571419851369101928484663332915221890084252974983244527833972031965544) }}, 
      {{ SC_(40.1744842529296875), SC_(42.1744842529296875), SC_(13888306771198703528421483388743752303473940039.4102895562521427143332987616776131260865041010771322), SC_(0.3583554691451176296889241779765488985250327905320915942322545065258820371877960981371943111488811587), SC_(24867364530066053706744022413437234142378733071.22337952848685409284247297273863439985095062857129643), SC_(0.6416445308548823703110758220234511014749672094679084057677454934741179628122039018628056888511188413) }}, 
      {{ SC_(40.1744842529296875), SC_(80.348968505859375), SC_(10297453142424702584860814468459300310714.26581298933898996634652706129685599333458805088014430853806), SC_(0.2657018391547936949654387140441327114368138897647303719002191428216298823431619777993151352447966925e-6), SC_(38755661003811614810462920941366517986552362396.36785609540000684082924467311939153260286667876828432), SC_(0.9999997342981608452063050345612859558672885631861102352696280997808571783701176568380222006848647552) }}, 
      {{ SC_(40.1744842529296875), SC_(4017.448486328125), SC_(0.2700477350407812016018325548647399119476191175927851658124516865191402053916788194164832727604714857e-1603), SC_(0.6967954004501231058803493451541279071457936604459712842319233523248254214931231564886775795838955157e-1650), SC_(38755671301264757235165505802180986445852673110.63366908473899680717577173441624752593745472964842863), SC_(1) }}, 
      {{ SC_(41.168750762939453125), SC_(0.41168749332427978515625), SC_(1524258603069265638743278312423780744130625018590.686165238612013968583442924585101825830212085904134), SC_(0.9999999999999999999999999999999999999999999999999999999999999999985543189618875330036628692360705089), SC_(0.2203591759637034721244346759822017892316646987063867858400490586901496518963689871966743469246620057e-17), SC_(0.1445681038112466996337130763929491133443604338109110730911692777822616154900423152471680813557074612e-65) }}, 
      {{ SC_(41.168750762939453125), SC_(20.5843753814697265625), SC_(1524194748986895939156748068594470617840101808542.147883921369726677855394627154080363588612453382105), SC_(0.9999581081043327410252978678033412655104043809687323781225330629606153568393178382780136588887519966), SC_(63854082369699586530243829310126290523210048.5382813172422872929316400570680561834859463923440476599), SC_(0.4189189566725897470213219665873448959561903126762187746693703938464316068216172198634111124800341377e-4) }}, 
      {{ SC_(41.168750762939453125), SC_(39.168750762939453125), SC_(921235832221207999894436234073217083769592391359.6367764729780647438573463877860202466651684393573161), SC_(0.6043828982603059202815090516192595596663242557967821462984970751314593449396962059754752775156110268), SC_(603022770848057638848842078350563660361032627231.0493887656339492269296882964361163004093904063688362), SC_(0.3956171017396940797184909483807404403336757442032178537015029248685406550603037940245247224843889732) }}, 
      {{ SC_(41.168750762939453125), SC_(41.168750762939453125), SC_(730534252406374013683152885251306441118544771229.5780837527804079903647704402323945156895778195318329), SC_(0.4792718577643986191255396729946647050226502718656690724878496065119580358902563096555433826366021708), SC_(793724350662891625060125427172474303012080247361.1080814858316059804222642439897420313849810261943195), SC_(0.5207281422356013808744603270053352949773497281343309275121503934880419641097436903444566173633978292) }}, 
      {{ SC_(41.168750762939453125), SC_(43.168750762939453125), SC_(548668567949485117299998089976314174637006606649.3558065210126974974653263152368532751670060638810415), SC_(0.3599576652181456768842813574348807638230264962726768429237893522425321974313715404978628431571321193), SC_(975590035119780521443280222447466569493618411941.3303587175993164733217083689852832719075527818451108), SC_(0.6400423347818543231157186425651192361769735037273231570762106477574678025686284595021371568428678807) }}, 
      {{ SC_(41.168750762939453125), SC_(82.33750152587890625), SC_(295194151561481442539883184817579927163593.185261637429442582745079888962317546805108318050677448853), SC_(0.1936640875551398648158013681401567369985181153948799089903491694490277067975544317324447372139193959e-6), SC_(1524258307875114077261835772540595926550697854997.500903601182571388041954795259819000269450527675475), SC_(0.9999998063359124448601351841986318598432630014818846051200910096508305509722932024455682675552627861) }}, 
      {{ SC_(41.168750762939453125), SC_(4116.875), SC_(0.1823183208486564649755902033103732767509437711098764678941584076934788183130309281845347251782807613e-1642), SC_(0.1196111476632233398205596072066382297314675492619930892102829251666369007875620560936819123776857662e-1690), SC_(1524258603069265638743278312423780744130625018590.686165238612013970787034684222136547074558845726152), SC_(1) }}, 
      {{ SC_(42.46524810791015625), SC_(0.4246524870395660400390625), SC_(189826116208112223374427708716952062262555313430053.0581376558616480180572702552664721584979197550157), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999868838410400578319132217190804235), SC_(0.248978951493405435581825791863767232391819941401534608748931768758315062249939998035433608403527693e-17), SC_(0.1311615895994216808677828091957652628287183331760047625485569591332527650331876930587546923009175046e-67) }}, 
      {{ SC_(42.46524810791015625), SC_(21.232624053955078125), SC_(189820013558825525413856451277124302722534888018895.5949328854530526624360500962295996242200863846981), SC_(0.9999678513715151426370708901040324345699634151844983814304977600782977945314620725113350584413611004), SC_(6102649286697960571257439827759540020425411157.463204770408595358111009673970926890096091288955325974), SC_(0.3214862848485736292910989596756543003658481550161856950223992170220546853792748866494155863889964229e-4) }}, 
      {{ SC_(42.46524810791015625), SC_(40.46524810791015625), SC_(114418509469147666618059763730225993904197929287012.7658071312781962775517922244974783993141906654385), SC_(0.6027543088102120114128560801755924306710305322450205040752823481499426851367728588029526240884331002), SC_(75407606738964556756367944986726068358357384143040.29233052458345174299526754570304811500198700821485), SC_(0.3972456911897879885871439198244075693289694677549794959247176518500573148632271411970473759115668998) }}, 
      {{ SC_(42.46524810791015625), SC_(42.46524810791015625), SC_(91038860601073319555031191320147622356965732166863.27570185908875239864710546014332004091709923594325), SC_(0.479590808786629812456920525708786660803436610293434862004471959968413641666478882385419840449504671), SC_(98787255607038903819396517396804439905589581263189.78243579677289562189995431005720647339907843771015), SC_(0.520409191213370187543079474291213339196563389706565137995528040031586358333521117614580159550495329) }}, 
      {{ SC_(42.46524810791015625), SC_(44.46524810791015625), SC_(68710885357270162173435573275602262281533441424085.69231057841556932928819252521522739727101779206907), SC_(0.3619675033647124732769363399463223410648460945809521431099493385666606665468411278891661772541151576), SC_(121115230850842061200992135441349799981021872005967.3658270774460786912588672449852991170451598815843), SC_(0.6380324966352875267230636600536776589351539054190478568900506614333393334531588721108338227458848424) }}, 
      {{ SC_(42.46524810791015625), SC_(84.9304962158203125), SC_(24348327108521101518414501008666294609723236.61824098477188140644477599895081557232651747139912370585), SC_(0.1282664766834679368955418038597182009370967953321035999631116697702154437085777266511155557205717818e-6), SC_(189826091859785114853326190302451053596260703706816.4398966710897666141022837712497109419896602022543), SC_(0.9999998717335233165320631044581961402817990629032046678964000368883302297845562914222733488844442794) }}, 
      {{ SC_(42.46524810791015625), SC_(4246.52490234375), SC_(0.1582138976529834669433177680858588062216552879141295278678516348608211028079490742605004732613922258e-1693), SC_(0.833467495481647495481160914000063543822730002585076733409460509982719856414211333368378429831102885e-1744), SC_(189826116208112223374427708716952062262555313430053.0581376558616480205470597702005265143161776736534), SC_(1) }}, 
      {{ SC_(42.497722625732421875), SC_(0.4249772131443023681640625), SC_(214320796587885406489458353728508854097873289394904.6024158630527288917218602076036150242028043390557), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999883411956140219450400432290945474), SC_(0.2498724243265148933181472014474271661064356718503270820032139724307779458620504172510254476937240104e-17), SC_(0.1165880438597805495995677090545256446620949551376648046928037362511313906278612645727943391506149808e-67) }}, 
      {{ SC_(42.497722625732421875), SC_(21.2488613128662109375), SC_(214313951967646903484275152390899015742965720544957.0244003475522738138072843627099232296750479851478), SC_(0.9999680636674206449787401653783054044121775659544962496092997854430722825546991266056094615440876975), SC_(6844620238503005183201337609838354907568849947.578015515500455080413300088158840727709228368382151053), SC_(0.319363325793550212598346216945955878224340455037503907002145569277174453008733943905384559123024965e-4) }}, 
      {{ SC_(42.497722625732421875), SC_(40.497722625732421875), SC_(129174249361023537107331876987310933122091042366831.2645618937047613242717506127419300674429383707532), SC_(0.6027144888296163515772252070453834692480092311566955326953291599058029767926908124663436695625012203), SC_(85146547226861869382126476741197920975782247028073.33785396934796756994883383812683388994133798277675), SC_(0.3972855111703836484227747929546165307519907688433044673046708400941970232073091875336563304374987797) }}, 
      {{ SC_(42.497722625732421875), SC_(42.497722625732421875), SC_(102787956119288975126093723648829399785804945587883.9803151682835690979042911457085841852094068383049), SC_(0.4795986099143638463567892055723837634276116729234156335106960194337764297212436073008822394018180986), SC_(111532840468596431363364630079679454312068343807020.6221006947691597963162933051601797721748695152251), SC_(0.5204013900856361536432107944276162365723883270765843664893039805662235702787563926991177605981819014) }}, 
      {{ SC_(42.497722625732421875), SC_(44.497722625732421875), SC_(77587716348964293578465407640649663151883390246322.89493559759560806796522105015336899577361192607823), SC_(0.3620167411852088050793255261572635397474417290529254386212890191099213379494954290219523059157586597), SC_(136733080238921112910992946087859190945989899148581.7074802654571208262553634007153949616106644274517), SC_(0.6379832588147911949206744738427364602525582709470745613787109808900786620505045709780476940842413403) }}, 
      {{ SC_(42.497722625732421875), SC_(84.99544525146484375), SC_(27208070530448802765802909580562168163995461.77254579478951131116041462644391236698700521687109732357), SC_(0.1269502118488614883135844698362221668980787971129111358877071664099451873870630359704078903509597235e-6), SC_(214320769379814876040655587925599273535705125399442.8298700682632175830601698244248515903972711366588), SC_(0.999999873049788151138511686415530163777833101921202887088864112292833590054812612936964029592109649) }}, 
      {{ SC_(42.497722625732421875), SC_(4249.7724609375), SC_(0.8326144286328681511297509911312044136597406528821339926238202082943488422887032281482269721890781093e-1695), SC_(0.3884897974851648675353071909446415031550976071737151800482655820055346640598305675474382338414838097e-1745), SC_(214320796587885406489458353728508854097873289394904.6024158630527288942205844508687639573842763535299), SC_(1) }}, 
      {{ SC_(44.155063629150390625), SC_(0.4415506422519683837890625), SC_(108477114678077093078697695322659091260698084784137369.110002963121029559199090947909271120281219104), SC_(0.999999999999999999999999999999999999999999999999999999999999999999999971405835691531463436772501), SC_(0.3101812440813520419483393002469302629985608179508771094556858171811451827514217878742256926755929311e-17), SC_(0.2859416430846853656322749899999994037199837561279552079800218535906471678278076452067456339118630281e-70) }}, 
      {{ SC_(44.155063629150390625), SC_(22.0775318145751953125), SC_(108474643430185028249549503850872916519826391393005797.430328383897984547126631643749528279128196121), SC_(0.9999772187165984397158403431700925824058753412351532475246527059570351643018381108199138172896039085), SC_(2471247892064829148191471786174740871693391131571.679674579223045015174271744973263260636415985468981), SC_(0.2278128340156028415965682990741759412465876484675247534729404296483569816188918008618271039609146006e-4) }}, 
      {{ SC_(44.155063629150390625), SC_(42.155063629150390625), SC_(65166733607384328109686174934992652095056623924479329.71630731218031381629055903769763393120666968009), SC_(0.6007417675219041750822628400919139150659383390950652539443606929164707374961076769162586172886969385), SC_(43310381070692764969011520387666439165641460859658039.39369565094071574601034435102515760855794242637), SC_(0.3992582324780958249177371599080860849340616609049347460556393070835292625038923230837413827113030615) }}, 
      {{ SC_(44.155063629150390625), SC_(44.155063629150390625), SC_(52067413750779344514119345276186742921186293772746499.41380384213826580730156316210705897365261918615), SC_(0.4799852384099410068415064305992278477407571638288250246591103967747364965706434447092705239015834618), SC_(56409700927297748564578350046472348339511791011390869.69619912098276375499934022661573256611199292031), SC_(0.5200147615900589931584935694007721522592428361711749753408896032252635034293565552907294760984165382) }}, 
      {{ SC_(44.155063629150390625), SC_(46.155063629150390625), SC_(39535757049385602447041006385754985944643699206637761.09264139802081605784331062412697787405216533363), SC_(0.3644617315524494040054148120284369212099063236559308483685850590153452830990755538609910522536928245), SC_(68941357628691490631656688936904105316054385577499608.01736156510021350445759276459581366571244677283), SC_(0.6355382684475505959945851879715630787900936763440691516314149409846547169009244461390089477463071755) }}, 
      {{ SC_(44.155063629150390625), SC_(88.31012725830078125), SC_(8137413449512315740698282975266611386652928396.043112228062756547178254908982430306893053990429077622), SC_(0.7501502481570763190138780452890031775330360096985795411810658666744412583681565686527092252128233038e-7), SC_(108477106540663643566381954624376115994086698131208973.066890735058273015122648479740361232871558116), SC_(0.9999999249849751842923680986121954710996822466963990301420458818934133325558741631843431347290774787) }}, 
      {{ SC_(44.155063629150390625), SC_(4415.50634765625), SC_(0.471616374294560277944461078335500447468289615585971440027982546549067486843462830019440340283459081e-1760), SC_(0.4347611712333574492131230726637439063324039886060442151202797559933361183474801399051158585639811607e-1813), SC_(108477114678077093078697695322659091260698084784137369.1100029631210295623009033887227915397646121065), SC_(1) }}, 
      {{ SC_(44.835826873779296875), SC_(0.4483582675457000732421875), SC_(1425978933609371600254458545091031314924821988225992007.557234079964693407661705427270692856772618663), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999999975782049885832827770176393437), SC_(0.3453428667800506345586379402470304713295120863379305752115250295842367161856972936119639096916324187e-17), SC_(0.2421795011416717222982360656263756591421154877670003395133154316227366187748464697721629599772812851e-71) }}, 
      {{ SC_(44.835826873779296875), SC_(22.4179134368896484375), SC_(1425950651713633889105666908760918881400866742496260282.113179056753909833420877276347905848622289105), SC_(0.999980166680537050201167214079127526076483317084996681897910004842606091655157227350710452797377076), SC_(28281895737711148791636330112433523955245729731725.44405502321078357769425681872329335373670896079778), SC_(0.1983331946294979883278592087247392351668291500331810208999515739390834484277264928954720262292402961e-4) }}, 
      {{ SC_(44.835826873779296875), SC_(42.835826873779296875), SC_(855535678182104766414101538607812051948212691408357581.4462739593052650716693109932594932935460042787), SC_(0.5999637568393893599087315525330780934527760671826708937832493979646943082931183806407797393962321876), SC_(570443255427266833840357006483219262976609296817634426.1109601206594283394458231018117059088129937868), SC_(0.4000362431606106400912684474669219065472239328173291062167506020353056917068816193592202606037678124) }}, 
      {{ SC_(44.835826873779296875), SC_(44.835826873779296875), SC_(684666388653978411093045829488133146997666675192448887.548528078215404828846865562619004725827358265), SC_(0.4801378004378947380266451988338181755814166171016997601902346821704416371646920497258774389818801572), SC_(741312544955393189161412715602898167927155313033543120.0087060017492885822682685324521944765316398005), SC_(0.5198621995621052619733548011661818244185833828983002398097653178295583628353079502741225610181198428) }}, 
      {{ SC_(44.835826873779296875), SC_(46.835826873779296875), SC_(521094130933416047837079183573472533059338367837325116.5799720069159845395376546564897521165798171593), SC_(0.3654290527381402493626935887566776833495382792235610396067617960985112005638177611240789255072658853), SC_(904884802675955552417379361517558781865483620388666890.9772620730487088715774794385814470857791809061), SC_(0.6345709472618597506373064112433223166504617207764389603932382039014887994361822388759210744927341147) }}, 
      {{ SC_(44.835826873779296875), SC_(89.67165374755859375), SC_(86195751040333604857084573714314451948245512370.79235789734733534050631501122476697460359002262506887), SC_(0.6044672120236652165734581570628687563255578813023631070319335842563478393717628809723536588107406485e-7), SC_(1425978847413620559920853688006457600610370039980479636.764876182617358070608819083846432227755408043), SC_(0.9999999395532787976334783426541842937131243674442118697636892968066415743652160628237119027646341189) }}, 
      {{ SC_(44.835826873779296875), SC_(4483.58251953125), SC_(0.7605491057948708736924073253960663000703660831533174820826097811656785980099961747730783148348354065e-1787), SC_(0.5333522732133246357469507632120627536627389505909703958332558281193272201000164939932160014407258852e-1841), SC_(1425978933609371600254458545091031314924821988225992007.557234079964693411115134095071199202358998065), SC_(1) }}, 
      {{ SC_(46.069919586181640625), SC_(0.46069920063018798828125), SC_(156229578645430029892693280469938894161099847723443430447.8937329526294770773514461975762040960485434), SC_(0.999999999999999999999999999999999999999999999999999999999999999999999999972414536373073821020386629), SC_(0.430966535917351299246823445116747633882755453793598188924370382185860462468582139997307910457170432e-17), SC_(0.2758546362692617897961337099106494794692271397414639378058001876362927589908259563322719332609135106e-73) }}, 
      {{ SC_(46.069919586181640625), SC_(23.0349597930908203125), SC_(156227167802482030291019955950849717986542276783577097596.7764187512164019070117619873055446230194126), SC_(0.9999845685882986913965954484603299408671471664544313095838757262758837338039566255031179892326667966), SC_(2410842947999601673324519089176174557570939866332851.117314201413075174649349569444172465497365238143), SC_(0.1543141170130860340455153967005913285283354556869041612427372411626619604337449688201076733320338164e-4) }}, 
      {{ SC_(46.069919586181640625), SC_(44.069919586181640625), SC_(93518739167256001160965508843623557287049283164262706802.08206238317796027550427531938997001220645491), SC_(0.598598165456881470526785542920476560627052846085107740656990795501163393325018781713583372398113095), SC_(62710839478174028731727771626315336874050564559180723645.81167056945151680615683623735974707631032292), SC_(0.401401834543118529473214457079523439372947153914892259343009204498836606674981218286416627601886905) }}, 
      {{ SC_(46.069919586181640625), SC_(46.069919586181640625), SC_(75053579006905291972845878009168891776075391934208005221.27770122160681576900920027778915844077444459), SC_(0.4804056930681655629591455827282010092249885224965548489268707311023785623924484916861804903328450513), SC_(81175999638524737919847402460770002385024455789235425226.61603173102266131265191127896055864774233324), SC_(0.5195943069318344370408544172717989907750114775034451510731292688976214376075515083138195096671549487) }}, 
      {{ SC_(46.069919586181640625), SC_(48.069919586181640625), SC_(57356732535777750826101726953433302049059639079849857461.90725107209455149651293551223027861293511609), SC_(0.3671310710371395400688098470264602078755856799586471251333558549032032640968970520939771044797009879), SC_(98872846109652279066591553516505592112040208643593572985.98648188053492558514817604451943847558166174), SC_(0.6328689289628604599311901529735397921244143200413528748666441450967967359031029479060228955202990121) }}, 
      {{ SC_(46.069919586181640625), SC_(92.13983917236328125), SC_(6386261777959473426463268613298083779201778180875.963636401171364540171862037153434000929449897273151), SC_(0.4087741792131039588147504168641433115263864467545102514308424422207845266372182224750302862122549557e-7), SC_(156229572259168251933219854006670280863016068521665249571.9300965514581125414892495195962830875873279), SC_(0.9999999591225820786896041185249583135856688473613553245489748569157557779215473362781777524969713788) }}, 
      {{ SC_(46.069919586181640625), SC_(4606.9921875), SC_(0.2103364288773543767991509542870335920129305151787917372994954838606983292825200444922887881847471441e-1835), SC_(0.1346329105544874108038106920532274902902258224702979771700801449163515518919323368752942104778867365e-1891), SC_(156229578645430029892693280469938894161099847723443430447.8937329526294770816611115567497170885167778), SC_(1) }}, 
      {{ SC_(47.73848724365234375), SC_(0.477384865283966064453125), SC_(94297871782126531667698757690457880775688953913143478158783.4026371124564849066620969800384558927427), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999999999999349491816884125540004068), SC_(0.6134153724468481696276626044323259403012657381341431694954157745658077001183420287143157095875836147e-17), SC_(0.6505081831158744599959323819852673084068016573338617816115596248891966884813541934905939397700390915e-76) }}, 
      {{ SC_(47.73848724365234375), SC_(23.869243621826171875), SC_(94296834823245807652969045967500639423686913863045283825866.12092678998463588262427567075517041016733), SC_(0.9999890033692051938476305602120476157955869002397150769041542477718912839914002884896529349163695651), SC_(1036958880724014729711722957241352002040050098194332917.281710322471849030171975033751767178851992382), SC_(0.1099663079480615236943978795238420441309976028492309584575222810871600859971151034706508363043494305e-4) }}, 
      {{ SC_(47.73848724365234375), SC_(45.73848724365234375), SC_(56280529723473313322772954173137164595518203073213855235385.45619029103223562820004377606088660146763), SC_(0.5968377510524142493503249212629070417341066991315400614686976736813838796351206883152067091509543647), SC_(38017342058653218344925803517320716180170750839929622923397.94644682142424928459620692844605098755169), SC_(0.4031622489475857506496750787370929582658933008684599385313023263186161203648793116847932908490456353) }}, 
      {{ SC_(47.73848724365234375), SC_(47.73848724365234375), SC_(45333819229102433455254827525534048742879689999947486539951.19954532498841582752257288476676363338733), SC_(0.480751244671198672827310863786147702830011497912631764613704226381736485766138504104714358349333159), SC_(48964052553024098212443930164923832032809263913195991618832.203091787468069085273677819740173955632), SC_(0.519248755328801327172689136213852297169988502087368235386295773618263514233861495895285641650666841) }}, 
      {{ SC_(47.73848724365234375), SC_(49.73848724365234375), SC_(34827306725858276966117445978915340810575352880081770694703.4605605862527481970966869862156645736762), SC_(0.3693329029347143432647220290012258387000367719450912937969606556838290008738547030598297130035940408), SC_(59470565056268254701581311711542539965113601033061707464079.94207652620373671569956371829127301534313), SC_(0.6306670970652856567352779709987741612999632280549087062030393443161709991261452969401702869964059592) }}, 
      {{ SC_(47.73848724365234375), SC_(95.4769744873046875), SC_(2272453501227737595672809400559769771223684974377983.827976395269020528779174166766882031804331639098), SC_(0.2409867219992195465527592924565649658742240559501080492032913406249111902612657779532496540897954508e-7), SC_(94297869509673030439961162017648480215919182689458503780799.57466071718746438401707653774005555721499), SC_(0.999999975901327800078045344724070754343503412577594404989195079670865937508880973873422204675034591) }}, 
      {{ SC_(47.73848724365234375), SC_(4773.8486328125), SC_(0.4930699700361143527972140765160232135500591407875671436014018474055318469318842911777409267112490955e-1901), SC_(0.5228855760131504268371997964833577252463985153824819644786388969005802260327733579808010387320073253e-1960), SC_(94297871782126531667698757690457880775688953913143478158783.40263711245648491279625070450693758901933), SC_(1) }}, 
      {{ SC_(48.7948760986328125), SC_(0.48794877529144287109375), SC_(5601572122098061051259791642269275646923022713836767611816339.1137889913367940628079996713078961603), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999999999999985876655788824192282825), SC_(0.7911293120411743533001376111343001937295274002968810106768363279940895381585075390096587193008694434e-17), SC_(0.1412334421117580771717536205560869187212298090709774667602193820952283548749621069654359532291337091e-77) }}, 
      {{ SC_(48.7948760986328125), SC_(24.39743804931640625), SC_(5601522402139792886638498079287725791823205121779703966794601.016615862491090543010529121958589696189), SC_(0.999991123927857320512363083686512750338327837341403865193132290293173625226193417093316263644182252), SC_(49719958268164621293562981549855099817592057063645021738.09717312884570352770876366976104999711212453), SC_(0.8876072142679487636916313487249661672162658596134806867709706826374773806582906683736355817747966447e-5) }}, 
      {{ SC_(48.7948760986328125), SC_(46.7948760986328125), SC_(3337252972618945238853345843103427263009076595580958815239085.917364310448605943882838936122588050498), SC_(0.5957707764671218367298061078886198032271253720656163155156411853611522701054849762534337523550633538), SC_(2264319149479115812406445799165848383913946118255808796577253.196424680888188126836453855597051642803), SC_(0.4042292235328781632701938921113801967728746279343836844843588146388477298945150237465662476449366462) }}, 
      {{ SC_(48.7948760986328125), SC_(48.7948760986328125), SC_(2694136564790500482748260777423500420852012948687403792505394.16676815034093075792922204727697680055), SC_(0.4809607920894563752724322425856259987941807214874355947391297070165003153642341702847879913264921532), SC_(2907435557307560568511530864845775226071009765149363819310944.947020840995863312790070744442662892751), SC_(0.5190392079105436247275677574143740012058192785125644052608702929834996846357658297152120086735078468) }}, 
      {{ SC_(48.7948760986328125), SC_(50.7948760986328125), SC_(2076343764684620073166086419044050262016135013176153464440846.664429231610555519468550009162785276707), SC_(0.3706716113666547602264918798884556302564009821822648843191020496528632303627131612767514362854816721), SC_(3525228357413440978093705223225225384906887700660614147375492.449359759726238551250742782556854416594), SC_(0.6293283886333452397735081201115443697435990178177351156808979503471367696372868387232485637145183279) }}, 
      {{ SC_(48.7948760986328125), SC_(97.589752197265625), SC_(96633720783328303798352010014189600454943867848270215.47055760089377523289780774911933669460249883556), SC_(0.1725117854005855020842370419366583086762499064870270317383869431514356647748290788156579276766810871e-7), SC_(5601572025464340267931487843917265632733422258892899763546123.643231390443018837821485042600302998698), SC_(0.9999999827488214599414497915762958063341691323750093512972968261613056848564335225170921184342072323) }}, 
      {{ SC_(48.7948760986328125), SC_(4879.48779296875), SC_(0.142902764516403185294728217767227941951713037297670494882890420551091468476013775233803109173853481e-1942), SC_(0.2551118889510596062852710063746790917638079926789072602114635625355302609430843127363392446485128694e-2003), SC_(5601572122098061051259791642269275646923022713836767611816339.113788991336794070719292791719639693301), SC_(1) }}, 
      {{ SC_(49.0131072998046875), SC_(0.490131080150604248046875), SC_(13061864686300908920803719163179816963237677037051715665276991.24303425192689419132654400708683577008), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999999999999993597665573432272928705), SC_(0.836264259562735739627584621018775264415451920404592899346755679500865071935186794232489730130344795e-17), SC_(0.6402334426567727071295084550402072098866010960149830297834331520992735700400049855174658417403349245e-78) }}, 
      {{ SC_(49.0131072998046875), SC_(24.50655364990234375), SC_(13061753764458253693889131231633966917056697244809076726567854.48561655813426357616271131753200856525), SC_(0.999991507962659300849474722779311188992029309392573691814886457299231043087112170534288979616810278), SC_(110921842655226914587931545850046180979792242638938709136.7574176937926306235264752851821846011056054), SC_(0.849203734069915052527722068881100797069060742630818511354270076895691288782946571102038318972203823e-5) }}, 
      {{ SC_(49.0131072998046875), SC_(47.0131072998046875), SC_(7779055177224531433847873356756550880745643673160067434883264.175524243200545787554424699998699886704), SC_(0.5955547208648616454908563451934368284777868953754228840242479213047790283151801262424758509649431696), SC_(5282809509076377486955845806423266082492033363891648230393727.067510008726348412134761902715493279651), SC_(0.4044452791351383545091436548065631715222131046245771159757520786952209716848198737575241490350568304) }}, 
      {{ SC_(49.0131072998046875), SC_(49.0131072998046875), SC_(6282799159117711650413155559190223007042393328845967305871549.376765107501095387327816026904935607209), SC_(0.4810032342248208072042698066580552453179272398068159449689453325312924253220975980845696118149472746), SC_(6779065527183197270390563603989593956195283708205748359405441.866269144425798812361370575809257559146), SC_(0.5189967657751791927957301933419447546820727601931840550310546674687075746779024019154303881850527254) }}, 
      {{ SC_(49.0131072998046875), SC_(51.0131072998046875), SC_(4845208239695453672310499194053447053092715720355790929554960.433543251225737318347763865778378682507), SC_(0.3709430740602478166121936161323102049305485691941792020654326044473795475903974477495853857611723314), SC_(8216656446605455248493219969126369910144961316695924735722030.809491000701156881341422736935814483848), SC_(0.6290569259397521833878063838676897950694514308058207979345673955526204524096025522504146142388276686) }}, 
      {{ SC_(49.0131072998046875), SC_(98.026214599609375), SC_(210302546324079617042666137317355910679338721332923180.7011094632185992140992419400883752605588168246), SC_(0.161004995362294501955781899433447647910794848223030498056618820371527992069100268591557647156092188e-7), SC_(13061864475998362596724102120513679645881766357712994332353810.5419247887082949855899446626258179058), SC_(0.9999999838995004637705498044218100566552352089205151776969501943381179628472007930899731408442352844) }}, 
      {{ SC_(49.0131072998046875), SC_(4901.310546875), SC_(0.3762759202371411607906182163728630489436731159784447719530250581881585367181454133780748766860948066e-1951), SC_(0.2880721315630943547874313385040782195852595290301301095111354119874378149376461073017779801557087002e-2012), SC_(13061864686300908920803719163179816963237677037051715665276991.24303425192689419968918660271419316635), SC_(1) }}, 
      {{ SC_(49.231555938720703125), SC_(0.4923155605792999267578125), SC_(30513621371784093137907492178483728526708751385403785887891548.23854827764774923684709064035148648646), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999999999999997099978963833420028762), SC_(0.8849014386779600512060918409202638110571377119277677306756900527895703405248910547011395073678119164e-17), SC_(0.2900021036166579971238497856762868731798590837906482108761044532802848110442112916452863099138439806e-78) }}, 
      {{ SC_(49.231555938720703125), SC_(24.6157779693603515625), SC_(30513373469024151077427407466748464253916093262945790568081786.96468838116647238895631811451178316184), SC_(0.9999918756690029818667536660677441010658447041407899302655904960908028819952123731430693041660260175), SC_(247902759942060480084711735264272792658122457995319809761.273859896481276856739786912619303836679277), SC_(0.8124330997018133246333932255898934155295859210069734409503909197118004787626856930695833973982461035e-5) }}, 
      {{ SC_(49.231555938720703125), SC_(47.231555938720703125), SC_(18165976531026817699694075872139940080858090169269377566790729.18049740095257364251337317300270303058), SC_(0.5953399076985622259376744449097626597320408517357455652989455255522387615460499030573249546917648582), SC_(12347644840757275438213416306343788445850661216134408321100819.05805087669517560318273185412838396794), SC_(0.4046600923014377740623255550902373402679591482642544347010544744477612384539500969426750453082351418) }}, 
      {{ SC_(49.231555938720703125), SC_(49.231555938720703125), SC_(14678438286187132704549611673975659053997461881768925114598324.54023317355898087685865946286072013889), SC_(0.4810454356545259460226648234226421578585333714355594346042312300451980308766843304950525841893354252), SC_(15835183085596960433357880504508069472711289503634860773293223.69831510408876836883744556427036685963), SC_(0.5189545643454740539773351765773578421414666285644405653957687699548019691233156695049474158106645748) }}, 
      {{ SC_(49.231555938720703125), SC_(51.231555938720703125), SC_(11327056074316051728317464973826531163156542845237827110031967.79109381718475434769618838452002397804), SC_(0.3712131030369986195606978160531938715384914963649215103746762677583232808809154482681745158093446569), SC_(19186565297468041409590027204657197363552208540165958777859580.44745446046299489799991664261106302048), SC_(0.6287868969630013804393021839468061284615085036350784896253237322416767191190845517318254841906553431) }}, 
      {{ SC_(49.231555938720703125), SC_(98.46311187744140625), SC_(458487525192315340840770286858890259374330205634710765.9988768621277089725207826487810563589003265197), SC_(0.1502566737674336393528638656732338483304684381381084127396773752730019404675626466336475080971018729e-7), SC_(30513620913296567945592151337713441667818492011073580253180782.23967141552004027317532237835003063962), SC_(0.9999999849743326232566360647136134326766151669531561861891587260322624726998059532437353366352491903) }}, 
      {{ SC_(49.231555938720703125), SC_(4923.15576171875), SC_(0.9717321242756456827191901001352849353556786219798769841406587556238286163318346298612203221364212635e-1960), SC_(0.318458472180625909505605899807483871295648097053185716425474836108328454194480870818140154208789747e-2021), SC_(30513621371784093137907492178483728526708751385403785887891548.23854827764774924569610502713108699852), SC_(1) }}, 
      {{ SC_(49.313610076904296875), SC_(0.493136107921600341796875), SC_(41977462250047053621278529477326524770382434246777810317301271.50355312924884894059528324863289768382), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999999999999997846166238980781349222), SC_(0.9041247539606111811561301659776818578488689362946063791809098998694084062604014379692784132080132169e-17), SC_(0.2153833761019218650777897073040746888619415685741883415747598184105013419478470021362496143382514766e-78) }}, 
      {{ SC_(49.313610076904296875), SC_(24.6568050384521484375), SC_(41977126834111098802325476057585044641461610329312651133657817.80438041334181472191041470716898161388), SC_(0.999992009618543473456957953827788227898425858640141642904158702373742555202893589905204560663320144), SC_(335415935954818953053419741480128920823917465159183643453.6991727159070342277261160810700278815059985), SC_(0.7990381456526543042046172211772101574141359858357095841297626257444797106410094795439336679855990441e-5) }}, 
      {{ SC_(49.313610076904296875), SC_(47.313610076904296875), SC_(24987487076314225090859455285460119707445499455299404530418239.95789704471690970870041620817722242819), SC_(0.5952595925754472204052306290824436181794875104709120322748544232982499815973709574172989348541860406), SC_(16989975173732828530419074191866405062936934791478405786883031.54565608453193924093611458006178706719), SC_(0.4047404074245527795947693709175563818205124895290879677251455767017500184026290425827010651458139594) }}, 
      {{ SC_(49.313610076904296875), SC_(49.313610076904296875), SC_(20193728989961464156407400427712716826877199356621370752578181.00940429055827926222557408902306356367), SC_(0.4810612149365658350199096657185796598997839581312059611269089898075494261587237385701322394433743991), SC_(21783733260085589464871129049613807943505234890156439564723090.49414883869056968741095669921594593172), SC_(0.5189387850634341649800903342814203401002160418687940388730910101924505738412762614298677605566256009) }}, 
      {{ SC_(49.313610076904296875), SC_(51.313610076904296875), SC_(15586823406579095014352178767892338209924728088557566605812326.27035014833144003135287498797910150214), SC_(0.3713140950192057725345167846810657523567871031455454878884239259485793829239381364071945398866452464), SC_(26390638843467958606926350709434186560457706158220243711488945.23320298091740891828365580025990799324), SC_(0.6286859049807942274654832153189342476432128968544545121115760740514206170760618635928054601133547536) }}, 
      {{ SC_(49.313610076904296875), SC_(98.62722015380859375), SC_(614582434878766631658381755290327694839226731674591511.4439373352808898253364458766736410914439707921), SC_(0.1464077154588061669542294492075360765560256682717113973689794974636505127774814401769897990679495622e-7), SC_(41977461635464618742511897818944769480054739407551078642709760.05961579396795912430008491156536840394), SC_(0.9999999853592284541193833045770550792463923443974331728288602631020502536349487222518559823010200932) }}, 
      {{ SC_(49.313610076904296875), SC_(4931.36083984375), SC_(0.5781374421410369483050943901670173138935377941438834462093143122446551440529941418555199448394287663e-1963), SC_(0.137725677340199120569492006946235910213477616632694978279574736604970959505980571279012260573630228e-2024), SC_(41977462250047053621278529477326524770382434246777810317301271.50355312924884894963653078823900949539), SC_(1) }}, 
      {{ SC_(50.61444091796875), SC_(0.50614440441131591796875), SC_(6714188046232440418685030023377617773603001027074053478294994042.204646644051537335902300746519907618), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999999999999999980715363415791268913), SC_(0.1294806764296310636318173346859335327241054167055133004392944644877422244201183535072458036592003221e-16), SC_(0.1928463658420873108652804777026377451373877260124550558001117332744510315505278162911918594962705467e-80) }}, 
      {{ SC_(50.61444091796875), SC_(25.307220458984375), SC_(6714146820546485816210964392746809241641339557308203649194458429.81834063847038356985374879819165094), SC_(0.999993859914903971804826160490836859357383212078582155689027432935121621190536804019545464384514836), SC_(41225685954602474065630630808531961661469765849829100535612.38630600558115377899661959129136304102089), SC_(0.614008509602819517383950916314064261678792141784431097256706487837880946319598045453561548516398687e-5) }}, 
      {{ SC_(50.61444091796875), SC_(48.61444091796875), SC_(3988313956145632916566663762336571620536279896513960331887006459.167227525169321876011864521792547979), SC_(0.5940128469269805020475397278656733185177834722866262153069773700644041051113597931821515140004607074), SC_(2725874090086807502118366261041046153066721130560093146407987583.037419118882215472838503867690466002), SC_(0.4059871530730194979524602721343266814822165277133737846930226299355958948886402068178484859995392926) }}, 
      {{ SC_(50.61444091796875), SC_(50.61444091796875), SC_(3231580463151548830516154806912916051190670333620249597297205901.021990540164873600299658797918958768), SC_(0.4813062191436384758388250043654343574286693186475618754553011841019147867069570438343251387511825629), SC_(3482607583080891588168875216464701722412330693453803880997788141.182656103886663748550709591564055213), SC_(0.5186937808563615241611749956345656425713306813524381245446988158980852132930429561656748612488174371) }}, 
      {{ SC_(50.61444091796875), SC_(52.61444091796875), SC_(2503613809043348826074455346249509284449404807156470871472444827.438146871104786877235935571082287603), SC_(0.3728840764965187117746424485085442369500169196675495454176896266215341707615979829805709488435240308), SC_(4210574237189091592610574677128108489153596219917582606822549214.766499772946750471614432818400726378), SC_(0.6271159235034812882253575514914557630499830803324504545823103733784658292384020170194290511564759692) }}, 
      {{ SC_(50.61444091796875), SC_(101.2288818359375), SC_(65157090661144176686930404729589898612925199880024698927.79274861109795689024903768341745546080942518), SC_(0.9704388708282610485660341164426108672165668055174493744243968577985313828355455148136453870853589378e-8), SC_(6714187981075349757540853336447213044013102414148853598270295114.41189803295358045860133070606555852), SC_(0.9999999902956112917173895143396588355738913278343319448255062557560314220146861716445448518635461291) }}, 
      {{ SC_(50.61444091796875), SC_(5061.4443359375), SC_(0.4289812536466745246255732966601129510431435781396240051532903497325943684690874971818157697955959851e-2014), SC_(0.6389175440020487899249233587686281673752734749390701447354800554184726072346876273924109482210533211e-2078), SC_(6714188046232440418685030023377617773603001027074053478294994042.204646644051537348850368389483013981), SC_(1) }}, 
      {{ SC_(54.914707183837890625), SC_(0.549147069454193115234375), SC_(164151310522993759069795066972687396443103420991679884830848715223699039.1653106566475602886411567813), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999999999999999999999996719495846733), SC_(0.5384990559349759171681441333454699105568520939738433355014750224830539512407632661747323173299402731e-16), SC_(0.3280504153267450125172471989136226939862161886184417111761738657190547864708487501819152013725201312e-87) }}, 
      {{ SC_(54.914707183837890625), SC_(27.4573535919189453125), SC_(164150887731298655188038651562491593455570836870325079905734706617590366.5972755127311180833858260057), SC_(0.9999974243781925538844289635804501882857438295912247848668748219088743426660381706768477071244500074), SC_(422791695103881756415410195802987532584121354804925114008606108672.5680351439164422591052363691705433), SC_(0.2575621807446115571036419549811714256170408775215133125178091125657333961829323152292875549992583763e-5) }}, 
      {{ SC_(54.914707183837890625), SC_(52.914707183837890625), SC_(96884578938958210997376202956674290839773847199735668357379347723709372.39625989326147265466419377192), SC_(0.590215080405263944811319921890712084248273030272297085126732257678891723123563893072502749049830431), SC_(67266731584035548072418864016013105603329573791944216473469367499989666.76905076338608768782686860291), SC_(0.409784919594736055188680078109287915751726969727702914873267742321108276876436106927497250950169569) }}, 
      {{ SC_(54.914707183837890625), SC_(54.914707183837890625), SC_(79129667267047147526717119118995088355831259181129876934354432191582853.77653680202639544058251024707), SC_(0.4820532167238648515239777182823065099496881627515239823294463925310285574100982896450873030840569627), SC_(85021643255946611543077947853692308087272161810550007896494283032116185.38877385462116490190855212777), SC_(0.5179467832761351484760222817176934900503118372484760176705536074689714425899017103549126969159430373) }}, 
      {{ SC_(54.914707183837890625), SC_(56.914707183837890625), SC_(61998698233085757229493527411137482480537560623537872923270337904981139.91599151236753006190384612575), SC_(0.3776923744047793622088152487925424046936010452307012286644065629232030935629673512651414067339507712), SC_(102152612289908001840301539561549913962565860368142011907578377318717899.2493191442800302805872162491), SC_(0.6223076255952206377911847512074575953063989547692987713355934370767969064370326487348585932660492288) }}, 
      {{ SC_(54.914707183837890625), SC_(109.82941436767578125), SC_(409887797602967570461851681889828802007684874925098320507959771.5715434779624004447688690016653063067), SC_(0.2497012032965474725110186547475795550820769743457111426043609148765376435274603693329847732145409736e-8), SC_(164151310113105961466827496510835714553274618983995009905750394715739267.5937671786851598977221933732), SC_(0.9999999975029879670345252748898134525242044491792302565428885739563908512346235647253963066701522679) }}, 
      {{ SC_(54.914707183837890625), SC_(5491.470703125), SC_(0.5165113766416084345161388194893437492127905673992045258572355165738821959725822506156487309956784915e-2183), SC_(0.3146556521516514313547899769529902715440568138637626889248921733720231539084951313300316259223236421e-2254), SC_(164151310522993759069795066972687396443103420991679884830848715223699039.1653106566475603424910623748), SC_(1) }}, 
      {{ SC_(54.94844818115234375), SC_(0.5494844913482666015625), SC_(187851168756962008518943585197155939239197451550074484378447714368658665.2380183083961816911607133335), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999999999999999999999997097092642134), SC_(0.5453145399682577866129223201000569205154674653231300863472075774659456902236400591754309838804134088e-16), SC_(0.2902907357865707827052086134526239861006169237323449091651043766816683560186739143948897058595964204e-87) }}, 
      {{ SC_(54.94844818115234375), SC_(27.474224090576171875), SC_(187850688204754556675259030571735333383262932952997517257249277514417744.3674666108961266782574975188), SC_(0.9999974418460601990063741194487108136798967754558587780131350787376230409100342878319683058714681691), SC_(480552207451843684554625420605855934518597076967121198436854240920.870551697500055067434669811554025), SC_(0.2558153939800993625880551289186320103224544141221986864921262376959089965712168031694128531830910458e-5) }}, 
      {{ SC_(54.94844818115234375), SC_(52.94844818115234375), SC_(110867332077426050430170113462157612347487429352825641994332385851947222.233911692886205435906040664), SC_(0.5901870763490640405017843227129827156929426843403059593921350219170041223755765166141042849834084803), SC_(76983836679535958088773471734998326891710022197248842384115328516711443.00410661550997630978612666635), SC_(0.4098129236509359594982156772870172843070573156596940406078649780829958776244234833858957150165915197) }}, 
      {{ SC_(54.94844818115234375), SC_(54.94844818115234375), SC_(90555295593671555882056125352107820301243760681827977424997667068714409.28854900998522407279115121804), SC_(0.4820587286887213413001143913452364408800882507714759540697120562191766618525011812570522720775708377), SC_(97295873163290452636887459845048118937953690868246506953450047299944255.94946929841095767290101611228), SC_(0.5179412713112786586998856086547635591199117492285240459302879437808233381474988187429477279224291623) }}, 
      {{ SC_(54.94844818115234375), SC_(56.94844818115234375), SC_(70956641203163086936978696616478734493599092913380748575928433966808218.65193597391433636996316283525), SC_(0.3777279730155170598106878915865848184309466262864013694659475230887023301322530086576178253354594503), SC_(116894527553798921581964888580677204745598358636693735802519280401850446.5860823344818453757290044951), SC_(0.6222720269844829401893121084134151815690533737135986305340524769112976698677469913423821746645405497) }}, 
      {{ SC_(54.94844818115234375), SC_(109.8968963623046875), SC_(464102201043865833557216906582828066994755225561277803369375097.9754584615902564830459384037959935776), SC_(0.2470584580947227152441614199965658460018276150506352260350268803453851765854228808608987929910805107e-8), SC_(187851168292859807475077751639939032656369384555319258817169910999283567.2625598468059252626462289265), SC_(0.9999999975294154190527728475583858000343415399817238494936477396497311965461482341457711913910120701) }}, 
      {{ SC_(54.94844818115234375), SC_(5494.8447265625), SC_(0.2445298890493541408008467785454571259883344621206772579885985213851975119760419015604019740185833505e-2184), SC_(0.1301721414178273752294907378127263551002731231502211006847882185446847655446946323738171949854707235e-2255), SC_(187851168756962008518943585197155939239197451550074484378447714368658665.2380183083961817456921673303), SC_(1) }}, 
      {{ SC_(63.41974639892578125), SC_(0.6341974735260009765625), SC_(178781775582555322831393459001548236824080056881981997135875096380855128931018811384607.8263867610159), SC_(1), SC_(0.2419755692515371515173584094950612592700908218521955459597516726810661567670404063127525834621512633e-14), SC_(0.1353468878262712472782977862087874621871057321340893800289611779258406507229157512362295404649566625e-100) }}, 
      {{ SC_(63.41974639892578125), SC_(31.709873199462890625), SC_(178781692342142170785409780820515383634926532408086873914117894912676684365389019767752.7790978582308), SC_(0.9999995344021342174868290258262038710262198353109634411194483106961237383691635096796115414028455356), SC_(83240413152045983678181032853189153524473895123221757201468178444565629791616855.04728890278507809948), SC_(0.4655978657825131709741737961289737801646890365588805516893038762616308364903203884585971544643507025e-6) }}, 
      {{ SC_(63.41974639892578125), SC_(61.41974639892578125), SC_(104388333133949398433671787908270687938056375083765771453773799137973989914779780509815.5199712670318), SC_(0.5838868799339473422094395385799267211052253663811901143993747449946945861354588975918358898317080505), SC_(74393442448605924397721671093277548886023681798216225682101297242881139016239030874792.30641549398414), SC_(0.4161131200660526577905604614200732788947746336188098856006252550053054138645411024081641101682919495) }}, 
      {{ SC_(63.41974639892578125), SC_(63.41974639892578125), SC_(86405254208785822498227842199061501037983747988368704154857210974591637094015848346466.45268598991196), SC_(0.4833001234451149344512694365288854307321929521337507679336835174464874355761806559738848052848309181), SC_(92376521373769500333165616802486735786096308893613292981017885406263491837002963038141.37370077110394), SC_(0.5166998765548850655487305634711145692678070478662492320663164825535125644238193440261151947151690819) }}, 
      {{ SC_(63.41974639892578125), SC_(65.41974639892578125), SC_(68971970365143646446038678095639125733682362723815819661774560317848098111087911901313.26750485990136), SC_(0.3857885969663319753685565262495054110135097416380730697356245827738402699182051967042563691350925875), SC_(109809805217411676385354780905909111090397694158166177474100536063007030819930899483294.5588819011145), SC_(0.6142114030336680246314434737504945889864902583619269302643754172261597300817948032957436308649074125) }}, 
      {{ SC_(63.41974639892578125), SC_(126.8394927978515625), SC_(30691980971237319028432377167557319780941716621634262788261966299504612911976.01558503915900095553956), SC_(0.1716728725354045363246736295952678021288539135443891582221118897564061608073873578322466586191962822e-9), SC_(178781775551863341860156139973115859656522737101040280514240833592593162631514198472631.8108017218569), SC_(0.9999999998283271274645954636753263704047321978711460864556108417778881102435938391926126421677533414) }}, 
      {{ SC_(63.41974639892578125), SC_(6341.974609375), SC_(0.1131375337335908502067153840311730674421577259558430438955710189241642025307830133905323542841378212e-2516), SC_(0.632824757249084362495991804315761507899299220479402442817501455851991753739628539547072013471685414e-2603), SC_(178781775582555322831393459001548236824080056881981997135875096380855128931018811384607.8263867610159), SC_(1) }}, 
      {{ SC_(64.15645599365234375), SC_(0.641564548015594482421875), SC_(3796435425063500659242313572638614372926115135269320819795223684466906909303368976530175.122451407014), SC_(1), SC_(0.3561664430749769036027482269146899004189751759660599438999688134522266198395501963955535988740201181e-14), SC_(0.9381601507656870649864913343266641376431807844052367907407753504569837108658752233482747677717175015e-102) }}, 
      {{ SC_(64.15645599365234375), SC_(32.078227996826171875), SC_(3796433900242956980688155158722538505241057205030970671838901774015999554644043025490295.635505813503), SC_(0.9999995983546740682282471759269639979078560500343554366709084460883989623621626228190293213646921447), SC_(1524820543678554158413916075867685057930238350147956321910450907354659325951039879.486945593510789982), SC_(0.4016453259317717528240730360020921439499656445633290915539116010376378373771809706786353078553392674e-6) }}, 
      {{ SC_(64.15645599365234375), SC_(62.15645599365234375), SC_(2214837906124932528128325425520561459324051607422165451016896221684228033014617351940846.565743533083), SC_(0.5833993359936805156355843233031200457341264817230711049983675821663794766359727700788132399993569834), SC_(1581597518938568131113988147118052913602063527847155368778327462782678876288751624589328.55670787393), SC_(0.4166006640063194843644156766968799542658735182769288950016324178336205233640272299211867600006430166) }}, 
      {{ SC_(64.15645599365234375), SC_(64.15645599365234375), SC_(1835182831180570409914708629671457763648714041584640291801144804519041877323209225292723.814233700998), SC_(0.4833962982920681250090980397015585499087385229065810522163504847965098050218325264821795143425437337), SC_(1961252593882930249327604942967156609277401093684680527994078879947865031980159751237451.308217706016), SC_(0.5166037017079318749909019602984414500912614770934189477836495152034901949781674735178204856574562663) }}, 
      {{ SC_(64.15645599365234375), SC_(66.15645599365234375), SC_(1467005652324336015906818546758285433114296416846523551637245253829911651877029717627645.184366720173), SC_(0.3864165955884257684548349803381523125565843035816766982692567090746627380615657140747703389524461245), SC_(2329429772739164643335495025880328939811818718422797268157978430636995257426339258902529.938084686841), SC_(0.6135834044115742315451650196618476874434156964183233017307432909253372619384342859252296610475538755) }}, 
      {{ SC_(64.15645599365234375), SC_(128.3129119873046875), SC_(517058479756301509601783283211190974417854638395221192100589177873826660470571.1434643133022531163644), SC_(0.1361957788990057661406623390290227662213212373635212449111954036803864924518024633802358205729655158e-9), SC_(3796435424546442179486012063036831089714924160851466181400002492366317731429542316059603.978987093712), SC_(0.9999999998638042211009942338593376609709772337786787626364787550888045963196135075481975366197641794) }}, 
      {{ SC_(64.15645599365234375), SC_(6415.6455078125), SC_(0.1501972817374904189947192006751610811566378120199453667459490453040374982588451571443047819412729202e-2545), SC_(0.3956271210249234272035512872107835510491067746256581794926752836254227375420570012656191632901861478e-2633), SC_(3796435425063500659242313572638614372926115135269320819795223684466906909303368976530175.122451407014), SC_(1) }}, 
      {{ SC_(64.80814361572265625), SC_(0.64808142185211181640625), SC_(57064303530430383996729458229257130231801588273800388697126125108151088365381775714781145.95985879319), SC_(1), SC_(0.5049774538054909199584092677118062653666933701505046003708884127507004677678223741124772310809781312e-14), SC_(0.8849270429388562022862722730475310480595182237631208674201045321741549884233443793981741970390437303e-103) }}, 
      {{ SC_(64.80814361572265625), SC_(32.404071807861328125), SC_(57064283417933883221970238789084305216792101206464811754288528323627940734515192893465592.08684760924), SC_(0.9999996475467979724054120652922043059124000828270789331017697272074390052504823272149944165329867989), SC_(20112496500774759219440172825015009487067335576942837596784523147630866582821315553.87301118395144131), SC_(0.3524532020275945879347077956940875999171729210668982302727925609947495176727850055834670132010959105e-6) }}, 
      {{ SC_(64.80814361572265625), SC_(62.80814361572265625), SC_(33267066351092621357557801726432026358661364649112280492241559461668010708553935629603600.64360322167), SC_(0.5829750701040706842898845713314486965142088106269133431003371650265263525010185764209656929781262825), SC_(23797237179337762639171656502825103873140223624688108204884565646483077656827840085177545.31625557152), SC_(0.4170249298959293157101154286685513034857911893730866568996628349734736474989814235790343070218737175) }}, 
      {{ SC_(64.80814361572265625), SC_(64.80814361572265625), SC_(27589449645371862123113533511696817712950177448901812103904222740979949068100159476483178.64080817411), SC_(0.4834800030575923874253729319974034966635835312330768614990931555871329733879043648167080009582767187), SC_(29474853885058521873615924717560312518851410824898576593221902367171139297281616238297967.31905061908), SC_(0.5165199969424076125746270680025965033364164687669231385009068444128670266120956351832919990417232813) }}, 
      {{ SC_(64.80814361572265625), SC_(66.80814361572265625), SC_(22081806621146139055171477960369436441741722947552119646792081319310182857054289976264452.51802025126), SC_(0.3869635701305052995758522155643032051724326397433195289354322121529371737951138727752313566162150975), SC_(34982496909284244941557980268887693790059865326248269050334043788840905508327485738516693.44183854193), SC_(0.6130364298694947004241477844356967948275673602566804710645677878470628262048861272247686433837849025) }}, 
      {{ SC_(64.80814361572265625), SC_(129.6162872314453125), SC_(6333069303558022755471401584057186796783754151767482065777881718486350969284051.207123983670851908655), SC_(0.1109812774667585290988500580232166290175194254736216733559281573355525708028349000552975379833083416e-9), SC_(57064303524097314693171435473785728647744401477016634545358643042373206646895424745497094.75273480952), SC_(0.999999999889018722533241470901149941976783370982480574526378326644071842664447429197165099944702462) }}, 
      {{ SC_(64.80814361572265625), SC_(6480.814453125), SC_(0.4318663435349180480771605832754060841663126038498941314495328213246217229719803389910472016804776487e-2571), SC_(0.7568064741289954268654103373011425276871650316179022296676779264925390727199244910390007532872691374e-2660), SC_(57064303530430383996729458229257130231801588273800388697126125108151088365381775714781145.95985879319), SC_(1) }}, 
      {{ SC_(65.7200469970703125), SC_(0.65720045566558837890625), SC_(2559334550193453458047928045143681115995090699028390076702073278152157048485934530589741019.993329575), SC_(1), SC_(0.8322935909245563296496052903098445485056609705917670879371842756568484537065699035714913548976504698e-14), SC_(0.3251992166720233650696134882963952235228517897458966941875070780887225768671085910687092858643365674e-104) }}, 
      {{ SC_(65.7200469970703125), SC_(32.86002349853515625), SC_(2559333798806136046903336846253865446432868075946183012282547839132061159157676016077590697.883689677), SC_(0.9999997064130137443933723045808171802671092117497975520038458170100784225411626966942287198503258944), SC_(751387317411144591198889815669562222623082207064419525439020095889328258514512150322.1096398981007926), SC_(0.2935869862556066276954191828197328907882502024479961541829899215774588373033057712801496741056349697e-6) }}, 
      {{ SC_(65.7200469970703125), SC_(63.7200469970703125), SC_(1490536274964613671595815806108988693018968387950980022211614580566253330891740694197166613.670925398), SC_(0.5823921201907534526914623237640265941667710613191372790718040782800847758518161432917761081775805404), SC_(1068798275228839786452112239034692422976122311077410054490458697585903717594193836392574406.322404177), SC_(0.4176078798092465473085376762359734058332289386808627209281959217199152241481838567082238918224194596) }}, 
      {{ SC_(65.7200469970703125), SC_(65.7200469970703125), SC_(1237681478333021299436036260772704189939039726424468025791236592392221839972793647760404305.069112678), SC_(0.4835950338104364542144764339636365461226890386503558396710241559827473710343276447133329329080310481), SC_(1321653071860432158611891784370976926056050972603922050910836685759935208513140882829336714.924216897), SC_(0.5164049661895635457855235660363634538773109613496441603289758440172526289656723552866670670919689519) }}, 
      {{ SC_(65.7200469970703125), SC_(67.7200469970703125), SC_(992294582857096673020436107615735633555491858668260413925488485824429265079937609704722392.1639511719), SC_(0.3877158548037776851676686582318276647538773116889477970463296988557626867776214215469071342508886513), SC_(1567039967336356785027491937527945482439598840360129662776584792327727783405996920885018627.829378403), SC_(0.6122841451962223148323313417681723352461226883110522029536703011442373132223785784530928657491113487) }}, 
      {{ SC_(65.7200469970703125), SC_(131.440093994140625), SC_(213300886950808367827748848163362418229652992448625125251021922855379214016709603.3541253196642483556), SC_(0.8334232307952295928887744983382544562611331340725414464157591127627065655955495457938285035431948473e-10), SC_(2559334549980152571097119677315932267831728280798737084253448152901135125630555316573031416.639204255), SC_(0.9999999999166576769204770407111225501661745543738866865927458553584240887237293434404450454206171496) }}, 
      {{ SC_(65.7200469970703125), SC_(6572.0048828125), SC_(0.7951110665801895186597449581938208498866077147902395876490462398033742287094703422089437391907177183e-2607), SC_(0.3106710166203512300411342022708193644206022181944519266725115058420432680872285730281665183332651508e-2697), SC_(2559334550193453458047928045143681115995090699028390076702073278152157048485934530589741019.993329575), SC_(1) }}, 
      {{ SC_(65.7462005615234375), SC_(0.65746200084686279296875), SC_(2854841366740655335749682711589405018617970255237657756653413289530476724094493897679244812.123014988), SC_(1), SC_(0.8444683280417830620909648362271240036135499334739793886760751528289379268614864246438558387232915288e-14), SC_(0.2958021898799597230685257872041095903545541336863801310149315080230457436391504684629229689145194224e-104) }}, 
      {{ SC_(65.7462005615234375), SC_(32.87310028076171875), SC_(2854840532976636690616123908905006010146740361518023308401225712007615174805725753744721184.244032938), SC_(0.9999997079473387353098914999058508099490747926743722046001226817425283756021315976509474394410258526), SC_(833764018645133558802684399008471229893719634448252187577522861549288768143934523627.8789820501151716), SC_(0.2920526612646901085000941491900509252073256277953998773182574716243978684023490525605589741474447032e-6) }}, 
      {{ SC_(65.7462005615234375), SC_(63.7462005615234375), SC_(1662589901978145349245492139292009919605672053551106941400828015313014944751529712675425485.872785929), SC_(0.5823755818265685614824870041971820963274359402029669131075613669423048624582759616275806290001338387), SC_(1192251464762509986504190572297395099012298201686550815252585274217461779342964185003819326.250229059), SC_(0.4176244181734314385175129958028179036725640597970330868924386330576951375417240383724193709998661613) }}, 
      {{ SC_(65.7462005615234375), SC_(65.7462005615234375), SC_(1380596424766725998343913761207864541236223769538290252632704764663009433071898936669504936.275679433), SC_(0.48359829756248051328495419810768024737755427516852003106702603082970574141263350210054939794092891), SC_(1474244941973929337405768950381540477381746485699367504020708524867467291022594961009739875.847335555), SC_(0.51640170243751948671504580189231975262244572483147996893297396917029425858736649789945060205907109) }}, 
      {{ SC_(65.7462005615234375), SC_(67.7462005615234375), SC_(1106928225149486035563430894908913383860784606738093747601687120295559440096387770602132440.181557678), SC_(0.3877372095155168780986027898437480552411677046160511382233187452365216829722816711350588651876171045), SC_(1747913141591169300186251816680491634757185648499564009051726169234917283998106127077112371.94145731), SC_(0.6122627904844831219013972101562519447588322953839488617766812547634783170277183288649411348123828955) }}, 
      {{ SC_(65.7462005615234375), SC_(131.492401123046875), SC_(235983031974996182434520718201718793478492986693507612270715274155248385596291556.0579580332088916059), SC_(0.826606461305469026265380207366545613849300878252028521478725068264649395360224228367418868733952718e-10), SC_(2854841366504672303774686529154884300416251461759164769959905677259761449939245512082953256.065056955), SC_(0.9999999999173393538694530973734619792633454386150699121747971478521274931735350604639775771632581131) }}, 
      {{ SC_(65.7462005615234375), SC_(6574.6201171875), SC_(0.7510687037399288751476618913126776904743706200734739131003765240622129428802251747674214841599943012e-2608), SC_(0.2630859677493803168372664020799002982996521138244652974298929967574770207819491498870966084808631374e-2698), SC_(2854841366740655335749682711589405018617970255237657756653413289530476724094493897679244812.123014988), SC_(1) }}, 
      {{ SC_(66.52874755859375), SC_(0.665287494659423828125), SC_(75437968758597569032633239079728043522874921500813687815049070751153925767719006676562144012.72458575), SC_(1), SC_(0.1310368926314709029218884864097245957203599769879394761921733122276034347692035013026957603074361871e-13), SC_(0.1737015123654648979205709059138716747491083896634223517139402900134914281996402426153610692408187843e-105) }}, 
      {{ SC_(66.52874755859375), SC_(33.264373779296875), SC_(75437949923163470610979559576525326783503782178493187353264273107179384659359278225112563291.9985126), SC_(0.9999997503189122350937731034617362792130824866556325999968830331547033567314799538196326683448374112), SC_(18835434098421653679503202716739371139322320500461784797643974541108359728451449580720.72607315341318), SC_(0.2496810877649062268965382637207869175133443674000031169668452966432685200461803673316551625887891426e-6) }}, 
      {{ SC_(66.52874755859375), SC_(64.52874755859375), SC_(43896244662554532338939348278022579463862400482165305546298097450254130252574215857898937405.32542262), SC_(0.5818852944334047084343589707551617331697413232753603391941630268768653072704879308927342810156120602), SC_(31541724096043036693693890801705464059012521018648382268750973300899795515144790818663206607.39916313), SC_(0.4181147055665952915656410292448382668302586767246396608058369731231346927295120691072657189843879398) }}, 
      {{ SC_(66.52874755859375), SC_(66.52874755859375), SC_(36488972888760509458901859774999522712882718994892665424066553669141913884185547148492076748.54893598), SC_(0.483695060845628982852720695561734966908199416779190979417625654226006698823212593179618976761835803), SC_(38948995869837059573731379304728520809992202505921022390982517082012011883533459528070067264.17564977), SC_(0.516304939154371017147279304438265033091800583220809020582374345773993301176787406820381023238164197) }}, 
      {{ SC_(66.52874755859375), SC_(68.52874755859375), SC_(29297888206347729296575966698323378323995282817463584378420497014448561006840018344131861862.44449552), SC_(0.3883705869666418658029677176690535808167289848451664644497395275043892882135779613460692453856760943), SC_(46140080552249839736057272381404665198879638683350103436628573736705364760878988332430282150.28009023), SC_(0.6116294130333581341970322823309464191832710151548335355502604724956107117864220386539307546143239057) }}, 
      {{ SC_(66.52874755859375), SC_(133.0574951171875), SC_(4877301420907752239273593820252772630997062336767277593443758326800991314131573868.232500449651190878), SC_(0.6465313821631620244656225618790585833495030126689809466090929707207843703391670990519534543499386092e-10), SC_(75437968753720267611725486840454449702622148869816625478281793157710167440918015362430570144.4920853), SC_(0.9999999999353468617836837975534377438120941416650496987331019053390907029279215629660832900948046546) }}, 
      {{ SC_(66.52874755859375), SC_(6652.875), SC_(0.1638371658676746711435298600027710247423818222982576588244433879024066268894343211493208998026040069e-2638), SC_(0.217181306129749627468661278592701590511686711110420093152134477432446731511023484744947255548436328e-2730), SC_(75437968758597569032633239079728043522874921500813687815049070751153925767719006676562144012.72458575), SC_(1) }}, 
      {{ SC_(68.034149169921875), SC_(0.6803414821624755859375), SC_(42113572483395761632651216760005728893592371847570855411971790947780728317856873505745209325832.18254), SC_(1), SC_(0.3132027947637063691661054357702716767202744008691014359264488944161261735519264427068623189384454917e-13), SC_(0.7437098690385236934785320724586100821607952736613959554958586439217113946281792159173787414727436084e-108) }}, 
      {{ SC_(68.034149169921875), SC_(34.0170745849609375), SC_(42113564704370016804616237592666406552406081985367936303009583358852186297359128077005267412785.08743), SC_(0.999999815284591496124114094383728334702982090857677274733886977058085052527979049157010887221663125), SC_(7779025744828034979167339322341186289862202919108962207588928542020497745428739941913047.095112193951), SC_(0.1847154085038758859056162716652970179091423227252661130229419149474720209508429891127783368749648998e-6) }}, 
      {{ SC_(68.034149169921875), SC_(66.034149169921875), SC_(24466563398752767202962055659309985267780106831640515180579794569276035095262688757081815421583.72315), SC_(0.5809662290796932260729255469353907152386036348452413899316923152735713121163657492892399027342077726), SC_(17647009084642994429689161100695743625812265015930340231391996378504693222594184748663393904248.45939), SC_(0.4190337709203067739270744530646092847613963651547586100683076847264286878836342507107600972657922274) }}, 
      {{ SC_(68.034149169921875), SC_(68.034149169921875), SC_(20377767576628504384241918380752641270626046464542414376923113662405512803808630762772573269062.81299), SC_(0.4838764886228283041456787146224839048785139798476573113651537980736581818384909560116974320885528351), SC_(21735804906767257248409298379253087622966325383028441035048677285375215514048242742972636056769.36954), SC_(0.5161235113771716958543212853775160951214860201523426886348462019263418181615090439883025679114471649) }}, 
      {{ SC_(68.034149169921875), SC_(70.034149169921875), SC_(16405741205065579848123850793709504105265276933409017996546748518272893268349260912963065782118.80864), SC_(0.3895594754288280396160516404291818270846124267683497095379825143486668985367433005556645469275644442), SC_(25707831278330181784527365966296224788327094914161837415425042429507835049507612592782143543713.3739), SC_(0.6104405245711719603839483595708181729153875732316502904620174856513331014632566994443354530724355558) }}, 
      {{ SC_(68.034149169921875), SC_(136.06829833984375), SC_(1697492820470778208009116220203957973208892689614393897159237063357334542343247564446.919025546396516), SC_(0.4030749994292347306924187071308939266876541080859990416483819140359357754059960488108142453377687677e-10), SC_(42113572481698268812180438551996612673388413874361962722357397050621491254499538963401961761385.26351), SC_(0.9999999999596925000570765269307581292869106073312345891914000958351618085964064224594003951189185755) }}, 
      {{ SC_(68.034149169921875), SC_(6803.4150390625), SC_(0.1746953208446148276684736178380634134756844512783961321515133641246683020658829024318666438297263536e-2697), SC_(0.4148195238328271727599871446993282605215932118915975221473394510687974990073548259877394985167337917e-2792), SC_(42113572483395761632651216760005728893592371847570855411971790947780728317856873505745209325832.18254), SC_(1) }}, 
      {{ SC_(68.2952728271484375), SC_(0.682952702045440673828125), SC_(126582574863438761228830593517522512508520236863029486015592624641165055813258028344773940209822.9421), SC_(1), SC_(0.3655698648380115662039687784607219011874234526434719246838163436733038283726974770745217066866947991e-13), SC_(0.2887995170207271926745273357827530241176788764649377300769413606632940800358016853546556809927628601e-108) }}, 
      {{ SC_(68.2952728271484375), SC_(34.14763641357421875), SC_(126582552672056417014808434553408814215248582817355988576374246752225659958679332711128204972304.6614), SC_(0.9999998246884899587895163213726572077349758539193495711816791314587048056482776703264498369545112542), SC_(22191382344214022158964113698293271654045673497439218377888939395854578695633645735237518.28067211215), SC_(0.1753115100412104836786273427922650241460806504288183208685412951943517223296735501630454887458449184e-6) }}, 
      {{ SC_(68.2952728271484375), SC_(66.2952728271484375), SC_(73520417391286104958055858026354647726294780431395263338089827702393209724399772840605246068573.41765), SC_(0.5808099374704790885288115332398236483278087093602159869520640494319793408584923594887640144873276232), SC_(53062157472152656270774735491167864782225456431634222677502796938771846088858255504168694141249.52443), SC_(0.4191900625295209114711884667601763516721912906397840130479359505680206591415076405112359855126723768) }}, 
      {{ SC_(68.2952728271484375), SC_(68.2952728271484375), SC_(61254237923856606700583230094316089399605722409239888849797195313073413074409245979174715830580.16501), SC_(0.4839073465675634533293329446769704752866300015878567809582937916543251686874530007008349671687899722), SC_(65328336939582154528247363423206423108914514453789597165795429328091642738848782365599224379242.77706), SC_(0.5160926534324365466706670553230295247133699984121432190417062083456748313125469992991650328312100278) }}, 
      {{ SC_(68.2952728271484375), SC_(70.2952728271484375), SC_(49337059529436736386578004138448953944339164723869614220313229619977576800535898424376469349181.44023), SC_(0.3897618576858868489435844374254280620853484725076235359025117780872035360460872236175286896098847471), SC_(77245515334002024842252589379073558564181072139159871795279395021187479012722129920397470860641.50185), SC_(0.6102381423141131510564155625745719379146515274923764640974882219127964639539127763824713103901152529) }}, 
      {{ SC_(68.2952728271484375), SC_(136.590545654296875), SC_(4700839111975588779188788696595833993422380714269912159673765499326484306510334737824.987810006664451), SC_(0.3713654203232159689278107243661297519810768725158405273618860447800230335190819159155517036811121922e-10), SC_(126582574858737922116855004738333723811924402869607105301322712481491290313931544038263605471997.9543), SC_(0.9999999999628634579676784031072189275633870248018923127484159472638113955219976966480918084084448296) }}, 
      {{ SC_(68.2952728271484375), SC_(6829.52734375), SC_(0.1034249536633599236785196035670678143805729443379432919455871398762615137761349996017938427713708189e-2707), SC_(0.8170552208701552862627374775177297737987641024647251179109401241013655399690321523514850019023597052e-2803), SC_(126582574863438761228830593517522512508520236863029486015592624641165055813258028344773940209822.9421), SC_(1) }}, 
      {{ SC_(69.6354522705078125), SC_(0.69635450839996337890625), SC_(36494733153103885068623195531403959468503907221966838069538523362315536099588670820401092282155839.98), SC_(1), SC_(0.821243650844431145822325914791510770588118888617299276531744580250254622626479394950264619782026395e-13), SC_(0.2250307318042642525746116460953930750388991052682855034004208019619828819236863988316701887577187591e-110) }}, 
      {{ SC_(69.6354522705078125), SC_(34.81772613525390625), SC_(36494728259617465153947838641094697313286364882611761987084257163440369157700054156490229953794827.34), SC_(0.9999998659125304633585665139721585810438771847327945631914586140873705434034562012506596143901484594), SC_(4893486419914675356890309262155217542339355076082454266198875166941888616663910862328361012.641363817), SC_(0.1340874695366414334860278414189561228152672054368085413859126294565965437987493403856098515406345331e-6) }}, 
      {{ SC_(69.6354522705078125), SC_(67.6354522705078125), SC_(21167740658497744035526008679318634598857228387431688493381770681347909285798263148871530263916424.97), SC_(0.5800217957395154441416737330896236258949146586865873335628129767424267798404189306705666388937009606), SC_(15326992494606141033097186852085324869646678834535149576156752680967626813790407671529562018239415.0), SC_(0.4199782042604845558583262669103763741050853413134126664371870232575732201595810693294333611062990394) }}, 
      {{ SC_(69.6354522705078125), SC_(69.6354522705078125), SC_(17665749248223416126653214753745146113923558769155426709622241005034603430531169652272575484240192.01), SC_(0.4840629790088200788456641937463001024839567125091214004413535009897810525448659287785015239623470264), SC_(18828983904880468941969980777658813354580348452811411359916282357280932669057501168128516797915647.97), SC_(0.5159370209911799211543358062536998975160432874908785995586464990102189474551340712214984760376529736) }}, 
      {{ SC_(69.6354522705078125), SC_(71.6354522705078125), SC_(14261533358525259240019711453763431388235546135384237578066571326238071511513322146246527620781458.43), SC_(0.3907833302601450230403561763286567234144781366045252737464741874179789745604100618957056892866496123), SC_(22233199794578625828603484077640528080268361086582600491471952036077464588075348674154564661374381.55), SC_(0.6092166697398549769596438236713432765855218633954747262535258125820210254395899381042943107133503877) }}, 
      {{ SC_(69.6354522705078125), SC_(139.270904541015625), SC_(890110899883298394368329713318148943829898387890662786538805253065883137862339993406627.6236715523172), SC_(0.2439011942213897971389923513193673705626597220135575610661785792643343855062508439067085023878478691e-10), SC_(36494733152213774168739897137035629755185758278136939681647860575776730846522787682538752288749212.35), SC_(0.9999999999756098805778610202861007648680632629437340277986442438933821420735665614493749156093291498) }}, 
      {{ SC_(69.6354522705078125), SC_(6963.54541015625), SC_(0.3383439389850162636134893032919890119060566002639058280359651072479638937963544182265002792730187551e-2760), SC_(0.9271034742618471161644565690139349365375186229622000779791484371703301348184139789335859207544453186e-2858), SC_(36494733153103885068623195531403959468503907221966838069538523362315536099588670820401092282155839.98), SC_(1) }}, 
      {{ SC_(70.7515869140625), SC_(0.707515895366668701171875), SC_(4163706035657014946019693907658547214916131410196136934921674637717229901325504561441313925622006123.0), SC_(1), SC_(0.1643972071042669722751281362510097721140723220071512581577423934010542168600930704594677005280381427e-12), SC_(0.3948338468095666086577953776027938478067170815924995171522064565083834914000504304114332262445179597e-112) }}, 
      {{ SC_(70.7515869140625), SC_(35.37579345703125), SC_(4163705589009756561554773694553940051853542079567081889878393834074793598574674923651264184190726964.0), SC_(0.9999998927284360232251844365723191151868508591919963391490480965143823590586647732622993067718293719), SC_(446647258384464920213104607163062589330629055045043280803642436302750829637790049741431279158.8964373), SC_(0.1072715639767748155634276808848131491408080036608509519034856176409413352267377006932281706280659512e-6) }}, 
      {{ SC_(70.7515869140625), SC_(68.7515869140625), SC_(2412379330002282047150316667300907136731608411820393886825314542906898242708660799711518553964147945.0), SC_(0.5793827204282011567042433334649813466858508509555800163506066185809776625939796223058480971579009996), SC_(1751326705654732898869377240357640078184522998375743048096360094810331658616843761729795371657858178.0), SC_(0.4206172795717988432957566665350186533141491490444199836493933814190223374060203776941519028420990004) }}, 
      {{ SC_(70.7515869140625), SC_(70.7515869140625), SC_(2016021510264593487997898102849132934082138733466350547072955795822992713628940188390279357107596497.0), SC_(0.484189203800617001147036344895303364629138501352656417207046106554740609314246090553869742251358091), SC_(2147684525392421458021795804809414280833992676729786387848718841894237187696564373051034568514409626.0), SC_(0.515810796199382998852963655104696635370861498647343582792953893445259390685753909446130257748641909) }}, 
      {{ SC_(70.7515869140625), SC_(72.7515869140625), SC_(1630560205779657737217888653375236420445551678696181688312344962515117513202870943145572271783397219.0), SC_(0.3916127103632959365388824210526464348615132466702460006275409122583637854358837080642212860005116432), SC_(2533145829877357208801805254283310794470579731499955246609329675202112388122633618295741653838608904.0), SC_(0.6083872896367040634611175789473535651384867533297539993724590877416362145641162919357787139994883568) }}, 
      {{ SC_(70.7515869140625), SC_(141.503173828125), SC_(71562535024855657188714540730942575403180184109238246910612029302370777772950438096110075.79121787223), SC_(0.1718722081050167035523539932377543742301113624703285766427441100752476657998764223251664592709290472e-10), SC_(4163706035585452410994838250469832674185188834792956750812436390806617872023133783668363487525896047.0), SC_(0.9999999999828127791894983296447646006762245625769888637529671423357255889924752334200123577674833541) }}, 
      {{ SC_(70.7515869140625), SC_(7075.15869140625), SC_(0.6716330277559341551972805983796192839817120592488331206926838690001874330556606168317269085566468756e-2804), SC_(0.1613065432583915222021059592420276667456025460907487840550408152306477160101129674319984601665394559e-2903), SC_(4163706035657014946019693907658547214916131410196136934921674637717229901325504561441313925622006123.0), SC_(1) }}, 
      {{ SC_(71.0818023681640625), SC_(0.7108180522918701171875), SC_(16967278276545062709413440359643354994456672559374489119855948031522443212720033114985470324312152990.0), SC_(1), SC_(0.2025647769109128315720793176152749380665523689423777423500246900427885686000238065897867498249115696e-12), SC_(0.1193855452886223239391264936785591200069288992993158253990970233471105465596535460023259124969189518e-112) }}, 
      {{ SC_(71.0818023681640625), SC_(35.54090118408203125), SC_(16967276572674003242408646285164667106576416153691486957360779217241205920301041179619357678262895310.0), SC_(0.9999998995789995486563650978302014019583343710567724543227928084695597460102966041515413997494867488), SC_(1703871059467004794074478687887880256405683002162495168814281237292418991935366112646049257678.235089), SC_(0.1004210004513436349021697985980416656289432275456772071915304402539897033958484586002505132512101627e-6) }}, 
      {{ SC_(71.0818023681640625), SC_(69.0818023681640625), SC_(9827389239227920296325677028712660539003279904144822000711105472064663276694749906840507394452588047.0), SC_(0.5791965617027062808291416894940335135941340645706906873018268267572126623399061768034329544463859378), SC_(7139889037317142413087763330930694455453392655229667119144842559457779936025283208144962929859564941.0), SC_(0.4208034382972937191708583105059664864058659354293093126981731732427873376600938231965670455536140622) }}, 
      {{ SC_(71.0818023681640625), SC_(71.0818023681640625), SC_(8215996900810625079496423772075431509048698083968916786640901232363021424433429892415143956427712421.0), SC_(0.4842259770188430872231521626055949922037302117054070521992337232159858497414284902998174593370823492), SC_(8751281375734437629917016587567923485407974475405572333215046799159421788286603222570326367884440568.0), SC_(0.5157740229811569127768478373944050077962697882945929478007662767840141502585715097001825406629176508) }}, 
      {{ SC_(71.0818023681640625), SC_(73.0818023681640625), SC_(6648704157522568520370762150953374547591311142336083857419182771136113379807064306023401472771637325.0), SC_(0.3918544889261049596367732974173298303572524058400409016773874665848631222839607280171312383703265499), SC_(10318574119022494189042678208689980446865361417038405262436765260386329832912968808962068851540515660.0), SC_(0.6081455110738950403632267025826701696427475941599590983226125334151368777160392719828687616296734501) }}, 
      {{ SC_(71.0818023681640625), SC_(142.163604736328125), SC_(262938756412896747213215188236001278847027364148037991932490962311991769259393830423375670.6579439202), SC_(0.1549681405157205142304516134193099810298042076407386925208034967910736349876033253562627025264122849e-10), SC_(16967278276282123953000543612430139806220671280527461755707910039589952250408041345726076493888777320.0), SC_(0.9999999999845031859484279485769548386580690018970195792359261307479196503208926365012396674643737297) }}, 
      {{ SC_(71.0818023681640625), SC_(7108.18017578125), SC_(0.7925901291711046454157466839165010077638812371633385136111648656867383361931098810911787264074165645e-2817), SC_(0.4671286203083920035736680607903529542936082782436866512728934451500865020889719453563455381482969287e-2917), SC_(16967278276545062709413440359643354994456672559374489119855948031522443212720033114985470324312152990.0), SC_(1) }}, 
      {{ SC_(72.720977783203125), SC_(0.7272098064422607421875), SC_(0.1854183717840343100576419051698198779346986720643644351833194162311895304701678338550713762978721865e104), SC_(1), SC_(0.584227334103519972527148609116497936872689547631761312843570754575529797448093633348073310743075528e-12), SC_(0.3150860017172395570637279099661674301309625325776630587338972912378046558409641268507235499744703355e-115) }}, 
      {{ SC_(72.720977783203125), SC_(36.3604888916015625), SC_(0.1854183583634267585417812458929086469008447986888731708175244645835645567444997919617141595308541004e104), SC_(0.9999999276198608455720485460479007724476218200884096956888093506941665549335216767569688124396721302), SC_(1342060755151586065927691123103385387337549126436579495164762497372566804189335721676701808609503.974), SC_(0.7238013915442795145395209922755237817991159030431119064930583344506647832324303118756032786981336922e-7) }}, 
      {{ SC_(72.720977783203125), SC_(70.720977783203125), SC_(0.1072258646513762753202513258857398040376367179405148101676530938486460991350106124410892126373657136e104), SC_(0.5782914800711732805075523468911675312044564188629240860286635747183585394694729255143501788834860785), SC_(7819250713265803473739057928408007389706195412384962501566632238254343133515722141398216366050647292000.0), SC_(0.4217085199288267194924476531088324687955435811370759139713364252816414605305270744856498211165139215) }}, 
      {{ SC_(72.720977783203125), SC_(72.720977783203125), SC_(0.89817548208652697445514740436429484847253809493416746301212339020224664090337531620151070119462629e103), SC_(0.4844047941121363799771049435504117715732047854514661929196842791217046328821782930228076351074660436), SC_(9560082357538161261212716473339039308744486257094768888210707721096486637983030223492030617840955754000.0), SC_(0.5155952058878636200228950564495882284267952145485338070803157208782953671178217069771923648925339564) }}, 
      {{ SC_(72.720977783203125), SC_(74.720977783203125), SC_(0.728751999246301164139914975737438488834658224372888105946350974303149343820388663337310800573377606e103), SC_(0.3930311717412305000064382963430835285379561206226218572452185422151244269217642418915329451717589638), SC_(0.1125431718594041936436504075960760290512328496270756245886843188008745960881289675213402962405344259e104), SC_(0.6069688282587694999935617036569164714620438793773781427547814577848755730782357581084670548282410362) }}, 
      {{ SC_(72.720977783203125), SC_(145.44195556640625), SC_(171894195151014147810335571924903231526337264398363312550405701325074345754859999016607823867.3588057), SC_(0.9270612911606600621792798616374474920082545128135137446295159713701175142329359141418348731791894442e-11), SC_(0.1854183717823153681061317636917165222154496397491010625393357831056854734569170903975227763077061083e104), SC_(0.9999999999907293870883933993782072013836255250799174548718648625537048402862988248576706408585816513) }}, 
      {{ SC_(72.720977783203125), SC_(7272.09765625), SC_(0.5425373386231230371360332810616549632128743881359974347483988718192634901413455427944545828498974858e-2881), SC_(0.2926017165413588859726165272094472950221094413187804610368358221527567388065186674020469429327224539e-2984), SC_(0.1854183717840343100576419051698198779346986720643644351833194162311895304701678338550713762978721865e104), SC_(1) }}, 
      {{ SC_(74.19440460205078125), SC_(0.7419440746307373046875), SC_(0.103096944693667078372505855083101936639648483194730208225688678773220655466061737686371464201193946e107), SC_(1), SC_(0.1563071086810666370616205804560007921832366501717499061877351517006994574600267097321586924137548826e-11), SC_(0.1516117758343890980537123029152958931549760787574603647876625489677333670504448297561430544434467781e-117) }}, 
      {{ SC_(74.19440460205078125), SC_(37.097202301025390625), SC_(0.1030969391330217260555902135020489251872782601501416700539877610692849104277768012939001874637722046e107), SC_(0.9999999460639171331477039661403436371101873018009664508191851295711768302311264182793338651054770588), SC_(556064535231691564158105301145237022304458853817170091770393574503828493639247127673742174148037535.1), SC_(0.5393608286685229603385965636288981269819903354918081487042882316976887358172066613489452294120816897e-7) }}, 
      {{ SC_(74.19440460205078125), SC_(72.19440460205078125), SC_(0.5953888317413273564906748994122272094904898485200246513231062364344647698117146498367873359094067445e106), SC_(0.5775038566956681337337125376309514374898918147640043989945446770929668710680828681187910833003667777), SC_(0.435580615195343427234383651418792156905994983427277430933780551297741784848902727026927306102532716e106), SC_(0.4224961433043318662662874623690485625101081852359956010054553229070331289319171318812089166996332223) }}, 
      {{ SC_(74.19440460205078125), SC_(74.19440460205078125), SC_(0.4995670142490296920169498235046103473458813331604768794774339122187026649237876737023481854377831564e106), SC_(0.4845604452521826529478203093948694839652109856692728218739248103267778665671280660876261571060499391), SC_(0.5314024326876410917081087273264090190506034987868252027794528755135038897368297031613664565741563041e106), SC_(0.5154395547478173470521796906051305160347890143307271781260751896732221334328719339123738428939500609) }}, 
      {{ SC_(74.19440460205078125), SC_(76.19440460205078125), SC_(0.4062604567339247674107670067757848103809706066612943202208411212119734290663837170648982834545366623e106), SC_(0.3940567375115240168365844348765027246508546563091336676273478806021703935900046330928357446637200625), SC_(0.6247089902027460163142915440552345560155142252860077620360456665202331255942336597988163585574027982e106), SC_(0.6059432624884759831634155651234972753491453436908663323726521193978296064099953669071642553362799375) }}, 
      {{ SC_(74.19440460205078125), SC_(148.3888092041015625), SC_(60237624385313302055665235306873112325974940132774658919644673881062125967566945102151418439872.17501), SC_(0.5842813728796514975532223625090371234787451854132919341858494016625603009928499681651780318180597495e-11), SC_(0.1030969446930647021286527220625452842865797520714704588243609321840242087272511164266957947501724319e107), SC_(0.9999999999941571862712034850244677763749096287652125481458670806581415059833743969900715003183482197) }}, 
      {{ SC_(74.19440460205078125), SC_(7419.4404296875), SC_(0.1179722193094915578935717266143196959052311594748193029599035189506627590851835025191653960621725195e-2938), SC_(0.114428433994841964446725195470617640729684634102522504382582901169448615548951099979177671548325492e-3044), SC_(0.103096944693667078372505855083101936639648483194730208225688678773220655466061737686371464201193946e107), SC_(1) }}, 
      {{ SC_(74.441680908203125), SC_(0.74441683292388916015625), SC_(0.298675015341771109328998721195943851260453455178199448830768319841923405180891924820729728180022541e107), SC_(1), SC_(0.184916278561090699099037604033157692346952564770072700307047407346149898349869829557738418214252951e-11), SC_(0.6191220191266841647671841348731786746774022944704988662190443852972301503091054062397502290604517503e-118) }}, 
      {{ SC_(74.441680908203125), SC_(37.2208404541015625), SC_(0.2986750000080278050049751018850249685720371733056236351180015292529360536590363311414165019708757929e107), SC_(0.9999999486607767081630168403251819011889987238664708573000133871172584781592338078611321120363868025), SC_(1533374330432402361931091888268841628187257581371276679058898735152185559367931322620914674819770733.0), SC_(0.5133922329183698315967481809881100127613352914269998661288274152184076619213886788796361319751992353e-7) }}, 
      {{ SC_(74.441680908203125), SC_(72.441680908203125), SC_(0.1724471852150723873909426980489912027960762231952930413131682460366243978179577080196454374001637703e107), SC_(0.5773739896447067674956388497956312360551227939544130336051365353278834425198371083350128787877183769), SC_(0.1262278301266987219380560231469526484643772319829064075176000738052990073629342168010842907798587707e107), SC_(0.4226260103552932325043611502043687639448772060455869663948634646721165574801628916649871212122816231) }}, 
      {{ SC_(74.441680908203125), SC_(74.441680908203125), SC_(0.1447337648301569631097449705777677492631982520699648787303804900450463831830847437810282680563705929e107), SC_(0.4845861133196542388892450821993280933765419405462445100303210962809583210841960294643589341752718066), SC_(0.1539412505116141462192537506181761019972552031082345701003878297968770219978071810397014601236519482e107), SC_(0.5154138866803457611107549178006719066234580594537554899696789037190416789158039705356410658247281934) }}, 
      {{ SC_(74.441680908203125), SC_(76.441680908203125), SC_(0.1177454502518706856399893134588603779708752816623303626890187782843005287792460099272954088916410525e107), SC_(0.3942259787519744011919334583519262476483397718839405717455562738377942407819730991785080213168913937), SC_(0.1809295650899004236890094077370834732895781735158690861417495415576228764016459148934343192883814885e107), SC_(0.6057740212480255988080665416480737523516602281160594282544437261622057592180269008214919786831086063) }}, 
      {{ SC_(74.441680908203125), SC_(148.88336181640625), SC_(161503584770533082581086438786413369716697740543373784717828984174173906089093439102689116682267.8527), SC_(0.5407334945165265876318014076261308795786126961901172496358820711934127335713109380040153160738914477e-11), SC_(0.2986750153401560734812933903701329868725893214810324714253345819947451153391501857598387937889956499e107), SC_(0.9999999999945926650548347341236819859237386912042138730380988275036411792880658726642868906199598468) }}, 
      {{ SC_(74.441680908203125), SC_(7444.16796875), SC_(0.2488406623696112424016604006644025019692138359840932648284366670428296286796017879360301301467396269e-2948), SC_(0.8331485714828377287939547305065686034566344446994003609698927561564347368054402192725806861495894663e-3055), SC_(0.298675015341771109328998721195943851260453455178199448830768319841923405180891924820729728180022541e107), SC_(1) }}, 
      {{ SC_(75.5913238525390625), SC_(0.755913257598876953125), SC_(0.4242477253272137647617212991868617728511106756522002328947888421119498400032394531507577497663366502e109), SC_(1), SC_(0.4083953741843696549097480758809416708986599224069236672784284441048169867255909538730560453479846561e-11), SC_(0.9626342106357376241892647824720372487706312747481373658665126908592794818779720637021502128379285455e-120) }}, 
      {{ SC_(75.5913238525390625), SC_(37.79566192626953125), SC_(0.4242477080105636045349249321929870635187340106847933401877266972965759184570668813604407323301216331e109), SC_(0.9999999591826917943500786443023004059424532541058629792801196573986142196731808101005526936326470357), SC_(173166501602267963669938747093323766649674068927070621448153739215461725717903170174362150170907349900.0), SC_(0.4081730820564992135569769959405754674589413702071988034260138578032681918989944730636735296429547881e-7) }}, 
      {{ SC_(75.5913238525390625), SC_(73.5913238525390625), SC_(0.2446970374383516701170112383132402074039394920380568220886681994285676371810261360732501448770457539e109), SC_(0.5767786668735153526046169661877055882910921621704855001081867184159331632257663411488377824825514857), SC_(0.1795506878888620946447100608736215654471711836141434108061206426833822028222133170775076048892908963e109), SC_(0.4232213331264846473953830338122944117089078378295144998918132815840668367742336588511622175174485143) }}, 
      {{ SC_(75.5913238525390625), SC_(75.5913238525390625), SC_(0.2056344808006848835561080085495280703614964379005029044017000942125330915956490108510669302259920002e109), SC_(0.4847037910270069952641052407598440232689987079266695197561836838237890345676302180254690285941374783), SC_(0.21861324452652888120561329063733370248961423775169732849308874789941674840759044229969081954034465e109), SC_(0.5152962089729930047358947592401559767310012920733304802438163161762109654323697819745309714058625217) }}, 
      {{ SC_(75.5913238525390625), SC_(77.5913238525390625), SC_(0.1675788295115058294045845753636932271533646682807641346575870708421114628199695105254128876388142231e109), SC_(0.3950023052740132855310325297889353500550916482172842671141806239812579696380756887917613019545609573), SC_(0.2566688958157079353571367238231685456977460073714360982372017712698383771832699426253448621275224271e109), SC_(0.6049976947259867144689674702110646499449083517827157328858193760187420303619243112082386980454390427) }}, 
      {{ SC_(75.5913238525390625), SC_(151.182647705078125), SC_(16004304186982045700616799258827168975919727704533783148963144390302145600708157465959364984302758.12), SC_(0.3772395992138377819944827127559729865623396679445628197408225041009515576418821542020120597236816695e-11), SC_(0.4242477253256133343430230946168000929252279587546082601243354637970535255642092385906869340197407137e109), SC_(0.9999999999962276040078616221800551728724402701343766033205543718025917749589904844235811784579798794) }}, 
      {{ SC_(75.5913238525390625), SC_(7559.13232421875), SC_(0.2601398745149622772144744583365776305968660274907080237808336081668872851245468229455614098220434899e-2993), SC_(0.6131791851431179921360103837730047591606072896964829384579079796625457480060635137783157142794418721e-3102), SC_(0.4242477253272137647617212991868617728511106756522002328947888421119498400032394531507577497663366502e109), SC_(1) }}, 
      {{ SC_(75.8951416015625), SC_(0.7589514255523681640625), SC_(0.1576610880827630915750715387591471623206435744144183808258662408336033415623736425954764220072782094e110), SC_(1), SC_(0.5050192634470511349043349976487289229957354112070766341391598692045923228355657049103168662600457057e-11), SC_(0.3203195345080612314603495583373330994604684961789754958003980810284858893281575688500125173302385166e-120) }}, 
      {{ SC_(75.8951416015625), SC_(37.94757080078125), SC_(0.1576610820258149813636386970152189372054304524069321267385874982425732512127241522887111025169610294e110), SC_(0.999999961582479330398379208961911876062341173097680751134854671843505899079503049389620804063815189), SC_(605694811021143284174392822511521312200748625408727874259103009034964949030676531949031718000728726700.0), SC_(0.3841752066960162079103808812393765882690231924886514532815649410092049695061037919593618481102624955e-7) }}, 
      {{ SC_(75.8951416015625), SC_(73.8951416015625), SC_(0.9091110765615005119277918089117758285357946388207661972224659232217551336177579451980741847577200826e109), SC_(0.5766236219835480113026072910896004673732409498188978113953102351059729008981914020467497010958591154), SC_(0.6674998042661304038229235786796957946706411053234176110361964851142782820059784807566900353150620113e109), SC_(0.4233763780164519886973927089103995326267590501811021886046897648940270991018085979532502989041408846) }}, 
      {{ SC_(75.8951416015625), SC_(75.8951416015625), SC_(0.764237596000268978530984796692187517926810737194940642906799285851867060496091779021516007667234362e109), SC_(0.4847344422734719223657006252852881767363662262289741501119445655334805879102597863560657863522584568), SC_(0.8123732848273619372197305908992841052796250069492431653518631224841663551276446469332482124055477318e109), SC_(0.5152655577265280776342993747147118232636337737710258498880554344665194120897402136439342136477415432) }}, 
      {{ SC_(75.8951416015625), SC_(77.8951416015625), SC_(0.6230839153669592598259089314471549400769400799877534670710022817610644858472306334112860309684345069e109), SC_(0.3952046271809792992949502977573670265537317728638628467316893833694358268047261173720764072587760447), SC_(0.9535269654606716559248064561443166831294956641564303411876601265749689297765057925434781891043475869e109), SC_(0.6047953728190207007050497022426329734462682271361371532683106166305641731952738826279235927412239553) }}, 
      {{ SC_(75.8951416015625), SC_(151.790283203125), SC_(54078715884269576805255278712574436680847609083128203929472593970474554213679039712416414445796411.4), SC_(0.3430061059573642612887287006334947136371136592347414652443019408599131896403145936150929996905295971e-11), SC_(0.1576610880822223044162288429910946095335178300476099047350349587943086156226688970533396316101540452e110), SC_(0.99999999999656993894042635738711271299366505286362886340765258534755698059140086810359685406384907) }}, 
      {{ SC_(75.8951416015625), SC_(7589.51416015625), SC_(0.3383463503066467090839842408262370538760052444563234782480342568255035474589408675922587445429465453e-3005), SC_(0.2146035869859239750162295431327099841183852786073455225304195666813596199558190520084078814659127595e-3114), SC_(0.1576610880827630915750715387591471623206435744144183808258662408336033415623736425954764220072782094e110), SC_(1) }}, 
      {{ SC_(76.49312591552734375), SC_(0.764931261539459228515625), SC_(0.2095923693508665733212266664105616002964602515885112111884076725851047321087565163648517442289689027e111), SC_(1), SC_(0.7698288572748873026179137564371431838502118639938578177820006177148089695801437767166418637414672702e-11), SC_(0.3672981319210915227898880809312097359854666507390340797084318735454641478988437178712802050821537283e-121) }}, 
      {{ SC_(76.49312591552734375), SC_(38.246562957763671875), SC_(0.2095923622039299725226602766154380008064576239864117031054310389919986262904883362715082297886032057e111), SC_(0.999999965900778625989530022564230269191844678207147551716882096559560633619580524178570088917264812), SC_(7146936600798566389795123599490002627602099508082976633593106105818268180093343514440365697011827678000.0), SC_(0.340992213740104699774357697308081553217928524482831179034404393663804194758214299110827351880076558e-7) }}, 
      {{ SC_(76.49312591552734375), SC_(74.49312591552734375), SC_(0.1207925218672008902550482039366135952593267165302736487785557528976681490519228793780905472936331966e111), SC_(0.5763211811637524469589849392117932169093358049235196647040523602938001945039995246812168264220477701), SC_(0.8879984748366568306617846247394800503713353505823756240985191968743658305683363698676119693533570615e110), SC_(0.4236788188362475530410150607882067830906641950764803352959476397061998054960004753187831735779522299) }}, 
      {{ SC_(76.49312591552734375), SC_(76.49312591552734375), SC_(0.1016091727209359103838942431594570948339463476748305222059757950224456293063428552220527209725333434e111), SC_(0.4847942367159265124843237811245452986002395500530058790090603393114621555637159504097429216485581152), SC_(0.1079831966299306629373324232511045054625139039136806889824318775626591028024136611427990232564355594e111), SC_(0.5152057632840734875156762188754547013997604499469941209909396606885378444362840495902570783514418848) }}, 
      {{ SC_(76.49312591552734375), SC_(78.49312591552734375), SC_(0.8291462638915453650596276729374457613056090980945158813709809334992238166822325168128542279373707402e110), SC_(0.3955994516687385335636730824671301123423310505182896208353315392309276179814084520285959802269162267), SC_(0.1266777429617120368152638991168170241658993417790596230513095792351823504405332646835663214352318287e111), SC_(0.6044005483312614664363269175328698876576689494817103791646684607690723820185915479714040197730837733) }}, 
      {{ SC_(76.49312591552734375), SC_(152.9862518310546875), SC_(596167200161926734374775279692061483473805848530932854833290675599640521913655128888979470223020001.4), SC_(0.2844412714109440655560631961173337073277138278908972143038962875366176409437369537658248142885273558e-11), SC_(0.2095923693502704061210647396761868250167681901050374053398767397302714414331568758429380891000799233e111), SC_(0.9999999999971555872858905593444393680388266629267228617210910278569610371246338235905626304623417519) }}, 
      {{ SC_(76.49312591552734375), SC_(7649.3125), SC_(0.1370543781717626238626659521982192432483665212936269130702466193589183695345712305328128312282162477e-3028), SC_(0.6539091981079127182312227251265392518337530977209765220846457801683209199242173273269744880301885647e-3139), SC_(0.2095923693508665733212266664105616002964602515885112111884076725851047321087565163648517442289689027e111), SC_(1) }}, 
      {{ SC_(76.66892242431640625), SC_(0.766689240932464599609375), SC_(0.4488464702502950046259288416482720965186308071384778518157728633611059492520992611162781320049642864e111), SC_(1), SC_(0.8721894906464812908020288700698180546604536334846266549430697676501728524188815019788559904110835842e-11), SC_(0.1943180014672083842033261775328204350472782894788191437488951736682953249353282695825697978138267625e-121) }}, 
      {{ SC_(76.66892242431640625), SC_(38.334461212158203125), SC_(0.448846455472120894394405798489075125537304391075684796459845221141614259449743648712749774717318238e111), SC_(0.999999967075213709510484718141138021588117712607774693279636765017436992497533819700804894634778285), SC_(0.1477817411023152304315919697098132641606279305535592764221949168980235561240352835728764604835443201e104), SC_(0.3292478629048951528185886197841188228739222530672036323498256300750246618029919510536522171498388696e-7) }}, 
      {{ SC_(76.66892242431640625), SC_(74.66892242431640625), SC_(0.2586401247543923870698747204830307352368892844471364589497705860380253823565157883651307603675501955e111), SC_(0.5762329480059499157542953888677713666857774551387583623662657389393162741485837032303115672863647067), SC_(0.1902063454959026175560541211652413612817415226913413928660022773230805668955834727511473716374140909e111), SC_(0.4237670519940500842457046111322286333142225448612416376337342610606837258514162967696884327136352933) }}, 
      {{ SC_(76.66892242431640625), SC_(76.66892242431640625), SC_(0.2176060121931860995839566139994411238233069861787977305760201030781773165102945417863382266658339813e111), SC_(0.4848116819807899066241302106664858704043448057989854381936277707919399546154937459796565134629064748), SC_(0.2312404580571089050419722276488309726953238209596801212397527602829286327418047193299399053391303051e111), SC_(0.5151883180192100933758697893335141295956551942010145618063722292080600453845062540203434865370935252) }}, 
      {{ SC_(76.66892242431640625), SC_(78.66892242431640625), SC_(0.1776151359243554714845888887637843469290147016342041202242485959056111440952994130837236204251724154e111), SC_(0.3957146768366253712883556927942301194211761225929087680895714536373640226182000808691584053388276181), SC_(0.271231334325939533141339952884487749589616105504273731591524267455494805156799848032554511579791871e111), SC_(0.6042853231633746287116443072057698805788238774070912319104285463626359773817999191308415946611723819) }}, 
      {{ SC_(76.66892242431640625), SC_(153.3378448486328125), SC_(1208340354750040169673093110162630940646939904953476810111867891477008100681713918881377104158094853.0), SC_(0.2692101720386083368586116719236877857848577387912425077510921207911619506768524998186418313361997967e-11), SC_(0.4488464702490866642711788014785990034084681761978309119108193865509940813606222530155964180860829093e111), SC_(0.9999999999973078982796139166314138832807631221421514226120875749224890787920883804932314750018135817) }}, 
      {{ SC_(76.66892242431640625), SC_(7666.89208984375), SC_(0.1821123293565225789529725592026371278350411294653651926509483135957711850671254861487385053133806531e-3035), SC_(0.4057341238641563885831526096175456837680872294050387714943344891563851270111831763997700135576580181e-3146), SC_(0.4488464702502950046259288416482720965186308071384778518157728633611059492520992611162781320049642864e111), SC_(1) }}, 
      {{ SC_(79.32462310791015625), SC_(0.793246209621429443359375), SC_(0.4671121597949982795711144175493706605009846561466580157372296518317719005372678466272806286973583136e116), SC_(1), SC_(0.6039168545348148856452350861970003224978502524901460062877985188730753683893012418024349808946731235e-10), SC_(0.1292873332177556976975851675496753973570456780369174162484505186987337201864822887596441509654278919e-125) }}, 
      {{ SC_(79.32462310791015625), SC_(39.662311553955078125), SC_(0.4671121507351240492604208198508603377019269254024439937901993046380224468789840420121404558453316837e116), SC_(0.9999999806044992828129231033044713064068338867545802771386030451446152224507990807321593976028763138), SC_(0.9059874230310693597698510322799057730744214021947030347193749453658283804615140172852026629832492352e108), SC_(0.1939550071718707689669552869359316611324541972286139695485538477754920091926784060239712368622000466e-7) }}, 
      {{ SC_(79.32462310791015625), SC_(77.32462310791015625), SC_(0.2685596907607638612260554874823900767470629784663574316924676978828936868056565540764625568568498545e116), SC_(0.5749362013582064993583896500521535492965535315276841309638485958891645153801820177715668270529624124), SC_(0.1985524690342344183450589300669805837539216776803005840447619539488782137316112925508180718405084591e116), SC_(0.4250637986417935006416103499478464507034464684723158690361514041108354846198179822284331729470375876) }}, 
      {{ SC_(79.32462310791015625), SC_(79.32462310791015625), SC_(0.2265812192859111793701268319180181432592332033520631459548418870087313461493587143570358980254121858e116), SC_(0.4850681245064375532830474944621702586601181813161844180209856045192746973602966734348745477845995594), SC_(0.2405309405090871002009875856313525172417514527945948697823877648230405543879091322702447306719461278e116), SC_(0.5149318754935624467169525055378297413398818186838155819790143954807253026397033265651254522154004406) }}, 
      {{ SC_(79.32462310791015625), SC_(81.32462310791015625), SC_(0.1856351400007264179915509790071180444141831443962993101439038589137498188297565091899947197479506563e116), SC_(0.3974102067524771654238415034508869981945050779154473286311149558701105627077748452563626311397099272), SC_(0.2814770197942718615795634385422526160868015117503587055933257929180220817075113374372859089494076573e116), SC_(0.6025897932475228345761584965491130018054949220845526713688850441298894372922251547436373688602900728) }}, 
      {{ SC_(79.32462310791015625), SC_(158.6492462158203125), SC_(0.5477330720068224780701445363285029876343876715557225104230520850538844174288125862419613510382120732e104), SC_(0.1172594334189900631026684846558912506266654225675454569702894665073176239070434312256368453610018499e-11), SC_(0.4671121597944505464991075950713005159646561531590236280656739293213488484522139622098518161111163522e116), SC_(0.9999999999988274056658100993689733151534410874937333457743245454302971053349268237609295656877436315) }}, 
      {{ SC_(79.32462310791015625), SC_(7932.46240234375), SC_(0.2507976175576844893816025545348994505732738811599451336268458914861545435100080396913936264183100242e-3139), SC_(0.5369109159302385766715005099968927909596208804645589535759265880326078668348439316806652406126744246e-3255), SC_(0.4671121597949982795711144175493706605009846561466580157372296518317719005372678466272806286973583136e116), SC_(1) }}, 
      {{ SC_(79.50051116943359375), SC_(0.7950050830841064453125), SC_(0.1007179855256139495130132385414409112491773013873557959418162063411915085777708335264524976384187991e117), SC_(1), SC_(0.6887000237791040303344447785375139417032139911190313071484984882544945606603220114308768983302289135e-10), SC_(0.6837905069139396906610398476672272204595124818016865895753945696678209963279127701144558535997180328e-126) }}, 
      {{ SC_(79.50051116943359375), SC_(39.750255584716796875), SC_(0.1007179836393830335336233439903068878202174926971471695238825534389799961797697618010140027702267658e117), SC_(0.9999999812721540632909521979986548649380838741865786059637062956721161538067683429285376975236657302), SC_(0.1886230915979389894551134023428959808690208626417933652902211512398001071725438494868192033298369219e109), SC_(0.1872784593670904780200134513506191612581342139403629370432788384619323165707146230247633426975256935e-7) }}, 
      {{ SC_(79.50051116943359375), SC_(77.50051116943359375), SC_(0.5789799949107917152570710484848434458064808949077017980685125521673178404641929193096087412095242976e116), SC_(0.5748526361893420229789120569013624245836437256323742750737512004325005902604086693828613549873692166), SC_(0.4281998603453477798730613369295656666852921189658561613496495112445972453135154159549162351746636933e116), SC_(0.4251473638106579770210879430986375754163562743676257249262487995674994097395913306171386450126307834) }}, 
      {{ SC_(79.50051116943359375), SC_(79.50051116943359375), SC_(0.4885674911797652114508761964378804385389577759098921348148099363155387118919106051255954421534190815e116), SC_(0.4850846535800856274945033512970544897150855947006202262011552441697614121488952414904204770326254579), SC_(0.5186123640763742836792561889765286739528152379636658246033521270963763738857977301389295342307689094e116), SC_(0.5149153464199143725054966487029455102849144052993797737988447558302385878511047585095795229673745421) }}, 
      {{ SC_(79.50051116943359375), SC_(81.50051116943359375), SC_(0.4003737369276933595165444490079175288966803252286052829692800846860985237220765734659062956459984663e116), SC_(0.3975196037115663804827922579647907397844393421819002221608464511372100484695665027416987597795269932), SC_(0.6068061183284461356135879364064915835950926886449526764488819787258165620556317617986186807381895246e116), SC_(0.6024803962884336195172077420352092602155606578180997778391535488627899515304334972583012402204730068) }}, 
      {{ SC_(79.50051116943359375), SC_(159.0010223388671875), SC_(0.1117782601617957330465406642863402034183538751360069213080811823615253974473994651893700610377698832e105), SC_(0.1109814295614252587586323883157197260814952349004543110702484673237072021217283859901908230123439344e-11), SC_(0.100717985525502171252851442808394370584890961183937442066680199419883427395409308129005098173229429e117), SC_(0.9999999999988901857043857474124136761168428027391850476509954568892975153267629279787827161400980918) }}, 
      {{ SC_(79.50051116943359375), SC_(7950.05126953125), SC_(0.332617490333505740193238740221960311618356967098140848780280664105621628940315461991208307850364067e-3146), SC_(0.3302463692037571600524407642610776659937268500918407630656802304688906743772950818205739444343777544e-3262), SC_(0.1007179855256139495130132385414409112491773013873557959418162063411915085777708335264524976384187991e117), SC_(1) }}, 
      {{ SC_(79.6223907470703125), SC_(0.7962238788604736328125), SC_(0.1715657227680164605630917478389861461913239451098814709264168965684594546202062069240005740101091525e117), SC_(1), SC_(0.754509793972818202583506331051781208522710342408733321500163303079991978066951619456360117963549162e-10), SC_(0.4397788682958732887173811193154454955888151794796743370538482289013582498261287684371327392962268777e-126) }}, 
      {{ SC_(79.6223907470703125), SC_(39.81119537353515625), SC_(0.1715657196320086458068259811820125306571938794776498778512967440364920605026325977989548622193198264e117), SC_(0.9999999817212449890317773405034720825579690706587396281355497774469202517371009703905926320510621998), SC_(0.3136007814756265766656973615534130065632231593075120152531967394117573609125045711790789326099725717e109), SC_(0.1827875501096822265949652791744203092934126037186445022255307974826289902960940736794893780017803728e-7) }}, 
      {{ SC_(79.6223907470703125), SC_(77.6223907470703125), SC_(0.9861510149806946069119244150539731712756570722452758207734953627951806391685407406714055767796988538e116), SC_(0.5747948943823260940081154817917987955871576341815977930738572693572120360781162011828666339628959371), SC_(0.7295062126994699987189930633358882906375823788535388884906736028894139070335213285686001633213926711e116), SC_(0.4252051056176739059918845182082012044128423658184022069261427306427879639218837988171333660371040629) }}, 
      {{ SC_(79.6223907470703125), SC_(79.6223907470703125), SC_(0.8322585873047840922376383521441536538728130600255677203896274724206914713520204498344752465338252139e116), SC_(0.4850960750651382367579725536937657793801694464515224466699114589073786351509412021268725682600372838), SC_(0.883398640375380513393279126245707808040426391073246988874541493263903074850041619405530493567266311e116), SC_(0.5149039249348617632420274463062342206198305535484775533300885410926213648490587978731274317399627162) }}, 
      {{ SC_(79.6223907470703125), SC_(81.6223907470703125), SC_(0.6821370856679498971296525115150974730855745751397914367805592884761332364821411828788225857696117516e116), SC_(0.3975952041366126054894817687557524182144172771315710656488169932801258933992178693882689294640018238), SC_(0.1033520142012214708501264966874763988827664875959023272483609677208461309719920886361183154331479773e117), SC_(0.6024047958633873945105182312442475817855827228684289343511830067198741066007821306117310705359981762) }}, 
      {{ SC_(79.6223907470703125), SC_(159.244781494140625), SC_(0.1832828915314380334113857311590267904888543149679052917412213341368534561089124778665601159484213666e105), SC_(0.1068295511331625416194923285915509115906296547130247095396640086031391470823974203287727401395873051e-11), SC_(0.1715657227678331776715603098055747604601649183193926166114489912767182332860693534678916615322425924e117), SC_(0.9999999999989317044886683745838050767140844908840937034528697529046033599139686085291760257967122726) }}, 
      {{ SC_(79.6223907470703125), SC_(7962.2392578125), SC_(0.5707574247311215651651126695679961463941861779012155096590663872746423650263852268844866525688891356e-3151), SC_(0.3326756740930555043164283198692223050084192888424458711044641812297007350754846039812739082533180289e-3267), SC_(0.1715657227680164605630917478389861461913239451098814709264168965684594546202062069240005740101091525e117), SC_(1) }}, 
      {{ SC_(79.829345703125), SC_(0.79829347133636474609375), SC_(0.4240441081412798178327694732666417723072057669917958145406633586949781267758762767540872567351954665e117), SC_(1), SC_(0.8813645253024489993550976092533766237873460413576730175642301470499238017901799923348019642589712028e-10), SC_(0.2078473697384335815411060540938428709327284148342604097582465097698775123509059896790079916976528154e-126) }}, 
      {{ SC_(79.829345703125), SC_(39.9146728515625), SC_(0.4240441007032240506684766617917096806560720482076284907552715296700713716577254656043438208489782786e117), SC_(0.9999999824592403847617250977446217538623581070912365241176574333345935152418470913514385563163792275), SC_(0.7438055767164292811474932091651133718784167323785391829024906755118150811149743435886217187953434908e109), SC_(0.1754075961523827490225537824613764189290876347588234256666540648475815290864856144368362077247058852e-7) }}, 
      {{ SC_(79.829345703125), SC_(77.829345703125), SC_(0.2436969414860120290289689777276043636584936128155226208509461532806576070130144369706266206922376831e117), SC_(0.5746971525066418798438281252523317290894689780779437149862575792522518902192007991791920250991936967), SC_(0.1803471666552677888038004955390374086487121541762731936897172054143205197628618397834606360429577834e117), SC_(0.4253028474933581201561718747476682709105310219220562850137424207477481097807992008208079749008063033) }}, 
      {{ SC_(79.829345703125), SC_(79.829345703125), SC_(0.2057103310021771387382717064845340168088360551371116254389197414013419499959175159941568001657888962e117), SC_(0.4851154091112618928575307309857291325089832757615232285715171921768187230517940573160602294139425922), SC_(0.2183337771391026790944977667821077554983697118546841891017436172936361767799587607599304565694065703e117), SC_(0.5148845908887381071424692690142708674910167242384767714284828078231812769482059426839397705860574078) }}, 
      {{ SC_(79.829345703125), SC_(81.829345703125), SC_(0.1686521768646532707913514122900405507011319383133847277363588584916610090298906867600795278457611923e117), SC_(0.3977231934760499265543096531991136395682943725759448848277093454940352318696169596549681950861851036), SC_(0.2553919312766265470414180609766012216060738286784110868043045002033171177459855899940077288894342742e117), SC_(0.6022768065239500734456903468008863604317056274240551151722906545059647681303830403450318049138148964) }}, 
      {{ SC_(79.829345703125), SC_(159.65869140625), SC_(0.424605873119110364212821116620527380541187863831844970899490116890177789724000182730469046696392776e105), SC_(0.1001324779585531658328192497418062102045756562153670520281231626880522693147593918096011773729412533e-11), SC_(0.4240441081408552119596503629024289511905852396112546266768315137240786366589860989643632565524649975e117), SC_(0.9999999999989986752204144683416718075025819378979542434378463294797187683731194773068524060819039882) }}, 
      {{ SC_(79.829345703125), SC_(7982.9345703125), SC_(0.4621662479706183011662750662723852497792440727322185958986325739851002898647535816572084573103929877e-3159), SC_(0.1089901354829430235357224959326508852275613378764967203384928943628269735805569956330024274570034831e-3275), SC_(0.4240441081412798178327694732666417723072057669917958145406633586949781267758762767540872567351954665e117), SC_(1) }}, 
      {{ SC_(79.89389801025390625), SC_(0.7989389896392822265625), SC_(0.5623872428860240914124385034669456317377062335483102811486398321544344297098623896453332740116185409e117), SC_(1), SC_(0.9252400586147207986399310125175872809713146282808823213806627825501812184354791877049496503893417913e-10), SC_(0.1645201007523981261932088980012233717527575414974406339656709968708528716110378383489968733983530401e-126) }}, 
      {{ SC_(79.89389801025390625), SC_(39.946949005126953125), SC_(0.5623872331473145380256817849925987163138703952898820899999530174122577585060346090230388143581559124e117), SC_(0.9999999826832673098873136057286627605889134128412976054955191328641337338943465638707743252432067262), SC_(0.9738709553386756718474346915423835838258428191148686814742176671203827780622294459653462628520698333e109), SC_(0.1731673269011268639427133723941108658715870239450448086713586626610565343612922567475679327383632885e-7) }}, 
      {{ SC_(79.89389801025390625), SC_(77.89389801025390625), SC_(0.3231852455582649743730220172309814969465482872883759397817585622260013630088536766339980712786839687e117), SC_(0.5746667436831655490083122794443975439715616394986560265564901985697189264778379184602249247159019612), SC_(0.2392019973277591170394164862359641347911579462599343413668812699284330667010087130113352027329345722e117), SC_(0.4253332563168344509916877205556024560284383605013439734435098014302810735221620815397750752840980388) }}, 
      {{ SC_(79.89389801025390625), SC_(79.89389801025390625), SC_(0.2728261002814886725877513262716592670634452736295204248614669541739911238383716909024473725449893467e117), SC_(0.4851214243079493673695258359589997582772367754525545927391731121566233487463718849674183056627391385), SC_(0.2895611426045354188246871771952863646742609599187898562871728779804433058714906987428859014666291943e117), SC_(0.5148785756920506326304741640410002417227632245474454072608268878433766512536281150325816943372608615) }}, 
      {{ SC_(79.89389801025390625), SC_(81.89389801025390625), SC_(0.2236968465488211857538073443874235675754314170333716992581290437541122706752715140400264023666312034e117), SC_(0.3977630171709933097440496739039984011001766085819066051719601609492872712497753172998195051897981828), SC_(0.3386903963372029056586311590795220641622748165149385818905107884003221590345908756053068716449873375e117), SC_(0.6022369828290066902559503260960015988998233914180933948280398390507127287502246827001804948102018172) }}, 
      {{ SC_(79.89389801025390625), SC_(159.7877960205078125), SC_(0.5518750534826592333439106118852649468895253290019915041723999567802947326613956916938138335229256075e105), SC_(0.9813079163221785503959194191372440868758643367920170695089911061279549457454591920905123279087302061e-12), SC_(0.5623872428854722163589558442336017211258209686014207558196378406502620297530820949126718783199247271e117), SC_(0.9999999999990186920836778214496040805808627559131241356632079829304910088938720450542545408079094877) }}, 
      {{ SC_(79.89389801025390625), SC_(7989.3896484375), SC_(0.1383507138942006080113356761199370492213922206755980013543626068704345075613213997141592584980275057e-3161), SC_(0.2460061383757941699094234196149238409539858091509580238126731100515831044151186882019558174679678258e-3278), SC_(0.5623872428860240914124385034669456317377062335483102811486398321544344297098623896453332740116185409e117), SC_(1) }}, 
      {{ SC_(79.911529541015625), SC_(0.79911530017852783203125), SC_(0.6074807445704054176953723897174493928056843658012608492033878323056858035817494945656714304004354818e117), SC_(1), SC_(0.9376075939991310316058652097322864958830318207703330053398677303143367435772012479563172441291508907e-10), SC_(0.1543435907029749124641430961701084628110712234538281039990333691540443834012832931513902983314662334e-126) }}, 
      {{ SC_(79.911529541015625), SC_(39.9557647705078125), SC_(0.6074807340876916319734828236712344466193462540382862173563921303925649879181289456211087278832922218e117), SC_(0.9999999827439571057762627432397076597338606062216417634020796417035472264920233241424457171679881343), SC_(0.1048271378572188956604621494618633811176297463184699570191312081566362054894456270251714326005997951e110), SC_(0.1725604289422373725676029234026613939377835823659792035829645277350797667585755428283201186567172893e-7) }}, 
      {{ SC_(79.911529541015625), SC_(77.911529541015625), SC_(0.3490939396819543194423472086692488440899329561754645394349542462300088417893174150204567615974322654e117), SC_(0.5746584444068667128455934529286477397106019468883497914927484236710355942777847424911227111339637018), SC_(0.2583868048884510982530251810482005487157514096257963097684335860756769617924320795452146688030032164e117), SC_(0.4253415555931332871544065470713522602893980531116502085072515763289644057222152575088772888660362982) }}, 
      {{ SC_(79.911529541015625), SC_(79.911529541015625), SC_(0.294702921344710284583015687923193164602506977430393597564273919764947267165659436584792585193649268e117), SC_(0.4851230660045307699251807140409752727269029578112530269856327993879109642416421942844061192299068579), SC_(0.3127778232256951331123567017942562282031773883708672516391139125407385364160900579808788452067862138e117), SC_(0.5148769339954692300748192859590247272730970421887469730143672006120890357583578057155938807700931421) }}, 
      {{ SC_(79.911529541015625), SC_(81.911529541015625), SC_(0.2416399766528549473697622900337525778959737836824036578697933604271083054382496466545196926326891434e117), SC_(0.3977738863537748080058086305828367901266073773264507209981113710914944422185002681011018837744666533), SC_(0.3658407679175504703256100996836968149097105821188571913335944718785774981434998479111517377677463384e117), SC_(0.6022261136462251919941913694171632098733926226735492790018886289085055577814997318988981162255333467) }}, 
      {{ SC_(79.911529541015625), SC_(159.82305908203125), SC_(0.5928468749707662143430063654698739701578602643830176982959642460330223717611053116877688191468460572e105), SC_(0.9759105622187450643987776870080494156376235134608410264363670080614512689454082944531773049734218145e-12), SC_(0.607480744569812570820401623503106386440214491831102988939004814607389839335716472193910325088747713e117), SC_(0.9999999999990240894377812549356012223129919505843623764865391589735636329919385487310545917055468227) }}, 
      {{ SC_(79.911529541015625), SC_(7991.15283203125), SC_(0.2828851956046506636217187683331236808099435276786311460043401171888690142450033547321326007520746213e-3162), SC_(0.4656694029120210489268327196326841874360145543289128837664634685581941563202048737167103318560911968e-3279), SC_(0.6074807445704054176953723897174493928056843658012608492033878323056858035817494945656714304004354818e117), SC_(1) }}, 
      {{ SC_(80.12790679931640625), SC_(0.8012790679931640625), SC_(0.1565858955345316778408697383409706114881625261885981877017429104297769723046463114404315151462293643e118), SC_(1), SC_(0.1103906892347550275984936375024131914313306692031262138020588747801109803699328609997449182650183472e-9), SC_(0.7049848829482264367664086348448905216092398164445087477821053207884342501027599062024031746506980864e-127) }}, 
      {{ SC_(80.12790679931640625), SC_(40.063953399658203125), SC_(0.1565858929464215987700381838538577091475063482521143618128528892829080714162263001395629912384775782e118), SC_(0.9999999834716270566011540626153264222935036769351386967304111779925509195585578623247484278439032468), SC_(0.2588110079070831554487112902340656177936483825888890021146868900888420011300868523907751786185826016e110), SC_(0.1652837294339884593738467357770649632306486130326958882200744908044144213767525157215609675319105551e-7) }}, 
      {{ SC_(80.12790679931640625), SC_(78.12790679931640625), SC_(0.8996749404983470527985969159238028099249147438421457261648644220762982170441636576776073490786413402e117), SC_(0.5745568190718320112196587122863238592372491398377904557699435971888929284450954160859714184830670111), SC_(0.6661840148469697256101004674859033049567105180438361508525646822214715060022994567267078023836523032e117), SC_(0.4254431809281679887803412877136761407627508601622095442300564028111070715549045839140285815169329889) }}, 
      {{ SC_(80.12790679931640625), SC_(80.12790679931640625), SC_(0.7596657758652123118886387267866211410677574072189233066134010920575256333497559921564728089270332406e117), SC_(0.4851431690395666803137511593175113993531310895097926504821190772250002016391107113849799128985336875), SC_(0.8061931794801044665200586566230849738138678546670585704040280122402440896967071222478423425352604028e117), SC_(0.5148568309604333196862488406824886006468689104902073495178809227749997983608892886150200871014663125) }}, 
      {{ SC_(80.12790679931640625), SC_(82.12790679931640625), SC_(0.6230662287369224783044172553715399976985326489531125576573499096252535174637146127256309107572849744e117), SC_(0.3979069932256564687190757801598174636710415784500894668989259748569020372840459038255617885912877157), SC_(0.942792726608394300104280128038166117183092612932869319360079194672516205582748501678684240705008669e117), SC_(0.6020930067743435312809242198401825363289584215499105331010740251430979627159540961744382114087122843) }}, 
      {{ SC_(80.12790679931640625), SC_(160.2558135986328125), SC_(0.1428131148366242601399739072987256872234264848389817971753261614311088472292008847131795907061501696e106), SC_(0.9120432868433534946432724833845173130774072327633806797938769372461187149892526218428508238215261114e-12), SC_(0.1565858955343888647260331140808306375808638005013747612169039286326016461432152025932023142615161847e118), SC_(0.9999999999990879567131566465053567275166154826869225927672366193202061230627538812850107473781571492) }}, 
      {{ SC_(80.12790679931640625), SC_(8012.79052734375), SC_(0.9813833801258848564907067590989331933673934913947440748745656518826023432810079629719642554627422948e-3171), SC_(0.6267380448128942072881349135209852478939912748695130086904104200672763288234875394585874700196810928e-3288), SC_(0.1565858955345316778408697383409706114881625261885981877017429104297769723046463114404315151462293643e118), SC_(1) }}, 
      {{ SC_(80.849334716796875), SC_(0.8084933757781982421875), SC_(0.3695313563630779228975452742878590145583333608065575253717395879967866264156839448832806724001298252e119), SC_(1), SC_(0.1910793356603405396091276046002837621116346950498761631147067245324122512531493535189456406667415525e-9), SC_(0.5170855798028630115329948188964096343551868072260648398316526340490731661038336678850118298026459568e-128) }}, 
      {{ SC_(80.849334716796875), SC_(40.4246673583984375), SC_(0.3695313510724557961316371554536349288899657621139192752676952633426620723906260032944788331957545609e119), SC_(0.9999999856828871605480739577719564646026456844148429021895784931791924362914873712591824805349456478), SC_(0.5290622126765908118834224085668367598692638250104044324654124554025057941588801839204375264251369873e111), SC_(0.1431711283945192604222804353539735431558515709781042150682080756370851262874081751946505435216986362e-7) }}, 
      {{ SC_(80.849334716796875), SC_(78.849334716796875), SC_(0.2121926511057782794199272803396497086439772919485559165285769515553270566324785307902295633987797339e119), SC_(0.5742209624486949494208166065593421844336741642102212276714392784181868117532148928657809272365487187), SC_(0.1573387052572996434776179939482093059143560688580016088431626364414595697832054140930511090013500912e119), SC_(0.4257790375513050505791833934406578155663258357897787723285607215818131882467851071342190727634512813) }}, 
      {{ SC_(80.849334716796875), SC_(80.849334716796875), SC_(0.1793001656053353488041135091497583237236729298957064369768475297283657107769874923206150829448610597e119), SC_(0.4852096108162644014951140255203384523193561677446202760909207893861087596394911130344296970112943799), SC_(0.1902311907577425740934317651381006908346604309108510883948920582684209156386964525626655894552687654e119), SC_(0.5147903891837355985048859744796615476806438322553797239090792106138912403605088869655703029887056201) }}, 
      {{ SC_(80.849334716796875), SC_(82.849334716796875), SC_(0.147201729366517941328145970611369179771754730056506404447137768869361989564926344576460636984497343e119), SC_(0.3983470599498650344822295094401653774419902739967054315366917017179567697339631514175192150359410387), SC_(0.2223296269965599815693993036764898347865786307500511209246018191274246368507576003068200354156324822e119), SC_(0.6016529400501349655177704905598346225580097260032945684633082982820432302660368485824807849640589613) }}, 
      {{ SC_(80.849334716796875), SC_(161.69866943359375), SC_(0.2689503176953981729747144490529877231974192647794491251249335107555282326872062865070864188251151032e107), SC_(0.7278146037251159774373769857431458856305825921008314075267928697741501028589999541438705298999868145e-12), SC_(0.3695313563628089725798498761148843001092803730833601061069601388716616929049284166505934661136227387e119), SC_(0.9999999999992721853962748840225626230142568541143694174078991685924732071302258498971410000458561295) }}, 
      {{ SC_(80.849334716796875), SC_(8084.93359375), SC_(0.6132380305701121462469405302454548114426482733649866731660738888202764961961434042504588482287468179e-3199), SC_(0.165950201521622322495940947866560483471548748879262058555335165308661377207671025476753503896989563e-3317), SC_(0.3695313563630779228975452742878590145583333608065575253717395879967866264156839448832806724001298252e119), SC_(1) }}, 
      {{ SC_(81.56500244140625), SC_(0.815650045871734619140625), SC_(0.8557910056361559208739241521745494880610417879882744978867358284465498673356955513677886983293923693e120), SC_(1), SC_(0.3314267214918079012256477817183939950867700173962530903842677738990700000165402649306683952481482028e-9), SC_(0.3872753035601728763877314752320223718662757264283768033172506607193758358351421608369197028952524728e-129) }}, 
      {{ SC_(81.56500244140625), SC_(40.782501220703125), SC_(0.8557909950103422240652532848601310717163547621576865221736181910852871532504420329864215025570134048e120), SC_(0.9999999875836347579863536858812355411289528473513077318224505894944554207512944589881490229084758716), SC_(0.1062581369680867086731441841634468702583058797571311763736126271408525351838136719577237896451181569e113), SC_(0.1241636524201364631411876445887104715264869226817754941050554457924870554101185097709152412836962729e-7) }}, 
      {{ SC_(81.56500244140625), SC_(79.56500244140625), SC_(0.491131810458415797253133694065392895216348628627804013362612257835154519583201315070753991709603353e120), SC_(0.5738922321266170072005300090309778178461083341052825393193901756574289533407410956212393868747024631), SC_(0.3646591951777401236207904581091565928446931593604704845241235706113953477524942362970347066197890163e120), SC_(0.4261077678733829927994699909690221821538916658947174606806098243425710466592589043787606131252975369) }}, 
      {{ SC_(81.56500244140625), SC_(81.56500244140625), SC_(0.4152936799533426187546279459127586883946615850364334799487274913233647039071691487511697198843596929e120), SC_(0.4852746490886899161634002152481990679415499680049732093189034240163252493710698745788645052169806065), SC_(0.4404973256828133021192962062617907996663802029518410179380083371231851634285264026166189784450326764e120), SC_(0.5147253509113100838365997847518009320584500319950267906810965759836747506289301254211354947830193935) }}, 
      {{ SC_(81.56500244140625), SC_(83.56500244140625), SC_(0.3412706588312780908661863866436670552199021881165747254070595902721923230275974137981746022332140344e120), SC_(0.3987780387778124407643074939272984787086376550411699153642160494542210874074353039102140980370086958), SC_(0.5145203468048778300077377655308824328411395998716997724796762381743575443080981375696140960961783349e120), SC_(0.6012219612221875592356925060727015212913623449588300846357839505457789125925646960897859019629913042) }}, 
      {{ SC_(81.56500244140625), SC_(163.1300048828125), SC_(0.4979569103926362279287184639116260612284836895084960854320411441443349189037934716281790427787321784e108), SC_(0.5818674268754178120372348650715318734531356120929647537057914753089229460774655785119123964053597103e-12), SC_(0.8557910056356579639635315159466207695971301619270460141972273323611178261915512164488849048577641903e120), SC_(0.9999999999994181325731245821879627651349284681265468643879070352462942085246910770539225344214880876) }}, 
      {{ SC_(81.56500244140625), SC_(8156.5), SC_(0.6481645983237165116476868438359473085675465428063233854312328145204451100927036046633890300552768762e-3227), SC_(0.7573865512198279914135246678286017335513840758213216543189188620312309378889936481224346436723878256e-3347), SC_(0.8557910056361559208739241521745494880610417879882744978867358284465498673356955513677886983293923693e120), SC_(1) }}, 
      {{ SC_(82.27938079833984375), SC_(0.822793781757354736328125), SC_(0.1983179232494865351873957720975123376379986118808518655503988724938961759719224804417829200263290348e122), SC_(1), SC_(0.577938743053930659084681674082901750744634487798841062507673955184367849107775263686605442346057389e-9), SC_(0.2914203283214478699052169618163989729721081714200892589492120879102489473671080255284348679690862441e-130) }}, 
      {{ SC_(82.27938079833984375), SC_(41.139690399169921875), SC_(0.1983179211133833816706717400704484917566805497731756340503074559239619980958067187248157997680728896e122), SC_(0.9999999892288951068256276963480248265633848704377949155882701823012280366006306533718564574322629001), SC_(0.2136103153516724032027063845881318062107676231500091416569934177876115761716967120258256145190798483e114), SC_(0.1077110489317437230365197517343661512956220508441172981769877196339936934662814354256773709986367443e-7) }}, 
      {{ SC_(82.27938079833984375), SC_(80.27938079833984375), SC_(0.1137488962797576184179232683250422036047193135702869592917316403600289371097784619249451487810758879e122), SC_(0.5735684118508039369307481187482281734253148523757919272131028213569543737074997842638856981426621017), SC_(0.8456902696972891676947250377247013403327929831056490625866723213386723886214401851683777124525314685e121), SC_(0.4264315881491960630692518812517718265746851476242080727868971786430456262925002157361143018573378983) }}, 
      {{ SC_(82.27938079833984375), SC_(82.27938079833984375), SC_(0.9625136741340621762846899382946768160880399753531011770794351092617381718542134240716155001244200256e121), SC_(0.4853387219687690128350225313207321218635154450024860038399871756957560965998204117573335934982355916), SC_(0.1020665558360803175589267782680446560291946143455417478424553615677223587865011380346213700138870322e122), SC_(0.5146612780312309871649774686792678781364845549975139961600128243042439034001795882426664065017644084) }}, 
      {{ SC_(82.27938079833984375), SC_(84.27938079833984375), SC_(0.7916907438958707079496094482701859713072892331527960241433957694157827310378157294240598011618099335e121), SC_(0.3992028208665302640343590676908354084681030936732554905381867505402633822735374778469003741999907536), SC_(0.1191488488598994643924348272704937405072696885655722631360592955523179028681409074993769399101480414e122), SC_(0.6007971791334697359656409323091645915318969063267445094618132494597366177264625221530996258000092464) }}, 
      {{ SC_(82.27938079833984375), SC_(164.5587615966796875), SC_(0.9229529795603485153461368490615812168769999815674405829557989909785396829739678098673931808173733641e109), SC_(0.4653906033491797027152972671150951566580532158075195767613418293025216873218072919120345009989942482e-12), SC_(0.1983179232493942398894397372459777239530924537591641655522421284356005960728246264734855232453422955e122), SC_(0.9999999999995346093966508202972847027328849048433419467841924804232386581706974783126781927080879655) }}, 
      {{ SC_(82.27938079833984375), SC_(8227.9384765625), SC_(0.7735068658678605879711478927950195701281275037675644656423127595544395725667868253109208668000308593e-3255), SC_(0.3900337665873895107561081441533175943567540187707929179576679352340155534583687010995194073636485055e-3376), SC_(0.1983179232494865351873957720975123376379986118808518655503988724938961759719224804417829200263290348e122), SC_(1) }}, 
      {{ SC_(82.434051513671875), SC_(0.824340522289276123046875), SC_(0.3919727298018941405607217213011860844848358362971197486574977786876580212154309353468872530105839726e122), SC_(1), SC_(0.6524236890668771801216402186187088295435761377068961184835672739387582320547845566414717541543312593e-9), SC_(0.1664461936922542654025055064849818737381098853423292904837662535719895443157365300509947378053417278e-130) }}, 
      {{ SC_(82.434051513671875), SC_(41.2170257568359375), SC_(0.3919727257078552634465817789575093075992751697658115097122013235789077370594016939005668254228014741e122), SC_(0.9999999895552966677470219099988238773006553770146631982774442737265025711963197188349852651550351783), SC_(0.4094038877114139942343676776885560666531308238945296455108750284156029241446320427587782498488383811e114), SC_(0.1044470333225297809000117612269934462298533680172255572627349742880368028116501473484496482168340509e-7) }}, 
      {{ SC_(82.434051513671875), SC_(80.434051513671875), SC_(0.2247959137555844463219799838800151023970241303476741068008275124151099011724539590862877473743632319e122), SC_(0.5734988601610064325179525464074205288727851883810181600442835883096950669687954548152247899629835615), SC_(0.1671768160463096942387417374211709820878117059494456418566702662725481200429769762605995056362207407e122), SC_(0.4265011398389935674820474535925794711272148116189818399557164116903049330312045451847752100370164385) }}, 
      {{ SC_(82.434051513671875), SC_(82.434051513671875), SC_(0.1902449383177598813121943592459519971433465338910958602674765059254867259669384595084196139702804307e122), SC_(0.4853524846330790726472721527323463497803873992912643511478114677216542975827866670784383776733209931), SC_(0.2017277914841342592485273620552340873414893024060238883900212727621712952484924758384676390403035419e122), SC_(0.5146475153669209273527278472676536502196126007087356488521885322783457024172133329215616223266790069) }}, 
      {{ SC_(82.434051513671875), SC_(84.434051513671875), SC_(0.1565123939362769475080542093432274593734265105911379115094644617192419784217256374202003624400390253e122), SC_(0.3992940886866783975414617111701057707494087359436857749747862726679760264831560352701675002487737709), SC_(0.2354603358656171930526675119579586251114093257059818371480333169684160427937052979266868905705449473e122), SC_(0.6007059113133216024585382888298942292505912640563142250252137273320239735168439647298324997512262291) }}, 
      {{ SC_(82.434051513671875), SC_(164.86810302734375), SC_(0.1738090887882876028946588574601746951600230312232219029923852247355357987239161631839663686179511776e110), SC_(0.443421380043790231228546841504518339061110443791415012729701037042423965868047423037588575690438944e-12), SC_(0.3919727298017203314719334336982914256273756616019597256262745567846656359906953995481633368474000062e122), SC_(0.9999999999995565786199562097687714531584954816609388895562085849872702989629575760341319525769624114) }}, 
      {{ SC_(82.434051513671875), SC_(8243.4052734375), SC_(0.6971392368408637469166147868026636930902825591766794678364263839891375076450310438880031744617769396e-3261), SC_(0.1778540147915909791649937511258041695399928890097942907640478290609899239403032100662605389814460253e-3382), SC_(0.3919727298018941405607217213011860844848358362971197486574977786876580212154309353468872530105839726e122), SC_(1) }}, 
      {{ SC_(83.58335113525390625), SC_(0.835833489894866943359375), SC_(0.6250104983253024354353258195270149601601580964177967772953464029665832309826066468765017864561227479e124), SC_(1), SC_(0.1620705241071594842570781310748864675248805746649472958871212345120860755644227650609100156095285155e-8), SC_(0.2593084828837639831866475426102194444538793153141880945736024613385237932061159355960015751687711728e-132) }}, 
      {{ SC_(83.58335113525390625), SC_(41.791675567626953125), SC_(0.6250104931313099839582598620334167977407873554242404310308676816768881037822397032441599993948453017e124), SC_(0.9999999916897516675412355459789302888889234159107027372328653716787524776515947724357309935712894211), SC_(0.5193992451477065957493598162419370740993556346264478721289695127200366943632341787061277446254741865e116), SC_(0.8310248332458764454021069711111076584089297262767134628321247522348405227564269006428710578919333882e-8) }}, 
      {{ SC_(83.58335113525390625), SC_(81.58335113525390625), SC_(0.3581236110580169435832374882697090836972635304200401188299253553682961011486821393884617022010927607e124), SC_(0.5729881530271872360260808321553573713909584341534538894126379779413255242769888734719038057412039819), SC_(0.2668868872672854918520883312573058764628945659977566584654210475982871298339245074880400842550299872e124), SC_(0.4270118469728127639739191678446426286090415658465461105873620220586744757230111265280961942587960181) }}, 
      {{ SC_(83.58335113525390625), SC_(83.58335113525390625), SC_(0.3034135652832531838128378741720513582025399432760641793461592013625401679615163818012854790001902296e124), SC_(0.4854535501343434421215288303351099254965391999814215447250813059693329765669362512112092267673308653), SC_(0.3215969330420492516224879453549636019576181531417325979491872016040430630210902650752163074559325184e124), SC_(0.5145464498656565578784711696648900745034608000185784552749186940306670234330637487887907732326691347) }}, 
      {{ SC_(83.58335113525390625), SC_(85.58335113525390625), SC_(0.249982067272088810012029790513346187111716303011738104780587897355003882160116348680389821774479704e124), SC_(0.3999645893019533809881934059957907297669017694037782697271849104891869077217330235130825727265587632), SC_(0.3750284310532136254232960290136687730484417934060586725147585056115793488224902981961119646816430439e124), SC_(0.6000354106980466190118065940042092702330982305962217302728150895108130922782669764869174272734412368) }}, 
      {{ SC_(83.58335113525390625), SC_(167.1667022705078125), SC_(0.1934974439668089150887715042154903985179484067469905242772479737610784086113668275607824017966298629e112), SC_(0.3095907100525186748471789218381523593198857249530897243372246918365126669665960352697245664667276552e-12), SC_(0.6250104983251089379913590106119261886559426060192788288885994124423059830088455684678904196285619655e124), SC_(0.9999999999996904092899474813251528210781618476406801142750469102756627753081634873330334039647302754) }}, 
      {{ SC_(83.58335113525390625), SC_(8358.3349609375), SC_(0.845969400365979574886862550187705991723284070666786457986127293036604310791457131354517548720033525e-3306), SC_(0.1353528304936845270173779455432921521105980011190597363844957855384842224786658781328124162824819356e-3429), SC_(0.6250104983253024354353258195270149601601580964177967772953464029665832309826066468765017864561227479e124), SC_(1) }}, 
      {{ SC_(84.98836517333984375), SC_(0.84988367557525634765625), SC_(0.3147499333307002189617876380154863465986945147349304831342953279964412492709090477424702755899928355e127), SC_(1), SC_(0.5037700606982246407274917999823031629613946019449361457173097271680094755563347755176211603063240909e-8), SC_(0.1600540643066397410823892957288058365712559930427241689451526132591528608330355588924111129711277525e-134) }}, 
      {{ SC_(84.98836517333984375), SC_(42.494182586669921875), SC_(0.3147499313525519491543202519411381298495260096093970818260315763781959485610432070851745016045700028e127), SC_(0.9999999937151749362594006926800487135537779853714980429323175210007925298585407679620892241967477558), SC_(0.1978148269807467386074348216749168505125533401308263751618245300709865840657295773985422832715776906e119), SC_(0.6284825063740599307319951286446222014628501957067682478999207470141459232037910775803252244198024714e-8) }}, 
      {{ SC_(84.98836517333984375), SC_(82.98836517333984375), SC_(0.1801559510286215017373426984372473391996227289023760086582069127174569927367777175938093166187628581e127), SC_(0.572378043490595301972894223377929722934098278038486783216220553046121815520930888855461871595810152), SC_(0.1345939823020787172244449395782390073990717858325544744760884152789842565341313301486609589712299774e127), SC_(0.427621956509404698027105776622070277065901721961513216783779446953878184479069111144538128404189848) }}, 
      {{ SC_(84.98836517333984375), SC_(84.98836517333984375), SC_(0.1528344804497610641801952021604887581831110563535578434293847599694322108222850107445504601298248642e127), SC_(0.485574306029102585556874122974721418897921592282894779628645620022485996122895375194226905132274364), SC_(0.1619154528809391547815924358549975884155834583813726397049105680270090384486240369979198154601679713e127), SC_(0.514425693970897414443125877025278581102078407717105220371354379977514003877104624805773094867725636) }}, 
      {{ SC_(84.98836517333984375), SC_(86.98836517333984375), SC_(0.1261411865023788640662105876883702788729516312247114401234959866137087875891976831691333107483075437e127), SC_(0.400766364483532200081475145599909941911516053453166983810262672559866631259877897428134003516020265), SC_(0.1886087468283213548955770503271160677257428835102190430107993413827324616817113645733369648416852918e127), SC_(0.599233635516467799918524854400090058088483946546833016189737327440133368740122102571865996483979735) }}, 
      {{ SC_(84.98836517333984375), SC_(169.9767303466796875), SC_(0.6281449624315834685133457201334404613436484734128638105709409720434543386911579482443896405013115509e114), SC_(0.1995695299390600969639804956282709060088505668835089824363202651524365647992937982247541867155333347e-12), SC_(0.3147499333306374044655444796686350120266811706887961182869540416153841551737047023086011597951683965e127), SC_(0.9999999999998004304700609399030360195043717290939911494331164910175636797348475634352007062017752458) }}, 
      {{ SC_(84.98836517333984375), SC_(8498.8369140625), SC_(0.1063698418444666347303177736786561475611653701802904162134794938298514958093962015776179400470636075e-3360), SC_(0.3379503236707802212437127054555506777027031449520524797100186373923287140445333930895315220141500838e-3487), SC_(0.3147499333307002189617876380154863465986945147349304831342953279964412492709090477424702755899928355e127), SC_(1) }}, 
      {{ SC_(87.306671142578125), SC_(0.873066723346710205078125), SC_(0.9518419603985717251524124396281547643233687475892451516078558510838563262744434280250717539531071e131), SC_(1), SC_(0.3444665049805299555904214747446838109733569884695338910567345224298504802504651096927727802743413352e-7), SC_(0.361894641455277916117689957869366844910494857771453540375396899891083126896658179984310187752512426e-138) }}, 
      {{ SC_(87.306671142578125), SC_(43.6533355712890625), SC_(0.9518419566246364089070974429717785557913466804027507821050077799056290790209905247233466628055053788e131), SC_(0.9999999960351240297653745573638963429547114221552042067021107518679323938467111062268547751267021326), SC_(0.377393531624531499665637620853202206718649436950284807117822724725345290330172509114760172120068062e123), SC_(0.3964875970234625442636103657045288577844795793297889248132067606153288893773145224873297867374630362e-8) }}, 
      {{ SC_(87.306671142578125), SC_(85.306671142578125), SC_(0.5438862635650597072124788098804889549618986852575264817794776912368300986980621067629603985757404489e131), SC_(0.5714039580029800807607960597771937634408631261196635414408653414781069849503330518337299290121027795), SC_(0.4079556968335120179399336297476658093614700623317186698283781598470262275763813212621113553773666511e131), SC_(0.4285960419970199192392039402228062365591368738803364585591346585218930150496669481662700709878972205) }}, 
      {{ SC_(87.306671142578125), SC_(87.306671142578125), SC_(0.4623735516545633866666434492710255947551328417022223265415705967753075885286439440423807818862388083e131), SC_(0.4857671450636094437739206652220028766245688155739812735916408232048659280970276933633550515173341512), SC_(0.4894684087440083384857689903571291695682359058870228250662852543085487377457994839826909720668682917e131), SC_(0.5142328549363905562260793347779971233754311844260187264083591767951340719029723066366449484826658488) }}, 
      {{ SC_(87.306671142578125), SC_(89.306671142578125), SC_(0.3826863314368711658651004534517857991024957793334872733048948216643563079750870152933643039315212161e131), SC_(0.4020481837936900025462790487630907951043397778955163010314690473309731672604280404562679413053620109), SC_(0.5691556289617005592873119861763689652208729682557578783029610294195000182993564127317074500215858839e131), SC_(0.5979518162063099974537209512369092048956602221044836989685309526690268327395719595437320586946379891) }}, 
      {{ SC_(87.306671142578125), SC_(174.61334228515625), SC_(0.9207203614216600978544808864347204705726423037068411206005513293690692640374769046533509946653880101e118), SC_(0.9673038169446954689708365548049206661691020733405680626494102470392406443497039014353203890007683255e-13), SC_(0.9518419603984796531162702736183693162347252755421878873774851669717962711415065210986680062626417649e131), SC_(0.999999999999903269618305530453102916344519507933383089792665943193735058975296075935565029609856468) }}, 
      {{ SC_(87.306671142578125), SC_(8730.6669921875), SC_(0.2900680930222122849220593513096194237825422669823092219730282066065468410747117442141400569012612992e-3451), SC_(0.3047439649548019054342147699253553733423211260822116004436472943020783007376126326014215871614523081e-3582), SC_(0.9518419603985717251524124396281547643233687475892451516078558510838563262744434280250717539531071e131), SC_(1) }}, 
      {{ SC_(87.9038543701171875), SC_(0.8790385723114013671875), SC_(0.1371285032812039464480184999742857673623282854122807058809312584589041795081406375743904552589834206e133), SC_(1), SC_(0.5709879014692858253347111310497184413188089827705203023424448448568530961664223775136110426007124725e-7), SC_(0.4163889255747098282303311497518099096868480856856128406321071889608203808709552473806937114702314829e-139) }}, 
      {{ SC_(87.9038543701171875), SC_(43.95192718505859375), SC_(0.1371285027983173096599530941847462304610727509616393075570542711013150684667575002037351001436241044e133), SC_(0.9999999964785830426674382910848986147126693070711280529410030882652030874834782169866712480061112024), SC_(0.4828866367880654057895395369012555344506413983238769873575891110413831373706553551153593162153278437e124), SC_(0.3521416957332561708915101385287330692928871947058996911734796912516521783013328751993888797603058565e-8) }}, 
      {{ SC_(87.9038543701171875), SC_(85.9038543701171875), SC_(0.7832222598482130672447231100378495419106963194909353147066608621749661991613725095396987935415369226e132), SC_(0.5711593440512440008668432644019009783945909058868876544173629887930429201021875761334930531866429801), SC_(0.5880627729638263972354618897050081317125865346318717441026517224140755959200338662042057590482972838e132), SC_(0.4288406559487559991331567355980990216054090941131123455826370112069570798978124238665069468133570199) }}, 
      {{ SC_(87.9038543701171875), SC_(87.9038543701171875), SC_(0.6661916327413937628868335220025218223927200190567384422699260902783641913047586513236178740915473937e132), SC_(0.4858155794023808319033656578769031457527172423192857266560807668904272854930526046673868007298039101), SC_(0.7050934000706457015933514777403358512305628350660686165393864943106776037766477244202866784982868126e132), SC_(0.5141844205976191680966343421230968542472827576807142733439192331095727145069473953326131992701960899) }}, 
      {{ SC_(87.9038543701171875), SC_(89.9038543701171875), SC_(0.5517645173124902285443461675305113809686016138028377782551712527793577824048543664882386138507288235e132), SC_(0.4023704073988241260096618308614479419843506170244029548189011549335569096330748008932018722641401952), SC_(0.8195205154995492359358388322123462926546812403199692805541413318096840126765520092556659387391053829e132), SC_(0.5976295926011758739903381691385520580156493829755970451810988450664430903669251991067981277358598048) }}, 
      {{ SC_(87.9038543701171875), SC_(175.807708740234375), SC_(0.1100758471671216571874904945348343816940499403471959777458028574251205738678312487341657941463745706e120), SC_(0.8027204011801507997304939786302172819890582139869213641050430314818326775172541565634952968684280417e-13), SC_(0.1371285032811929388633017878085670183128748019741113008868965388611295992223981255170036721341100041e133), SC_(0.9999999999999197279598819849200269506021369782718010941786013078635894956968518167322482745843436505) }}, 
      {{ SC_(87.9038543701171875), SC_(8790.3857421875), SC_(0.1373358261999490763947814039173620510502254439109454275065495374964786861642938022896809167507932816e-3474), SC_(0.1001511887855437181540785413588061699802838236144406958135167813072890198184454198262171479956051549e-3606), SC_(0.1371285032812039464480184999742857673623282854122807058809312584589041795081406375743904552589834206e133), SC_(1) }}, 
      {{ SC_(90.6262969970703125), SC_(0.90626299381256103515625), SC_(0.2760991447905968099998244747627223571445600955649976457020917582719042855651229604588354402394909185e138), SC_(1), SC_(0.6019880277243076263303088644058669531254501971762422813432732070535195078709052929761867895611137917e-6), SC_(0.2180332822765084168150556254968300997146974845353508933974624745328612653465345298480537267656177249e-143) }}, 
      {{ SC_(90.6262969970703125), SC_(45.31314849853515625), SC_(0.27609914422427419059678759953644914563405258716380905745373799758045973183356615523965970260547371e138), SC_(0.9999999979488432684840235995803165725301339377839249756053611971133056964406789109650144087975625962), SC_(0.5663226194030368752262732115105075084011885882483537606914445537315568052191757376340172084253521505e129), SC_(0.205115673151597640041968342746986606221607502439463880288669430355932108903498559120243740380039977e-8) }}, 
      {{ SC_(90.6262969970703125), SC_(88.6262969970703125), SC_(0.1573972774410437243260839260751180196316095514391650415020344615818868314804255719759245145956408335e138), SC_(0.5700752081663247869026412581421822741046403825044177107787477971783452665951230853182864209034778601), SC_(0.1187018673495530856737405486876043375129505441258326042000572966900174540846973884829109256438500849e138), SC_(0.4299247918336752130973587418578177258953596174955822892212522028216547334048769146817135790965221399) }}, 
      {{ SC_(90.6262969970703125), SC_(90.6262969970703125), SC_(0.1341925450276609640170078763714683523929425593225370960775740050971261681521806683859312208385957931e138), SC_(0.4860302813666346390600522864190792796549723292306669551047023898310899932900183728856710939530385156), SC_(0.1419065997629358459828165983912540047516175362424605496245177531747781174129422920729042194008951254e138), SC_(0.5139697186333653609399477135809207203450276707693330448952976101689100067099816271143289060469614844) }}, 
      {{ SC_(90.6262969970703125), SC_(92.6262969970703125), SC_(0.1114888614894672880829858090681039497513255322634145649762690156709095145750230643814102952869464243e138), SC_(0.4038000971499724004888563318451891954737695059747291944183013638969006249799930855173241849102317202), SC_(0.1646102833011295219168386656946184073932345633015830807258227426009947709900998960774251449525444942e138), SC_(0.5961999028500275995111436681548108045262304940252708055816986361030993750200069144826758150897682798) }}, 
      {{ SC_(90.6262969970703125), SC_(181.252593994140625), SC_(0.9472987548437135960848890047517963685870652895575465108730541290562109617810394792612864516074885327e124), SC_(0.3431009377309654126650940644543544134331402222913932505843644459157220461586687601110515226127371097e-13), SC_(0.2760991447905873370122760376267615082545125776013117750491961828067955550238323983492176298446983056e138), SC_(0.9999999999999656899062269034587334905935545645586566859777708606749415635554084277953841331239888948) }}, 
      {{ SC_(90.6262969970703125), SC_(9062.6298828125), SC_(0.6733028142738727433504501682917135782256407253133656103286819407569504188555592492380068166999921889e-3581), SC_(0.2438626946072321249232337351711433472875255405825154438607198482931327220334100404279311997235593699e-3718), SC_(0.2760991447905968099998244747627223571445600955649976457020917582719042855651229604588354402394909185e138), SC_(1) }}, 
      {{ SC_(91.38089752197265625), SC_(0.913809001445770263671875), SC_(0.8271168156063419272868148980100652099723865498989358104433664836039747851793965147343675354069691111e139), SC_(1), SC_(0.1173636078351168206677101705950664637888626864853100709679175198025117529332896905828075540319696747e-5), SC_(0.1418948395446174434093368946299219675183068818320376708786350068506630821483216296151085550477636149e-144) }}, 
      {{ SC_(91.38089752197265625), SC_(45.690448760986328125), SC_(0.8271168141457145530395582905968771952783065228432161516797903162781041165098848330657599964885380586e139), SC_(0.999999998234073655996823828876283579453180682132814964643137071144932588040496076626575687002086842), SC_(0.1460627374247256607413188014694080027055719658763576167325870668669511681668607538918431052500131316e131), SC_(0.1765926344003176171123716420546819317867185035356862928855067411959503923373424312997913158035198356e-8) }}, 
      {{ SC_(91.38089752197265625), SC_(89.38089752197265625), SC_(0.4712774108857810132297461337187371451535619618564149339790566898887987638670873863076061196698768235e139), SC_(0.5697833752059525756000770780016692346602869050037441575140215928495581860269599601718853476693324499), SC_(0.3558394047205609140570687642913280648188245880425208764643097937151760213123091284267614157370922876e139), SC_(0.4302166247940474243999229219983307653397130949962558424859784071504418139730400398281146523306675501) }}, 
      {{ SC_(91.38089752197265625), SC_(91.38089752197265625), SC_(0.4020516304974041869331300333192498158943724369343195686818219020453063245746597843699157988075491434e139), SC_(0.4860880868474044981456629314350169340905142835482453857382763436371358817909281373111745265180121052), SC_(0.4250651851089377403536848646908153940780141129646162417615445815586684606047367303644517365994199677e139), SC_(0.5139119131525955018543370685649830659094857164517546142617236563628641182090718626888254734819878948) }}, 
      {{ SC_(91.38089752197265625), SC_(93.38089752197265625), SC_(0.3343085304178820728370368129959118333262701588219830817687394527297239830908937405585383246554379356e139), SC_(0.4041853872512645340790677210377141135565046684607601842820224129177111740962517595911118837242360801), SC_(0.4928082851884598544497780850141533766461163910769527286746270308742508020885027741758292107515311755e139), SC_(0.5958146127487354659209322789622858864434953315392398157179775870822888259037482404088881162757639199) }}, 
      {{ SC_(91.38089752197265625), SC_(182.7617950439453125), SC_(0.2242347883104259437001784511984710777882398779126640010013852032385948064536430991705623094015407603e126), SC_(0.2711041343610504888312244980890428719957989769344600100872958766626703931015703696110789010156216201e-13), SC_(0.8271168156063195038079838554156951921272667027911569864555752172038746466590726552537221710970520549e139), SC_(0.9999999999999728895865638949511168775501910957128004201023065539989912704123337329606898429630388921) }}, 
      {{ SC_(91.38089752197265625), SC_(9138.08984375), SC_(0.2333405346524099127624255741241154919994013551962445138669378665084206519458809297303162487523163497e-3610), SC_(0.2821131553000199596532769712641041750655436227808082779084539017881929532379149155438559785602743135e-3749), SC_(0.8271168156063419272868148980100652099723865498989358104433664836039747851793965147343675354069691111e139), SC_(1) }}, 
      {{ SC_(91.61568450927734375), SC_(0.916156828403472900390625), SC_(0.2385189268132603569055279026036546112395915526413302413256263736409617454186115678115986264026363563e140), SC_(1), SC_(0.1446453859717900429097782132177879063240359542688517946884893813623675812971708328130670459279510702e-5), SC_(0.6064314807396179557035601629002116264656254440473100721390435473282140291122761398197827485200985883e-145) }}, 
      {{ SC_(91.61568450927734375), SC_(45.807842254638671875), SC_(0.238518926411223458160612352089912267170034206878002477834678957797293691968846083000679646512203263e140), SC_(0.9999999983144444589100654864475953588852510830926201772112214743526110376318694859429160128628401535), SC_(0.4020368987449155505137423440695573457633277634909474158436680534497654848109189798904330932519000524e131), SC_(0.1685555541089934513552404641114748916907379822788778525647388962368130514057083987137159846524333654e-8) }}, 
      {{ SC_(91.61568450927734375), SC_(89.61568450927734375), SC_(0.1358826381378452566845392283014301020453500944370103332851395912117357312092954675420960016948060605e140), SC_(0.5696933151314636889402717210561072807102313699205187508039606407930233958262280151724194046635621987), SC_(0.1026362886754151002209886743022245091942414582043199080404867824292260142093161002695026247078302958e140), SC_(0.4303066848685363110597282789438927192897686300794812491960393592069766041737719848275805953364378013) }}, 
      {{ SC_(91.61568450927734375), SC_(91.61568450927734375), SC_(0.1159454639386415140701919344785711101504330716079660400352039529819548657858671453762086107583345204e140), SC_(0.4861059266354018157904697733562905256389065862860975026641924934910029520357672026469138595111939714), SC_(0.1225734628746188428353359681250835010891584810333642012904224206590068796327444224353900156443018359e140), SC_(0.5138940733645981842095302266437094743610934137139024973358075065089970479642327973530861404888060286) }}, 
      {{ SC_(91.61568450927734375), SC_(93.61568450927734375), SC_(0.9643423388279861618669781781438069099799900832275488185133844003057310316651022224454395076022114872e139), SC_(0.4043043257455969591796033043242189888972541916103391582990723897824397271660015256348028906827695693), SC_(0.1420846929304617407188300847892739202415925443185753594742879336103886422521013455670546756424152076e140), SC_(0.5956956742544030408203966956757810111027458083896608417009276102175602728339984743651971093172304307) }}, 
      {{ SC_(91.61568450927734375), SC_(183.2313690185546875), SC_(0.6009474554939568385244398976364296982229594888929610986392548338715402504612508893799738676511000755e126), SC_(0.2519495888745326284176734984445699726983809622642543662087476024883228942742565203028678570088077873e-13), SC_(0.2385189268132543474309729630352693668406151883443480117307374440299753528702728524090940138937425565e140), SC_(0.9999999999999748050411125467371582326501555430027301619037735745633791252397511677105725743479697132) }}, 
      {{ SC_(91.61568450927734375), SC_(9161.568359375), SC_(0.1593456530256608853233064269366703549460168956394397898165810210118554235782690081080923322853894046e-3619), SC_(0.6680629296576313978312502326105659086966784471453663663580446490696325479332881389705279818795240907e-3759), SC_(0.2385189268132603569055279026036546112395915526413302413256263736409617454186115678115986264026363563e140), SC_(1) }}, 
      {{ SC_(92.12703704833984375), SC_(0.9212703704833984375), SC_(0.2399876453932557709035963058340481135622175286808518995946642268081351389373379385408490973122764218e141), SC_(1), SC_(0.2285161460865770312684052016459511707861475065482028014778375841615432664705606506253415139167093647e-5), SC_(0.9521996255770543248507019797080309969664705034667222929863386994113202258092320333410356802674857838e-146) }}, 
      {{ SC_(92.12703704833984375), SC_(46.063518524169921875), SC_(0.2399876450277638485757886841159475759421222612629946380212164618188833289937115257074378242460809734e141), SC_(0.9999999984770385920121252110149154360487429041767187470002014110363695240033054408199869788510190661), SC_(0.3654919223278076217181005376200952674178572615734477649892518099436264128334112730661954483695002139e132), SC_(0.1522961407987874788985084563951257095823281252999798588963630475996694559180013021148980933924946507e-8) }}, 
      {{ SC_(92.12703704833984375), SC_(90.12703704833984375), SC_(0.1366725728706164496211607713524598709187956968742644666129730537246230023910500337211476317361295124e141), SC_(0.5694983699959134525449270791074549310207375095754663587823908208016178743877145827913884183431730345), SC_(0.1033150725226393212824355344815882426434218318065874329816911730835121365462879048197014655761469094e141), SC_(0.4305016300040865474550729208925450689792624904245336412176091791983821256122854172086115816568269655) }}, 
      {{ SC_(92.12703704833984375), SC_(92.12703704833984375), SC_(0.1166686845219986488818554224472973818313047319415121068610232864695809611388847169895474560281645051e141), SC_(0.48614454436110451151996468540273911446245403663453944005499929830226081967028024171591317527262112), SC_(0.1233189608712571220217408833867507317309127967393397927336409403385541777984532215513016412841119167e141), SC_(0.51385545563889548848003531459726088553754596336546055994500070169773918032971975828408682472737888) }}, 
      {{ SC_(92.12703704833984375), SC_(94.12703704833984375), SC_(0.9708984381984547719038796803494227312344065442236234380066800099772773805997925825317171993463153688e140), SC_(0.4045618417596005754006107404734865361987804155104383914748224604608107016638010596702460973672671963), SC_(0.1428978015734102937132083377991058404387768742584895557939962258104074008773586802876773773776448849e141), SC_(0.5954381582403994245993892595265134638012195844895616085251775395391892983361989403297539026327328037) }}, 
      {{ SC_(92.12703704833984375), SC_(184.2540740966796875), SC_(0.5154654025170943048379933630072361646831059286893631784471351458822835474658284543943173832619619619e127), SC_(0.2147883078199408511675238699806345305806230493370052347091621201654187458303302006729866476491097872e-13), SC_(0.2399876453932506162495711348909997336285874563192050685353773331763506675858791157053744390277324786e141), SC_(0.9999999999999785211692180059148832476130019365469419376950662994765290837879834581254169669799327013) }}, 
      {{ SC_(92.12703704833984375), SC_(9212.7041015625), SC_(0.1740260185610722150132898864030278176879091468564177201588954956804257120622731650947061696398860464e-3639), SC_(0.7251457393813105181120231572651733738519794464115866097010846557465806558180663021583787844775357479e-3780), SC_(0.2399876453932557709035963058340481135622175286808518995946642268081351389373379385408490973122764218e141), SC_(1) }}, 
      {{ SC_(93.4323272705078125), SC_(0.934323251247406005859375), SC_(0.8814967134478776682875380788820907155756713245915086236629259348723005585824778198786951082475439305e143), SC_(1), SC_(0.7439264291879768548103199400435278012420110051886328485273432417984741385778097874396393306578837987e-5), SC_(0.8439355675850341606610333856828111362005601766448654572199934359421580463125806995716505409098085548e-148) }}, 
      {{ SC_(93.4323272705078125), SC_(46.71616363525390625), SC_(0.8814967124115816644428110120532236990775480938286720383273278139949431476870563194223429740319097179e143), SC_(0.9999999988243903941611206237710406412358805844735764378231693011616242798809704624019090670629683518), SC_(0.103629600384472706682886701649812323076283658533559812087735741089542150045635213421563421265495188e135), SC_(0.1175609605838879376228959358764119415526423562176830698838375720119029537598090932937031648150732343e-8) }}, 
      {{ SC_(93.4323272705078125), SC_(91.4323272705078125), SC_(0.5015787454101221129295525920738692750796895112434379522282892305449693416283657589264175830475498272e143), SC_(0.569008072019068441378141224129859484843913549106268473388321108632746869660168361088019147327254114), SC_(0.3799179680377555553579854868082214404959818133480706714346367043273312169541120609522775251999941033e143), SC_(0.430991927980931558621858775870140515156086450893731526611678891367253130339831638911980852672745886) }}, 
      {{ SC_(93.4323272705078125), SC_(93.4323272705078125), SC_(0.4286204421291983901657204887758065580849070272358778008816834971857064031129186504368326875862846622e143), SC_(0.486241679169394248977891557118270927040069031656068991568797425507919067660955199856740555894381588), SC_(0.4528762713186792781218175901062841574907642973556308227812424376865941554695591694418624206612592683e143), SC_(0.513758320830605751022108442881729072959930968343931008431202574492080932339044800143259444105618412) }}, 
      {{ SC_(93.4323272705078125), SC_(95.4323272705078125), SC_(0.3571911708923214852825956235373317199244122044271645894800192401985153692143479124758817967531471405e143), SC_(0.4052098725305593197447557452013893919656732535974720385317845783769326496469985662908191758457480378), SC_(0.52430554255555618300494245534475899565125912016434403418290669467378518936812990740281331149439679e143), SC_(0.5947901274694406802552442547986106080343267464025279614682154216230673503530014337091808241542519622) }}, 
      {{ SC_(93.4323272705078125), SC_(186.864654541015625), SC_(0.1259953718851497422185155838432709775415377681234627891274319482880983197650512335906366190780121108e130), SC_(0.1429334562035207942219561580292535457466577078886806996466399874934997762978014383761464213682159646e-13), SC_(0.8814967134478650687503495639078688640172869974937544698861135885933878153876490100467186031241848669e143), SC_(0.9999999999999857066543796479205778043841970746454253342292111319300353360012506500223702198561623854) }}, 
      {{ SC_(93.4323272705078125), SC_(9343.232421875), SC_(0.1960314045329095653874896587430064105960842290239001554238513241670632927461577447737697784737955613e-3690), SC_(0.2223847253680098670168278676241422662084837978009286299217324300789098229947253471418167411428882428e-3833), SC_(0.8814967134478776682875380788820907155756713245915086236629259348723005585824778198786951082475439305e143), SC_(1) }}, 
      {{ SC_(95.04709625244140625), SC_(0.950470983982086181640625), SC_(0.1347151497701627838023004899030991007135183961667830130160321116038462511703415545257334974334882037e147), SC_(1), SC_(0.3286612795944616265711661159620158180111738426278486839585148422911814462000818729717402563514602976e-4), SC_(0.2439675716912239653605419199699105800940081390120250957910020333139694222067332074038136544243711667e-150) }}, 
      {{ SC_(95.04709625244140625), SC_(47.523548126220703125), SC_(0.134715149655174837158908365734295756525909899321280250267181720062970685562896010218651352005874697e147), SC_(0.9999999991464364116465534636328681416670507850803823863855186962459346530413634417636243160462913207), SC_(0.114987946643392124168803344187608496845502762748850391540875565607445544307082145427613506749351943e138), SC_(0.8535635883534465363671318583329492149196176136144813037540653469586365582363756839537086792727480771e-9) }}, 
      {{ SC_(95.04709625244140625), SC_(93.04709625244140625), SC_(0.7657419898087756918044401927859150010110236627212083718551073992050834278986980247942861154148661996e146), SC_(0.5684156467295670833457314748182583026711347615029028702386864296192251088564944072740070382355011149), SC_(0.5814095078928521462185647062450760061241602989466217583052137168333790838047175204630488589200158375e146), SC_(0.4315843532704329166542685251817416973288652384970971297613135703807748911435055927259929617644988851) }}, 
      {{ SC_(95.04709625244140625), SC_(95.04709625244140625), SC_(0.6551993414891400584657331890429218727010636138597867246040294498234147999757611336129285742445526427e146), SC_(0.4863590640005776572938148287895322447425672342498795296867376257066880031162988779311197928274050768), SC_(0.6919521562124877795572717099880691344341203478080434055562916662150477117276544116444064000903293943e146), SC_(0.5136409359994223427061851712104677552574327657501204703132623742933119968837011220688802071725949232) }}, 
      {{ SC_(95.04709625244140625), SC_(97.04709625244140625), SC_(0.5469348543810198898788108400219066674055519288845905559098385193141874425095257183053365380552173915e146), SC_(0.4059935763083396511879930219600213943088317540084712903484937176675430142752990570780958626728778976), SC_(0.8002166433206079481441940590090843397296320327832395742504825967242750691938898269519984362796646455e146), SC_(0.5940064236916603488120069780399786056911682459915287096515062823324569857247009429219041373271221024) }}, 
      {{ SC_(95.04709625244140625), SC_(190.0941925048828125), SC_(0.1163565210751933735917713115824884295377410943134003957027515756150491650147536720126667740467403185e133), SC_(0.8637226122949718303297924930807240476707255995627851606738122984246652433596622525296156940282444593e-14), SC_(0.134715149770161620237089737969363183000402571282487635605088977599889223654585404034083349896768077e147), SC_(0.9999999999999913627738770502816967020750691927595232927440043721483932618770157533475664033774747038) }}, 
      {{ SC_(95.04709625244140625), SC_(9504.7099609375), SC_(0.1882910792556985454022291750937049650277749642926213574473710789217539816042178440456911801998452087e-3753), SC_(0.1397697880134057195925378652333761731239724208573611460809672748666332725027162330835038869860775248e-3899), SC_(0.1347151497701627838023004899030991007135183961667830130160321116038462511703415545257334974334882037e147), SC_(1) }}, 
      {{ SC_(95.7381134033203125), SC_(0.95738112926483154296875), SC_(0.3131256477376182698644958520288062730120597952997735383909639369911279332348153218599580667846002149e148), SC_(1), SC_(0.6259638796335379154132491067850054630581491227431517134904320208680904887791967705070062451309013877e-4), SC_(0.1999082106995146361595919566373510363928443455250615728995542441899260700897608092918146555224762139e-151) }}, 
      {{ SC_(95.7381134033203125), SC_(47.86905670166015625), SC_(0.3131256475045529369814942168364075834643974857802806071524605507825921146892747325138071613543204894e148), SC_(0.9999999992556811153384110140909467483022561115010639504399530543910037541382647473365746503693152161), SC_(0.2330653328830016351923986895476623095194929312385033862085358185455405893461509054302797255478092976e139), SC_(0.7443188846615889859090532516977438884989360495600469456089962458617352526634253496306847838730929468e-9) }}, 
      {{ SC_(95.7381134033203125), SC_(93.7381134033203125), SC_(0.1779075806560239984812940622982116868384319330920774575055611294206390996442651224588361381273713192e148), SC_(0.5681667469318916109572248335985115949990266831109569692342841499116304801664564362997469459285025136), SC_(0.1352180670815942713832017897305945861736278622076960808854028075704888335905501994011219286572288958e148), SC_(0.4318332530681083890427751664014884050009733168890430307657158500883695198335435637002530540714974864) }}, 
      {{ SC_(95.7381134033203125), SC_(95.7381134033203125), SC_(0.1523069413357484754374655843484772981270197064005375713583089713574349155157906826494491640806102121e148), SC_(0.486408387291778633373088719439421104518278577765243274560857715290013748197857083438047466237509057), SC_(0.1608187064018697944270302676803289748850400888992359670326549656336930177190246392105089027039900028e148), SC_(0.513591612708221366626911280560578895481721422234756725439142284709986251802142916561952533762490943) }}, 
      {{ SC_(95.7381134033203125), SC_(97.7381134033203125), SC_(0.1272301724542666352897305399682160778528059289031360213001123841522621279128773634522821199701337433e148), SC_(0.4063230635162737729139607119689733600039122115886902710738823918667641280750498841296328319592011901), SC_(0.1858954752833516345747653120605901951592538663966375170908515528388658053219379584076759468144664717e148), SC_(0.5936769364837262270860392880310266399960877884113097289261176081332358719249501158703671680407988099) }}, 
      {{ SC_(95.7381134033203125), SC_(191.476226806640625), SC_(0.2180196622498523257301542686260743105073414249254762792124539563440049600216553340937756140491204197e134), SC_(0.6962689381246105216999019579043882106585794758815525099073918717235018946643874538994431733526895434e-14), SC_(0.3131256477376160896678733535055489714693735345566684649767146822283358086952518818103578502312592772e148), SC_(0.9999999999999930373106187538947830009804209561178934142052411844749009260812827649810533561254610056) }}, 
      {{ SC_(95.7381134033203125), SC_(9573.8115234375), SC_(0.2047732975618550995754113760724771754917001565403564547482936210611620508815755658679756315244336058e-3780), SC_(0.6539652661523390685549576910392316896310064392954560978721253545887258570329705975085945726161612243e-3928), SC_(0.3131256477376182698644958520288062730120597952997735383909639369911279332348153218599580667846002149e148), SC_(1) }}, 
      {{ SC_(95.7719268798828125), SC_(0.957719266414642333984375), SC_(0.3652849570149194338699061207330042214691456897036249830724716251190496625103977890988745608082955137e148), SC_(1), SC_(0.6460962117384378869279234146664704642368952870130778723019981523479582282998533951667994862931581714e-4), SC_(0.1768745740361953097953374286122383490316270159748731628068026014703218132734349114704652833259151599e-151) }}, 
      {{ SC_(95.7719268798828125), SC_(47.88596343994140625), SC_(0.3652849567448467119867724600565472535737109986173074600773479878919375666756425665914060545781570586e148), SC_(0.9999999992606519466606367634027247531235874725433591722307935837515353090377636417927730005937149443), SC_(0.2700727218831336606764569678954346910863175229951236372271120958347552225074685062301384551140417128e139), SC_(0.7393480533393632365972752468764125274566408277692064162484646909622363582072269994062850557420366691e-9) }}, 
      {{ SC_(95.7719268798828125), SC_(93.7719268798828125), SC_(0.2075383422095549687859377236939378107114657757302374892385421489967748556047972620384339732353374175e148), SC_(0.5681546371510678531694417944497217516827858752382429985455100325556076293298399603999204855166479129), SC_(0.1577466148053644650839683970390664107576799139733874938339294761222748069056005270604405875729580962e148), SC_(0.4318453628489321468305582055502782483172141247617570014544899674443923706701600396000795144833520871) }}, 
      {{ SC_(95.7719268798828125), SC_(95.7719268798828125), SC_(0.177678543462314010033087289241834056162334179822220833301232019405816572090901330642553819015097833e148), SC_(0.4864107871134070173635423726031997269295451919903017667180518041824731982418145023429873050756568583), SC_(0.1876064135526054238368188314911701653068115098814041497712396057132330904194964584563207417931976807e148), SC_(0.5135892128865929826364576273968002730704548080096982332819481958175268017581854976570126949243431417) }}, 
      {{ SC_(95.7719268798828125), SC_(97.7719268798828125), SC_(0.1484295597668667428775736535331630296681882535240900528013208803104929721032433830611157371241063034e148), SC_(0.4063390975084812857035843719225526404875919795108845743390067002160173730743997401102112392276590868), SC_(0.2168553972480526909923324671998411918009574361795349302711507448085566904071544060377588236841892103e148), SC_(0.5936609024915187142964156280774473595124080204891154256609932997839826269256002598897887607723409132) }}, 
      {{ SC_(95.7719268798828125), SC_(191.543853759765625), SC_(0.2516686336021675418611698546987653816499941105148260826852650065055606281718805886542475222521621197e134), SC_(0.6889652277465358933659581357101355310973981860453255196360638195856970852590291402046461472367230807e-14), SC_(0.3652849570149169171835700990575856097705987020498084831313664768582228098603327334925928420024089713e148), SC_(0.9999999999999931103477225346410663404186428986446890260181395467448036393618041430291474097085979535) }}, 
      {{ SC_(95.7719268798828125), SC_(9577.1923828125), SC_(0.9820446416400385471291120811359246173564396216628169581930201486009838862871880857921148673236349781e-3782), SC_(0.2688434392878457976004143846157690027486569442491400678476504825174714873928563405149730139047476491e-3929), SC_(0.3652849570149194338699061207330042214691456897036249830724716251190496625103977890988745608082955137e148), SC_(1) }}, 
      {{ SC_(95.9694976806640625), SC_(0.95969498157501220703125), SC_(0.8988904723156887356012107799441275312418593243208014880413139676615531337476793393561548314041286741e148), SC_(1), SC_(0.7775532350760850592566798483145674178911053960838610368804008889174502471471979934315644618187284575e-4), SC_(0.8650144361559210582330244822718418745008546595130323716668430638571407656273080012109137913565568591e-152) }}, 
      {{ SC_(95.9694976806640625), SC_(47.98474884033203125), SC_(0.8988904716766126166939975555980772170756885470646476971694580349494473886587007395701191314780083168e148), SC_(0.999999999289038944577030929194373674906775676461699355270804256922066870404743674860414668366488164), SC_(0.6390761189072132243460503141661707772561537908718559327121057450889785997860356999261203572380515485e139), SC_(0.710961055422969070805626325093224323538300644729195743077933129595256325139585331633511835971429417e-9) }}, 
      {{ SC_(95.9694976806640625), SC_(93.9694976806640625), SC_(0.5106453031401706958874686731877492178373397076855608964341605247495209661803158176596874047791691091e148), SC_(0.5680840089723778642741157291574694673861764928115673917849250989121876424663867840757203986146950236), SC_(0.3882451691755180397137421067563783134045196166352405916071534429120321675673635216964674266249595649e148), SC_(0.4319159910276221357258842708425305326138235071884326082150749010878123575336132159242796013853049764) }}, 
      {{ SC_(95.9694976806640625), SC_(95.9694976806640625), SC_(0.4372426036633443703152630474867006269870107139751057689321058911291692380395573600758055950897572711e148), SC_(0.4864247838081273436278930988607284813083308399111701394286159830005270322032526325715030490820724468), SC_(0.461647868652344365285947732457426904254848610345695719109208076532383895708121979280349236314371403e148), SC_(0.5135752161918726563721069011392715186916691600888298605713840169994729677967473674284969509179275532) }}, 
      {{ SC_(95.9694976806640625), SC_(97.9694976806640625), SC_(0.3653384090294889179570744023709294075670560020484027585130674878302772435343810853747166727161003022e148), SC_(0.4064326191914321662733597058118192064395549037294047488870574711565968218280688126274168958357045322), SC_(0.5335520632861998176441363775731981236748033222723987295282464798312758902132982539814381586880283718e148), SC_(0.5935673808085678337266402941881807935604450962705952511129425288434031781719311873725831041642954678) }}, 
      {{ SC_(95.9694976806640625), SC_(191.938995361328125), SC_(0.5822982328948006435737807281578419044014484020000974539379528698443953508191288602845044552763522951e134), SC_(0.647796645785670914908748603629668344694911658572068883553404827450404780697858124751787433931707515e-14), SC_(0.898890472315682912618881831937691793434577745901757473557293966687013754218980895402646640115525829e148), SC_(0.9999999999999935220335421432908509125139637033165530508834142793111644659517254959521930214187524821) }}, 
      {{ SC_(95.9694976806640625), SC_(9596.9501953125), SC_(0.1918665688322226928751168952668221825445953471936491301047602982841331358555390667766866403994938041e-3789), SC_(0.2134482172649389202229921939920421615942616969370868273660456787836678675297174122513258018418992707e-3937), SC_(0.8988904723156887356012107799441275312418593243208014880413139676615531337476793393561548314041286741e148), SC_(1) }}, 
      {{ SC_(96.50640869140625), SC_(0.965064108371734619140625), SC_(0.104081470313939383399980076902031575333837677123720840219590627347975340149583141194459192157858389e150), SC_(1), SC_(0.0001288878762553660822785032377974479083690693074294903312294189102239252761261013917864670292285100774), SC_(0.1238336428824492076943272225514118974368124534956402163253871707041926408739601180320656758054305306e-152) }}, 
      {{ SC_(96.50640869140625), SC_(48.253204345703125), SC_(0.1040814702474095423108915813336528582679041752720567555952742474621147139881304843425143166311848848e150), SC_(0.9999999993607907258764165207652036503181063662964695299747817400164165567516881173260046768811448106), SC_(0.6652984108908849556837871706593350185166408462431637988586062616145265685194487552667350419343486044e140), SC_(0.639209274123583479234796349681893633703530470025218259983583443248311882673995323118855189414108806e-9) }}, 
      {{ SC_(96.50640869140625), SC_(94.50640869140625), SC_(0.5910715674357945417470451356153752698081140399023623838202272541561170885950138267672895201167842354e149), SC_(0.5678931760408016974721714595963387241135092482003720131767831357439503875802461502575415599150064892), SC_(0.4497431357035992922527556334049404835302627313348460183756790193236363129008175851773024014617996549e149), SC_(0.4321068239591983025278285404036612758864907517996279868232168642560496124197538497424584400849935108) }}, 
      {{ SC_(96.50640869140625), SC_(96.50640869140625), SC_(0.5063174300669548712614426106251515093644403262825368921640208648071899359997799340395772196278629511e149), SC_(0.4864626033238742438159076952113745361558565753687473331434574974285942332471156794257793457918942406), SC_(0.5344972730724389627383581583951642439739364449546715100318854086725634654960514779050147019507209392e149), SC_(0.5135373966761257561840923047886254638441434246312526668565425025714057667528843205742206542081057594) }}, 
      {{ SC_(96.50640869140625), SC_(98.50640869140625), SC_(0.423284104382396379258562518066386682749446146111560308535351043846909564918271088757702137610426983e149), SC_(0.4066853620588283978244159358965841872554085124555466328379108912595676207745429642516172809905483357), SC_(0.6175305987569974547412382509539290705889306251256480936605552296328438365775603231868897839681569072e149), SC_(0.5933146379411716021755840641034158127445914875444533671620891087404323792254570357483827190094516643) }}, 
      {{ SC_(96.50640869140625), SC_(193.0128173828125), SC_(0.5702932063362658146497557220876501088111928008680285582303564940585735484128831116740249908317046183e135), SC_(0.5479296214937192369271195386717291116896000385171152183907175724591223930479007358565146607646451507e-14), SC_(0.104081470313938813106773740636216925578115589473612029026789759319417109793089082620910779274746715e150), SC_(0.9999999999999945207037850628076307288046132827088831039996148288478160928242754087760695209926414349) }}, 
      {{ SC_(96.50640869140625), SC_(9650.640625), SC_(0.216269920331202128905217701996341364898115068952132792986833613785485549214663818827074818564108093e-3810), SC_(0.2077890710794826402679973440509143849983478253598296757658625667957221367082380646538242723072631106e-3959), SC_(0.104081470313939383399980076902031575333837677123720840219590627347975340149583141194459192157858389e150), SC_(1) }}, 
      {{ SC_(96.78564453125), SC_(0.967856466770172119140625), SC_(0.3724598131294536343398109668923985859203747030194388497798578726261914387526477324667859085720360661e150), SC_(1), SC_(0.0001678332808908020943283293029069396846093850320834892198674110718905131575467436562237443072098180859), SC_(0.4506077567956822298823915943207680555295756301415503786556950504838393851394222930939928077870604193e-153) }}, 
      {{ SC_(96.78564453125), SC_(48.392822265625), SC_(0.3724598129041874996438790385291063679069971062343384641769258467456117251862533068311161864278702852e150), SC_(0.9999999993951934497222186964978425197646291015421062627878722716222847556072923788106589101179363935), SC_(0.2252661346959319283632922180133775967851003856029320258805797135663944256356697221441657809244158561e141), SC_(0.6048065502777813035021574802353708984578937372121277283777152443927076211893410898820636065283739553e-9) }}, 
      {{ SC_(96.78564453125), SC_(94.78564453125), SC_(0.211480655749212205044644869596991181812753161585398458122766247612689186207593992606806258457161397e150), SC_(0.5677945600958274005304991276982070488019463096449289389008115674613537863245697729052476184887262383), SC_(0.1609791573802414292951660972954074041076215414340403916570916250135022525450537398599796501148746692e150), SC_(0.4322054399041725994695008723017929511980536903550710610991884325386462136754302270947523815112737617) }}, 
      {{ SC_(96.78564453125), SC_(96.78564453125), SC_(0.181195049902318147388030211482786423576652183156515684528226096557957212220954664248061902665371483e150), SC_(0.486482147912535372774068981948366664439516605617168951033794949533390980017648272385497423008468406), SC_(0.1912647632271354869517807554096121623437225198629231652516317760682342265316930682187240059066645831e150), SC_(0.513517852087464627225931018051633335560483394382831048966205050466609019982351727614502576991531594) }}, 
      {{ SC_(96.78564453125), SC_(98.78564453125), SC_(0.1515226118176752313035688446512826968152502868958858183887041039841931003160098346291651851843612774e150), SC_(0.4068160012876648827327081524966805045583725025237251867284387154200792488593249977099978807408178945), SC_(0.2209372013117784030362421222411158891051244161235530313911537686419983384366378978376207233876747887e150), SC_(0.5931839987123351172672918475033194954416274974762748132715612845799207511406750022900021192591821055) }}, 
      {{ SC_(96.78564453125), SC_(193.5712890625), SC_(0.1870637842991391015010663648296748437142083884191977779539140467046472738549827752985732128679112928e136), SC_(0.5022388394801735521027847423222732342582714241511936352785317356020273036462226147007162693025195549e-14), SC_(0.3724598131294517637019679755013835752567264062710017076959736806484118996121806859940473587442830804e150), SC_(0.9999999999999949776116051982644789721525767772676574172857584880636472146826439797269635377738529928) }}, 
      {{ SC_(96.78564453125), SC_(9678.564453125), SC_(0.2758384386668010183377737823576817812230999605250417996275087054016893757744886753518863688699504654e-3821), SC_(0.7405857731312599312978054295970517318343436113957608079621190574526458812397822292104098270571378232e-3971), SC_(0.3724598131294536343398109668923985859203747030194388497798578726261914387526477324667859085720360661e150), SC_(1) }}, 
      {{ SC_(96.90234375), SC_(0.9690234661102294921875), SC_(0.6347320556272004652073982242536028194250409150692933065991408861790148561353721903119442930671763471e150), SC_(1), SC_(0.0001874583589201791437291983798768283723896698260731056267314507479603455787496827788278764167485788292), SC_(0.2953346333437423832394076485593320813165578729931174932400091818159549811163639584775345457776462517e-153) }}, 
      {{ SC_(96.90234375), SC_(48.451171875), SC_(0.6347320552520839867078549918104881900997296117067298120210355383146608245327375100050746281258299894e150), SC_(0.9999999994090160167995961646372182559459576153174360025635501679412890906560142831362803741195849695), SC_(0.3751164784995432324431146293253113033625634945781053478643540316026346803068696649413463576981119521e141), SC_(0.5909839832004038353627817440540423846825639974364498320587109093439857168637196258804150304528693879e-9) }}, 
      {{ SC_(96.90234375), SC_(94.90234375), SC_(0.3603713292007616599193847321433693776406224132985977617950650429927701818740197288718386980391139537e150), SC_(0.5677534733056240831243053541942271704991142413473022811865382907937593552157659834684067326969442147), SC_(0.2743607264264388052880134921102334417844185017706955448040758431862446742613524614401055950280623935e150), SC_(0.4322465266943759168756946458057728295008857586526977188134617092062406447842340165315932673030557853) }}, 
      {{ SC_(96.90234375), SC_(96.90234375), SC_(0.3087909824560275584103431046974543181404229622606248088770167430436689442739193291655649929835173834e150), SC_(0.4864902910109063604317574490403166925735264301207989523508894092408729165424412856192746790398212724), SC_(0.3259410731711729067970551195561485012846179528086684977221241431353459118614528611463793000836589637e150), SC_(0.5135097089890936395682425509596833074264735698792010476491105907591270834575587143807253209601787276) }}, 
      {{ SC_(96.90234375), SC_(98.90234375), SC_(0.2582537083249196166752992251315786292914265190930702521336240441031477618567462816775728292650975125e150), SC_(0.4068704361712601545380401980897904253692293050276365212662219983212046424823103805791446810847055177), SC_(0.3764783473022808485320989991220241901336143959762230544655168420758670942786259086343714638020788347e150), SC_(0.5931295638287398454619598019102095746307706949723634787337780016787953575176896194208553189152944823) }}, 
      {{ SC_(96.90234375), SC_(193.8046875), SC_(0.3073956091842520906334222999991014751494347564888634269649774940368938307198659998765531208644280484e136), SC_(0.484291925165972545491085733790579460724785915588532436230595300192679987889820064584958321718595281e-14), SC_(0.6347320556271973912513063817326964852020409240545418122515759975447452063604318213736370944071775816e150), SC_(0.9999999999999951570807483402745450891426620942053927521408441146756376940469980732001211017993541504) }}, 
      {{ SC_(96.90234375), SC_(9690.234375), SC_(0.7723287903400092132238434162563586125412816998193352152794296763426365221417582924303709204887939552e-3826), SC_(0.1216779243293210874272980541689570391334500547490670817786599996042033528280232172239591316726908051e-3975), SC_(0.6347320556272004652073982242536028194250409150692933065991408861790148561353721903119442930671763471e150), SC_(1) }}, 
      {{ SC_(97.07398223876953125), SC_(0.970739841461181640625), SC_(0.1390602098901114121749451291573722964962338436836892395635709177769657264832915164849385924487263315e151), SC_(1), SC_(0.0002206239018632627690767847378446033317282464529187679501063029450469716998532478533460905427524571721), SC_(0.1586535084605473190778182620046851287283362311207892713720991931149175973722946235657202316078723266e-153) }}, 
      {{ SC_(97.07398223876953125), SC_(48.536991119384765625), SC_(0.1390602098106765064700909705681863732023823758577724316703853743472771138627075462610002703522638277e151), SC_(0.9999999994287732934703215628849594223214888332647574438491813559160290445198946227973930490539689349), SC_(0.7943490570485415858918592329385146782591680789318554342968861262058397022393832209646250381387634481e141), SC_(0.5712267065296784371150405776785111667352425561508186440839709554801053772026069509460310650605150922e-9) }}, 
      {{ SC_(97.07398223876953125), SC_(95.07398223876953125), SC_(0.7894353266841565987861782321798955768786126888151560587018964703541536790461173522028631221430328714e150), SC_(0.5676931793127499352346121685087645812907292134401894428603932426387977992743975009460501537817292928), SC_(0.6011667722169575229632730593938273880837257480217363369338127074155035857867978126465228023442304435e150), SC_(0.4323068206872500647653878314912354187092707865598105571396067573612022007256024990539498462182707072) }}, 
      {{ SC_(97.07398223876953125), SC_(97.07398223876953125), SC_(0.6765310374491799687911161592387927937432361182800670053630090175678365342909441778772192319630897275e150), SC_(0.4865022409960335966405506224452614435763428868120114813409497819943814759656889306376952973024101145), SC_(0.7140710614519341529583351323349301712191023185568253902727001602018207305419709869721666925241735873e150), SC_(0.5134977590039664033594493775547385564236571131879885186590502180056185240343110693623047026975898855) }}, 
      {{ SC_(97.07398223876953125), SC_(99.07398223876953125), SC_(0.5659059756647238479027162601695954937224889597067600830708907184786265352965625297621317680730040811e150), SC_(0.4069503246916683160883089096616709612540613828178047608656015929946719366073371994219608414198293247), SC_(0.8246961232363902738467350314041274712398494771301323125648184592910307295363526350872541564142592338e150), SC_(0.5930496753083316839116910903383290387459386171821952391343984070053280633926628005780391585801706753) }}, 
      {{ SC_(97.07398223876953125), SC_(194.1479644775390625), SC_(0.6383632161739827405539381205559532425372824200941984115614212460584196737360667222050732683537774928e136), SC_(0.4590552658294073405400621127602235511556825500235165921282899372189791108142883841281540591924135969e-14), SC_(0.1390602098901107738117289551746317425581132877304467022811508235785541650620454580652648563820041264e151), SC_(0.9999999999999954094473417059265945993788723977644884431744997648340787171006278102088918571161587185) }}, 
      {{ SC_(97.07398223876953125), SC_(9707.3984375), SC_(0.1554508300767295629826289151447813502664571621031079084444997489221130098077847451573058000951078545e-3832), SC_(0.1117867074985507336921978163621817009174894348152931507303180908352071729637763538136893928075969754e-3982), SC_(0.1390602098901114121749451291573722964962338436836892395635709177769657264832915164849385924487263315e151), SC_(1) }}, 
      {{ SC_(98.12041473388671875), SC_(0.98120415210723876953125), SC_(0.1669861126231065195696424210456449455874901874757519165598086560442649717334048611202518743421394436e153), SC_(1), SC_(0.0005995920660668525537494187738509380037779136267531571358642991713728663808182319218773355681394449147), SC_(0.3590670245855430863209564274456623316692224537418637279292316026931209748682832128112907126760146097e-155) }}, 
      {{ SC_(98.12041473388671875), SC_(49.060207366943359375), SC_(0.1669861125455763331198117763777534542100306355761290717646558166017830188844910799626912721597589294e153), SC_(0.9999999995357087770237577802132886010370796676612177697437781117048098433027613820443436950625134848), SC_(0.7753018644983064466789149137745955189962284479515283944248195284891378115756060218238051413235590034e143), SC_(0.4642912229762422197867113989629203323387822302562218882951901566972386179556563049374865152304991776e-9) }}, 
      {{ SC_(98.12041473388671875), SC_(96.12041473388671875), SC_(0.9473606987607607444162359033381187331616413605914796182148290306820635206055067013063380990272026731e152), SC_(0.5673290334621938796334557435615629674436183735623090299121721865800802055227599217464685843771893237), SC_(0.7225004274703044512801883071183307227132605141660395473832575297605861967285419098961806443941917625e152), SC_(0.4326709665378061203665442564384370325563816264376909700878278134199197944772400782535314156228106763) }}, 
      {{ SC_(98.12041473388671875), SC_(98.12041473388671875), SC_(0.8125117040501215495901912543897995656017673674978463794419908130380244834825786707561141646853676885e152), SC_(0.4865744170498709703442065095897757442101073480034036518069836488507185420422249108418259636845307825), SC_(0.8573494221809436461062329560666498902731345072596727861560957474046252338514699404464045787360267471e152), SC_(0.5134255829501290296557934904102242557898926519965963481930163511492814579577750891581740363154692175) }}, 
      {{ SC_(98.12041473388671875), SC_(100.12041473388671875), SC_(0.6803564871832928177159582514744978657280803772975073660113670706072234550293769642186209286816285035e152), SC_(0.407432975410884100980901523989665724125993095817062210669172889587378725311547568392472868883197767), SC_(0.9895046390477723779804659589819515901468214974600117995867194898354262623046716469838978147397659321e152), SC_(0.592567024589115899019098476010334275874006904182937789330827110412621274688452431607527131116802233) }}, 
      {{ SC_(98.12041473388671875), SC_(196.2408294677734375), SC_(0.553168185375483171311911317425422099669113043593090421980236738034294414866142668511758051956328719e138), SC_(0.3312659817550235805717646856318195369118825209718113222350421009178599909376141034823064329939271353e-14), SC_(0.1669861126231059664014570455624736336761727620536522474467650629538429914966668268258370081994709318e153), SC_(0.9999999999999966873401824497641942823531436818046308811747902818867776495789908214000906238589651769) }}, 
      {{ SC_(98.12041473388671875), SC_(9812.041015625), SC_(0.2346250772246972934171285657447916944577522845825685409951114003454529013915430270537003652031158959e-3873), SC_(0.1405057423872452651825780465087118987148174626297156633481913580232931698194660556817189936822231592e-4025), SC_(0.1669861126231065195696424210456449455874901874757519165598086560442649717334048611202518743421394436e153), SC_(1) }}, 
      {{ SC_(99.29168701171875), SC_(0.992916882038116455078125), SC_(0.3597624564984979874650854926866432905161310445950019636523602570162960992596525061377901113302937769e155), SC_(1), SC_(0.001860653680996480746120215693416169775474692575384950751232870362171917307754109381576689713381564001), SC_(0.5171895086290775861902886429200427445322214598498490011747917328426230694453350912549248682639434057e-157) }}, 
      {{ SC_(99.29168701171875), SC_(49.645843505859375), SC_(0.3597624563660405669769966065476653256904599130972006072640997946387738493048496378318045373246759746e155), SC_(0.9999999996318197797033279445461782059086398697320519541274375216503024650752574302018488206145517109), SC_(0.1324574204880888861389779648256711314978013563882604623775222499548028683059855740056178023196625975e146), SC_(0.3681802202966720554538217940913601302679480458725624783496975349247425697981511793854482890744472973e-9) }}, 
      {{ SC_(99.29168701171875), SC_(97.29168701171875), SC_(0.2039595298602704488808504417746175401883689267588590015231184635430435875756193943407960954331784377e155), SC_(0.5669283333379784789854031798208565520520003304176385930356300549361939017465670842801981648578905589), SC_(0.1558029266382275385842350509120257503277621178361429621292417934732525116840331117969940158971153392e155), SC_(0.4330716666620215210145968201791434479479996695823614069643699450638060982534329157198018351421094411) }}, 
      {{ SC_(99.29168701171875), SC_(99.29168701171875), SC_(0.1750797832530988328169132173893130174254008496321055685339008114105910726769212926522925729047997561e155), SC_(0.4866538464216590454440676436349334932426876959021907449396188196024282900170669737839801733323471724), SC_(0.1846826732453991546481722752973302730907301949628963951184594456057050265827312134854975384254940208e155), SC_(0.5133461535783409545559323563650665067573123040978092550603811803975717099829330262160198266676528276) }}, 
      {{ SC_(99.29168701171875), SC_(101.29168701171875), SC_(0.1467702746048460278502892487691477658037913099545341024587246861819735300178044798974726957500010696e155), SC_(0.407964399713450354129594185814006095866732327668751744622880206051640575152975771178319565882907657), SC_(0.2129921818936519596147962439174955247123397346404678611936355708343225692418480262403174155802927073e155), SC_(0.592035600286549645870405814185993904133267672331248255377119793948359424847024228821680434117092343) }}, 
      {{ SC_(99.29168701171875), SC_(198.5833740234375), SC_(0.827233542896868997011855796813781815677230400991992891565280334025260219053460972781573951373944216e140), SC_(0.229938818782866162381957384742067701211139315001140649983601537152353780603212112398035629790115604e-14), SC_(0.3597624564984971602315425958176462786603342308131862864219592650234045339793184808775710578693209953e155), SC_(0.9999999999999977006118121713383761804261525793229878886068499885935001639846284764621939678788760196) }}, 
      {{ SC_(99.29168701171875), SC_(9929.1689453125), SC_(0.4834473233080081830333768520751663665093597177735535847660483721488578903585873065526523207939684243e-3919), SC_(0.1343795925826480955658960684191085655544382968324780717244341336895034665163230020619295313734211649e-4073), SC_(0.3597624564984979874650854926866432905161310445950019636523602570162960992596525061377901113302937769e155), SC_(1) }}, 
      {{ SC_(99.40981292724609375), SC_(0.994098126888275146484375), SC_(0.6189775403998407011012861882761402733097287676441233200787688479850177921372028259997245685694001147e155), SC_(1), SC_(0.00208738650682762943074724179328328460912087074928959890241928233000629188305710213804783747970955094), SC_(0.3372313808800301725169188483181072887659421985588169372890476556137167360016957658877023326983095951e-157) }}, 
      {{ SC_(99.40981292724609375), SC_(49.704906463623046875), SC_(0.6189775401772136033366649694131709554114237751328974114695223637149822231246713201702283730746409055e155), SC_(0.9999999996403308953329536449926347585079614442743745335075024035068298900441595001383387493915938425), SC_(0.2226270977646212188629693178983049925112259086092464842700355690125315058294961954947592092115827498e146), SC_(0.3596691046670463550073652414920385557256254664924975964931701099558404998616612506084061575015153272e-9) }}, 
      {{ SC_(99.40981292724609375), SC_(97.40981292724609375), SC_(0.3508911365196629713996826314769176339475002271815756817668854924735257948695597303600379465355294383e155), SC_(0.5668883176164969556694640046035019373021062926401136236228527719055084133507101313260179116199909852), SC_(0.2680864038801777297016035567992226393622285404625476383118833555114919972676430956396866220338706763e155), SC_(0.4331116823835030443305359953964980626978937073598863763771472280944915866492898686739820883800090148) }}, 
      {{ SC_(99.40981292724609375), SC_(99.40981292724609375), SC_(0.3012327110073060776126306088558402484398597921259981479632252878490593671505499604951644728373842357e155), SC_(0.4866617790569895164132848585800606033635106037347255456377686770273865390342095779746840038072262761), SC_(0.317744829392534623488655579420300024869868975518125172115543560135958424986652865504560095732015879e155), SC_(0.5133382209430104835867151414199393966364893962652744543622313229726134609657904220253159961927737239) }}, 
      {{ SC_(99.40981292724609375), SC_(101.40981292724609375), SC_(0.2525536615874421367012932901172485860763539011272499932099422653784982044920184787105406746658177969e155), SC_(0.4080174886867464334217982943121703482051615723869957786212134749545282348319943206732155228552149625), SC_(0.3664238788123985643999928981588916872333748665168733268688265826065195876451843472891838939035823178e155), SC_(0.5919825113132535665782017056878296517948384276130042213787865250454717651680056793267844771447850375) }}, 
      {{ SC_(99.40981292724609375), SC_(198.8196258544921875), SC_(0.1371819884134727259345696989796477150536656151060715801081402111868202863481570951651604961881278798e141), SC_(0.221626762620267814217739611891735278077275735293365054216933274355798919338201866535892704439999524e-14), SC_(0.6189775403998393292814020535488809276127389711669727834226177872692167107350909577968610869984484631e155), SC_(0.9999999999999977837323737973218578226038810826472192272426470663494578306672564420108066179813346411) }}, 
      {{ SC_(99.40981292724609375), SC_(9940.9814453125), SC_(0.1194537579446871083493681851309120071876520743662587465911793406448948030112600502063890936876032829e-3923), SC_(0.1929856095707828218066317814300956090965211451849739733633670381338185644181153034168965828385051012e-4078), SC_(0.6189775403998407011012861882761402733097287676441233200787688479850177921372028259997245685694001147e155), SC_(1) }}, 
      {{ SC_(99.6479034423828125), SC_(0.996479034423828125), SC_(0.1848618324328595326256540103756933748634832912163837099714564642354930615866313317180770173409626267e156), SC_(1), SC_(0.002632953621713545975680045402254573025958139457581454220024431257252884916204475441566275959699470982), SC_(0.1424281901278791824660099798410885257699748667114052276410912168756372599058364270087640660099318927e-157) }}, 
      {{ SC_(99.6479034423828125), SC_(49.82395172119140625), SC_(0.1848618323694318986984968527056010536947721607403919764188529025226665743038734891777793577541211654e156), SC_(0.9999999996568916736763733473241955787224548174526161914240157740209114383969351598000863202596909474), SC_(0.6342763392715715767009232116871113047599173355260356171282648728275784254029765958684146128176885942e146), SC_(0.3431083263236266526758044212775451825473838085759842259790885616030648401999136797403090526350547118e-9) }}, 
      {{ SC_(99.6479034423828125), SC_(97.6479034423828125), SC_(0.104781143510080106941519063115430082168881879110811778245289071826214589716454123584899890589776219e156), SC_(0.5668078809514984818732949250616079106146259355202233070637680474174180977553905187864349475271238675), SC_(0.8008068892277942568413494726026329269460141210557193172616739240927847187017720813317712675118640764e155), SC_(0.4331921190485015181267050749383920893853740644797766929362319525825819022446094812135650524728761325) }}, 
      {{ SC_(99.6479034423828125), SC_(99.6479034423828125), SC_(0.8996813603114861425627742217275710021870970554377666868921695606836039683900496541598731785012627279e155), SC_(0.4866777249101670793371012779886767047310287873694062698229024013112932567958949261113829499504654837), SC_(0.9489369640171091836937658820293627464477358567260704128223950816713266474762636630208969949083635387e155), SC_(0.5133222750898329206628987220113232952689712126305937301770975986887067432041050738886170500495345163) }}, 
      {{ SC_(99.6479034423828125), SC_(101.6479034423828125), SC_(0.7544659013596046014875316445704815685260451593376435295742314736115164671432240751181442400434537482e155), SC_(0.4081242144094947811955420069383153567301560395689175929907159931951304506349246950413365552505599538), SC_(0.1094152422968990724769008459186452180108787752826193570140333168743414148723089242062625933366172518e156), SC_(0.5918757855905052188044579930616846432698439604310824070092840068048695493650753049586634447494400462) }}, 
      {{ SC_(99.6479034423828125), SC_(199.295806884765625), SC_(0.3804006384186390812353329092798841093741132631690706197243637647942568433128668478754826060017677696e141), SC_(0.2057756506101917034700047476092601152101401495116289370474041581162582830156798739943260060771748412e-14), SC_(0.1848618324328591522250155917366121395305740113322743358581932951648733372228665374612337044741147512e156), SC_(0.9999999999999979422434938980829652999525239073988478985985048837106295259584188374171698432012600567) }}, 
      {{ SC_(99.6479034423828125), SC_(9964.7900390625), SC_(0.6187187441149196707967788811980241646983120637234991013972314808151116439559127711068191156963192852e-3933), SC_(0.3346925300762848381679977351230198692364721942446516591127645420968259313810798749854292537402422257e-4088), SC_(0.1848618324328595326256540103756933748634832912163837099714564642354930615866313317180770173409626267e156), SC_(1) }}
   } };



