#fedora and mdk are exclusive
%define fedora 1
%define mdk    0
%define gmimever 2.1.17
%if %fedora
%define config_opts --prefix=%{_prefix} --sysconfdir=%{_sysconfdir} --mandir=%{_mandir} --libdir=%{_libdir} --bindir=%{_bindir} --includedir=%{_includedir} --datadir=%{_datadir} --enable-threads --disable-more-warnings --with-ssl --with-gss --with-gtkspell
%endif
%if %mdk
%define config_opts --prefix=%{_prefix} --sysconfdir=%{_sysconfdir} --mandir=%{_mandir} --libdir=%{_libdir} --bindir=%{_bindir} --includedir=%{_includedir} --datadir=%{_datadir} --enable-threads --disable-more-warnings
%endif

Name:           balsa
Version:        2.5.7
Release:        1
Summary:        Mail Client

Group:          Applications/Internet
License:        GPLv2+
URL:            http://balsa.gnome.org/
Source0:        http://balsa.gnome.org/%{name}-%{version}.tar.bz2
%if ! %fedora
Source1:        http://balsa.gnome.org/gmime-%{gmimever}.tar.bz2
%endif
BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)


%if %fedora
Requires: libesmtp >= 1.0.6
#BuildRequires: gnome-vfs2-devel
BuildRequires: NetworkManager-glib-devel
BuildRequires: desktop-file-utils
BuildRequires: enchant-devel
BuildRequires: gettext
BuildRequires: gmime-devel >= 2.5.1
BuildRequires: gnome-doc-utils
BuildRequires: gpgme-devel
BuildRequires: gtkspell3-devel
BuildRequires: intltool
BuildRequires: libesmtp-devel >= 1.0.6
BuildRequires: libnotify-devel
BuildRequires: libsecret-devel
BuildRequires: libtool
BuildRequires: openssl-devel
BuildRequires: rarian-compat
BuildRequires: unique-devel
BuildRequires: webkitgtk3-devel
BuildRequires: yelp-tools
%endif
%if %mdk
BuildRequires:  libgnome-vfs2_0-devel
BuildRequires:  libgnome2_0-devel 
BuildRequires:  libgnomeui2_0-devel
BuildRequires:  libgtk+2.0_0-devel
BuildRequires:  libltdl3-devel
BuildRequires:  libpcre0-devel
BuildRequires:  libpspell4-devel
BuildRequires: gtkspell-devel
BuildRequires: gtkspell-devel
BuildRequires: libesmtp-devel >= 1.0.4
BuildRequires: openssl-devel
BuildRequires: openssl-devel
Requires: gtk+2.0
Requires: libesmtp >= 1.0.4
Requires: libgnome-vfs2_0
Requires: libgnome2_0 
Requires: libgnomeui2_0
%endif

%description
Balsa is an e-mail reader.  This client is part of the GNOME
desktop environment.  It supports local mailboxes, POP3 and
IMAP.

%prep
%if %fedora
%setup -q
%else
%setup -q -D -a 1
%endif

%build

%if !%fedora
dir=`pwd`; cd gmime-%{gmimever} && ./configure --prefix=`pwd` --disable-gtk-doc --disable-shared && make install; cd $dir
export PKG_CONFIG_PATH="gmime-%{gmimever}:$PKG_CONFIG_PATH"
%endif

%configure %{config_opts}

make %{?_smp_mflags}


%install
rm -rf "$RPM_BUILD_ROOT"
make install DESTDIR="$RPM_BUILD_ROOT"

desktop-file-install $RPM_BUILD_ROOT%{_datadir}/applications/balsa.desktop \
        --vendor=fedora \
        --add-category=Email \
        --dir=$RPM_BUILD_ROOT%{_datadir}/applications \
        --copy-name-to-generic-name \
        --delete-original

%find_lang %{name}

%clean
rm -rf "$RPM_BUILD_ROOT"

%post
scrollkeeper-update -q -o %{_datadir}/omf/%{name} || :

/bin/touch --no-create %{_datadir}/icons/hicolor
touch --no-create %{_datadir}/icons/hicolor || :
if [ -x %{_bindir}/gtk-update-icon-cache ]; then
   %{_bindir}/gtk-update-icon-cache --quiet %{_datadir}/icons/hicolor || :
fi

%postun
scrollkeeper-update -q || :

touch --no-create %{_datadir}/icons/hicolor || :
if [ -x %{_bindir}/gtk-update-icon-cache ]; then
   %{_bindir}/gtk-update-icon-cache --quiet %{_datadir}/icons/hicolor || :
fi

%files -f %{name}.lang
%defattr(-,root,root,-)
%doc README COPYING ChangeLog NEWS AUTHORS docs/mh-mail-HOWTO
%doc docs/vconvert.awk docs/pine2vcard
%{_bindir}/balsa
%{_bindir}/balsa-ab
%{_datadir}/applications/*.desktop
%{_datadir}/balsa/
%{_datadir}/help/C/balsa/
%{_datadir}/help/de/balsa/
%{_datadir}/help/es/balsa/
%{_datadir}/help/fr/balsa/
%{_datadir}/help/sl/balsa/
%{_datadir}/icons/hicolor/*
%{_datadir}/pixmaps/gnome-balsa2.png
%{_datadir}/sounds/balsa/
%{_mandir}/man1/balsa.1*
%config(noreplace) %{_sysconfdir}/sound/events/balsa.soundlist


%changelog
* Mon Mar 31 2008 Pawel Salek <pawsa at theochem.kth.se> - 2.3.23-1
- adapt to fedora 9.

* Fri May 20 2005 Pawel Salek <pawsa@theochem.kth.se> - 2.3.2-1
- adapt to Fedora Extras template.


* Sat Jul 26 2003 Misu Moldovan <dumol@go.ro>
- further split the Red Hat and Mandrake sections
- fix Mandrake 9.x dependencies

* Mon Sep 16 2002 Pawel Salek <pawsa@theochem.kth.se>
- adapt to GNOME2 requirements.

* Sun Jun 24 2001 Spider <spider@darkmere.wanfear.com>
- remove all defined paths to user-specified. 
- update configures, locales, update esmtp as a requires/buildrequires 

