/*
 * Decompiled with CFR 0.152.
 */
package org.netrexx.process;

import java.util.EmptyStackException;
import java.util.Stack;
import netrexx.lang.NoOtherwiseException;
import netrexx.lang.Rexx;
import netrexx.lang.RexxIO;
import netrexx.lang.RexxSet;
import netrexx.lang.RexxUtil;
import netrexx.lang.RexxWords;
import org.netrexx.process.RxClassInfo;
import org.netrexx.process.RxClasser;
import org.netrexx.process.RxCode;
import org.netrexx.process.RxConvert;
import org.netrexx.process.RxConverter;
import org.netrexx.process.RxCursor;
import org.netrexx.process.RxError;
import org.netrexx.process.RxExprOpType;
import org.netrexx.process.RxProcessor;
import org.netrexx.process.RxQuit;
import org.netrexx.process.RxSignal;
import org.netrexx.process.RxToken;
import org.netrexx.process.RxTranslator;
import org.netrexx.process.RxType;
import org.netrexx.process.RxWarn;

public class RxExprParser {
    private static final Rexx $01 = new Rexx(0);
    private static final Rexx $02 = Rexx.toRexx("# term:");
    private static final Rexx $03 = new Rexx('\'');
    private static final Rexx $04 = new Rexx('[');
    private static final Rexx $05 = new Rexx(']');
    private static final Rexx $06 = new Rexx('(');
    private static final Rexx $07 = new Rexx(')');
    private static final Rexx $08 = Rexx.toRexx("");
    private static final Rexx $09 = new Rexx('\\');
    private static final Rexx $010 = Rexx.toRexx("# cast");
    private static final Rexx $011 = Rexx.toRexx("from");
    private static final Rexx $012 = Rexx.toRexx("to");
    private static final Rexx $013 = new Rexx('.');
    private static final Rexx $014 = new Rexx(',');
    private static final Rexx $015 = Rexx.toRexx("instanceof");
    private static final Rexx $016 = Rexx.toRexx("?1:0)");
    private static final Rexx $017 = Rexx.toRexx(",(int)");
    private static final Rexx $018 = Rexx.toRexx(".equals(");
    private static final Rexx $019 = Rexx.toRexx("# rexxOp:");
    private static final Rexx $020 = new Rexx('<');
    private static final Rexx $021 = new Rexx('>');
    private static final Rexx $022 = Rexx.toRexx("(!");
    private static final Rexx $023 = Rexx.toRexx("==0");
    private static final Rexx $024 = Rexx.toRexx("128");
    private static final Rexx $025 = Rexx.toRexx("32768");
    private static final Rexx $026 = Rexx.toRexx("2147483648");
    private static final Rexx $027 = Rexx.toRexx("double");
    private static final Rexx $028 = Rexx.toRexx("float");
    private static final Rexx $029 = Rexx.toRexx("long");
    private static final Rexx $030 = Rexx.toRexx("\\=");
    private static final Rexx $031 = Rexx.toRexx("||");
    private static final Rexx $032 = Rexx.toRexx("==");
    private static final Rexx $033 = Rexx.toRexx("\\==");
    private static final Rexx $034 = Rexx.toRexx(">=");
    private static final Rexx $035 = Rexx.toRexx("<=");
    private static final Rexx $036 = Rexx.toRexx("&&");
    private static final Rexx $037 = Rexx.toRexx("//");
    private static final Rexx $038 = Rexx.toRexx("**");
    private static final Rexx $039 = Rexx.toRexx(">>");
    private static final Rexx $040 = Rexx.toRexx("<<");
    private static final Rexx $041 = Rexx.toRexx(">>=");
    private static final Rexx $042 = Rexx.toRexx("<<=");
    private static final Rexx $043 = Rexx.toRexx("\\>>");
    private static final Rexx $044 = Rexx.toRexx("\\<<");
    private static final Rexx $045 = Rexx.toRexx("<>");
    private static final Rexx $046 = Rexx.toRexx("><");
    private static final Rexx $047 = Rexx.toRexx("\\>");
    private static final Rexx $048 = Rexx.toRexx("\\<");
    private static final String $0 = "RxExprParser.nrx";
    Rexx copyright = RxProcessor.copyright;
    private RxTranslator rxt;
    private RxClasser classer;
    private RxConverter converter;
    private static final Rexx compareops = new Rexx("= \\= < > <= >=");
    private static final Rexx allcompareops = new Rexx(compareops.OpCcblank(null, Rexx.toRexx("== \\== << >> <<= >>=")));
    private static final Rexx equalityops = new Rexx("= == \\= \\==");
    private static final Rexx arithops = new Rexx("+ - / * ** // %");
    private static final Rexx logicops = new Rexx("& | && ?");
    private static final RxExprOpType semicolon = new RxExprOpType(';', null, 0, false);
    private static final Integer int0 = new Integer(0);
    private static final Integer int1 = new Integer(1);
    private static final int O_AND = 1;
    private static final int O_BLANK = 2;
    private static final int O_CONCAT = 3;
    private static final int O_CONDOR = 4;
    private static final int O_DIVIDE = 5;
    private static final int O_EQ = 6;
    private static final int O_GT = 7;
    private static final int O_GTEQ = 8;
    private static final int O_IDIVIDE = 9;
    private static final int O_LT = 10;
    private static final int O_LTEQ = 11;
    private static final int O_MINUS = 12;
    private static final int O_NEQ = 13;
    private static final int O_NOT = 14;
    private static final int O_OR = 15;
    private static final int O_PLUS = 16;
    private static final int O_POWER = 17;
    private static final int O_REM = 18;
    private static final int O_SEQ = 19;
    private static final int O_SNEQ = 20;
    private static final int O_SGT = 21;
    private static final int O_SLT = 22;
    private static final int O_SGTEQ = 23;
    private static final int O_SLTEQ = 24;
    private static final int O_TIMES = 26;
    private static final int O_XOR = 27;

    public RxExprParser(RxTranslator rxTranslator) {
        this.rxt = rxTranslator;
        this.classer = this.rxt.classer;
        this.converter = this.rxt.converter;
    }

    public RxCode evalexpr(RxCursor rxCursor, boolean bl, int n, char[] cArray, Rexx rexx) {
        return this.evalexpr(rxCursor, bl, n, cArray, rexx, '>', Rexx.toRexx(""));
    }

    public RxCode evalexpr(RxCursor rxCursor, boolean bl, int n, char[] cArray, Rexx rexx, char c) {
        return this.evalexpr(rxCursor, bl, n, cArray, rexx, c, Rexx.toRexx(""));
    }

    public RxCode evalexpr(RxCursor rxCursor, boolean bl, int n, char[] cArray, Rexx rexx, char c, Rexx rexx2) {
        RuntimeException runtimeException = null;
        try {
            return this.parseexpr(rxCursor, bl, n, cArray, rexx, c, rexx2);
        }
        catch (RuntimeException runtimeException2) {
            runtimeException = runtimeException2;
            if (!(runtimeException instanceof RxSignal)) {
                if (rxCursor.curprogram.flag.diag) {
                    RexxIO.Say("# unwrapped exception " + runtimeException.toString());
                    runtimeException.printStackTrace();
                }
                runtimeException = new RxSignal(rxCursor, runtimeException, null);
            }
            throw runtimeException;
        }
    }

    public RxCode parseexpr(RxCursor rxCursor, boolean bl, int n, char[] cArray, Rexx rexx) {
        return this.parseexpr(rxCursor, bl, n, cArray, rexx, '>', Rexx.toRexx(""));
    }

    public RxCode parseexpr(RxCursor rxCursor, boolean bl, int n, char[] cArray, Rexx rexx, char c) {
        return this.parseexpr(rxCursor, bl, n, cArray, rexx, c, Rexx.toRexx(""));
    }

    public RxCode parseexpr(RxCursor rxCursor, boolean bl, int n, char[] cArray, Rexx rexx, char c, Rexx rexx2) {
        int n2;
        RxToken[] rxTokenArray;
        String string;
        int n3;
        RxCode rxCode;
        RxToken rxToken;
        Stack<RxCode> stack;
        block52: {
            int n4;
            Stack<RxExprOpType> stack2 = null;
            stack = null;
            Rexx rexx3 = null;
            int n5 = 0;
            rxToken = null;
            char c2 = '\u0000';
            Rexx rexx4 = null;
            RxToken[] rxTokenArray2 = null;
            RxCode rxCode2 = null;
            String string2 = null;
            RxExprOpType rxExprOpType = null;
            boolean bl2 = false;
            Rexx rexx5 = null;
            int n6 = 0;
            char c3 = '\u0000';
            rxCode = null;
            char c4 = '\u0000';
            n3 = 0;
            string = null;
            rxTokenArray = rxCursor.curclause.tokens;
            if (rexx != null) {
                rexx3 = rexx.upper();
                n4 = rxTokenArray.length - 1;
                n5 = n;
                while (n5 <= n4) {
                    rxToken = rxTokenArray[n5];
                    c2 = rxToken.type;
                    if (c2 == ';') break;
                    if (c2 == 'S' && rexx3.wordpos(rexx4 = new Rexx(rxToken.value).upper()).OpNotEqS(null, $01) && (this.rxt.exec || rxCursor.curprogram.parser.iskey(Rexx.tochararray(rexx4), Rexx.toString(rexx4)))) {
                        if (n5 > 0 && rxTokenArray[n5 - 1].type == 'B') {
                            --n5;
                        }
                        rxTokenArray2 = new RxToken[n5 + 1];
                        System.arraycopy(rxTokenArray, 0, rxTokenArray2, 0, n5 + 1);
                        rxTokenArray2[n5] = new RxToken(';', rxToken.line, rxToken.pos, rxToken.len, '\u0004');
                        rxTokenArray = rxTokenArray2;
                        if (n < n5) break;
                        throw new RxError(this.rxt, rxToken, "term.expected");
                    }
                    ++n5;
                }
            }
            stack2 = new Stack<RxExprOpType>();
            stack = new Stack<RxCode>();
            stack2.push(semicolon);
            rxToken = rxTokenArray[n];
            c2 = rxToken.type;
            if (c2 == 'B') {
                ++n;
            }
            n2 = n;
            boolean bl3 = false;
            block1: while (true) {
                rxToken = rxTokenArray[n];
                c2 = rxToken.type;
                if (c2 == 'S' | c2 == 'L' | c2 == 'N' | c2 == '(' | c2 == '[') {
                    block51: {
                        rxCode2 = this.rxt.tparser.parseterm(rxCursor, n, true);
                        if (rxCode2.group == 'U') {
                            throw new RxError(this.rxt, rxToken, "unknown.variable");
                        }
                        if (rxCode2.type.equals(RxType.VOID_TYPE)) {
                            throw new RxError(this.rxt, rxToken, "undefined.type");
                        }
                        if (rxCursor.curprogram.flag.diag) {
                            string2 = rxCode2.value == null ? "? [null]" : String.valueOf(rxCode2.value.getClass().getName()) + " " + this.rxt.interpreter.stringvalue(rxCode2);
                            RexxIO.Say($02.OpCcblank(null, rxCode2.type.toSig()).OpCcblank(null, $03).OpCc(null, rxCode2.javacode).OpCc(null, $03).OpCcblank(null, $04).OpCc(null, Rexx.toRexx(string2)).OpCc(null, $05).OpCcblank(null, new Rexx(rxCode2.endoff)));
                        }
                        stack.push(rxCode2);
                        if (!this.rxt.exec) {
                            rxCursor.curprogram.parser.addexceptions(true, rxCode2.exceptions, rxToken);
                        }
                        n = rxCode2.endoff + 1;
                        while (true) {
                            rxExprOpType = (RxExprOpType)stack2.peek();
                            if (rxExprOpType.isprefix) {
                                stack2.pop();
                                stack.push(this.oneopdo(rxCursor, rxExprOpType.tok.value, rxExprOpType.tok, (RxCode)stack.pop()));
                                continue;
                            }
                            rxToken = rxTokenArray[n];
                            c2 = rxToken.type;
                            bl2 = false;
                            if (c2 == 'S' | c2 == 'L' | c2 == 'N' | c2 == '(') {
                                bl2 = true;
                            }
                            if (c2 == 'B' | c2 == 'O' | bl2) {
                                if (c2 == 'B') {
                                    rexx5 = Rexx.toRexx(" ");
                                    n6 = 1;
                                } else if (bl2) {
                                    rexx5 = Rexx.toRexx("||");
                                    n6 = 0;
                                } else {
                                    rexx5 = this.optokens(rxTokenArray, n);
                                    n6 = rexx5.length().toint();
                                }
                                c3 = rxExprOpType.type;
                                if (c3 == 'O' | c3 == 'B' | c3 == 'A') {
                                    this.opdo(rxCursor, rxTokenArray, stack, stack2, rexx5, rxToken, -1);
                                }
                                if (bl2) {
                                    stack2.push(new RxExprOpType('A', rxToken, n, false));
                                } else {
                                    stack2.push(new RxExprOpType(c2, rxToken, n, false));
                                }
                                n += n6;
                                continue block1;
                            }
                            if (c2 == ';') {
                                bl3 = true;
                            } else if (c2 == ')') {
                                bl3 = true;
                            } else if (cArray != null) {
                                n4 = cArray.length;
                                n5 = 0;
                                while (n4 > 0) {
                                    if (c2 == cArray[n5]) {
                                        bl3 = true;
                                        break;
                                    }
                                    --n4;
                                    ++n5;
                                }
                            }
                            if (!bl3) break block51;
                            if (rxExprOpType != null) {
                                this.opdo(rxCursor, rxTokenArray, stack, stack2, new Rexx('?'), rxToken, 0);
                                rxExprOpType = (RxExprOpType)stack2.peek();
                            }
                            if (rxExprOpType.type != '(' || c2 != ')') break;
                            rxCode = (RxCode)stack.peek();
                            rxCode.javacode = $06.OpCc(null, rxCode.javacode).OpCc(null, $07);
                            stack2.pop();
                            ++n;
                        }
                        if (rxExprOpType.type != ';') {
                            throw new RxError(this.rxt, rxToken, "unmatched.left.parenthesis");
                        }
                        if (c2 == ')' && (cArray == null || RexxWords.pos(c2, cArray, 1) == 0)) {
                            throw new RxError(this.rxt, rxToken, "unexpected.right.parenthesis");
                        }
                        break block52;
                    }
                    if (c2 == ']') {
                        throw new RxError(this.rxt, rxToken, "unexpected.right.bracket");
                    }
                    if (c2 == ')') {
                        throw new RxError(this.rxt, rxToken, "unexpected.right.parenthesis");
                    }
                    if (c2 == ',') {
                        throw new RxError(this.rxt, rxToken, "unexpected.comma");
                    }
                    if (c2 == ';') {
                        throw new RxError(this.rxt, rxToken, "unexpected.clause.end");
                    }
                    throw new RxError(this.rxt, rxToken, "bad.expression.syntax");
                }
                rxToken = rxTokenArray[n];
                c2 = rxToken.type;
                if (c2 == '(') {
                    stack2.push(new RxExprOpType(c2, null, 0, false));
                    ++n;
                    continue;
                }
                if (c2 != 'O' || !((c4 = rxToken.value[0]) == '+' | c4 == '-' | c4 == '\\')) break;
                stack2.push(new RxExprOpType('O', rxToken, n, true));
                ++n;
            }
            if (((RxExprOpType)stack2.pop()).type != ';') {
                throw new RxError(this.rxt, rxToken, "term.expected");
            }
            if (cArray == null || RexxWords.pos(c2, cArray, 1) == 0) {
                if (c2 == ';') {
                    throw new RxError(this.rxt, rxToken, "unexpected.clause.end");
                }
                throw new RxError(this.rxt, rxToken, "bad.expression.syntax");
            }
        }
        if (stack.empty()) {
            if (n == n2) {
                throw new RxError(this.rxt, rxToken, "expression.expected");
            }
            throw new RxError(this.rxt, rxToken, "expression.incomplete");
        }
        rxCode = (RxCode)stack.pop();
        if (!stack.empty()) {
            throw new RxQuit(this.rxt, rxToken, "internal.error", Rexx.toRexx("RxExprParser: terms unempty"));
        }
        if (rxCode.group == 'U') {
            rxToken = rxTokenArray[n2];
            throw new RxError(this.rxt, rxToken, "unknown.result.not.allowed");
        }
        if (rxCode.group == 'T') {
            if (!bl) {
                rxToken = rxTokenArray[n2];
                throw new RxError(this.rxt, rxToken, "type.result.not.allowed");
            }
        } else if (rxCode.group == 'L' && rxCode.type.equals(RxType.BYTE_TYPE) | rxCode.type.equals(RxType.SHORT_TYPE)) {
            rxCode.javacode = $06.OpCc(null, rxCode.type.toJava()).OpCc(null, $07).OpCc(null, rxCode.javacode);
        }
        if (c != '\u0000' && rxCode.group != 'T') {
            n3 = rexx2.OpEqS(null, $08) ? 4 : 1;
            if (rxCursor.curprogram.flag.java && this.rxt.pass2) {
                rxCursor.curprogram.tracer.tracecode(rxCode, rxCursor.curclause.tokens[0], c, n3, rexx2);
            }
            if (rxCursor.curexec && rxCursor.curtrace != null && rxCode.value != null) {
                string = this.rxt.interpreter.stringvalue(rxCode);
                rxCursor.curtrace.traceString(rxCursor.curclause.tokens[0].line, string, c, n3, Rexx.toString(rexx2));
            }
        }
        rxCode.endclause = rxCode.begclause = rxCursor.curclause;
        rxCode.begoff = n2;
        rxCode.endoff = n - 1;
        return rxCode;
    }

    private void opdo(RxCursor rxCursor, RxToken[] rxTokenArray, Stack stack, Stack stack2, Rexx rexx, RxToken rxToken, int n) {
        RxExprOpType rxExprOpType = null;
        Rexx rexx2 = null;
        int n2 = 0;
        RxCode rxCode = null;
        RxCode rxCode2 = null;
        if (rexx.OpEqS(null, $09)) {
            throw new RxError(this.rxt, rxToken, "dyadic.not");
        }
        if (n == -1) {
            n = this.getprio(rexx, rxToken);
        }
        try {
            while (true) {
                rxExprOpType = (RxExprOpType)stack2.peek();
                if (rxExprOpType.type == 'A') {
                    rexx2 = Rexx.toRexx("||");
                } else if (rxExprOpType.type == 'B') {
                    rexx2 = new Rexx(' ');
                } else if (rxExprOpType.type == 'O') {
                    rexx2 = this.optokens(rxTokenArray, rxExprOpType.off);
                } else {
                    return;
                }
                rxToken = rxExprOpType.tok;
                n2 = this.getprio(rexx2, rxToken);
                if (n2 < n) {
                    return;
                }
                rxCode = (RxCode)stack.pop();
                rxCode2 = (RxCode)stack.pop();
                stack2.pop();
                stack.push(this.twoopdo(rxCursor, rexx2, rxToken, rxCode2, rxCode));
            }
        }
        catch (EmptyStackException emptyStackException) {
            throw new RxQuit(this.rxt, rxToken, "internal.error", Rexx.toRexx("RxExprParser: nxopdo bad stack"));
        }
    }

    public RxCode codeop(RxCursor rxCursor, Rexx rexx, RxToken rxToken, RxCode rxCode, RxCode rxCode2) {
        this.converter.javawrap(rxCode);
        this.converter.javawrap(rxCode2);
        return this.twoopdo(rxCursor, rexx, rxToken, rxCode, rxCode2);
    }

    public RxCode twoopdo(RxCursor rxCursor, Rexx rexx, RxToken rxToken, RxCode rxCode, RxCode rxCode2) {
        int n = 0;
        int n2 = 0;
        RxConvert rxConvert = null;
        RuntimeException runtimeException = null;
        Rexx rexx2 = null;
        int n3 = 0;
        boolean bl = false;
        String string = null;
        String string2 = null;
        String string3 = null;
        boolean bl2 = false;
        RxClassInfo rxClassInfo = null;
        RxClassInfo rxClassInfo2 = null;
        RxCode rxCode3 = null;
        Rexx rexx3 = null;
        RxType rxType = null;
        RxClassInfo rxClassInfo3 = null;
        Integer n4 = null;
        int n5 = 0;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        double d = 0.0;
        int n6 = 0;
        double d2 = 0.0;
        RxType rxType2 = null;
        int n7 = 0;
        int n8 = 0;
        long l4 = 0L;
        long l5 = 0L;
        double d3 = 0.0;
        RxType rxType3 = null;
        String string4 = null;
        String string5 = null;
        boolean bl3 = false;
        String string6 = null;
        String string7 = null;
        Rexx rexx4 = null;
        Rexx rexx5 = null;
        RexxSet rexxSet = null;
        boolean bl4 = false;
        Rexx rexx6 = null;
        boolean bl5 = rxCursor.curexec;
        int n9 = this.getcode(rexx);
        boolean bl6 = rxCode.constant & rxCode2.constant;
        if (rxCode.type.equals(RxType.NULL_TYPE) && !equalityops.wordpos(rexx, new Rexx(1)).OpNotEqS(null, $01)) {
            throw new RxError(this.rxt, rxToken, "cannot.operate.on.null.lhs");
        }
        if (!(!rxCode2.type.equals(RxType.NULL_TYPE) || rxCode.group == 'T' && n9 == 2 | n9 == 3 || equalityops.wordpos(rexx, new Rexx(1)).OpNotEqS(null, $01))) {
            throw new RxError(this.rxt, rxToken, "cannot.operate.on.null.rhs");
        }
        if (bl5) {
            if (rxCode.value == null && rxCode.group != 'T' && !equalityops.wordpos(rexx, new Rexx(1)).OpNotEqS(null, $01)) {
                throw new RxSignal(rxCursor, new NullPointerException("Left operand null"), rxToken);
            }
            if (!(rxCode2.value != null || rxCode2.group == 'T' || rxCode.group == 'T' && n9 == 2 | n9 == 3 || equalityops.wordpos(rexx, new Rexx(1)).OpNotEqS(null, $01))) {
                throw new RxSignal(rxCursor, new NullPointerException("Right operand null"), rxToken);
            }
        }
        RxCode rxCode4 = new RxCode();
        rxCode4.group = (char)71;
        n = RxType.REXX_TYPE.equals(rxCode.type) ? 83 : (RxType.STRING_TYPE.equals(rxCode.type) ? 83 : (rxCode.type.isPrimitive() ? 80 : (RxType.CHARARRAY_TYPE.equals(rxCode.type) ? 83 : 85)));
        n2 = RxType.REXX_TYPE.equals(rxCode2.type) ? 83 : (RxType.STRING_TYPE.equals(rxCode2.type) ? 83 : (rxCode2.type.isPrimitive() ? 80 : (RxType.CHARARRAY_TYPE.equals(rxCode2.type) ? 83 : 85)));
        if (rxCode.group == 'T' && n9 == 16 | n9 == 12 | n9 == 14) {
            rxCode2 = this.oneopdo(rxCursor, Rexx.tochararray(rexx), rxToken, rxCode2);
            rexx = new Rexx(' ');
            n9 = 2;
        }
        if (n9 == 2 | n9 == 3) {
            if (rxCode.group == 'T') {
                if (rxCode2.group == 'T') {
                    throw new RxError(this.rxt, rxToken, "cannot.convert.type.to.type");
                }
                if (rxCode2.group == 'L' && !rxCode2.type.equals(rxCode.type)) {
                    this.converter.litexpr(rxCursor, rxCode2);
                }
                if (rxCursor.curprogram.flag.diag) {
                    RexxIO.Say($010.OpCcblank(null, rxCode2.javacode).OpCcblank(null, $011).OpCcblank(null, rxCode2.type.toSig()).OpCcblank(null, $012).OpCcblank(null, rxCode.type.toSig()));
                }
                if (rxCode2.type.equals(RxType.VOID_TYPE)) {
                    throw new RxError(this.rxt, rxToken, "undefined.type");
                }
                rxConvert = this.converter.assigncost(rxCursor, rxCode.type, rxCode2.type);
                if (rxConvert.cost > 50) {
                    throw new RxError(this.rxt, rxToken, "cannot.convert", Rexx.toRexx(rxCursor.curprogram.toString(rxCode2.type)), Rexx.toRexx(rxCursor.curprogram.toString(rxCode.type)));
                }
                try {
                    this.converter.convertcode(rxCursor, rxCode.type, rxConvert.proc, rxCode2);
                }
                catch (RuntimeException runtimeException2) {
                    runtimeException = runtimeException2;
                    if (bl5) {
                        throw new RxSignal(rxCursor, runtimeException, rxToken);
                    }
                    throw new RxError(this.rxt, rxToken, "bad.cast", Rexx.toRexx(rxCursor.curprogram.toString(rxCode.type)), Rexx.toRexx(this.rxt.interpreter.stringvalue(rxCode2)));
                }
                rxCode4.javacode = rxCode2.javacode;
                if (rxConvert.cost > 0 & rxConvert.cost < 10 && (n3 = rxCode4.javacode.pos(rexx2 = $06.OpCc(null, rxCode.type.toJava()).OpCc(null, $07)).toint()) == 0 | n3 > 2) {
                    rxCode4.javacode = $06.OpCc(null, rxCode.type.toJava()).OpCc(null, $07).OpCc(null, rxCode4.javacode);
                }
                if (rxCode2.constant | bl5) {
                    rxCode4.constant = rxCode2.constant;
                    rxCode4.value = rxCode2.value;
                }
                rxCode4.type = rxCode.type;
                return rxCode4;
            }
            if (rxCode2.group == 'T') {
                throw new RxError(this.rxt, rxToken, "cannot.have.rhs.type");
            }
            if (n == 85 && rxCode.type.isarray() && !rxCode.type.equals(RxType.CHARARRAY_TYPE)) {
                throw new RxError(this.rxt, rxToken, "array.operation.invalid", Rexx.toRexx(rxCursor.curprogram.toString(rxCode.type)));
            }
            if (n2 == 85 && rxCode2.type.isarray() && !rxCode2.type.equals(RxType.CHARARRAY_TYPE)) {
                throw new RxError(this.rxt, rxToken, "array.operation.invalid", Rexx.toRexx(rxCursor.curprogram.toString(rxCode2.type)));
            }
            bl = false;
            if (rxCursor.curbinary && !rxCode.type.equals(RxType.REXX_TYPE) && !rxCode2.type.equals(RxType.REXX_TYPE)) {
                bl = true;
            }
            if (bl) {
                if (rxCode.type.equals(RxType.BOOL_TYPE)) {
                    rxCode.javacode = $06.OpCc(null, rxCode.javacode).OpCc(null, Rexx.toRexx("?\"1\":\"0\")"));
                } else if (rxCode.type.equals(RxType.OBJECT_TYPE)) {
                    this.converter.javawrap(rxCode);
                    rxCode.javacode = rxCode.javacode.OpCc(null, Rexx.toRexx(".toString()"));
                } else {
                    rxConvert = this.converter.assigncost(rxCursor, RxType.STRING_TYPE, rxCode.type);
                    this.converter.convertcode(rxCursor, RxType.STRING_TYPE, rxConvert.proc, rxCode);
                }
                if (rxCode2.type.equals(RxType.BOOL_TYPE)) {
                    rxCode2.javacode = $06.OpCc(null, rxCode2.javacode).OpCc(null, Rexx.toRexx("?\"1\":\"0\")"));
                } else if (!rxCode2.type.equals(RxType.CHAR_TYPE) & rxCode2.type.isPrimitive()) {
                    this.converter.javawrap(rxCode2);
                } else if (rxCode2.type.equals(RxType.OBJECT_TYPE)) {
                    this.converter.javawrap(rxCode2);
                    rxCode2.javacode = rxCode2.javacode.OpCc(null, Rexx.toRexx(".toString()"));
                } else {
                    rxConvert = this.converter.assigncost(rxCursor, RxType.STRING_TYPE, rxCode2.type);
                    this.converter.convertcode(rxCursor, RxType.STRING_TYPE, rxConvert.proc, rxCode2);
                }
                string = n9 == 2 ? "+\" \"+" : "+";
                rxCode4.javacode = rxCode.javacode.OpCc(null, Rexx.toRexx(string)).OpCc(null, rxCode2.javacode);
                rxCode4.type = RxType.STRING_TYPE;
            } else {
                this.converter.torexx(rxCursor, rxCode, true);
                this.converter.torexx(rxCursor, rxCode2, true);
                string2 = n9 == 2 ? "OpCcblank" : "OpCc";
                this.converter.javawrap(rxCode);
                rxCode4.javacode = rxCode.javacode.OpCc(null, $013).OpCc(null, Rexx.toRexx(string2)).OpCc(null, $06).OpCc(null, this.settings()).OpCc(null, $014).OpCc(null, rxCode2.javacode).OpCc(null, $07);
                rxCode4.type = RxType.REXX_TYPE;
            }
            if (bl6 | bl5) {
                rxCode4.constant = bl6;
                string3 = n9 == 2 ? String.valueOf(this.rxt.interpreter.stringvalue(rxCode)) + " " + this.rxt.interpreter.stringvalue(rxCode2) : String.valueOf(this.rxt.interpreter.stringvalue(rxCode)) + this.rxt.interpreter.stringvalue(rxCode2);
                rxCode4.value = bl ? string3 : new Rexx(string3);
            }
            return rxCode4;
        }
        if (n9 == 8 | n9 == 11 && rxCode.group == 'T' | rxCode2.group == 'T') {
            rxCode4.type = RxType.BOOL_TYPE;
            if (rxCode.group == rxCode2.group) {
                bl2 = n9 == 11 ? this.classer.issubclass(rxCursor, rxCode.type, rxCode2.type, rxToken) : this.classer.issubclass(rxCursor, rxCode2.type, rxCode.type, rxToken);
                if (bl2) {
                    rxCode4.javacode = Rexx.toRexx("true");
                    rxCode4.value = int1;
                } else {
                    rxCode4.javacode = Rexx.toRexx("false");
                    rxCode4.value = int0;
                }
                rxCode4.constant = true;
                return rxCode4;
            }
            rxClassInfo = this.classer.findclass(rxCursor, rxCode.type, rxToken, false);
            rxClassInfo2 = this.classer.findclass(rxCursor, rxCode2.type, rxToken, false);
            if (n9 == 11) {
                if (!rxCode.type.equals(RxType.OBJECT_TYPE)) {
                    if (rxClassInfo == null) {
                        throw new RxError(this.rxt, rxToken, "class.not.found", rxCode.type.classname);
                    }
                    if (rxClassInfo2 == null) {
                        throw new RxError(this.rxt, rxToken, "class.not.found", rxCode2.type.classname);
                    }
                    if (!(this.classer.issubclass(rxCursor, rxClassInfo2, rxClassInfo, rxToken) || this.classer.issubclass(rxCursor, rxClassInfo, rxClassInfo2, rxToken) || rxClassInfo2.isinterface & !rxClassInfo.isfinal)) {
                        new RxWarn(this.rxt, rxToken, "cannot.be.instanceof.lhs", Rexx.toRexx(rxCursor.curprogram.toString(rxCode.type)), Rexx.toRexx(rxCursor.curprogram.toString(rxCode2.type)));
                        rxCode4.javacode = Rexx.toRexx("false");
                        rxCode4.wrapped = true;
                        return rxCode4;
                    }
                }
                rxCode4.javacode = $06.OpCc(null, rxCode.javacode).OpCcblank(null, $015).OpCcblank(null, rxCode2.javacode).OpCc(null, $07);
                rxCode4.wrapped = true;
            } else {
                if (!rxCode2.type.equals(RxType.OBJECT_TYPE)) {
                    if (rxClassInfo2 == null) {
                        throw new RxError(this.rxt, rxToken, "class.not.found", rxCode2.type.classname);
                    }
                    if (rxClassInfo == null) {
                        throw new RxError(this.rxt, rxToken, "class.not.found", rxCode.type.classname);
                    }
                    if (!(this.classer.issubclass(rxCursor, rxClassInfo, rxClassInfo2, rxToken) || this.classer.issubclass(rxCursor, rxClassInfo2, rxClassInfo, rxToken) || rxClassInfo.isinterface & !rxClassInfo2.isfinal)) {
                        new RxWarn(this.rxt, rxToken, "cannot.be.instanceof.rhs", Rexx.toRexx(rxCursor.curprogram.toString(rxCode2.type)), Rexx.toRexx(rxCursor.curprogram.toString(rxCode.type)));
                        rxCode4.javacode = Rexx.toRexx("false");
                        rxCode4.wrapped = true;
                        return rxCode4;
                    }
                }
                rxCode4.javacode = $06.OpCc(null, rxCode2.javacode).OpCcblank(null, $015).OpCcblank(null, rxCode.javacode).OpCc(null, $07);
                rxCode4.wrapped = true;
            }
            if (bl5) {
                rxCode3 = n9 == 11 ? rxCode : rxCode2;
                rexx3 = new Rexx(rxCode3.value.getClass().getName());
                rxType = rexx3.left(new Rexx(1)).OpEqS(null, $04) ? RxType.OBJECT_TYPE : new RxType(rexx3, 0);
                rxClassInfo3 = this.classer.findclass(rxCursor, rxType, rxToken, false);
                n4 = int0;
                if (n9 == 11) {
                    if (this.classer.issubclass(rxCursor, rxClassInfo3, rxClassInfo2, rxToken)) {
                        n4 = int1;
                    }
                } else if (this.classer.issubclass(rxCursor, rxClassInfo3, rxClassInfo, rxToken)) {
                    n4 = int1;
                }
                rxCode4.value = n4;
            }
            return rxCode4;
        }
        if (rxCode.group == 'T') {
            throw new RxError(this.rxt, rxToken, "cannot.operate.on.type.lhs", Rexx.toRexx(rxCursor.curprogram.toString(rxCode.type)));
        }
        if (rxCode2.group == 'T') {
            throw new RxError(this.rxt, rxToken, "cannot.operate.on.type.rhs", Rexx.toRexx(rxCursor.curprogram.toString(rxCode2.type)));
        }
        n5 = n != 80 ? 0 : (n2 != 80 ? 0 : (rxCode.type.equals(RxType.BOOL_TYPE) & rxCode2.type.equals(RxType.BOOL_TYPE) & logicops.wordpos(rexx, new Rexx(1)).OpNotEqS(null, $01) ? 1 : (!rxCursor.curbinary ? 0 : (rxCode.type.equals(RxType.CHAR_TYPE) & rxCode2.type.equals(RxType.CHAR_TYPE) & allcompareops.wordpos(rexx, new Rexx(1)).OpNotEqS(null, $01) ? 1 : (rxCode.type.equals(RxType.CHAR_TYPE) ? 0 : (rxCode2.type.equals(RxType.CHAR_TYPE) ? 0 : 1))))));
        if (new Rexx(n5).toboolean()) {
            if (logicops.wordpos(rexx, new Rexx(1)).OpNotEqS(null, $01)) {
                if (rxCode.type.equals(RxType.BOOL_TYPE) & rxCode2.type.equals(RxType.BOOL_TYPE)) {
                    rxCode4.type = RxType.BOOL_TYPE;
                } else {
                    if (rxCode.type.equals(RxType.BOOL_TYPE)) {
                        rxCode.javacode = $06.OpCc(null, rxCode.javacode).OpCc(null, $016);
                    }
                    if (rxCode2.type.equals(RxType.BOOL_TYPE)) {
                        rxCode2.javacode = $06.OpCc(null, rxCode2.javacode).OpCc(null, $016);
                    }
                    rxCode4.type = this.binarytype(rxCode.type, rxCode2.type);
                    if (rxCode4.type.equals(RxType.FLOAT_TYPE) | rxCode4.type.equals(RxType.DOUBLE_TYPE)) {
                        throw new RxError(this.rxt, rxToken, "cannot.use.logical.op", rxCode4.type.classname);
                    }
                }
                switch (n9) {
                    case 15: {
                        string = "|";
                        break;
                    }
                    case 1: {
                        string = "&";
                        break;
                    }
                    case 27: {
                        string = "^";
                        break;
                    }
                    case 4: {
                        string = "||";
                        break;
                    }
                    default: {
                        throw new NoOtherwiseException();
                    }
                }
                this.converter.javawrap(rxCode);
                this.converter.javawrap(rxCode2);
                rxCode4.javacode = rxCode.javacode.OpCc(null, Rexx.toRexx(string)).OpCc(null, rxCode2.javacode);
                if (bl5 | bl6) {
                    rxCode4.constant = bl6;
                    l = ((Number)rxCode.value).longValue();
                    l2 = ((Number)rxCode2.value).longValue();
                    switch (n9) {
                        case 15: {
                            l3 = l | l2;
                            break;
                        }
                        case 1: {
                            l3 = l & l2;
                            break;
                        }
                        case 27: {
                            l3 = l ^ l2;
                            break;
                        }
                        case 4: {
                            l3 = Rexx.toRexx(String.valueOf(String.valueOf(l)) + l2).tolong();
                            break;
                        }
                        default: {
                            throw new NoOtherwiseException();
                        }
                    }
                    rxCode4.value = !rxCode4.type.equals(RxType.LONG_TYPE) ? (Number)new Integer((int)l3) : (Number)new Long(l3);
                }
                return rxCode4;
            }
            if (rxCode.type.equals(RxType.BOOL_TYPE)) {
                rxCode.javacode = $06.OpCc(null, rxCode.javacode).OpCc(null, $016);
                rxCode.wrapped = true;
                rxCode.type = RxType.INT_TYPE;
            }
            if (rxCode2.type.equals(RxType.BOOL_TYPE)) {
                rxCode2.javacode = $06.OpCc(null, rxCode2.javacode).OpCc(null, $016);
                rxCode2.wrapped = true;
                rxCode2.type = RxType.INT_TYPE;
            }
            if (n9 == 17) {
                rxCode4.type = rxCode.type.equals(RxType.LONG_TYPE) | rxCode.type.equals(RxType.DOUBLE_TYPE) ? RxType.DOUBLE_TYPE : RxType.FLOAT_TYPE;
                this.converter.javawrap(rxCode);
                this.converter.javawrap(rxCode2);
                rxCode4.javacode = RxType.REXXUTIL_CLASS.OpCc(null, $013).OpCc(null, rxCode4.type.classname).OpCc(null, Rexx.toRexx("Pow((double)")).OpCc(null, rxCode.javacode).OpCc(null, $017).OpCc(null, rxCode2.javacode).OpCc(null, $07);
                rxCode4.wrapped = true;
                if (bl5 | bl6) {
                    try {
                        rxCode4.constant = bl6;
                        d = ((Number)rxCode.value).doubleValue();
                        n6 = ((Number)rxCode2.value).intValue();
                        d2 = RexxUtil.doublePow(d, n6);
                        if (rxCode4.type.equals(RxType.FLOAT_TYPE)) {
                            d2 = (float)d2;
                        }
                        rxCode4.value = new Double(d2);
                    }
                    catch (RuntimeException runtimeException3) {
                        runtimeException = runtimeException3;
                        if (bl5) {
                            throw new RxSignal(rxCursor, runtimeException, rxToken);
                        }
                        throw new RxError(this.rxt, rxToken, "bad.dyadic.operation", Rexx.toRexx("**"));
                    }
                }
                return rxCode4;
            }
            switch (n9) {
                case 9: {
                    string = "/";
                    break;
                }
                case 18: {
                    string = "%";
                    break;
                }
                case 6: {
                    string = "==";
                    break;
                }
                case 13: {
                    string = "!=";
                    break;
                }
                case 20: {
                    string = "!=";
                    break;
                }
                case 22: {
                    string = "<";
                    break;
                }
                case 21: {
                    string = ">";
                    break;
                }
                case 24: {
                    string = "<=";
                    break;
                }
                case 23: {
                    string = ">=";
                    break;
                }
                default: {
                    string = Rexx.toString(rexx);
                }
            }
            if (n9 == 5) {
                rxType2 = rxCode.type.equals(RxType.LONG_TYPE) | rxCode.type.equals(RxType.DOUBLE_TYPE) | rxCode2.type.equals(RxType.LONG_TYPE) | rxCode2.type.equals(RxType.DOUBLE_TYPE) ? RxType.DOUBLE_TYPE : RxType.FLOAT_TYPE;
                this.converter.javawrap(rxCode);
                this.converter.javawrap(rxCode2);
            } else if (n9 == 9) {
                rxType2 = rxCode.type.equals(RxType.LONG_TYPE) | rxCode.type.equals(RxType.DOUBLE_TYPE) | rxCode2.type.equals(RxType.LONG_TYPE) | rxCode2.type.equals(RxType.DOUBLE_TYPE) ? RxType.LONG_TYPE : RxType.INT_TYPE;
                this.converter.javawrap(rxCode);
                this.converter.javawrap(rxCode2);
            } else {
                rxType2 = this.binarytype(rxCode.type, rxCode2.type);
            }
            if (!rxCode.type.equals(RxType.CHAR_TYPE)) {
                rxConvert = this.converter.assigncost(rxCursor, rxType2, rxCode.type);
                this.converter.convertcode(rxCursor, rxType2, rxConvert.proc, rxCode);
                rxConvert = this.converter.assigncost(rxCursor, rxType2, rxCode2.type);
                this.converter.convertcode(rxCursor, rxType2, rxConvert.proc, rxCode2);
            }
            this.converter.javawrap(rxCode);
            this.converter.javawrap(rxCode2);
            rxCode4.javacode = rxCode.javacode.OpCc(null, Rexx.toRexx(string)).OpCc(null, rxCode2.javacode);
            rxCode4.type = allcompareops.wordpos(rexx, new Rexx(1)).OpNotEqS(null, $01) ? RxType.BOOL_TYPE : rxType2;
            if (bl5 | bl6) {
                rxCode4.constant = bl6;
                if (rxType2.equals(RxType.FLOAT_TYPE)) {
                    rxType2 = RxType.DOUBLE_TYPE;
                }
                if (rxCode.type.equals(RxType.CHAR_TYPE)) {
                    rxCode.value = new Integer(((Rexx)rxCode.value).tochar());
                    rxCode2.value = new Integer(((Rexx)rxCode2.value).tochar());
                }
                try {
                    if (rxType2.equals(RxType.INT_TYPE)) {
                        n7 = ((Number)rxCode.value).intValue();
                        n6 = ((Number)rxCode2.value).intValue();
                        switch (n9) {
                            case 19: {
                                n8 = n7 == n6 ? 1 : 0;
                                break;
                            }
                            case 20: {
                                n8 = n7 != n6 ? 1 : 0;
                                break;
                            }
                            case 22: {
                                n8 = n7 < n6 ? 1 : 0;
                                break;
                            }
                            case 21: {
                                n8 = n7 > n6 ? 1 : 0;
                                break;
                            }
                            case 24: {
                                n8 = n7 <= n6 ? 1 : 0;
                                break;
                            }
                            case 23: {
                                n8 = n7 >= n6 ? 1 : 0;
                                break;
                            }
                            case 6: {
                                n8 = n7 == n6 ? 1 : 0;
                                break;
                            }
                            case 13: {
                                n8 = n7 != n6 ? 1 : 0;
                                break;
                            }
                            case 10: {
                                n8 = n7 < n6 ? 1 : 0;
                                break;
                            }
                            case 7: {
                                n8 = n7 > n6 ? 1 : 0;
                                break;
                            }
                            case 11: {
                                n8 = n7 <= n6 ? 1 : 0;
                                break;
                            }
                            case 8: {
                                n8 = n7 >= n6 ? 1 : 0;
                                break;
                            }
                            case 16: {
                                n8 = n7 + n6;
                                break;
                            }
                            case 12: {
                                n8 = n7 - n6;
                                break;
                            }
                            case 26: {
                                n8 = n7 * n6;
                                break;
                            }
                            case 5: {
                                n8 = n7 / n6;
                                break;
                            }
                            case 9: {
                                n8 = n7 / n6;
                                break;
                            }
                            case 18: {
                                n8 = n7 % n6;
                                break;
                            }
                            default: {
                                throw new NoOtherwiseException();
                            }
                        }
                        if (rxCode4.type.equals(RxType.BYTE_TYPE)) {
                            n8 = (byte)n8;
                        } else if (rxCode4.type.equals(RxType.SHORT_TYPE)) {
                            n8 = (short)n8;
                        }
                        rxCode4.value = new Integer(n8);
                    } else if (rxType2.equals(RxType.LONG_TYPE)) {
                        l3 = ((Number)rxCode.value).longValue();
                        l4 = ((Number)rxCode2.value).longValue();
                        switch (n9) {
                            case 19: {
                                l5 = l3 == l4 ? 1 : 0;
                                break;
                            }
                            case 20: {
                                l5 = l3 != l4 ? 1 : 0;
                                break;
                            }
                            case 22: {
                                l5 = l3 < l4 ? 1 : 0;
                                break;
                            }
                            case 21: {
                                l5 = l3 > l4 ? 1 : 0;
                                break;
                            }
                            case 24: {
                                l5 = l3 <= l4 ? 1 : 0;
                                break;
                            }
                            case 23: {
                                l5 = l3 >= l4 ? 1 : 0;
                                break;
                            }
                            case 6: {
                                l5 = l3 == l4 ? 1 : 0;
                                break;
                            }
                            case 13: {
                                l5 = l3 != l4 ? 1 : 0;
                                break;
                            }
                            case 10: {
                                l5 = l3 < l4 ? 1 : 0;
                                break;
                            }
                            case 7: {
                                l5 = l3 > l4 ? 1 : 0;
                                break;
                            }
                            case 11: {
                                l5 = l3 <= l4 ? 1 : 0;
                                break;
                            }
                            case 8: {
                                l5 = l3 >= l4 ? 1 : 0;
                                break;
                            }
                            case 16: {
                                l5 = l3 + l4;
                                break;
                            }
                            case 12: {
                                l5 = l3 - l4;
                                break;
                            }
                            case 26: {
                                l5 = l3 * l4;
                                break;
                            }
                            case 5: {
                                l5 = l3 / l4;
                                break;
                            }
                            case 9: {
                                l5 = l3 / l4;
                                break;
                            }
                            case 18: {
                                l5 = l3 % l4;
                                break;
                            }
                            default: {
                                throw new NoOtherwiseException();
                            }
                        }
                        rxCode4.value = new Long(l5);
                    } else if (rxType2.equals(RxType.DOUBLE_TYPE)) {
                        d = ((Number)rxCode.value).doubleValue();
                        d3 = ((Number)rxCode2.value).doubleValue();
                        d2 = 0.0;
                        switch (n9) {
                            case 19: {
                                d2 = d == d3 ? 1 : 0;
                                break;
                            }
                            case 20: {
                                d2 = d != d3 ? 1 : 0;
                                break;
                            }
                            case 22: {
                                d2 = d < d3 ? 1 : 0;
                                break;
                            }
                            case 21: {
                                d2 = d > d3 ? 1 : 0;
                                break;
                            }
                            case 24: {
                                d2 = d <= d3 ? 1 : 0;
                                break;
                            }
                            case 23: {
                                d2 = d >= d3 ? 1 : 0;
                                break;
                            }
                            case 6: {
                                d2 = d == d3 ? 1 : 0;
                                break;
                            }
                            case 13: {
                                d2 = d != d3 ? 1 : 0;
                                break;
                            }
                            case 10: {
                                d2 = d < d3 ? 1 : 0;
                                break;
                            }
                            case 7: {
                                d2 = d > d3 ? 1 : 0;
                                break;
                            }
                            case 11: {
                                d2 = d <= d3 ? 1 : 0;
                                break;
                            }
                            case 8: {
                                d2 = d >= d3 ? 1 : 0;
                                break;
                            }
                            case 16: {
                                d2 = d + d3;
                                break;
                            }
                            case 12: {
                                d2 = d - d3;
                                break;
                            }
                            case 26: {
                                d2 = d * d3;
                                break;
                            }
                            case 5: {
                                d2 = d / d3;
                                break;
                            }
                            case 9: {
                                d2 = (long)d / (long)d3;
                                break;
                            }
                            case 18: {
                                d2 = d % d3;
                                break;
                            }
                            default: {
                                throw new NoOtherwiseException();
                            }
                        }
                        if (rxCode4.type.equals(RxType.FLOAT_TYPE)) {
                            d2 = (float)d2;
                        }
                        rxCode4.value = new Double(d2);
                    }
                }
                catch (RuntimeException runtimeException4) {
                    runtimeException = runtimeException4;
                    if (bl5) {
                        throw new RxSignal(rxCursor, runtimeException, rxToken);
                    }
                    throw new RxError(this.rxt, rxToken, "bad.dyadic.operation", rexx);
                }
            }
            return rxCode4;
        }
        if (n == 85 && !rxCode.type.equals(RxType.NULL_TYPE)) {
            rxConvert = this.converter.assigncost(rxCursor, RxType.REXX_TYPE, rxCode.type);
            if (rxConvert.cost <= rxCursor.curprogram.flag.maxassign) {
                n = 82;
            }
        }
        if (n2 == 85 && !rxCode2.type.equals(RxType.NULL_TYPE)) {
            rxConvert = this.converter.assigncost(rxCursor, RxType.REXX_TYPE, rxCode2.type);
            if (rxConvert.cost <= rxCursor.curprogram.flag.maxassign) {
                n2 = 82;
            }
        }
        if (n == 85 | n2 == 85) {
            if (equalityops.wordpos(rexx, new Rexx(1)).OpEqS(null, $01)) {
                rxType3 = n == 85 ? rxCode.type : rxCode2.type;
                string4 = rxCursor.curprogram.toString(rxType3);
                if (rxType3.isarray()) {
                    throw new RxError(this.rxt, rxToken, "array.operation.invalid", Rexx.toRexx(string4));
                }
                throw new RxError(this.rxt, rxToken, "operation.not.allowed", Rexx.toRexx(string4));
            }
            if (n == 80) {
                throw new RxError(this.rxt, rxToken, "cannot.compare.primitive.object", Rexx.toRexx(rxCursor.curprogram.toString(rxCode.type)), Rexx.toRexx(rxCursor.curprogram.toString(rxCode2.type)));
            }
            if (n2 == 80) {
                throw new RxError(this.rxt, rxToken, "cannot.compare.object.primitive", Rexx.toRexx(rxCursor.curprogram.toString(rxCode.type)), Rexx.toRexx(rxCursor.curprogram.toString(rxCode2.type)));
            }
            if (!(rxCode.type.equals(RxType.NULL_TYPE) | rxCode.type.equals(RxType.NULL_TYPE))) {
                rxConvert = this.converter.assigncost(rxCursor, rxCode.type, rxCode2.type);
                if (rxConvert.cost >= 40) {
                    throw new RxError(this.rxt, rxToken, "cannot.compare.dissimilar", Rexx.toRexx(rxCursor.curprogram.toString(rxCode.type)), Rexx.toRexx(rxCursor.curprogram.toString(rxCode2.type)));
                }
            }
            rxCode4.type = RxType.BOOL_TYPE;
            if (n9 == 6 | n9 == 13 && !rxCode.type.equals(RxType.NULL_TYPE) && !rxCode2.type.equals(RxType.NULL_TYPE) && this.classer.issubclass(rxCursor, rxCode.type, rxCode2.type, rxToken)) {
                string5 = n9 == 6 ? "" : "!";
                this.converter.javawrap(rxCode);
                rxCode4.javacode = Rexx.toRexx(string5).OpCc(null, rxCode.javacode).OpCc(null, $018).OpCc(null, rxCode2.javacode).OpCc(null, $07);
                rxCode4.wrapped = true;
                if (bl5 | bl6) {
                    rxCode4.constant = bl6;
                    bl3 = rxCode.value.equals(rxCode2.value);
                    if (string5.equals("!")) {
                        bl3 = !bl3;
                    }
                    rxCode4.value = bl3 ? int1 : int0;
                }
                return rxCode4;
            }
            switch (n9) {
                case 6: {
                    string = "==";
                    break;
                }
                case 19: {
                    string = "==";
                    break;
                }
                case 13: {
                    string = "!=";
                    break;
                }
                case 20: {
                    string = "!=";
                    break;
                }
                default: {
                    throw new NoOtherwiseException();
                }
            }
            this.converter.javawrap(rxCode);
            this.converter.javawrap(rxCode2);
            rxCode4.javacode = rxCode.javacode.OpCc(null, Rexx.toRexx(string)).OpCc(null, rxCode2.javacode);
            if (bl5 | bl6) {
                rxCode4.constant = bl6;
                boolean bl7 = bl3 = rxCode.value == rxCode2.value;
                if (string.equals("!=")) {
                    bl3 = !bl3;
                }
                rxCode4.value = bl3 ? int1 : int0;
            }
            return rxCode4;
        }
        if (n9 == 19 | n9 == 20) {
            if (rxCode.type.equals(RxType.STRING_TYPE) | rxCode2.type.equals(RxType.STRING_TYPE)) {
                if (rxCode.type.equals(RxType.CHAR_TYPE)) {
                    rxConvert = this.converter.assigncost(rxCursor, RxType.STRING_TYPE, rxCode.type);
                    this.converter.convertcode(rxCursor, RxType.STRING_TYPE, rxConvert.proc, rxCode);
                }
                if (rxCode2.type.equals(RxType.CHAR_TYPE)) {
                    rxConvert = this.converter.assigncost(rxCursor, RxType.STRING_TYPE, rxCode2.type);
                    this.converter.convertcode(rxCursor, RxType.STRING_TYPE, rxConvert.proc, rxCode2);
                }
                if (rxCode.type.equals(rxCode2.type)) {
                    string5 = n9 == 19 ? "" : "!";
                    this.converter.javawrap(rxCode);
                    rxCode4.javacode = Rexx.toRexx(string5).OpCc(null, rxCode.javacode).OpCc(null, $018).OpCc(null, rxCode2.javacode).OpCc(null, $07);
                    rxCode4.wrapped = true;
                    rxCode4.type = RxType.BOOL_TYPE;
                    if (bl5 | bl6) {
                        rxCode4.constant = bl6;
                        bl3 = this.rxt.interpreter.stringvalue(rxCode).equals(this.rxt.interpreter.stringvalue(rxCode2));
                        if (string5.equals("!")) {
                            bl3 = !bl3;
                        }
                        rxCode4.value = bl3 ? int1 : int0;
                    }
                    return rxCode4;
                }
            } else if (rxCode.type.equals(rxCode2.type) && n == 80) {
                string = n9 == 19 ? "==" : "!=";
                this.converter.javawrap(rxCode);
                this.converter.javawrap(rxCode2);
                rxCode4.javacode = rxCode.javacode.OpCc(null, Rexx.toRexx(string)).OpCc(null, rxCode2.javacode);
                rxCode4.type = RxType.BOOL_TYPE;
                if (bl5 | bl6) {
                    rxCode4.constant = bl6;
                    if (rxCode.value instanceof Integer) {
                        bl3 = ((Integer)rxCode.value).intValue() == ((Integer)rxCode2.value).intValue();
                    } else if (rxCode.value instanceof Double) {
                        bl3 = ((Double)rxCode.value).doubleValue() == ((Double)rxCode2.value).doubleValue();
                    } else if (rxCode.value instanceof Long) {
                        bl3 = ((Long)rxCode.value).longValue() == ((Long)rxCode2.value).longValue();
                    } else if (rxCode.value instanceof Rexx) {
                        bl3 = ((Rexx)rxCode.value).equals((Rexx)rxCode2.value);
                    } else {
                        throw new NoOtherwiseException();
                    }
                    if (string.equals("!=")) {
                        bl3 = !bl3;
                    }
                    rxCode4.value = bl3 ? int1 : int0;
                }
                return rxCode4;
            }
        }
        this.converter.torexx(rxCursor, rxCode, true);
        this.converter.torexx(rxCursor, rxCode2, true);
        if (rxCursor.curprogram.flag.diag) {
            string6 = rxCode.value == null ? "[null]" : rxCode.value.toString();
            string7 = rxCode2.value == null ? "[null]" : rxCode2.value.toString();
            RexxIO.Say($019.OpCcblank(null, rxCode.type.toSig()).OpCcblank(null, Rexx.toRexx(string6)).OpCcblank(null, $020).OpCc(null, new Rexx(n9)).OpCc(null, $021).OpCcblank(null, rxCode2.type.toSig()).OpCcblank(null, Rexx.toRexx(string7)));
        }
        block93 : switch (n9) {
            case 19: {
                string2 = "OpEqS";
                break;
            }
            case 20: {
                string2 = "OpNotEqS";
                break;
            }
            case 22: {
                string2 = "OpLtS";
                break;
            }
            case 21: {
                string2 = "OpGtS";
                break;
            }
            case 24: {
                string2 = "OpLtEqS";
                break;
            }
            case 23: {
                string2 = "OpGtEqS";
                break;
            }
            case 15: {
                string2 = "OpOr";
                break;
            }
            case 1: {
                string2 = "OpAnd";
                break;
            }
            case 27: {
                string2 = "OpXor";
                break;
            }
            default: {
                if (!rxCursor.curprogram.flag.decimal) {
                    throw new RxError(this.rxt, rxToken, "decimal.arithmetic.required");
                }
                switch (n9) {
                    case 6: {
                        string2 = "OpEq";
                        break block93;
                    }
                    case 13: {
                        string2 = "OpNotEq";
                        break block93;
                    }
                    case 10: {
                        string2 = "OpLt";
                        break block93;
                    }
                    case 7: {
                        string2 = "OpGt";
                        break block93;
                    }
                    case 11: {
                        string2 = "OpLtEq";
                        break block93;
                    }
                    case 8: {
                        string2 = "OpGtEq";
                        break block93;
                    }
                    case 16: {
                        string2 = "OpAdd";
                        break block93;
                    }
                    case 12: {
                        string2 = "OpSub";
                        break block93;
                    }
                    case 26: {
                        string2 = "OpMult";
                        break block93;
                    }
                    case 5: {
                        string2 = "OpDiv";
                        break block93;
                    }
                    case 9: {
                        string2 = "OpDivI";
                        break block93;
                    }
                    case 18: {
                        string2 = "OpRem";
                        break block93;
                    }
                    case 17: {
                        string2 = "OpPow";
                        break block93;
                    }
                }
                throw new NoOtherwiseException();
            }
        }
        rxCode4.type = arithops.wordpos(rexx, new Rexx(1)).OpNotEqS(null, $01) ? RxType.REXX_TYPE : (allcompareops.wordpos(rexx, new Rexx(1)).OpNotEqS(null, $01) ? RxType.BOOL_TYPE : (logicops.wordpos(rexx, new Rexx(1)).OpNotEqS(null, $01) ? RxType.BOOL_TYPE : RxType.REXX_TYPE));
        this.converter.javawrap(rxCode);
        rxCode4.javacode = rxCode.javacode.OpCc(null, $013).OpCc(null, Rexx.toRexx(string2)).OpCc(null, $06).OpCc(null, this.settings()).OpCc(null, $014).OpCc(null, rxCode2.javacode).OpCc(null, $07);
        rxCode4.wrapped = true;
        if (bl5) {
            try {
                rxCode4.constant = false;
                rexx4 = rxCode.value instanceof Rexx ? (Rexx)rxCode.value : new Rexx(rxCode.value.toString());
                rexx5 = rxCode2.value instanceof Rexx ? (Rexx)rxCode2.value : new Rexx(rxCode2.value.toString());
                rexxSet = rxCursor.curnumer;
                switch (n9) {
                    case 19: {
                        bl4 = rexx4.OpEqS(rexxSet, rexx5);
                        break;
                    }
                    case 20: {
                        bl4 = rexx4.OpNotEqS(rexxSet, rexx5);
                        break;
                    }
                    case 22: {
                        bl4 = rexx4.OpLtS(rexxSet, rexx5);
                        break;
                    }
                    case 21: {
                        bl4 = rexx4.OpGtS(rexxSet, rexx5);
                        break;
                    }
                    case 24: {
                        bl4 = rexx4.OpLtEqS(rexxSet, rexx5);
                        break;
                    }
                    case 23: {
                        bl4 = rexx4.OpGtEqS(rexxSet, rexx5);
                        break;
                    }
                    case 15: {
                        bl4 = rexx4.OpOr(rexxSet, rexx5);
                        break;
                    }
                    case 1: {
                        bl4 = rexx4.OpAnd(rexxSet, rexx5);
                        break;
                    }
                    case 27: {
                        bl4 = rexx4.OpXor(rexxSet, rexx5);
                        break;
                    }
                    case 6: {
                        bl4 = rexx4.OpEq(rexxSet, rexx5);
                        break;
                    }
                    case 13: {
                        bl4 = rexx4.OpNotEq(rexxSet, rexx5);
                        break;
                    }
                    case 10: {
                        bl4 = rexx4.OpLt(rexxSet, rexx5);
                        break;
                    }
                    case 7: {
                        bl4 = rexx4.OpGt(rexxSet, rexx5);
                        break;
                    }
                    case 11: {
                        bl4 = rexx4.OpLtEq(rexxSet, rexx5);
                        break;
                    }
                    case 8: {
                        bl4 = rexx4.OpGtEq(rexxSet, rexx5);
                        break;
                    }
                    case 16: {
                        rexx6 = rexx4.OpAdd(rexxSet, rexx5);
                        break;
                    }
                    case 12: {
                        rexx6 = rexx4.OpSub(rexxSet, rexx5);
                        break;
                    }
                    case 26: {
                        rexx6 = rexx4.OpMult(rexxSet, rexx5);
                        break;
                    }
                    case 5: {
                        rexx6 = rexx4.OpDiv(rexxSet, rexx5);
                        break;
                    }
                    case 9: {
                        rexx6 = rexx4.OpDivI(rexxSet, rexx5);
                        break;
                    }
                    case 18: {
                        rexx6 = rexx4.OpRem(rexxSet, rexx5);
                        break;
                    }
                    case 17: {
                        rexx6 = rexx4.OpPow(rexxSet, rexx5);
                        break;
                    }
                    default: {
                        throw new NoOtherwiseException();
                    }
                }
                if (rxCode4.type.equals(RxType.BOOL_TYPE)) {
                    n8 = bl4 ? 1 : 0;
                    rxCode4.value = new Integer(n8);
                } else {
                    rxCode4.value = rexx6;
                }
            }
            catch (RuntimeException runtimeException5) {
                runtimeException = runtimeException5;
                throw new RxSignal(rxCursor, runtimeException, rxToken);
            }
        }
        return rxCode4;
    }

    public RxCode oneopdo(RxCursor rxCursor, char[] cArray, RxToken rxToken, RxCode rxCode) {
        int n = 0;
        Rexx rexx = null;
        Rexx rexx2 = null;
        boolean bl = false;
        RuntimeException runtimeException = null;
        Object object = null;
        String string = null;
        RexxSet rexxSet = null;
        if (rxCode.group == 'T') {
            throw new RxError(this.rxt, rxToken, "cannot.operate.on.type");
        }
        if (rxCode.group == 'T') {
            throw new RxError(this.rxt, rxToken, "cannot.have.rhs.type");
        }
        boolean bl2 = rxCursor.curexec;
        RxType rxType = rxCode.type;
        if (rxType.equals(RxType.NULL_TYPE)) {
            throw new RxError(this.rxt, rxToken, "cannot.operate.on.null.rhs");
        }
        if (bl2 && rxCode.value == null) {
            throw new RxSignal(rxCursor, new NullPointerException("Right operand null"), rxToken);
        }
        if (rxType.equals(RxType.REXX_TYPE)) {
            n = 83;
        } else if (rxType.isPrimitive()) {
            n = 80;
        } else if (rxType.equals(RxType.STRING_TYPE)) {
            n = 83;
        } else if (rxType.equals(RxType.CHARARRAY_TYPE)) {
            n = 83;
        } else {
            throw new RxError(this.rxt, rxToken, "operation.not.allowed", Rexx.toRexx(rxCursor.curprogram.toString(rxType)));
        }
        int n2 = this.getcode(Rexx.toRexx(cArray));
        RxCode rxCode2 = new RxCode();
        rxCode2.group = rxCode.group == 'L' ? (char)76 : (char)71;
        rxCode2.constant = rxCode.constant;
        if (rxCursor.curbinary & n == 80 && !rxType.equals(RxType.CHAR_TYPE)) {
            this.converter.javawrap(rxCode);
            rexx = rxCode.javacode;
            if (n2 == 14) {
                if (rxType.equals(RxType.FLOAT_TYPE) | rxType.equals(RxType.DOUBLE_TYPE)) {
                    throw new RxError(this.rxt, rxToken, "cannot.use.logical.op", rxType.classname);
                }
                if (rxCode2.constant | bl2) {
                    try {
                        rexx2 = new Rexx(this.rxt.interpreter.stringvalue(rxCode));
                        bl = rexx2.toboolean();
                        rxCode2.value = bl ? int0 : int1;
                    }
                    catch (RuntimeException runtimeException2) {
                        runtimeException = runtimeException2;
                        if (!bl2) {
                            throw new RxError(this.rxt, rxToken, "value.not.boolean", rexx2);
                        }
                        throw new RxSignal(rxCursor, runtimeException, rxToken);
                    }
                }
                rxCode2.type = RxType.BOOL_TYPE;
                rxCode2.javacode = rxType.equals(RxType.BOOL_TYPE) ? $022.OpCc(null, rexx).OpCc(null, $07) : rexx.OpCc(null, $023);
                return rxCode2;
            }
            if (rxType.equals(RxType.BOOL_TYPE)) {
                rexx = $06.OpCc(null, rexx).OpCc(null, $016);
                rxCode2.type = RxType.INT_TYPE;
            } else {
                if (n2 == 12 && rxCode2.group == 'L') {
                    if (rexx.OpEqS(null, $024)) {
                        rxType = RxType.BYTE_TYPE;
                    }
                    if (rexx.OpEqS(null, $025)) {
                        rxType = RxType.SHORT_TYPE;
                    }
                    if (rexx.OpEqS(null, $026)) {
                        rxType = RxType.INT_TYPE;
                    }
                }
                rxCode2.type = rxType;
            }
            rxCode2.javacode = Rexx.toRexx(cArray).OpCc(null, rexx);
            rxCode2.wrapped = false;
            if (rxCode2.constant | bl2) {
                object = rxCode.value;
                if (n2 == 12) {
                    if (object instanceof Integer) {
                        object = new Integer(-((Integer)object).intValue());
                    } else if (object instanceof Long) {
                        object = new Long(-((Long)object).longValue());
                    } else if (object instanceof Double) {
                        object = new Double(-((Double)object).doubleValue());
                    } else {
                        throw new NoOtherwiseException();
                    }
                }
                rxCode2.value = object;
            }
            if (rxCode2.group != 'L') {
                rxCode2.javacode = $06.OpCc(null, rxCode2.type.classname).OpCc(null, $07).OpCc(null, rxCode2.javacode);
                rxCode2.wrapped = false;
            }
            return rxCode2;
        }
        this.converter.torexx(rxCursor, rxCode, true);
        if (n2 == 14) {
            string = "OpNot";
        } else {
            if (!rxCursor.curprogram.flag.decimal) {
                throw new RxError(this.rxt, rxToken, "decimal.arithmetic.required");
            }
            if (n2 == 12) {
                string = "OpMinus";
            } else if (n2 == 16) {
                string = "OpPlus";
            } else {
                throw new NoOtherwiseException();
            }
        }
        this.converter.javawrap(rxCode);
        rxCode2.javacode = rxCode.javacode.OpCc(null, $013).OpCc(null, Rexx.toRexx(string)).OpCc(null, $06).OpCc(null, this.settings()).OpCc(null, $07);
        rxCode2.wrapped = true;
        rxCode2.type = n2 == 14 ? RxType.BOOL_TYPE : RxType.REXX_TYPE;
        if (rxCode2.constant) {
            rxCode2.constant = false;
        }
        if (bl2) {
            try {
                rexx2 = new Rexx(this.rxt.interpreter.stringvalue(rxCode));
                rexxSet = rxCursor.curnumer;
                switch (n2) {
                    case 14: {
                        rxCode2.value = rexx2.OpNot(rexxSet) ? int1 : int0;
                        break;
                    }
                    case 12: {
                        rxCode2.value = rexx2.OpMinus(rexxSet);
                        break;
                    }
                    case 16: {
                        rxCode2.value = rexx2.OpPlus(rexxSet);
                        break;
                    }
                    default: {
                        throw new NoOtherwiseException();
                    }
                }
            }
            catch (RuntimeException runtimeException3) {
                runtimeException = runtimeException3;
                throw new RxSignal(rxCursor, runtimeException, rxToken);
            }
        }
        return rxCode2;
    }

    private RxType binarytype(RxType rxType, RxType rxType2) {
        if (rxType.classname.OpEqS(null, $027)) {
            return rxType;
        }
        if (rxType2.classname.OpEqS(null, $027)) {
            return rxType2;
        }
        if (rxType.classname.OpEqS(null, $028)) {
            return rxType;
        }
        if (rxType2.classname.OpEqS(null, $028)) {
            return rxType2;
        }
        if (rxType.classname.OpEqS(null, $029)) {
            return rxType;
        }
        if (rxType2.classname.OpEqS(null, $029)) {
            return rxType2;
        }
        return RxType.INT_TYPE;
    }

    private int getcode(Rexx rexx) {
        if (rexx.length().toint() == 1) {
            switch (rexx.tochar()) {
                case ' ': {
                    return 2;
                }
                case '+': {
                    return 16;
                }
                case '-': {
                    return 12;
                }
                case '=': {
                    return 6;
                }
                case '<': {
                    return 10;
                }
                case '>': {
                    return 7;
                }
                case '|': {
                    return 15;
                }
                case '*': {
                    return 26;
                }
                case '&': {
                    return 1;
                }
                case '/': {
                    return 5;
                }
                case '%': {
                    return 9;
                }
                case '\\': {
                    return 14;
                }
                case '?': {
                    return 4;
                }
            }
            throw new NoOtherwiseException();
        }
        if (rexx.OpEqS(null, $030)) {
            return 13;
        }
        if (rexx.OpEqS(null, $031)) {
            return 3;
        }
        if (rexx.OpEqS(null, $032)) {
            return 19;
        }
        if (rexx.OpEqS(null, $033)) {
            return 20;
        }
        if (rexx.OpEqS(null, $034)) {
            return 8;
        }
        if (rexx.OpEqS(null, $035)) {
            return 11;
        }
        if (rexx.OpEqS(null, $036)) {
            return 27;
        }
        if (rexx.OpEqS(null, $037)) {
            return 18;
        }
        if (rexx.OpEqS(null, $038)) {
            return 17;
        }
        if (rexx.OpEqS(null, $039)) {
            return 21;
        }
        if (rexx.OpEqS(null, $040)) {
            return 22;
        }
        if (rexx.OpEqS(null, $041)) {
            return 23;
        }
        if (rexx.OpEqS(null, $042)) {
            return 24;
        }
        throw new NoOtherwiseException();
    }

    private int getprio(Rexx rexx, RxToken rxToken) {
        int n = this.getcode(rexx);
        switch (n) {
            case 2: {
                return 5;
            }
            case 16: {
                return 7;
            }
            case 12: {
                return 7;
            }
            case 6: {
                return 4;
            }
            case 7: {
                return 4;
            }
            case 10: {
                return 4;
            }
            case 15: {
                return 2;
            }
            case 26: {
                return 8;
            }
            case 1: {
                return 3;
            }
            case 5: {
                return 8;
            }
            case 9: {
                return 8;
            }
            case 14: {
                throw new RxError(this.rxt, rxToken, "dyadic.not");
            }
            case 13: {
                return 4;
            }
            case 3: {
                return 5;
            }
            case 19: {
                return 4;
            }
            case 20: {
                return 4;
            }
            case 8: {
                return 4;
            }
            case 11: {
                return 4;
            }
            case 27: {
                return 2;
            }
            case 18: {
                return 8;
            }
            case 17: {
                return 9;
            }
            case 21: {
                return 4;
            }
            case 22: {
                return 4;
            }
            case 23: {
                return 4;
            }
            case 24: {
                return 4;
            }
        }
        throw new RxQuit(this.rxt, rxToken, "internal.error", Rexx.toRexx("RxExprParser: bad operator").OpCcblank(null, rexx));
    }

    private Rexx optokens(RxToken[] rxTokenArray, int n) {
        Rexx rexx = null;
        Rexx rexx2 = new Rexx(rxTokenArray[n].value[0]);
        char c = rxTokenArray[n + 1].type;
        if (c != 'O') {
            return rexx2;
        }
        Rexx rexx3 = rexx2.OpCc(null, new Rexx(rxTokenArray[n + 1].value[0]));
        char c2 = rxTokenArray[n + 2].type;
        if (c2 == 'O') {
            rexx = rexx3.OpCc(null, new Rexx(rxTokenArray[n + 2].value[0]));
            if (rexx.OpEqS(null, $033)) {
                return rexx;
            }
            if (rexx.OpEqS(null, $042)) {
                return rexx;
            }
            if (rexx.OpEqS(null, $041)) {
                return rexx;
            }
            if (rexx.OpEqS(null, $043)) {
                return Rexx.toRexx("<<=");
            }
            if (rexx.OpEqS(null, $044)) {
                return Rexx.toRexx(">>=");
            }
        }
        if (rexx3.OpEqS(null, $030)) {
            return rexx3;
        }
        if (rexx3.OpEqS(null, $035)) {
            return rexx3;
        }
        if (rexx3.OpEqS(null, $034)) {
            return rexx3;
        }
        if (rexx3.OpEqS(null, $031)) {
            return rexx3;
        }
        if (rexx3.OpEqS(null, $032)) {
            return rexx3;
        }
        if (rexx3.OpEqS(null, $037)) {
            return rexx3;
        }
        if (rexx3.OpEqS(null, $038)) {
            return rexx3;
        }
        if (rexx3.OpEqS(null, $036)) {
            return rexx3;
        }
        if (rexx3.OpEqS(null, $039)) {
            return rexx3;
        }
        if (rexx3.OpEqS(null, $040)) {
            return rexx3;
        }
        if (rexx3.OpEqS(null, $045)) {
            return Rexx.toRexx("\\=");
        }
        if (rexx3.OpEqS(null, $046)) {
            return Rexx.toRexx("\\=");
        }
        if (rexx3.OpEqS(null, $047)) {
            return Rexx.toRexx("<=");
        }
        if (rexx3.OpEqS(null, $048)) {
            return Rexx.toRexx(">=");
        }
        return rexx2;
    }

    private Rexx settings() {
        if (this.rxt.exec) {
            return Rexx.toRexx("");
        }
        if (this.rxt.program.parser.level >= 2) {
            return this.rxt.program.parser.cursor.curmethod.methodset;
        }
        return Rexx.toRexx(this.rxt.program.parser.cursor.curclass.classset);
    }
}

