/***************************************************************************
 * SPDX-FileCopyrightText: 2024 S. MANKOWSKI stephane@mankowski.fr
 * SPDX-FileCopyrightText: 2024 G. DE BURE support@mankowski.fr
 * SPDX-License-Identifier: GPL-3.0-or-later
 ***************************************************************************/
/** @file
 * This file is a test script.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgtestmacro.h"
#include "skgbankincludes.h"
#include "skgimportexportmanager.h"

/**
 * The main function of the unit test
 * @param argc the number of arguments
 * @param argv the list of arguments
 */
int main(int argc, char** argv)
{
    Q_UNUSED(argc)
    Q_UNUSED(argv)

    // Init test
    SKGINITTEST(true)

    // ============================================================================
    {
        // Import
        SKGDocumentBank document1;
        SKGTESTERROR(QLatin1String("document1.load()"), document1.load(SKGTest::getTestPath(QLatin1String("IN")) % "skgtestbudget/budget.skg"), true)
        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QLatin1String("BUDGET_CREATION"), err)

            SKGTESTERROR(QLatin1String("BUDGET.createAutomaticBudget"), SKGBudgetObject::createAutomaticBudget(&document1, 2010, 2010, true, true), true)
            SKGTESTERROR(QLatin1String("BUDGET.balanceBudget"), SKGBudgetObject::balanceBudget(&document1, 2010), true)
        }
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QLatin1String("BUDGETRULE_CREATION"), err)

            SKGBudgetRuleObject br(&document1);

            SKGTESTERROR(QLatin1String("BUDGETRULE.enableYearCondition"), br.enableYearCondition(true), true)
            SKGTESTBOOL("BUDGETRULE.isYearConditionEnabled", br.isYearConditionEnabled(), true)
            SKGTESTERROR(QLatin1String("BUDGETRULE.enableYearCondition"), br.enableYearCondition(false), true)
            SKGTESTBOOL("BUDGETRULE.isYearConditionEnabled", br.isYearConditionEnabled(), false)
            SKGTESTERROR(QLatin1String("BUDGETRULE.setBudgetYear"), br.setBudgetYear(2010), true)
            SKGTEST(QLatin1String("BUDGETRULE.getBudgetYear"), br.getBudgetYear(), 2010)

            SKGTESTERROR(QLatin1String("BUDGETRULE.enableMonthCondition"), br.enableMonthCondition(true), true)
            SKGTESTBOOL("BUDGETRULE.isMonthConditionEnabled", br.isMonthConditionEnabled(), true)
            SKGTESTERROR(QLatin1String("BUDGETRULE.enableMonthCondition"), br.enableMonthCondition(false), true)
            SKGTESTBOOL("BUDGETRULE.isMonthConditionEnabled", br.isMonthConditionEnabled(), false)
            SKGTESTERROR(QLatin1String("BUDGETRULE.setBudgetMonth"), br.setBudgetMonth(10), true)
            SKGTEST(QLatin1String("BUDGETRULE.getBudgetMonth"), br.getBudgetMonth(), 10)

            SKGTESTERROR(QLatin1String("BUDGETRULE.setOrder"), br.setOrder(1.0), true)
            SKGTEST(QLatin1String("BUDGETRULE.getOrder"), br.getOrder(), 1.0)
            SKGTESTERROR(QLatin1String("BUDGETRULE.setOrder"), br.setOrder(-1), true)
            SKGTEST(QLatin1String("BUDGETRULE.getOrder"), br.getOrder(), 1.0)

            SKGTESTERROR(QLatin1String("BUDGETRULE.enableCategoryCondition"), br.enableCategoryCondition(true), true)
            SKGTESTBOOL("BUDGETRULE.isCategoryConditionEnabled", br.isCategoryConditionEnabled(), true)
            SKGCategoryObject cat;
            SKGTESTERROR(QLatin1String("BUDGETRULE.enableCategoryChange"), br.enableCategoryChange(br.isCategoryChangeEnabled()), true)
            SKGTESTERROR(QLatin1String("BUDGETRULE.getBudgetCategory"), br.getBudgetCategory(cat), false)
            SKGTESTERROR(QLatin1String("BUDGETRULE.createPathCategory"), SKGCategoryObject::createPathCategory(&document1, QLatin1String("category_55 > category_57"), cat), true)
            SKGTESTERROR(QLatin1String("BUDGETRULE.removeBudgetCategory"), br.removeBudgetCategory(), true)
            SKGTESTERROR(QLatin1String("BUDGETRULE.setBudgetCategory"), br.setBudgetCategory(cat), true)


            SKGTESTERROR(QLatin1String("BUDGETRULE.setCondition"), br.setCondition(SKGBudgetRuleObject::NEGATIVE), true)
            SKGTEST(QLatin1String("BUDGETRULE.getCondition"), static_cast<unsigned int>(br.getCondition()), static_cast<unsigned int>(SKGBudgetRuleObject::NEGATIVE))
            SKGTESTERROR(QLatin1String("BUDGETRULE.setCondition"), br.setCondition(SKGBudgetRuleObject::POSITIVE), true)
            SKGTEST(QLatin1String("BUDGETRULE.getCondition"), static_cast<unsigned int>(br.getCondition()), static_cast<unsigned int>(SKGBudgetRuleObject::POSITIVE))
            SKGTESTERROR(QLatin1String("BUDGETRULE.setCondition"), br.setCondition(SKGBudgetRuleObject::ALL), true)
            SKGTEST(QLatin1String("BUDGETRULE.getCondition"), static_cast<unsigned int>(br.getCondition()), static_cast<unsigned int>(SKGBudgetRuleObject::ALL))

            SKGTESTERROR(QLatin1String("BUDGETRULE.setQuantity"), br.setQuantity(100, false), true)
            SKGTEST(QLatin1String("BUDGETRULE.getQuantity"), br.getQuantity(), 100)
            SKGTESTBOOL("BUDGETRULE.isAbolute", br.isAbolute(), false)

            SKGTESTERROR(QLatin1String("BUDGETRULE.setTransfer"), br.setTransfer(SKGBudgetRuleObject::CURRENT), true)
            SKGTEST(QLatin1String("BUDGETRULE.getTransferMode"), static_cast<unsigned int>(br.getTransferMode()), static_cast<unsigned int>(SKGBudgetRuleObject::CURRENT))
            SKGTESTERROR(QLatin1String("BUDGETRULE.setTransfer"), br.setTransfer(SKGBudgetRuleObject::NEXT), true)
            SKGTEST(QLatin1String("BUDGETRULE.getTransferMode"), static_cast<unsigned int>(br.getTransferMode()), static_cast<unsigned int>(SKGBudgetRuleObject::NEXT))

            SKGTESTERROR(QLatin1String("BUDGETRULE.save"), br.save(), true)

            SKGBudgetRuleObject br2 = br;
            SKGBudgetRuleObject br3(br);
            SKGBudgetRuleObject br4(static_cast<SKGObjectBase>(br));
            SKGBudgetRuleObject br5(SKGObjectBase(&document1, QLatin1String("xxx"), br.getID()));

            SKGTESTERROR(QLatin1String("BUDGETRULE.processAllRules"), SKGBudgetRuleObject::processAllRules(&document1), true)

            SKGTESTERROR(QLatin1String("BUDGETRULE.setTransfer"), br.setTransfer(SKGBudgetRuleObject::YEAR), true)
            SKGTEST(QLatin1String("BUDGETRULE.getTransferMode"), static_cast<unsigned int>(br.getTransferMode()), static_cast<unsigned int>(SKGBudgetRuleObject::YEAR))
            SKGTESTERROR(QLatin1String("BUDGETRULE.save"), br.save(), true)

            SKGTESTERROR(QLatin1String("BUDGETRULE.processAllRules"), SKGBudgetRuleObject::processAllRules(&document1), true)
        }
        SKGTESTERROR(QLatin1String("document1.saveAs()"), document1.saveAs(SKGTest::getTestPath(QLatin1String("OUT")) % "skgtestbudget/budget.skg", true), true)
    }

    // ============================================================================
    {
        // Import
        SKGDocumentBank document1;
        SKGTESTERROR(QLatin1String("document1.load()"), document1.load(SKGTest::getTestPath(QLatin1String("IN")) % "skgtestbudget/320323.skg"), true)
        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QLatin1String("BUDGET_PROCESS"), err)

            SKGTESTERROR(QLatin1String("BUDGETRULE.processAllRules"), SKGBudgetRuleObject::processAllRules(&document1), true)
        }
        document1.dump(DUMPBUDGET);
        bool check = false;
        document1.existObjects(QLatin1String("v_budget_display"), QLatin1String("t_PERIOD='2013-02' AND t_CATEGORY='Alimentation' AND f_budgeted_modified=300"), check);
        SKGTESTBOOL("BUDGETRULE.Alimentation 2013-02 300", check, true)

        document1.existObjects(QLatin1String("v_budget_display"), QLatin1String("t_PERIOD='2013-02' AND t_CATEGORY='Loisirs' AND f_budgeted_modified=2100"), check);
        SKGTESTBOOL("BUDGETRULE.Loisirs 2013-02 2100", check, true)

        SKGObjectBase bo;
        SKGTESTERROR(QLatin1String("document1.getObject()"), document1.getObject(QLatin1String("v_budget_display"), QLatin1String("t_PERIOD='2013-02' AND t_CATEGORY='Loisirs' AND f_budgeted_modified=2100"), bo), true)
        SKGBudgetObject b(bo);
        SKGTEST(QLatin1String("BUDGET.getBudgetedAmount"), b.getBudgetedAmount(), 300)
        SKGCategoryObject cat;
        SKGTESTERROR(QLatin1String("BUDGET.getCategory"), b.getCategory(cat), true)
        SKGTEST(QLatin1String("BUDGET.getModificationReasons"), b.getModificationReasons().remove(QLatin1Char(',')), QLatin1String("Transfer of -1800 from ' 2013-01 2000.0' to 'Loisirs 2013-02 300.0' due to the rule 'All 100.0% Next Loisirs'"))
        SKGTESTERROR(QLatin1String("BUDGET.removeCategory"), b.removeCategory(), true)
        SKGTESTERROR(QLatin1String("BUDGET.enableSubCategoriesInclusion"), b.enableSubCategoriesInclusion(true), true)
        SKGTESTBOOL(QLatin1String("BUDGET.isSubCategoriesInclusionEnabled"), b.isSubCategoriesInclusionEnabled(), true)
        SKGTESTERROR(QLatin1String("BUDGET.enableSubCategoriesInclusion"), b.enableSubCategoriesInclusion(false), true)
        SKGTESTBOOL(QLatin1String("BUDGET.isSubCategoriesInclusionEnabled"), b.isSubCategoriesInclusionEnabled(), false)

        SKGBudgetObject bu;
    }

    // End test
    SKGENDTEST()
}
