/*
    This file is part of KOrganizer.
    Copyright (c) 2001 Cornelius Schumacher <schumacher@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    As a special exception, permission is given to link this program
    with any edition of Qt, and distribute the resulting executable,
    without including the source code for Qt in the source distribution.
*/

#include <qtooltip.h>
#include <qlayout.h>
#include <qvbox.h>
#include <qbuttongroup.h>
#include <qvgroupbox.h>
#include <qwidgetstack.h>
#include <qdatetime.h>

#include <kdebug.h>
#include <kglobal.h>
#include <klocale.h>
#include <kiconloader.h>
#include <kmessagebox.h>
#include <kfiledialog.h>
#include <kstandarddirs.h>

#include <libkcal/event.h>

#include <libkdepim/kdateedit.h>

#include "koprefs.h"

#include "koeditorgeneralevent.h"
#include "koeditorgeneralevent.moc"
#include "koeventtimewidget.h"

KOEditorGeneralEvent::KOEditorGeneralEvent(QObject* parent,
                                           const char* name) :
  KOEditorGeneral( parent, name)
{
}

KOEditorGeneralEvent::~KOEditorGeneralEvent()
{
}

void KOEditorGeneralEvent::finishSetup()
{
  QWidget::setTabOrder(mSummaryEdit, mLocationEdit);
  QWidget::setTabOrder(mLocationEdit, mEventTimeWidget);
  QWidget::setTabOrder(mEventTimeWidget, mAlarmButton);
  QWidget::setTabOrder(mAlarmButton, mFreeTimeCombo);
  QWidget::setTabOrder(mFreeTimeCombo, mCategoriesButton);
#if 0
  QWidget::setTabOrder(mCategoriesButton, mSecrecyCombo);
  QWidget::setTabOrder(mSecrecyCombo, mDescriptionEdit);
#endif
  QWidget::setTabOrder(mCategoriesButton, mDescriptionEdit);

  mSummaryEdit->setFocus();
}

void KOEditorGeneralEvent::initTime(QWidget *parent,QBoxLayout *topLayout)
{
  mEventTimeWidget = new KOEventTimeWidget( parent );
  topLayout->addWidget( mEventTimeWidget );
  connect( mEventTimeWidget, SIGNAL( dateTimesChanged( QDateTime, QDateTime ) ),
           this, SIGNAL( dateTimesChanged( QDateTime, QDateTime ) ) );
  connect( mEventTimeWidget, SIGNAL( allDayChanged( bool ) ),
           this, SIGNAL( allDayChanged( bool ) ) );
  connect( mEventTimeWidget, SIGNAL( recursChanged( bool ) ),
           this, SIGNAL( recursChanged( bool ) ) );
  connect(this,SIGNAL(dateTimesChanged(QDateTime,QDateTime)),
          mEventTimeWidget,SLOT(setDuration()));
}

void KOEditorGeneralEvent::initClass(QWidget *parent,QBoxLayout *topLayout)
{
  QBoxLayout *classLayout = new QHBoxLayout(topLayout);

  QLabel *freeTimeLabel = new QLabel(i18n("Show time as:"),parent);
  classLayout->addWidget(freeTimeLabel);

  mFreeTimeCombo = new QComboBox(false, parent);
  mFreeTimeCombo->insertItem(i18n("Busy"));
  mFreeTimeCombo->insertItem(i18n("Free"));
  classLayout->addWidget(mFreeTimeCombo);
}

void KOEditorGeneralEvent::setDefaults(QDateTime from,QDateTime to,bool allDay)
{
  KOEditorGeneral::setDefaults(allDay);
  mEventTimeWidget->setDefaults( from, to, allDay );
}

void KOEditorGeneralEvent::readEvent( Event *event, bool tmpl )
{
  mEventTimeWidget->readEvent( event, tmpl );

  switch( event->transparency() ) {
  case Event::Transparent:
    mFreeTimeCombo->setCurrentItem(1);
    break;
  case Event::Opaque:
    mFreeTimeCombo->setCurrentItem(0);
    break;
  }

  readIncidence(event);
}

void KOEditorGeneralEvent::writeEvent(Event *event)
{
//  kdDebug(5850) << "KOEditorGeneralEvent::writeEvent()" << endl;

  writeIncidence(event);

  mEventTimeWidget->writeEvent( event );

  event->setTransparency(mFreeTimeCombo->currentItem());

//  kdDebug(5850) << "KOEditorGeneralEvent::writeEvent() done" << endl;
}

bool KOEditorGeneralEvent::validateInput()
{
//  kdDebug(5850) << "KOEditorGeneralEvent::validateInput()" << endl;

    if( !mEventTimeWidget->validateInput() )
        return false;

    return KOEditorGeneral::validateInput();
}
