/*
    SPDX-FileCopyrightText: 2020 Volker Krause <vkrause@kde.org>
    SPDX-License-Identifier: LGPL-2.0-or-later
*/

#include "localization_p.h"

#include <KLazyLocalizedString>

namespace KOSMIndoorMap {

// TODO expand this, see:
// - https://taginfo.openstreetmap.org/keys/?key=amenity#values
// - https://taginfo.openstreetmap.org/keys/?key=shop#values
// - https://taginfo.openstreetmap.org/keys/?key=tourism#values
// - https://taginfo.openstreetmap.org/keys/?key=leisure#values
// - parts of https://taginfo.openstreetmap.org/keys/?key=office#values
// - parts of https://taginfo.openstreetmap.org/keys/?key=room#values
static constexpr const ValueMapEntry amenity_map[] = {
    { "alcohol", kli18nc("OSM::amenity/shop", "Alcohol") },
    { "antiques", kli18nc("OSM::shop", "Antiques") },
    { "apartment", kli18nc("OSM::amenity/shop", "Apartment") },
    { "aquarium", kli18nc("OSM::tourism", "Aquarium") },
    { "archaeological_site", kli18nc("OSM::historic", "Archaeological Site") },
    { "art", kli18nc("OSM::shop", "Art") },
    { "arts_centre", kli18nc("OSM::amenity/shop", "Arts Center") },
    { "artwork", kli18nc("OSM::amenity/shop", "Artwork") },
    { "atm", kli18nc("OSM::amenity/shop", "ATM") },
    { "attraction", kli18nc("OSM::amenity/shop", "Attraction") },
    { "baby_goods", kli18nc("OSM::shop", "Baby Goods") },
    { "bag", kli18nc("OSM::amenity/shop", "Bag") },
    { "baggage_claim", kli18nc("OSM::amenity", "Baggage Claim") },
    { "bakery", kli18nc("OSM::amenity/shop", "Bakery") },
    { "bank", kli18nc("OSM::amenity/shop", "Bank") },
    { "bar", kli18nc("OSM::amenity/shop", "Bar") },
    { "beauty", kli18nc("OSM::amenity/shop", "Beauty") },
    { "bed", kli18nc("OSM::amenity/shop", "Bed") },
    { "bench", kli18nc("OSM::amenity", "Bench") },
    { "beverages", kli18nc("OSM::amenity/shop", "Beverages") },
    { "bicycle", kli18nc("OSM::amenity/shop", "Bicycle") },
    { "bicycle_parking", kli18nc("OSM::amenity/shop", "Bicycle Parking") },
    { "bicycle_rental", kli18nc("OSM::amenity/shop", "Bicycle Rental") },
    { "bicycle_repair_station", kli18nc("OSM::amenity", "Bicycle Repair Station") },
    { "biergarten", kli18nc("OSM::amenity", "Beer Garden") },
    { "books", kli18nc("OSM::amenity/shop", "Books") },
    { "boutique", kli18nc("OSM::amenity/shop", "Boutique") },
    { "bowling_alley", kli18nc("OSM::leisure", "Bowling Alley") },
    { "bureau_de_change", kli18nc("OSM::amenity/shop", "Bureau de Change") },
    { "butcher", kli18nc("OSM::amenity/shop", "Butcher") },
    { "cafe", kli18nc("OSM::amenity/shop", "Cafe") },
    { "car", kli18nc("OSM::amenity/shop", "Car") },
    { "car_rental", kli18nc("OSM::amenity/shop", "Car Rental") },
    { "car_repair", kli18nc("OSM::shop", "Car Repair") },
    { "car_sharing", kli18nc("OSM::amenity/shop", "Car Sharing") },
    { "car_wash", kli18nc("OSM::amenity", "Car Wash") },
    { "castle", kli18nc("OSM::historic", "Castle") },
    { "charging_station", kli18nc("OSM::amenity/shop", "Charging Station") },
    { "charity", kli18nc("OSM::shop", "Charity Shop") },
    { "cheese", kli18nc("OSM::shop", "Cheese") },
    { "chemist", kli18nc("OSM::amenity/shop", "Chemist") },
    { "chocolate", kli18nc("OSM::amenity/shop", "Chocolate") },
    { "cinema", kli18nc("OSM::amenity/shop", "Cinema") },
    { "citywalls", kli18nc("OSM::historic", "Citywall") },
    { "class", kli18nc("OSM::room", "Classroom") },
    { "classroom", kli18nc("OSM::room", "Classroom") },
    { "clinic", kli18nc("OSM::healthcare", "Clinic") },
    { "clothes", kli18nc("OSM::amenity/shop", "Clothes") },
    { "coffee", kli18nc("OSM::amenity/shop", "Coffee") },
    { "community_centre", kli18nc("OSM::amenity", "Community Center") },
    { "computer", kli18nc("OSM::amenity/shop", "Computer") },
    { "confectionery", kli18nc("OSM::amenity/shop", "Confectionery") },
    { "conference_centre", kli18nc("OSM::amenity", "Conference Center") },
    { "consulate", kli18nc("OSM::diplomatic", "Consulate") },
    { "convenience", kli18nc("OSM::amenity/shop", "Convenience Store") },
    { "copyshop", kli18nc("OSM::amenity/shop", "Copy Shop") },
    { "cosmetics", kli18nc("OSM::amenity/shop", "Cosmetics") },
    { "courthouse", kli18nc("OSM::amenity/shop", "Court House") },
    { "coworking", kli18nc("OSM::amenity", "Coworking Space") },
    { "coworking_space", kli18nc("OSM::amenity", "Coworking Space") },
    { "craft", kli18nc("OSM::shop", "Art and Craft Supplies") },
    { "curtain", kli18nc("OSM::shop", "Curtains") },
    { "deli", kli18nc("OSM::amenity/shop", "Deli") },
    { "dentist", kli18nc("OSM::healthcare", "Dentist") },
    { "department_store", kli18nc("OSM::amenity/shop", "Department Store") },
    { "doctor", kli18nc("OSM::healthcare", "Doctor") },
    { "doctors", kli18nc("OSM::healthcare", "Doctor") },
    { "doityourself", kli18nc("OSM::amenity/shop", "Hardware Store") },
    { "drinking_water", kli18nc("OSM::amenity/shop", "Drinking Water") },
    { "dry_cleaning", kli18nc("OSM::amenity/shop", "Dry Cleaning") },
    { "electrical", kli18nc("OSM::shop", "Electrical") },
    { "electronics", kli18nc("OSM::amenity/shop", "Electronics") },
    { "embassy", kli18nc("OSM::diplomatic", "Embassy") },
    { "events_venue", kli18nc("OSM::amenity", "Events Venue") },
    { "exhibition_hall", kli18nc("OSM::amenity", "Exhibition Hall") },
    { "fabric", kli18nc("OSM::shop", "Fabric") },
    { "fashion", kli18nc("OSM::amenity/shop", "Fashion") },
    { "fashion_accessories", kli18nc("OSM::shop", "Fashion Accessories") },
    { "fast_food", kli18nc("OSM::amenity/shop", "Fast Food") },
    { "ferry_terminal", kli18nc("OSM::amenity/shop", "Ferry Terminal") },
    { "fire_station", kli18nc("OSM::amenity", "Fire Station") },
    { "fitness_centre", kli18nc("OSM::leisure", "Fitness Center") },
    { "fitness_station", kli18nc("OSM::leisure", "Fitness Station") },
    { "florist", kli18nc("OSM::amenity/shop", "Florist") },
    { "food", kli18nc("OSM::shop", "Food") },
    { "food_court", kli18nc("OSM::amenity/shop", "Food Court") },
    { "fountain", kli18nc("OSM::amenity/shop", "Fountain") },
    { "fuel", kli18nc("OSM::amenity", "Gas Station") },
    { "furniture", kli18nc("OSM::amenity/shop", "Furniture") },
    { "gallery", kli18nc("OSM::amenity/shop", "Gallery") },
    { "games", kli18nc("OSM::shop", "Games") },
    { "garden", kli18nc("OSM::amenity/shop", "Garden") },
    { "garden_centre", kli18nc("OSM::amenity/shop", "Garden Center") },
    { "gift", kli18nc("OSM::amenity/shop", "Gift Shop") },
    { "golf_course", kli18nc("OSM::leisure", "Golf Course") },
    { "government", kli18nc("OSM::office", "Government") },
    { "greengrocer", kli18nc("OSM::amenity/shop", "Greengrocer") },
    { "guest_house", kli18nc("OSM::amenity/shop", "Guest House") },
    { "hairdresser", kli18nc("OSM::amenity/shop", "Hairdresser") },
    { "hardware", kli18nc("OSM::shop", "Hardware") },
    { "health_food", kli18nc("OSM::shop", "Health Food") },
    { "hearing_aids", kli18nc("OSM::amenity/shop", "Hearing Aids") },
    { "hifi", kli18nc("OSM::shop", "Hi-fi") },
    { "hospital", kli18nc("OSM::amenity/shop", "Hospital") },
    { "hostel", kli18nc("OSM::amenity/shop", "Hostel") },
    { "hotel", kli18nc("OSM::amenity/shop", "Hotel") },
    { "houseware", kli18nc("OSM::amenity/shop", "Houseware") },
    { "ice_cream", kli18nc("OSM::amenity/shop", "Ice Cream") },
    { "information", kli18nc("OSM::amenity/shop", "Information") },
    { "interior_decoration", kli18nc("OSM::amenity/shop", "Interior Decoration") },
    { "internet_cafe", kli18nc("OSM::amenity/shop", "Internet Cafe") },
    { "jewelry", kli18nc("OSM::amenity/shop", "Jewelry") },
    { "kiosk", kli18nc("OSM::amenity/shop", "Kiosk") },
    { "kitchen", kli18nc("OSM::room", "Kitchen") },
    { "laundry", kli18nc("OSM::amenity/shop", "Laundry") },
    { "lecture", kli18nc("OSM::room", "Lecture Hall") },
    { "lecture_hall", kli18nc("OSM::room", "Lecture Hall") },
    { "library", kli18nc("OSM::amenity/shop", "Library") },
    { "locker", kli18nc("OSM::amenity", "Locker") },
    { "lockers", kli18nc("OSM::amenity", "Locker") },
    { "locksmith", kli18nc("OSM::amenity/shop", "Locksmith") },
    { "lost_and_found", kli18nc("OSM::amenity", "Lost & Found") },
    { "lost_property", kli18nc("OSM::amenity", "Lost & Found") },
    { "lost_property_office", kli18nc("OSM::amenity", "Lost & Found") },
    { "luggage_locker", kli18nc("OSM::amenity", "Locker") },
    { "mall", kli18nc("OSM::amenity/shop", "Mall") },
    { "marketplace", kli18nc("OSM::amenity", "Marketplace") },
    { "medical_supply", kli18nc("OSM::amenity/shop", "Medical Supply") },
    { "memorial", kli18nc("OSM::historic", "Memorial") },
    { "mobile_phone", kli18nc("OSM::amenity/shop", "Mobile Phone") },
    { "money_transfer", kli18nc("OSM::amenity/shop", "Money Transfer") },
    { "monument", kli18nc("OSM::historic", "Monument") },
    { "motorcycle", kli18nc("OSM::shop", "Motorcycle") },
    { "motorcycle_parking", kli18nc("OSM::amenity/shop", "Motorcycle Parking") },
    { "motorcycle_rental", kli18nc("OSM::amenity/shop", "Motorcycle Rental") },
    { "museum", kli18nc("OSM::amenity/shop", "Museum") },
    { "music", kli18nc("OSM::amenity/shop", "Music") },
    { "musical_instrument", kli18nc("OSM::amenity/shop", "Musical Instruments") },
    { "newsagent", kli18nc("OSM::amenity/shop", "Newsagent") },
    { "nightclub", kli18nc("OSM::amenity", "Nightclub") },
    { "nutrition_supplements", kli18nc("OSM::shop", "Nutrition Supplements") },
    { "office", kli18nc("OSM::amenity/shop", "Office") },
    { "optician", kli18nc("OSM::amenity/shop", "Optician") },
    { "optometrist", kli18nc("OSM::healthcare", "Optometrist") },
    { "outdoor", kli18nc("OSM::amenity/shop", "Outdoor") },
    { "paint", kli18nc("OSM::amenity/shop", "Paint") },
    { "park", kli18nc("outdoor recreational area", "Park") },
    { "parking", kli18nc("OSM::amenity/shop", "Parking") },
    { "parking_tickets", kli18nc("OSM::amenity/shop", "Parking Tickets") },
    { "pastry", kli18nc("OSM::amenity/shop", "Pastry") },
    { "perfumery", kli18nc("OSM::amenity/shop", "Perfumery") },
    { "pet", kli18nc("OSM::amenity/shop", "Pet") },
    { "pharmacy", kli18nc("OSM::amenity/shop", "Pharmacy") },
    { "photo", kli18nc("OSM::amenity/shop", "Photo") },
    { "physiotherapist", kli18nc("OSM::healthcare", "Physiotherapist") },
    { "place_of_worship", kli18nc("OSM::amenity/shop", "Place of Worship") },
    { "playground", kli18n("Playground") },
    { "police", kli18nc("OSM::amenity/shop", "Police") },
    { "post_box", kli18nc("OSM::amenity/shop", "Post Box") },
    { "post_office", kli18nc("OSM::amenity/shop", "Post Office") },
    { "pottery", kli18nc("OSM::shop", "Potery") },
    { "psychotherapist", kli18nc("OSM::healthcare", "Psychotherapist") },
    { "pub", kli18nc("OSM::amenity/shop", "Pub") },
    { "public_transport_tickets", kli18nc("OSM::amenity/shop", "Public Transport Tickets") },
    { "railway_station", kli18nc("OSM::building", "Train Station") },
    { "recycling", kli18nc("OSM::amenity/shop", "Recycling") },
    { "research_institute", kli18nc("OSM::amenity", "Research Institute") },
    { "restaurant", kli18nc("OSM::amenity/shop", "Restaurant") },
    { "sauna", kli18nc("OSM::amenity", "Sauna") },
    { "school", kli18nc("OSM::amenity/shop", "School") },
    { "scooter_rental", kli18nc("OSM::amenity/shop", "Kick Scooter Rental") },
    { "seafood", kli18nc("OSM::amenity/shop", "Seafood") },
    { "second_hand", kli18nc("OSM::shop", "Second Hand") },
    { "shoe_repair", kli18nc("OSM::shop", "Shoe Repair") },
    { "shoes", kli18nc("OSM::shop", "Shoes") },
    { "shop", kli18nc("OSM::amenity/shop", "Shop") },
    { "shower", kli18nc("OSM::amenity", "Shower") },
    { "social_facility", kli18nc("OSM::amenity/shop", "Social Facility") },
    { "souveniers", kli18nc("OSM::amenity/shop", "Souvenirs") },
    { "sports", kli18nc("OSM::amenity/shop", "Sports") },
    { "sports_centre", kli18nc("OSM::amenity", "Sports Center") },
    { "sports_hall", kli18nc("OSM::amenity", "Sports Hall") },
    { "stationery", kli18nc("OSM::amenity/shop", "Stationery") },
    { "supermarket", kli18nc("OSM::amenity/shop", "Supermarket") },
    { "tailor", kli18nc("OSM::amenity/shop", "Tailor") },
    { "tatoo", kli18nc("OSM::amenity/shop", "Tattoo") },
    { "taxi", kli18nc("OSM::amenity/shop", "Taxi") },
    { "tea", kli18nc("OSM::amenity/shop", "Tea") },
    { "telecommunication", kli18nc("OSM::shop", "Telecommunication") },
    { "theatre", kli18nc("OSM::amenity/shop", "Theatre") },
    { "theme_park", kli18nc("OSM::tourism", "Theme Park") },
    { "ticket", kli18nc("OSM::amenity/shop", "Tickets") },
    { "tobacco", kli18nc("OSM::amenity/shop", "Tobacco") },
    { "toilets", kli18nc("OSM::amenity/shop", "Toilets") },
    { "townhall", kli18nc("OSM::amenity/shop", "Town Hall") },
    { "toys", kli18nc("OSM::amenity/shop", "Toys") },
    { "train_station", kli18nc("OSM::building", "Train Station") },
    { "travel_agency", kli18nc("OSM::amenity/shop", "Travel Agency") },
    { "travel_agent", kli18nc("OSM::amenity/shop", "Travel Agency") },
    { "university", kli18nc("OSM::amenity/shop", "University") },
    { "variety_store", kli18nc("OSM::amenity/shop", "Variety Store") },
    { "veterinary", kli18nc("OSM::amenity", "Veterinary") },
    { "video_games", kli18nc("OSM::amenity/shop", "Video Games") },
    { "viewpoint", kli18nc("OSM::tourism", "Viewpoint") },
    { "waiting", kli18nc("OSM::amenity/shop", "Waiting Area") },
    { "waiting_area", kli18nc("OSM::amenity/shop", "Waiting Area") },
    { "waiting_room", kli18nc("OSM::amenity/shop", "Waiting Area") },
    { "waste_basket", kli18nc("OSM::amenity", "Waste Basket") },
    { "watches", kli18nc("OSM::shop", "Watches") },
    { "wine", kli18nc("OSM::amenity/shop", "Wine") },
    { "zoo", kli18nc("OSM::tourism", "Zoo") },
};
static_assert(isSortedLookupTable(amenity_map), "amenity map is not sorted!");

// TODO expand this, see https://taginfo.openstreetmap.org/keys/cuisine#values
static constexpr const ValueMapEntry cuisine_map[] = {
    { "african", kli18nc("OSM::cuisine", "African") },
    { "american", kli18nc("OSM::cuisine", "American") },
    { "arab", kli18nc("OSM::cuisine", "Arab") },
    { "argentinian", kli18nc("OSM::cuisine", "Argentinian") },
    { "asian", kli18nc("OSM::cuisine", "Asian") },
    { "austrian", kli18nc("OSM::cuisine", "Austrian") },
    { "bagel", kli18nc("OSM::cuisine", "Bagel") },
    { "balkan", kli18nc("OSM::cuisine", "Balkan") },
    { "barbecue", kli18nc("OSM::cuisine", "Barbecue") },
    { "barbeque", kli18nc("OSM::cuisine", "Barbecue") }, // very wide-spread typo
    { "bavarian", kli18nc("OSM::cuisine", "Bavarian") },
    { "bbq", kli18nc("OSM::cuisine", "Barbecue") }, // wide-spread alternative tag
    { "beef_bowl", kli18nc("OSM::cuisine", "Beef Bowl") },
    { "bolivian", kli18nc("OSM::cuisine", "Bolivian") },
    { "brazilian", kli18nc("OSM::cuisine", "Brazilian") },
    { "breakfast", kli18nc("OSM::cuisine", "Breakfast") },
    { "british", kli18nc("OSM::cuisine", "British") },
    { "brunch", kli18nc("OSM::cuisine", "Brunch") },
    { "bubble_tea", kli18nc("OSM::cuisine", "Bubble Tea") },
    { "buffet", kli18nc("OSM::cuisine", "Buffet") },
    { "burger", kli18nc("OSM::cuisine", "Burger") },
    { "cake", kli18nc("OSM::cuisine", "Cake") },
    { "caribbean", kli18nc("OSM::cuisine", "Caribbean") },
    { "chicken", kli18nc("OSM::cuisine", "Chicken") },
    { "chinese", kli18nc("OSM::cuisine", "Chinese") },
    { "coffee", kli18nc("OSM::cuisine", "Coffee") },
    { "coffee_shop", kli18nc("OSM::cuisine", "Coffee Shop") },
    { "cookies", kli18nc("OSM::cuisine", "Cookies") },
    { "crepe", kli18nc("OSM::cuisine", "Crêpe") },
    { "curry", kli18nc("OSM::cuisine", "Curry") },
    { "czech", kli18nc("OSM::cuisine", "Czech") },
    { "dessert", kli18nc("OSM::cuisine", "Dessert") },
    { "donut", kli18nc("OSM::cuisine", "Donut") },
    { "dumpling", kli18nc("OSM::cuisine", "Dumplings") },
    { "dumplings", kli18nc("OSM::cuisine", "Dumplings") },
    { "ethiopian", kli18nc("OSM::cuisine", "Ethiopian") },
    { "falafel", kli18nc("OSM::cuisine", "Falafel") },
    { "fast_food", kli18nc("OSM::cuisine", "Fast Food") },
    { "filipino", kli18nc("OSM::cuisine", "Filipino") },
    { "fish", kli18nc("OSM::cuisine", "Fish") },
    { "fish_and_chips", kli18nc("OSM::cuisine", "Fish & Chips") },
    { "french", kli18nc("OSM::cuisine", "French") },
    { "fries", kli18nc("OSM::cuisine", "Fries") },
    { "georigan", kli18nc("OSM::cuisine", "Georigan") },
    { "german", kli18nc("OSM::cuisine", "German") },
    { "greek", kli18nc("OSM::cuisine", "Greek") },
    { "grill", kli18nc("OSM::cuisine", "Grill") },
    { "gyros", kli18nc("OSM::cuisine", "Gyros") },
    { "hawaiian", kli18nc("OSM::cuisine", "Hawaiian") },
    { "hot_dog", kli18nc("OSM::cuisine", "Hot Dog") },
    { "hotdog", kli18nc("OSM::cuisine", "Hot Dog") }, // wide-spread alternative taggin
    { "ice_cream", kli18nc("OSM::cuisine", "Ice Cream") },
    { "indian", kli18nc("OSM::cuisine", "Indian") },
    { "indonesian", kli18nc("OSM::cuisine", "Indonesian") },
    { "international", kli18nc("OSM::cuisine", "International") },
    { "irish", kli18nc("OSM::cuisine", "Irish") },
    { "italian", kli18nc("OSM::cuisine", "Italian") },
    { "italian_pizza", kli18nc("OSM::cuisine", "Pizza") },
    { "japanese", kli18nc("OSM::cuisine", "Japanese") },
    { "juice", kli18nc("OSM::cuisine", "Juice") },
    { "kebab", kli18nc("OSM::cuisine", "Kebab") },
    { "korean", kli18nc("OSM::cuisine", "Korean") },
    { "lebanese", kli18nc("OSM::cuisine", "Lebanese") },
    { "local", kli18nc("OSM::cuisine", "Local") },
    { "malaysian", kli18nc("OSM::cuisine", "Malaysian") },
    { "meat", kli18nc("OSM::cuisine", "Meat") },
    { "mediterranean", kli18nc("OSM::cuisine", "Mediterranean") },
    { "mexican", kli18nc("OSM::cuisine", "Mexican") },
    { "moroccan", kli18nc("OSM::cuisine", "Moroccan") },
    { "nepalese", kli18nc("OSM::cuisine", "Nepalese") },
    { "noodle", kli18nc("OSM::cuisine", "Noodle") },
    { "noodles", kli18nc("OSM::cuisine", "Noodle") }, // wide-spread alternative tagging
    { "pakistani", kli18nc("OSM::cuisine", "Pakistani") },
    { "pancake", kli18nc("OSM::cuisine", "Pancake") },
    { "pasta", kli18nc("OSM::cuisine", "Pasta") },
    { "pastry", kli18nc("OSM::cuisine", "Pastry") },
    { "persian", kli18nc("OSM::cuisine", "Persian") },
    { "peruvian", kli18nc("OSM::cuisine", "Peruvian") },
    { "pizza", kli18nc("OSM::cuisine", "Pizza") },
    { "poke", kli18nc("OSM::cuisine", "Poke") },
    { "polish", kli18nc("OSM::cuisine", "Polish") },
    { "portuguese", kli18nc("OSM::cuisine", "Portuguese") },
    { "pretzel", kli18nc("OSM::cuisine", "Pretzel") },
    { "ramen", kli18nc("OSM::cuisine", "Ramen") },
    { "regional", kli18nc("OSM::cuisine", "Regional") },
    { "russian", kli18nc("OSM::cuisine", "Russian") },
    { "salad", kli18nc("OSM::cuisine", "Salad") },
    { "sandwich", kli18nc("OSM::cuisine", "Sandwich") },
    { "sausage", kli18nc("OSM::cuisine", "Sausage") },
    { "seafood", kli18nc("OSM::cuisine", "Seafood") },
    { "shawarma", kli18nc("OSM::cuisine", "Shawarma") },
    { "soup", kli18nc("OSM::cuisine", "Soup") },
    { "spanish", kli18nc("OSM::cuisine", "Spanish") },
    { "steak", kli18nc("OSM::cuisine", "Steak") },
    { "steak_house", kli18nc("OSM::cuisine", "Steak") },
    { "sushi", kli18nc("OSM::cuisine", "Sushi") },
    { "syrian", kli18nc("OSM::cuisine", "Syrian") },
    { "tacos", kli18nc("OSM::cuisine", "Tacos") },
    { "taiwanese", kli18nc("OSM::cuisine", "Taiwanese") },
    { "tapas", kli18nc("OSM::cuisine", "Tapas") },
    { "tea", kli18nc("OSM::cuisine", "Tea") },
    { "teahouse", kli18nc("OSM::cuisine", "Teahouse") },
    { "tex-mex", kli18nc("OSM::cuisine", "Tex-Mex") },
    { "thai", kli18nc("OSM::cuisine", "Thai") },
    { "turkish", kli18nc("OSM::cuisine", "Turkish") },
    { "vegetarian", kli18nc("OSM::cuisine", "Vegetarian") },
    { "vietnamese", kli18nc("OSM::cuisine", "Vietnamese") },
    { "waffle", kli18nc("OSM::cuisine", "Waffles") },
    { "wings", kli18nc("OSM::cuisine", "Chicken Wings") },
};
static_assert(isSortedLookupTable(cuisine_map), "cuising map is not sorted!");

}
