/*
 *
 *  Kepas - KDE Easy Publish and Share
 *
 *  Copyright (C) 2008  Tom Patzig <tpatzig@suse.de>
 *
 *  This file is part of kepas.
 *
 *  kepas is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  kepas is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with kepas; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
*/


#include <trayicon.h>

TrayIcon::TrayIcon(QObject* parent) : QObject(parent)
//TrayIcon::TrayIcon() : QMainWindow()
{

// 	 QCoreApplication::instance()->setApplicationName("kifer");	 
//	 config = new KConfig("kiver");	

	 setParent(kapp);

	 tray = new QSystemTrayIcon(this);
	 tray->setIcon(KIcon("folder-remote"));

	 mainmenu = new QMenu();
	 
	 buddyAction = mainmenu->addAction(KIcon("user"),i18n("Buddies"));
	 connect(buddyAction, SIGNAL(triggered(bool)), this, SLOT(slotBuddyList(bool)));
	 mainmenu->addSeparator();
	
	 sendFileAction = mainmenu->addAction(KIcon("text-directory"),i18n("Send File"));
	 connect(sendFileAction, SIGNAL(triggered(bool)), this, SLOT(slotFileSelect(bool)));
	 
	 clipMenu = mainmenu->addMenu(KIcon("klipper"),i18n("Send Clipboard"));
	 addClipEntries();

	 serverAction = mainmenu->addAction(i18n("Public Server"));
	 connect(serverAction, SIGNAL(triggered(bool)), this, SLOT(slotServerWizard(bool)));

	 configAction = mainmenu->addAction(KIcon("configure"), i18n("Configure..."));
	 connect(configAction, SIGNAL(triggered(bool)), this, SLOT(showConfigurationInterface()));

	 configAction = mainmenu->addAction(KIcon("folder-remote"),i18n("About"));
	 connect(configAction, SIGNAL(triggered(bool)), this, SLOT(showAboutInfo()));

	 quitAction = mainmenu->addAction(KIcon("application-exit"),i18n("Quit"));
	 connect(quitAction, SIGNAL(triggered(bool)), this, SLOT(slotQuitApp(bool)));
	 
	 m_dialog = 0;

	 mainmenu->setDefaultAction(buddyAction);
	 
	 buddylist = new BuddyList(this);
	 avahiClient = new ServiceLocator(this);
//	 connect(avahiClient, SIGNAL(serviceRuns()), this, SLOT(serviceRunning()));

	 tray->setContextMenu(mainmenu);
	 tray->setVisible(true);
	 connect(tray,SIGNAL(activated(QSystemTrayIcon::ActivationReason)),this,SLOT(slotTrayActivated(QSystemTrayIcon::ActivationReason)));
	
}

TrayIcon::~TrayIcon()
{
	qDebug() << "bye bye";
	delete mainmenu;
	delete dbus;

}

void TrayIcon::slotBuddyList(bool set)
{

	 avahiClient->browse();
	 connect(avahiClient, SIGNAL(addBuddy(QMap<QString, QByteArray>)),buddylist,SLOT(addService(QMap<QString,QByteArray>)));
	 connect(avahiClient, SIGNAL(delBuddy(QString)),buddylist,SLOT(delService(QString)));
	 
	 buddylist->initDefaultBuddyList(avahiClient->getUserName());

}


void TrayIcon::slotServerWizard(bool set)
{



}

void TrayIcon::slotTrayActivated(QSystemTrayIcon::ActivationReason reason)
{
	disconnect(clipMenu, SIGNAL(triggered(QAction*)), this, SLOT(slotSendClipEntry(QAction*)));
	if (reason == 1) {
		clipMenu->clear();
		addClipEntries();
		qDebug() << "update clipList";
	} 
//	else if (reason == 3)
//		slotBuddyList(true);

 	connect(clipMenu, SIGNAL(triggered(QAction*)), this, SLOT(slotSendClipEntry(QAction*)));
}

void TrayIcon::addClipEntries()
{
	dbus = new QDBusConnection("dbus");
	QDBusConnection dbusconn = dbus->connectToBus(QDBusConnection::SessionBus, "dbus");
	QString service = "org.kde.klipper";
	QString path = "/klipper";
	QString method = "getClipboardHistoryMenu";
	QString service2 = "org.kde.klipper.klipper";

	QDBusInterface* interface = new QDBusInterface(service,path,service2,dbusconn);
	QDBusReply<QStringList> reply = interface->call(method);
	
//	qDebug() << "klipper reply: " << reply.value();
	QStringList clipList = reply.value();

	for (int i=0; i < clipList.size(); i++){
		if (clipList.at(i).size() >= 30) {
			QString cut = clipList.at(i);
			cut.truncate(30);
			
			clipAction = clipMenu->addAction(cut + " ...");
	         } else
			clipAction = clipMenu->addAction(clipList.at(i));
		
		clipAction->setToolTip(clipList.at(i));
	}
}

void TrayIcon::slotSendClipEntry(QAction* action)
{
	//The triggered signal gets emitted two times for the QMenu, so we have to disconnect after the first signal
 	disconnect(clipMenu, SIGNAL(triggered(QAction*)), this, SLOT(slotSendClipEntry(QAction*)));

	avahiClient->browse();
	connect(avahiClient, SIGNAL(addBuddy(QMap<QString, QByteArray>)),buddylist,SLOT(addService(QMap<QString,QByteArray>)));
	connect(avahiClient, SIGNAL(delBuddy(QString)),buddylist,SLOT(delService(QString)));

	QString entry = action->toolTip();
	buddylist->initSendClipBuddyList(entry,avahiClient->getUserName());

}

void TrayIcon::slotShowToolTip(QAction* action)
{
	qDebug() << "tooltip: " << action->toolTip();
}


void TrayIcon::slotFileSelect(bool)
{
	qDebug() << "slotFileSelect";
	QString fileName = QFileDialog::getOpenFileName(mainmenu, tr("Select File"),"./","*");
	avahiClient->browse();
	connect(avahiClient, SIGNAL(addBuddy(QMap<QString, QByteArray>)),buddylist,SLOT(addService(QMap<QString,QByteArray>)));
	connect(avahiClient, SIGNAL(delBuddy(QString)),buddylist,SLOT(delService(QString)));
	
        buddylist->initSendFileBuddyList(fileName,avahiClient->getUserName());
}


void TrayIcon::showConfigurationInterface()
{
   if (m_dialog == 0) {
        m_dialog = new KDialog;
        m_dialog->setCaption( i18n("Configure Kepas") );
        ui.setupUi(m_dialog->mainWidget());
        m_dialog->setButtons( KDialog::Ok | KDialog::Cancel | KDialog::Apply );
        connect( m_dialog, SIGNAL(applyClicked()), this, SLOT(configAccepted()) );
        connect( m_dialog, SIGNAL(okClicked()), this, SLOT(configAccepted()) );
	connect( ui.saveToButton,SIGNAL(clicked()),this,SLOT(slotSelectDir()));
    }
    ui.pictureButton->setIcon(KIcon("user"));
    ui.nameLineEdit->setText(avahiClient->getUserName());
    ui.saveToLineEdit->setText(avahiClient->receiver->getTargetPath());
 
    
    m_dialog->show();
}

void TrayIcon::configAccepted()
{
	avahiClient->receiver->setTargetPath(ui.saveToLineEdit->text());
	avahiClient->setUserName(ui.nameLineEdit->text());
	bool OK = avahiClient->restartPublish();
        OK ? qDebug() << "Service restarted and published succesfull " : qDebug() << "Service not published";
}

void TrayIcon::slotSelectDir()
{
	QString dirname = QFileDialog::getExistingDirectory(m_dialog, tr("Select Target Directory"),"./");
	if (!dirname.isEmpty())
		ui.saveToLineEdit->setText(dirname);
}

void TrayIcon::serviceRunning()
{
	KMessageBox::information(mainmenu, "Service already running!");
	slotQuitApp(true);
}

void TrayIcon::slotQuitApp(bool set)
{
	kapp->quit();
}

void TrayIcon::showAboutInfo()
{
	KAboutData aboutData("kepas", 0, ki18n("Kepas"), "0.1",
		           ki18n("KDE Easy Publish and Share"), KAboutData::License_GPL_V2);
	aboutData.addAuthor(ki18n("Tom Patzig"), KLocalizedString(), "tpatzig@suse.de", "http://www.kde.org/");
	aboutData.setProgramLogo(KIcon("folder-remote"));

	KAboutApplicationDialog about(&aboutData, mainmenu);
//	about.setIcon( KIcon( "network-folder" ) );
	about.exec();
}

