/***************************************************************************
                          ksteakplugin.cpp  -  description
                             -------------------
    begin                : Don Apr 26 13:08:29 CEST 2001
    copyright            : (C) 2001 by Olaf Hartig
    email                : OleBowle@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "ksteakplugin.h"

#include <dcopclient.h>
#include <kaction.h>
#include <kapp.h>
#include <kdebug.h>
#include <khtml_part.h> // this plugin applies to a khtml part
#include <kinstance.h>
#include <kiconloader.h>
#include <klocale.h>
//#include <qarray.h>
#include <qmemarray.h>
#include <qmessagebox.h>

KSteakPlugin::KSteakPlugin( QObject* parent, const char* name )
    : Plugin( parent, name )
{
    (void) new KAction( "Translate via K&Steak",
                        "ksteakplugin", 0,
                        this, SLOT(slotAction()),
                        actionCollection(), "ksteakplugin" );
}

void KSteakPlugin::slotAction()
{
	QString szSelection;

	if ( ! parent()->inherits("KHTMLPart") )
	{
		QString title = i18n( "KSteakPlugin" );
		QString text = i18n( "The KSteak plugin can only be used for web pages, sorry." );

		QMessageBox::warning( 0, title, text );
	}
	else
	{
		KHTMLPart *part = static_cast<KHTMLPart *> (parent());
		szSelection = part->selectedText();

		if ( ! szSelection.isEmpty() )
		{
			DCOPClient * pClient = kapp->dcopClient();
			if ( ! pClient->attach() )
				kdDebug() << "KSteakPlugin " << k_funcinfo << "Couldn't attach DCOP-Client" << endl;
			else
			{
				// Test, if former KSteak instance is still running
				if ( (m_szKSteakAppID.isEmpty()) || (!pClient->isApplicationRegistered(m_szKSteakAppID)) )
				{
					// if not, try to find the ID of the currently running instance
					kdDebug() << "KSteakPlugin " << k_funcinfo << " KSteak DCOP App.ID unknown - try to find it" << endl;

					m_szKSteakAppID = QCString();
					QCStringList list = pClient->registeredApplications();
					QCStringList::Iterator it;
					for( it = list.begin(); it != list.end(); ++it )
						if ( (*it).contains("ksteak") )
							m_szKSteakAppID = *it;
				}

				if ( ! m_szKSteakAppID.isEmpty() )
				{
					QByteArray data;
					QDataStream arg(data, IO_WriteOnly);

					arg << szSelection;

					if ( pClient->send( m_szKSteakAppID, "KSteakIface","translate(QString)",data) )
						kdDebug() << "KSteakPlugin " << k_funcinfo << " DCOP-message sent" << endl;
					else
						kdDebug() << "KSteakPlugin " << k_funcinfo << "Couldn't send DCOP-message to [" << m_szKSteakAppID << ']' << endl;
				}
				else
					kdDebug() << "KSteakPlugin " << k_funcinfo << " KSteak is not running" << endl;
			}
		}
		else
			kdDebug() << "KSteakPlugin " << k_funcinfo << " No text selected" << endl;
	}
}

KPluginFactory::KPluginFactory( QObject* parent, const char* name )
  : KLibFactory( parent, name )
{
  s_instance = new KInstance("KPluginFactory");
}

QObject* KPluginFactory::createObject( QObject* parent, const char* name, const char*, const QStringList & )
{
    QObject *obj = new KSteakPlugin( parent, name );
    return obj;
}
KPluginFactory::~KPluginFactory()
{ delete s_instance; }


extern "C"
{
  void* init_libksteakplugin()
  {
    return new KPluginFactory;
  }

}
 
KInstance* KPluginFactory::s_instance = 0L;
