// C++ interface wrapper code.
//
// Generated by SIP snapshot-20030204 (build 65) on Sun Mar 16 13:45:47 2003
//
// Terms and Conditions
// 
// 
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
// 
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
// COPYRIGHT HOLDER BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
// IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// 
// Except as contained in this notice, the name of the copyright holder shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from the
// copyright holder.

#include "sipkdecoreDeclkdecore.h"
#include "sipkdecoreKEntryMap.h"


int sipConvertTo_KEntryMap(PyObject *sipPy,KEntryMap **sipCppPtr,int *sipIsErr)
{
#line 163 "sip/kentrymap.sip"
	// Convert a Python dictionary to a KEntryMap on the heap.

	if (sipIsErr == NULL)
		return PyDict_Check(sipPy);

	KEntryMap *map = new KEntryMap;

        PyObject *key, *value;
        int pos = 0;

        while (PyDict_Next(sipPy, &pos, &key, &value))
                if (!(PyTuple_Check (key) && PyTuple_Check (value)))
                {
                        *sipIsErr = 1;
                        delete map;
                        return 0;
                }
                else
                {
                        KEntryKey *cKey;
                        KEntry *cValue;

                        int iserr = 0;
                        cKey = sipForceConvertTo_KEntryKey (key, &iserr);
                        if (iserr)
                        {
                                *sipIsErr = 1;
                                delete map;
                                return 0;
                        }

                        cValue = sipForceConvertTo_KEntry (value, &iserr);
                        if (iserr)
                        {
                                *sipIsErr = 1;
        			delete cKey;
                                delete map;
                                return 0;
                        }

                        map->insert (*cKey, *cValue);

			delete cKey;
                }

	*sipCppPtr = map;

	return 1;
#line 87 "sipkdecoreKEntryMap.cpp"
}

KEntryMap *sipForceConvertTo_KEntryMap(PyObject *valobj,int *iserrp)
{
	if (*iserrp || valobj == NULL)
		return NULL;

	if (sipConvertTo_KEntryMap(valobj,NULL,NULL))
	{
		KEntryMap *val;

		sipConvertTo_KEntryMap(valobj,&val,iserrp);

		return val;
	}

	sipBadClass(sipName_kdecore_KEntryMap);

	*iserrp = 1;

	return NULL;
}

PyObject *sipConvertFrom_KEntryMap(KEntryMap *sipCpp)
{
#line 118 "sip/kentrymap.sip"
	// Convert to a Python dictionary

	if (!sipCpp)
		return PyDict_New();

        PyObject *dict;

	// Create the dictionary.

	if ((dict = PyDict_New()) == NULL)
		return NULL;

	// Get it.

        KEntryMap map = *sipCpp;
        KEntryMap::Iterator it;
        int iserr = 0;

        PyObject *key, *value;

	for (it = map.begin (); it != map.end (); ++it)
        {
                key   = sipMapCppToSelf ((KEntryKey *)&it.key (), sipClass_KEntryKey);
                value = sipMapCppToSelf ((KEntry *)&it.data (), sipClass_KEntry);

                if ((key == NULL) || (value == NULL) || (PyDict_SetItem (dict, key, value) < 0))
		{
                        Py_XDECREF (key);
                        Py_XDECREF (value);
			Py_DECREF (dict);
			return NULL;
		}


        }


	return dict;
#line 152 "sipkdecoreKEntryMap.cpp"
}
