import os, os.path, string, sys, shutil

RName = "PyKDE-3.3.2"

qtVersion  = 'Qt_2_3_0'
kdeVersion = 'KDE_2_1_1'

FALSE = 0
TRUE  = not FALSE
docdir = RName + "/doc/" + RName + "/@25114/"
newdir = RName + "/doc/"

titles = ["Python Bindings for KDE2 (v3.2.4)",\
        "General Limitations",\
        "Signal and Slot Support",\
        "Static Member Functions",
        "None and NULL",\
        "Enumerated Types",\
        "Namespaces",\
        "Mapped Types and Substitutions",\
        "Abstract Classes and Pure Virtual Methods",\
        "tr(...) methods in PyKDE and Socket classes",\
        "Module Reference Documentation",\
        "Introduction",\
        "Qt XML",\
        "dcop Module Reference",\
        "kdecore Module Reference",\
        "kdesu Module Reference",\
        "kdefx Module Reference",\
        "kdeui Module Reference",\
        "kio Module Reference",\
        "kfile Module Reference",\
        "kparts Module Reference",\
        "khtml Module Reference",\
        "kjs Module Reference",\
        "kspell Module Reference",\
        "kdeprint Module Reference"]


toc = ["index1",  "limits", "signal", "static", "none", "enum", "namespace", "mapped", "abstract", "tr", "module",\
       "qt", "qtxml", "dcop", "kdecore", "kdesu", "kdefx", "kdeui", "kio", "kfile", "kparts", "khtml", "kjs", "kspell", "kdeprint"]

catalog = {}
order   = {}

def getCatalog ():
        flist = os.listdir (docdir)
        for f in flist:
                m    = open (docdir + f, 'r')
                buff = m.readlines ()
                m.close ()
                ttl  = getTitle (buff)
                prev = getPrev (buff)
                next = getNext (buff)
                print ttl
                catalog [f] = titles.index (ttl)
                order [f] = (prev, next)


def doRename ():
        flist = catalog.keys ()
        for f in flist:
                m = open (docdir + f, "r")
                buff = m.read ()
                m.close ()

                if f != "t1.html":
                        buff = string.replace (buff, 't1.html', 'index.html')

                if order [f][0] != None:
                        p = order [f][0]
                        buff = string.replace (buff, p, toc [catalog [p]] + ".html")

                if order [f][1] != None:
                        n = order [f][1]
                        buff = string.replace (buff, n, toc [catalog [n]] + ".html")

                m = open (newdir + toc [catalog [f]] + ".html", "w")
                m.write (buff)
                m.close ()

        os.system ('rm -rf ' + RName + '/doc/' + RName)
        os.system ('cp lib/index.html ' + newdir)



def getTitle (buff):
        flag = FALSE
        for line in buff:
                if flag:
                        line = string.strip (string.replace (line, ">", ""))
                        line = string.replace (line, "</TITLE", "")
                        return line

                if string.find (line, "><TITLE") >= 0:
                        flag = TRUE


def getPrev (buff):
        flag = 0
        for line in buff:
                if flag == 1:
                        flag = flag + 1
                        continue

                if flag == 2:
                        line = string.strip (string.replace (line, 'HREF="', ""))
                        line = string.replace (line, '"><LINK', "")
                        line = string.replace (line, '"></HEAD', "")
                        return line

                if string.find (line, 'REL="PREVIOUS"') >= 0:
                        flag = 1

        return None


def getNext (buff):
        flag = 0
        for line in buff:
                if flag == 1:
                        flag = flag + 1
                        continue

                if flag == 2:
                        line = string.strip (string.replace (line, 'HREF="', ""))
                        line = string.replace (line, '"></HEAD', "")
                        return line

                if string.find (line, 'REL="NEXT"') >= 0:
                        flag = 1

        return None

def makeDocs ():
    try:
        shutil.rmtree ('doc')
    except:
        pass

    try:
        os.mkdir ('doc')
    except:
        print "Unable to create the %s directory" % ('doc')

    print "sip -t " + qtVersion +  ' -t ' + kdeVersion + ' -I /usr/local/PyQt-3.3.2/sip -I sip -d doc/PyKDE.sgml sip/kde.sip'

    os.system ("sip -t " + qtVersion +  ' -t ' + kdeVersion + ' -t WS_X11 -I /usr/local/PyQt-3.3.2/sip -I sip -d doc/PyKDE.sgml sip/kde.sip')
    os.system ("cd doc; sgmltools -b html PyKDE.sgml; ln -sf t1.html index.html; tar zcvf PyKDE-Docs.html.tar.gz *.html")


makeDocs ()
#if not os.path.exists (docdir):
#        print "path " + docdir + " does not exist - edit docs.py"
#        sys.exit (-1)

#getCatalog ()
#doRename ()
