// -*- c++ -*-

/*
 *
 * Copyright (C) 2002 Richard Moore <rich@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */


#ifndef KDETVCHANNELIFACE_H
#define KDETVCHANNELIFACE_H

#include <dcopobject.h>

/**
 * A DCOP interface for a Kdetv Channel.
 *
 * @author Richard Moore, rich@kde.org
 */
class KdetvChannelIface : virtual public DCOPObject
{
    K_DCOP
k_dcop:

    virtual int number() const=0;
    virtual ulong freq() const=0;
    virtual bool enabled() const=0;
    virtual QString name() const=0;
    virtual QString source() const=0;

    virtual void setNumber(int x)=0;
    virtual void setFreq(ulong x)=0;
    virtual void setEnabled( bool enabled = true )=0;
    virtual void setName( const QString &name )=0;
    virtual void setSource( const QString &source )=0;
    virtual void setEncoding( const QString &encoding )=0;
};

#endif


// Local Variables:
// c-basic-offset: 4
// End:

