// -*- c++ -*-

/*
 *
 * Copyright (C) 2002 Richard Moore <rich@kde.org>
 * Copyright (C) 2002 George Staikos <staikos@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef CHANNELIO_H
#define CHANNELIO_H

#include <qptrlist.h>
#include <qstring.h>

#include "kdetvchannelplugin.h"

class ChannelStore;
class Kdetv;

/**
 * Support for loading and saving channel suites in different formats.
 *
 * @author Richard Moore, <rich@kde.org>
 */
class ChannelIO
{
public:
    virtual ~ChannelIO();

    typedef KdetvChannelPlugin Format;
    typedef KdetvChannelPluginList FormatList;

    /**
     * Get the meta info for a given channel file.
     */
    static KdetvChannelPlugin::ChannelFileMetaInfo getMetaInfo( Kdetv *ktv, const QString& filename, const QString& fmt = QString::null );

    /**
     * Loads a channel file into the specified store. 
     */
    static bool load( Kdetv *ktv, ChannelStore *store, const QString &filename, const QString& fmt=QString::null );

    /**
     * Save the channels in the store to the specified file. 
     */
    static bool save( Kdetv *ktv, ChannelStore *store, const QString &filename, const QString& fmt=QString::null );

    /*
     * Provides mappings between user readable and internal format names.
     * Key is user readable, value is internal name.
     * Internal name can be supplied to load/save functions as format argument.
     */
    static const QMap<QString, QString>& fileFormatsRead(Kdetv* ktv);
    static const QMap<QString, QString>& fileFormatsWrite(Kdetv* ktv);

    /**
     * Registers the specified format.
     */
    static void registerFormat( Kdetv *ktv, KdetvChannelPlugin *format );

    /**
     * Returns a list of all the known formats.
     */
    static KdetvChannelPluginList *formats(Kdetv *ktv);

    /**
     * Try to find a format handler for the specified format. The flags
     * indicate the facility we need, ie. reading or writing. If there
     * is no matching handler, 0 is returned.
     */
    static KdetvChannelPlugin *findFormat( Kdetv *ktv, const QString& fmt, int flags = KdetvChannelPlugin::FormatRead );

private:
    /**
     * Registers the built-in formats (happens automatically).
     */
    static void registerFormats(Kdetv *ktv);

    static KdetvChannelPlugin* guessFormat( Kdetv *ktv, const QString &filename, int flags );
};


#endif // CHANNELIO_H
