/***************************************************************************
                           channelimportdlgimpl.cpp
                           ------------------------
    begin                : Sat Oct 25 2003
    copyright            : (C) 2003 by Dirk Ziegelmeier
    email                : dziegel@gmx.de
 ***************************************************************************/

/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <kdebug.h>
#include <klocale.h>
#include <qcombobox.h>
#include <qradiobutton.h>
#include <qpushbutton.h>

#include <kconfig.h>
#include <kmessagebox.h>

#include "kdetv.h"
#include "sourcemanager.h"
#include "kdetvsrcplugin.h"
#include "channel.h"
#include "channelstore.h"
#include "channelimporter.h"
#include "channelimportdlgimpl.h"

ChannelImportDlgImpl::ChannelImportDlgImpl(Kdetv* ktv, QWidget* parent, const char* name, bool modal, WFlags flags)
    : ChannelImportDlg(parent, name, modal, flags),
      _ktv(ktv)
{
    SourceManager* srcm = _ktv->sourceManager();

    _importer = new ChannelImporter();
    _freqList->insertStringList(_importer->lists());
    
    _source->insertStringList(srcm->sourcesFor(srcm->device()));
    _source->setCurrentText(srcm->source());

    _encoding->insertStringList(srcm->encodingsFor(srcm->device()));
    _encoding->setCurrentText(srcm->encoding());
}

ChannelImportDlgImpl::~ChannelImportDlgImpl()
{
    delete _importer;
}

void ChannelImportDlgImpl::accept()
{
    ChannelStore tmp(_ktv, this, "TmpStore");
    if ( !_importer->import(&tmp, _freqList->currentText()) ) {
	KMessageBox::error(0L,
			   i18n("Unable to import channel list.\nCheck your installation!"),
			   i18n("Error importing channels"));
	return;
    }
    for (uint i=0; i<tmp.count(); i++) {
	Channel* c = tmp.channelAt(i);

	c->setSource(_source->currentText());
	c->setEncoding(_encoding->currentText());
    }

    ChannelStore* cs = _ktv->channels();
    if ( _replace->isChecked() ) {
	int rc = KMessageBox::warningContinueCancel(0L,
						    i18n("Are you sure you want to import?\nThis will overwrite your current channel file!"),
						    i18n("Continue import?"));
	if (rc == KMessageBox::Cancel) {
	    reject();
	    return;
	}
	
	cs->clear();
    }
    cs->addChannels(tmp);

    _ktv->setChannel(cs->channelAt(0));
    QDialog::accept();
}

#include "channelimportdlgimpl.moc"
