/*
 *
 * Copyright (C) 2002 George Staikos <staikos@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <klocale.h>
#include <kapp.h>

#include "channel.h"
#include "channel.moc"

Channel::Channel( QObject *parent, const char *name )
    : DCOPObject(),
      QObject( parent, name ),
      _num(-1), _freq(0), _enabled(true), _source(QString::null), _encoding(QString::null)
{
}

void Channel::setNumber(int x)
{
    _num = x;
    emit changed();
}

void Channel::setFreq(ulong x)
{
    _freq = x;
    emit changed();
}

void Channel::setEnabled( bool enabled )
{
    _enabled = enabled;
    emit changed();
}

void Channel::setName( const QString &name )
{
    _name = name;
#if KDE_VERSION >= 308
    setObjId( _name.local8Bit() );
#endif
    emit changed();
}

void Channel::setSource( const QString &source )
{
    _source = source;
    emit changed();
}

void Channel::setEncoding( const QString &encoding )
{
    _encoding = encoding;
    emit changed();
}

void Channel::setValues( const Channel *chan )
{
    setNumber( chan->number() );
    setFreq( chan->freq() );
    setEnabled( chan->enabled() );
    setName( chan->name() );
    setSource( chan->source() );
    setEncoding( chan->encoding() );

    emit changed();
}

void Channel::updateValues( const QString& name, int num, unsigned long freq, bool enabled, QString encoding, QString source )
{
   _num = num;
   _freq = freq;
   _enabled = enabled;
   setName( name );
   setSource( source );
   setEncoding( encoding );

   emit changed();
}
