/***************************************************************************
                          partdatabase.cpp  -  description
                             -------------------
    begin                : Wed Oct 13 1999
    copyright            : (C) 1999 by Jan Mueller
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "partdatabase.h"
#include <assert.h>
#include <stdlib.h>

#define Inherited Table

PartDataBase::PartDataBase(Oid part, Sql *conn):Inherited("partdata", conn) {
	Str s=Str("where partdata.no=");
	oid2str(newPartData(part), &s);
	initWhere(s);
}

PartDataBase::PartDataBase(Oid part, const char *dbname):Inherited("partdata", dbname) {
	Str s=Str("where partdata.no=");
	oid2str(newPartData(part), &s);
	initWhere(s);
}

PartDataBase::PartDataBase(const char *where, const char *dbname):Inherited("partdata", dbname) {
	initWhere(where);
}

PartDataBase::PartDataBase(const char *where, Sql *conn):Inherited("partdata", conn) {
	initWhere(where);
}

void PartDataBase::initWhere(const char *where) {
  PartDataRec *partdata=Inherited::getPartData(where);
  if(!partdata) {
    partdata=new PartDataRec;
    assert(partdata);
    partdata->empty();
    partdata->id.set((Oid)InvalidOid);
  }
  init(partdata);
	if(where)	_where=mystrdup(where);
	else _where=0L;
}

PartDataBase::~PartDataBase() throw() {
}


KaspaRec *PartDataBase::read(const char *where) {
	return getPartData(where);
}	

KaspaRec *PartDataBase::invalid() {
	KaspaRec *partdata=new PartDataRec;
	partdata->id.set((Oid)InvalidOid);
	return 	partdata;
}	


void PartDataBase::write(const char *where, bool block) {
    updatePartData(partdata(), where, block);
}

void PartDataBase::del(const Oid o) {
		Str s=Str("where partdata.no=");
		oid2str(o, &s);
    deletePartData(s);
    partdata()->empty();
    partdata()->id.set((Oid)InvalidOid);
}

PartDataRec *PartDataBase::partdata() {
	if(!dynamic_cast<PartDataRec*>(rec))
		abort();
	return dynamic_cast<PartDataRec*>(rec);
}

const char *PartDataBase::getFilename() {
    return partdata()->filename.get();
}

const char *PartDataBase::getType() {
    return partdata()->type.get();
}

const char *PartDataBase::getData() {
    return partdata()->file.get();
}

const char *PartDataBase::getText() {
    return partdata()->text.get();
}

const char *PartDataBase::getPartMemo() {
    return partdata()->memo.get();
}


PartTitle *PartDataBase::getPartTitle() {
		Str s("where part.no=");
		partdata()->partno.get(s);
		return Inherited::getPartTitles(s);
}

Oid PartDataBase::getPartNo() {
	return partdata()->partno.get();
}

PublTitle *PartDataBase::getPublTitle() {
		Str s("where publication.no=part.publication_no and part.no=");
		partdata()->partno.get(s);
		return Inherited::getPublTitles(s);
}


void PartDataBase::setFilename(const char *s) {
  partdata()->filename.set(s);
  partdata()->filename.setChanged();
}

void PartDataBase::setType(const char *t) {
  partdata()->type.set(t);
  partdata()->type.setChanged();
}

void PartDataBase::setData(const char *d) {
  partdata()->file.set(d);
  partdata()->file.setChanged();
}

void PartDataBase::setText(const char *d) {
  partdata()->text.set(d);
  partdata()->text.setChanged();
}

void PartDataBase::setPartMemo(const char *d) {
  partdata()->memo.set(d);
  partdata()->memo.setChanged();
}

Oid PartDataBase::createNote() {
	PublTitle *p=getPublTitle();
	if(!p) throw KaspaErr("PartData has no Part!");
	Oid o=newNote(p->getOid());
	insertLink(o);
	delete p;
	return o;
}	


NoteTitle *PartDataBase::getNotes() {
	PublTitle *p=getPublTitle();
	if(!p) throw KaspaErr("PartData has no Part!");
	Str s=Str("where publication_no=");
	oid2str(p->getOid(), &s);
	s+=" order by title";
	delete p;
	return getNoteTitles(s);
}
