/***************************************************************************
                          main.cpp  -  description                              
                             -------------------                                         
    begin                : Don Jun 15 22:33:56 CEST 2000
                                           
    copyright            : (C) 2000 by Jan Mueller                         
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "resource.h"
#include <iostream.h>
#include <stdlib.h>
#include <signal.h>
#include <unistd.h>
#include <qfile.h>
#include <kaspasql.h>
#include <qlist.h>


Sql svr(DB_NAME);
QList<Oid> oids;

void getOIDs(QString rel, QString field, QList<Oid>& l) {
	svr.exec("BEGIN");
	QString s("select "); s+=field+" as o from "+rel+" where "+field+" != 0 order by "+field;
	svr.exec(s);

	for(int i=0; i<svr.tuples(); i++) {
		Oid *o = new Oid;
		*o=QString(svr.getValue(i, "o")).toUInt();
		l.append(o);
	}
	svr.exec("END");
}


void readOIDs() {
  getOIDs("author", "memo", oids);
  getOIDs("author", "picture", oids);
  getOIDs("publication", "memo", oids);
  getOIDs("part", "memo", oids);
  getOIDs("partdata", "file", oids);
  getOIDs("note", "memo", oids);
}


char *lo2buf(Oid i, long *len) {
  int lfd=0;
  char *buf=0L;

//  cout << "\nLese LO - Anfang!";

  if(i==InvalidOid) return 0L;
  svr.exec("begin");
  lfd=svr.lOpen(i, INV_READ);

  svr.lSeek(lfd, 0, SEEK_END);
  *len=svr.lTell(lfd);
  svr.lSeek(lfd, 0, SEEK_SET);
//  cout << "\nLese LO - Nach Seek!";
  buf=new char[*len+1];
//  assert(buf);
  buf[*len]=0;
  svr.lRead(lfd, buf, *len);
//  cout << "\nLese LO - Nach Read!";
  svr.lClose(lfd);
//  cout << "\nLese LO - Ende!";
  svr.exec("commit");
  return buf;
}


void oid2file(Oid o, QString n) {
	QFile f(n);
	
	cout<<"\nWriting "<<n;
	
	if(!f.open(IO_WriteOnly))
		throw KaspaErr("Unable to open file for writing!");
	
	long l;	
	char *buffer=0L;
	try {
    buffer = lo2buf(o, &l);
  } catch (KaspaErr& err) {
	  cout<<"\nCannot read large object no."<<o<<": "<< err.error()<<"\nIgnoring...\n";
    return;
  }
  if(!buffer) return;
	if(f.writeBlock((char *)buffer, (uint) l)!=l)
	  throw KaspaErr("Unable to write to file!");
	f.close();
	delete buffer;
}





int main(int argc, char** argv){
QString target;
int b=0;

	for(int i=0; i<argc; i++) {
		if(!strcmp(argv[i], "-o")) {
			i++;
			target=argv[i];
		}
		if(!strcmp(argv[i], "-b")) {
			i++;
			b=atoi(argv[i]);
		}
	}
	if(target.isEmpty()) {
		cout<<"\nTool to write the large objects of the kaspaliste database in a directory.\n" \
					"This program is part of the kaspaliste distribution\n (C) 2000 Jan Mueller\n" \
					"See COPYING file for the licence.\n" \
					"Syntax: unloadoids -o <directory> [-b offset]\n" \
					"if the process interrupts after - say - 1000 objects and you\n" \
					"encounter strange postgres errors restart unloadlo with the -b option\n" \
					"and an offset of 1000"; 
		exit(1);
	}

	
try {
	readOIDs();
	for(unsigned int i=b; i<oids.count(); i++) {
//                svr.reset();
                cout <<"\n===================== lo no. "<<i<<" ==========================";
		QString s(target+"/"+QString().setNum(*oids.at(i)));
		oid2file(*oids.at(i), s);		
	}
} catch (KaspaErr& err) {
	cout<<"\nError: "<< err.error()<<"\n";
	exit(1);
}
cout << "\nFinished!\n";
return EXIT_SUCCESS;
}