/***************************************************************************
                          selection.cpp  -  description
                             -------------------
    begin                : Sun Jan 7 2001
    copyright            : (C) 2001 by Jan Mueller
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/**********************************************************************

	--- Qt Architect generated file ---

	File: publisher.cpp
	Last generated: Mon Oct 4 03:28:08 1999

 *********************************************************************/

#define Inherited SelectionData


#include "selection.h"
#include "kaspawidget.h"
#include "resource.h"
#include <kapp.h>
#include <qstring.h>
#include "kaspabase.h"
#include <kiconloader.h>
#include <klocale.h>
#include <qwhatsthis.h>


// SelectionBase-Constructor creates new notice.
Selection::Selection(QWidget* parent,	const char* name, const char *caption=0):
	Inherited( parent, name )
{
	debug("Selection::Selection(QWidget, char*)");
	QWhatsThis::add(selection,	i18n("Just doubleclick an entry."));

  connect(selection,   SIGNAL(open(Oid, bool)), this, SLOT(open(Oid, bool)));
}

Selection::~Selection()
{
	debug("Selection::~Selection()");
}

bool Selection::isValid() {
	return true;
}

void Selection::reread() {
  setFields();
}

void Selection::setFields() {
  if(isValid()) {
		setWorkingGUI();
	  selection->set(getList());
	}
	setupGUI();
}

void Selection::setInvalidGUI() {
  emit enableCommand(ID_SELECTION_RESET);
	Inherited::setInvalidGUI();
	lockGUI();

}	

void Selection::setReadWriteGUI() {
  emit enableCommand(ID_SELECTION_RESET);
 	Inherited::setReadWriteGUI();
 	unlockGUI();
}

void Selection::setWorkingGUI() {
  emit disableCommand(ID_SELECTION_RESET);
	Inherited::setWorkingGUI();
	lockGUI();
}

void Selection::setReadOnlyGUI() {
  emit enableCommand(ID_SELECTION_RESET);
	Inherited::setReadOnlyGUI();
	unlockGUI();
}


bool Selection::closeRequest() {
  return true;
}

KToolBar *Selection::getToolBar() {
	KaspaToolBar *toolbar = new KaspaToolBar(topLevelWidget());
  toolbar->insertButton(BarIcon("reload.xpm"), ID_SELECTION_RESET, SIGNAL(clicked()),
				this, SLOT(reread()), true, i18n("Revert") );
	toolbar->setBarPos(KToolBar::Top);
	toolbar->enable(KToolBar::Show);
  return toolbar;
}










