/***************************************************************************
                          JournalView.cpp  -  description
                             -------------------
    begin                : Sun Jan 7 2001
    copyright            : (C) 2001 by Jan Mueller
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/**********************************************************************

	--- Qt Architect generated file ---

	File: journalview.cpp
	Last generated: Mon Oct 4 03:28:08 1999

 *********************************************************************/

#include "journalview.h"

#define Inherited JournalViewData


#include "journalview.h"
#include "kaspawidget.h"
#include "resource.h"
#include <kapp.h>
#include <qstring.h>
#include "selectiondlg.h"
#include "notetreedlg.h"
#include <kiconloader.h>
#include <klocale.h>

CommandSetup journalviewcs[] = { {ID_JOURNALVIEW_DELREC, RW},
																 {ID_JOURNALVIEW_FLUSH,  RW},
																 {ID_JOURNALVIEW_RESET,  RW+RO+INV} };


// JournalViewBase-Constructor reads row matching WHERE-Clause.
JournalView::JournalView(KaspaURL url, Sql *conn, QWidget* parent,	const char* name):
	Inherited( parent, name)
{
	debug("JournalView::JournalView(QString, QWidget, char*)");
	if(url.command()=="new")
	  publisher = new PublisherBase(conn);
	else
	  publisher = new PublisherBase(url.where(), conn);
  ASSERT(publisher);
	publisher->setCallBack(&idle);
	QString s("kaspa://journal#where publisher.no="); s+=QString().setNum(publisher->id());
	_url=s;

  connect(publs,   SIGNAL(open(Oid, bool)), this, SLOT(requestPublication(Oid, bool)));
//	publs->setTitle(i18n("Publications"));
}

JournalView::~JournalView()
{
	debug("JournalView::~JournalView()");
	delete publisher;
}

bool JournalView::isValid() {
	try {
	  return publisher->isValid();
	} catch(KaspaErr& err) {
		handleWarning(err);
		return false;
	}
}


void JournalView::reread() {
	setWorkingGUI();
	try {
  	publisher->reset();
	} catch(KaspaErr& err) {
		handleWarning(err);
	}
  setFields();
}

void JournalView::setFields() {
  if(isValid()) {
		try {
			setWorkingGUI();
		  publishername->setText(publisher->getName());
	  	city->setText(publisher->getCity());
		  publs->set(publisher->getPubls());
			serie->setText(publisher->getSerie());
			created->setText(QString("created: ")+publisher->getCreated());
			modified->setText(QString("modified: ")+publisher->getModified());
		} catch(KaspaErr& err) {
			handleWarning(err);
		}
	}
	setupGUI();
}

void JournalView::flush() {
	setWorkingGUI();
	save();
	setupGUI();
}

void JournalView::save(bool block) {
	try {
	  if(isValid() && !isReadOnly() && !isWorking()) {
    	  if(strcmp(publishername->text(), publisher->getName()))
      	  publisher->setName(publishername->text());
	      if(strcmp(city->text(), publisher->getCity()))
  	      publisher->setCity(city->text());
	      if(strcmp(serie->text(), publisher->getSerie()))
  	      publisher->setSerie(serie->text());
  	    if(!strcmp(publisher->getSerie(), ""))
  	    	publisher->setSerie("NoName");

    	  publisher->flush(block);
	  }
	} catch(KaspaErr& err) {
		handleWarning(err);
	}
}


void JournalView::setInvalidGUI() {
	Inherited::setInvalidGUI();
	lockGUI();
	for(unsigned int i=0; i<sizeof(journalviewcs)/sizeof(CommandSetup); i++)
		emit enableCommand(journalviewcs[i].command, ((journalviewcs[i].setup&INV)==INV));
}	

void JournalView::setReadWriteGUI() {
 	Inherited::setReadWriteGUI();
 	unlockGUI();
	for(unsigned int i=0; i<sizeof(journalviewcs)/sizeof(CommandSetup); i++)
		emit enableCommand(journalviewcs[i].command, ((journalviewcs[i].setup&RW)==RW));
}

void JournalView::setWorkingGUI() {
	if(isReadOnly() || !isValid())
		lockGUI();
	else {
  	publishername->setEnabled(true);
	  city->setEnabled(true);
	  serie->setEnabled(true);
    publs->setEnabled(false);
  }
	
	Inherited::setWorkingGUI();
	for(unsigned int i=0; i<sizeof(journalviewcs)/sizeof(CommandSetup); i++)
		emit enableCommand(journalviewcs[i].command, ((journalviewcs[i].setup&WORK)==WORK));
}

void JournalView::setReadOnlyGUI() {
	Inherited::setReadOnlyGUI();
	publishername->setEnabled(false);
	city->setEnabled(false);
	serie->setEnabled(false);
  publs->setEnabled(true);
	for(unsigned int i=0; i<sizeof(journalviewcs)/sizeof(CommandSetup); i++)
		emit enableCommand(journalviewcs[i].command, ((journalviewcs[i].setup&RO)==RO));
}


void JournalView::del() {
	try {
	  if(isValid() && !isReadOnly() && !isWorking()&&deleteDlg()) {
			setWorkingGUI();
		  publisher->deleteRec();
		  setInvalidGUI();
		}
	} catch(KaspaErr& err) {
		handleWarning(err);
	}
}

bool JournalView::closeRequest() {
//	setWorkingGUI();
 	save(true);
	setupGUI();
  return true;
}
	
KToolBar *JournalView::getToolBar() {
	KaspaToolBar *toolbar = new KaspaToolBar(topLevelWidget());
	toolbar->insertButton(BarIcon("filedel.xpm"), ID_PUBLISHER_DELREC, SIGNAL(clicked()),
				this, SLOT(del()), true, i18n("Delete Record") );
	toolbar->insertLineSeparator();
	toolbar->insertButton(BarIcon("filefloppy.xpm"), ID_PUBLISHER_FLUSH, SIGNAL(clicked()),
				this, SLOT(flush()), true, i18n("Save Changes") );
	toolbar->insertButton(BarIcon("reload.xpm"), ID_PUBLISHER_RESET, SIGNAL(clicked()),
				this, SLOT(reread()), true, i18n("Revert Record") );
	toolbar->setBarPos(KToolBar::Top);
	toolbar->enable(KToolBar::Show);
	return toolbar;
}
