/***************************************************************************
                          DataView.cpp  -  description
                             -------------------
    begin                : Sun Jan 7 2001
    copyright            : (C) 2001 by Jan Mueller
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/**********************************************************************

	--- Qt Architect generated file ---

	File: DataView.cpp
	Last generated: Sun Sep 26 14:18:38 1999

 *********************************************************************/



#include "dataview.h"

#define Inherited DataViewData

#include "resource.h"

#include <kapp.h>
#include <qaccel.h>
#include <qstring.h>
#include <qmessagebox.h>
#include <kiconloader.h>
#include <qclipboard.h>
#include "selectiondlg.h"
#include "notetreedlg.h"
#include "kaspawidget.h"
#include <klocale.h>
#include <klibloader.h>
#include <stdio.h>
#include <qlayout.h>
#include <ktrader.h>
#include <qcstring.h>
#include <kmimemagic.h>
#include <kservice.h>
#include <kmdcodec.h>
#include <kio/netaccess.h>
#include <qsplitter.h>
#include <qmultilineedit.h>
#include <run.h>

#define Inherited DataViewData

CommandSetup dataviewcs[] = {	{ID_HTML_SHOWPART,  RW+RO},
															{ID_HTML_NEWLINK, 	RW+RO},
															{ID_HTML_INSLINK, 	RW+RO},
															{ID_HTML_REMLINK,		RW+RO},
															{ID_HTML_FLUSH,     RW},
															{ID_HTML_RESET,			RW+RO+INV} };

															
// DataViewBase-Constructor reads row matching WHERE-Clause.
DataView::DataView(KaspaURL url, Sql *conn, QWidget* parent,	const char* name):
	Inherited( parent, name), handling_request(false), part(0L), file("")
{

  splitter=new QSplitter(viewframe);
	layout=new QBoxLayout(viewframe, QBoxLayout::Down);
  layout->addWidget(splitter, 1);
	layout->activate();

  memo=new MyTextEdit(splitter);
  setupEditorConnections();


  tmpfiles.setAutoDelete(true);
  debug("DataView::DataView(QString, QWidget, char*)");
  data = new PartDataBase(url.where(), conn);
  ASSERT(data);
  QString s("kaspa://partdata#where partdata.no="); s+=QString().setNum(data->id());
  _url=s;
  connect(notes, SIGNAL(open(Oid, bool)), this, SLOT(requestNote(Oid, bool)));

  QString filename = data->getFilename();
	KMimeMagicResult *mime;

  if(filename.left(8)=="kaspa://") {
    const char *buf=data->getData();
    QByteArray in=QByteArray().duplicate(buf, strlen(buf));
    QByteArray out;
    KCodecs::base64Decode(in, out);
    mime=KMimeMagic::self()->findBufferFileType(out, filename);
    file="file:/"+buf2file(out);
  }
  else {
    if (KIO::NetAccess::download(filename, kio_target) == false)
      throw KaspaErr(i18n("Cannot download file!"));
    mime=KMimeMagic::self()->findFileType(kio_target);
    file=kio_target;
  }


/*
  KMimeType::Ptr mimeType = KMimeType::findByURL( url );
  KoDocumentEntry m_documentEntry = KoDocumentEntry::queryByMimeType( mimeType->name().latin1() );
  if ( m_documentEntry.isEmpty() )
    return false;

  KoDocument* newdoc = m_documentEntry.createDoc();
*/
  // Pass the filterManager to the document (who will own it from now on)
/*
  if ( filterManager )
      newdoc->setFilterManager( filterManager );
*/
/*
  connect(newdoc, SIGNAL(sigProgress(int)), this, SLOT(slotProgress(int)));
  connect(newdoc, SIGNAL(completed()), this, SLOT(slotKSLoadCompleted()));
  connect(newdoc, SIGNAL(canceled( const QString & )), this, SLOT(slotKSLoadCanceled( const QString & )));
  if ( !newdoc || !newdoc->openURL( url ) )
  {
      delete newdoc;
      return false;
  }
  return true;
*/


/*
  KTrader::OfferList offers = KTrader::self()->query(mime->mimeType(), "'KParts/ReadWritePart' in ServiceTypes");
  if(offers.count()>0) {
	  debug("DataView::DataView(QString, QWidget, char*): offers.count()>0");
    KService::Ptr ptr = offers.first();
   	if(ptr) {
		  debug("DataView::DataView(QString, QWidget, char*): ptr!=0");
    	KLibFactory *factory = KLibLoader::self()->factory( ptr->library() );
	    if (factory)
		  {
    	  debug("DataView::DataView(QString, QWidget, char*): factory!=0");
				part = (KParts::ReadWritePart *)factory->create(splitter, ptr->name(), "KParts::ReadWritePart");
//        emit modifyGUI(part);
		    part->openURL(file);
        part->setReadWrite(true);
		  }
		}
	}
*/

  KTrader::OfferList offers = KTrader::self()->query(mime->mimeType(), "'KParts/ReadOnlyPart' in ServiceTypes");
  if(offers.count()>0) {
	  debug("DataView::DataView(QString, QWidget, char*): offers.count()>0");
    KService::Ptr ptr = offers.first();
   	if(ptr) {
		  debug("DataView::DataView(QString, QWidget, char*): ptr!=0");
    	KLibFactory *factory = KLibLoader::self()->factory( ptr->library() );
	    if (factory)
		  {
    	  debug("DataView::DataView(QString, QWidget, char*): factory!=0");
				part = (KParts::ReadOnlyPart *)factory->create(splitter, ptr->name(), "KParts::ReadOnlyPart");
//        emit modifyGUI(part);
		    part->openURL(file);
		  }
		}
	}

  notes->setTitle("Links");
}



DataView::~DataView()
{
	debug("DataView::~DataView()");
	delete data;
  for(unsigned int i=0; i<tmpfiles.count(); i++) {
	  tmpfiles.at(i)->remove();
	}
  if(!kio_target.isEmpty())
    KIO::NetAccess::removeTempFile(kio_target);
  emit modifyGUI(0L);
}

QString DataView::buf2file(QByteArray b) {
	QString fname=tmpnam(0L);
	debug("DataView::buf2file() - "+fname);
	QFile *f=new QFile(fname);
  if (!f->open(IO_WriteOnly) )
    throw KaspaErr("Kann kein temporres File ffnen!");
	f->writeBlock(b);
  f->close();
  tmpfiles.append(f);
  return fname;
}

bool DataView::isValid() {
	try {
	  return data->isValid();
	} catch(KaspaErr& err) {
		handleWarning(err);
		return false;
	}
}


void DataView::save(bool block) {
  debug("DataView::save()");
	try {
	  if(isValid() && !isReadOnly() && !isWorking()) {
	    if(strcmp(filename->text(), data->getFilename()))
	      data->setFilename(filename->text());
	    if(strcmp(memo->text(), data->getPartMemo()))
        data->setPartMemo(memo->text());

	    data->flush(block);
		}
	} catch(KaspaErr &err) {
		handleWarning(err);
	}
}

void DataView::flush() {
	setWorkingGUI();
	save();
	setupGUI();
}

void DataView::reread() {
	try {
		setWorkingGUI();
  	data->reset();
	} catch(KaspaErr& err) {
		handleWarning(err);
	}
	  setFields();
}

void DataView::setFields() {
  if(isValid()) {
		setWorkingGUI();

		try {
			Title *p;
			if((p=data->getPublTitle())) publtitle->setText(p->getTitle());
			else throw KaspaErr("File has no Publication!");

			if((p=data->getPartTitle())) parttitle->setText(p->getTitle());
			else throw KaspaErr("File has no Part!");

		  filename->setText(data->getFilename());
		  memo->setText(data->getPartMemo());
		  notes->set(data->getLinks());

  	  if(part)
        emit modifyGUI(part);

		} catch(KaspaErr& err) {
			handleWarning(err);
		}
	}
	setupGUI();
}


void DataView::setInvalidGUI() {
	Inherited::setInvalidGUI();
	lockGUI();
	for(unsigned int i=0; i<sizeof(dataviewcs)/sizeof(CommandSetup); i++)
		emit enableCommand(dataviewcs[i].command, ((dataviewcs[i].setup&INV)==INV));
}	

void DataView::setReadWriteGUI() {
 	Inherited::setReadWriteGUI();
 	unlockGUI();
	for(unsigned int i=0; i<sizeof(dataviewcs)/sizeof(CommandSetup); i++)
		emit enableCommand(dataviewcs[i].command, ((dataviewcs[i].setup&RW)==RW));
}

void DataView::setWorkingGUI() {
	Inherited::setWorkingGUI();
  notes->setEnabled(false);
	for(unsigned int i=0; i<sizeof(dataviewcs)/sizeof(CommandSetup); i++)
		emit enableCommand(dataviewcs[i].command, ((dataviewcs[i].setup&WORK)==WORK));
}

void DataView::setReadOnlyGUI() {
	Inherited::setReadOnlyGUI();
	lockGUI();
	notes->setEnabled(true);
	for(unsigned int i=0; i<sizeof(dataviewcs)/sizeof(CommandSetup); i++)
		emit enableCommand(dataviewcs[i].command, ((dataviewcs[i].setup&RO)==RO));
}



bool DataView::closeRequest() {
  save(true);
	setupGUI();
  return true;
}
	
void DataView::newLink() {
	try {
		setWorkingGUI();
		Oid o=data->createNote();
		requestNote(o);
		setupGUI();
		save();
		setFields();	
	} catch(KaspaErr& err) {
		handleWarning(err);
	}
}
	
void DataView::insLink() {
	try {
		SelectionDlg dlg(data->getNotes(), this);
		if(dlg.exec()) {
			Oid o=dlg.getOid();
			if(o==InvalidOid) return;
			setWorkingGUI();
			data->insertLink(o);
  		save();
	  	setFields();	
		}
	} catch(KaspaErr& err) {
		handleWarning(err);
	}
}		
	
void DataView::remLink() {
	try {
		Oid o=notes->getCurrentOid();
		if(o==InvalidOid) return;
		setWorkingGUI();
		data->removeLink(o);
		save();
		setFields();	
	} catch(KaspaErr& err) {
		handleWarning(err);
	}
}
		
void DataView::showPart() {
	requestPart(data->getPartNo());
}

void DataView::runApp() {
	Run r(file, this);
  r.exec();
}


KToolBar *DataView::getToolBar() {
	KaspaToolBar *toolbar = new KaspaToolBar(topLevelWidget());
  toolbar->insertButton(BarIcon("newnote.xpm"), ID_HTML_NEWLINK, SIGNAL(clicked()),
				this, SLOT(newLink()), true, i18n("New Note") );
  toolbar->insertButton(BarIcon("insnote.xpm"), ID_HTML_INSLINK, SIGNAL(clicked()),
				this, SLOT(insLink()), true, i18n("Insert Note") );
  toolbar->insertButton(BarIcon("delnote.xpm"), ID_HTML_REMLINK, SIGNAL(clicked()),
				this, SLOT(remLink()), true, i18n("Delete Note") );

	toolbar->insertLineSeparator();
  toolbar->insertButton(BarIcon("showpart.xpm"), ID_HTML_SHOWPART, SIGNAL(clicked()),
				this, SLOT(showPart()), true, i18n("Show Part") );
  toolbar->insertButton(BarIcon("run.xpm"), ID_HTML_RESET, SIGNAL(clicked()),
				this, SLOT(runApp()), true, i18n("Run Application") );
	toolbar->insertLineSeparator();

  toolbar->insertButton(BarIcon("filefloppy.xpm"), ID_HTML_FLUSH, SIGNAL(clicked()),
				this, SLOT(flush()), true, i18n("Save Changes") );
  toolbar->insertButton(BarIcon("reload.xpm"), ID_HTML_RESET, SIGNAL(clicked()),
				this, SLOT(reread()), true, i18n("Revert Record") );
	toolbar->insertLineSeparator();
  setupToolbar(toolbar);
	toolbar->setBarPos(KToolBar::Top);
	toolbar->enable(KToolBar::Show);
  return toolbar;
}

