/***************************************************************************
                          notebase.h  -  description
                             -------------------
    begin                : Sat Sep 4 1999
    copyright            : (C) 1999 by Jan Mueller
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef NOTEBASE_H
#define NOTEBASE_H
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <table.h>

/** @author Jan Mueller
  * One tuple from the table note.
  * See @ref AuthorBase for details.
  */

class NoteBase : public Table {
 private:
  NoteBase(const NoteBase&);
	NoteBase& operator=(const NoteBase&);	


 	void initNew();
 	void initWhere(const char *where);
 public:
  /** Creates new note.
   */
  NoteBase(Sql *conn);
  NoteBase(const char *dbname);

  /** Reads row with the SQL-WHERE clause "where". "where" must not return more than one record.
   */
  NoteBase(const char *where, Sql *conn);
  NoteBase(const char *where, const char *dbname);

  /** Updates row, if data has changed and not readonly-mode.
   */
  virtual ~NoteBase() throw();

  const char *getTitle();
  int   getType();
  Oid   getPublNo();
  const char *getMemo();
	const char *getModified();
	const char *getCreated();

  void setTitle(const char *s);
  void setType(int t);
  void setPublNo(Oid publ);
  void setMemo(const char *s);

  Oid createNote();

  virtual const char *getWhereClause() { return _where; }
  NoteTitle *getNoteTitles(const char *where);

 private:
  virtual KaspaRec *invalid();
  virtual KaspaRec *read(const char *where);
  virtual void write(const char *where, bool block=false);
  void del(const Oid o);
  NoteRec *note();
  Str _where;
};

#endif
















