/***************************************************************************
                          processfiledlg.h  -  description
                             -------------------
    begin                : Fri Oct 5 2001
    copyright            : (C) 2001 by Jan Mueller
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PROCESSFILEDLG_H
#define PROCESSFILEDLG_H

#include <qwidget.h>
#include <processfile.h>
#include "kaspasql.h"

class KMimeMagicResult;

/**
  *@author Jan Mueller
  */

class ProcessFileDlg : public ProcessFile  {
   Q_OBJECT
private:
  QString out;
  bool canceled;
  Sql *sql;
public:
	ProcessFileDlg(Sql *sql, QWidget *parent=0, const char *name=0);
	~ProcessFileDlg();

public slots:
  void slotCanceled();
  void slotImportFiles(QStrList l, Oid partid);
  void slotCreateReferences(QStrList l, Oid partid);
  void slotOutput(QString s);
  QString slotConv2Text(QByteArray buffer, KMimeMagicResult *res);
  void slotCreateReference(QString s, Oid partid);
  void slotImportFile(QString s, Oid partid);
  void slotRebuildText(bool all);

};

#endif
