/***************************************************************************
                          prefdialog.cpp  -  description
                             -------------------
    begin                : Wed Jan 26 2000
    copyright            : (C) 2000 by Frank von Daak
    email                : frank.fun@skydsl.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "prefdialog.h"

PrefDialog::PrefDialog(QWidget *parent, const char *name, bool modal, WFlags f)
			: QDialog(parent,name,modal)
{
	prefTab = new QTabWidget(this);
	prefTab->setCaption(i18n("KWebGet-Setup"));

	pathConf = new QWidget(0, "pathConf");

	startupConf = new QWidget(0, "startupConf");

	proxyConf = new QWidget(0, "proxyConf");

	setPathConf();
	setStartupConf();
	setProxyConf();

	prefTab->addTab (startupConf, i18n("Startup"));
	prefTab->addTab (pathConf, i18n("Path & Password"));
	prefTab->addTab (proxyConf, i18n("Proxy"));
/*	prefTab->setDefaultButton(i18n("Ok"));
	prefTab->setApplyButton(i18n("Apply"));
    prefTab->setCancelButton(i18n("Cancel"));
    prefTab->setOkButton(0);
*/    prefTab->setGeometry(5,5,420,300);

	okBut = new QPushButton("OK",this);
	okBut->setGeometry(180,320,80,30);

	appBut = new QPushButton(i18n("Apply"),this);
	appBut->setGeometry(265,320,80,30);

	canBut = new QPushButton(i18n("Cancel"), this);
	canBut->setGeometry(350,320,80,30);

	prefTab->show();
}

PrefDialog::~PrefDialog()
{
}


void PrefDialog::setPathConf()
{
	QFont fnt ("helvetica", 12, QFont::Bold);

	QFrame *pathFrame = new QFrame(pathConf);
	pathFrame->setGeometry(2,2,412,126);
	pathFrame->setFrameStyle(QFrame::Panel | QFrame::Sunken);

	QLabel *wgetBinLab = new QLabel(i18n("Please enter the path to wget,\n"
			"if the wget-executable is not in your $PATH"), pathFrame);
	wgetBinLab->setAlignment(AlignCenter);
	wgetBinLab->setGeometry(5,30,400,32);
	wgetBinLab->setFont(fnt);

	wgetBinLine = new QLineEdit(pathFrame);
	wgetBinLine->setGeometry(50,75,300,20);

	wgetBinBut = new QPushButton(pathFrame);
	wgetBinBut->setPixmap(BarIcon("fileopen"));
	wgetBinBut->setGeometry(360,72,27,27);
	connect(wgetBinBut, SIGNAL(clicked()), this, SLOT(getWgetPath()));

	QFrame *passFrame = new QFrame(pathConf);
	passFrame->setGeometry(2,130,412,138);
	passFrame->setFrameStyle(QFrame::Panel | QFrame::Sunken);

	QLabel *passInfoLab = new QLabel(i18n("If you don't want KWebGet to use\n"
				"username@hostname.domainname as password for\n"
				"anonymous Ftp-Logins, you can enter your real\n"
				"Email-adress here !"), passFrame);
	passInfoLab->setAlignment(AlignCenter);
	passInfoLab->setFont(fnt);
	passInfoLab->setGeometry(5,12,400,60);
	
	QLabel *emailLab = new QLabel(i18n("E-Mail :"), passFrame);
	emailLab->setGeometry(40,92,50,20);

	emailLine = new QLineEdit(passFrame);
	emailLine->setGeometry(90,92,250,20);
}

void PrefDialog::setStartupConf()
{
	QFrame *startFrame = new QFrame(startupConf);
	startFrame->setGeometry(2,2,412,268);
	startFrame->setFrameStyle(QFrame::Panel | QFrame::Sunken);

	QFont fnt ("helvetica", 14, QFont::Bold);
	fnt.setUnderline(true);

	QLabel *startupLab = new QLabel(i18n("Please choose the behavior of KWebGet at start time"), startFrame);
	startupLab->setAlignment(AlignCenter);
	startupLab->setGeometry(10,20,380,40);
	startupLab->setFont(fnt);

	QButtonGroup *selGrp = new QButtonGroup(i18n("Behaviour on Startup"), startFrame);
		advBut = new QRadioButton(i18n("Start KWebGet-Advanced"), selGrp);
		advBut->setGeometry(10,22,200,15);

		wizBut = new QRadioButton(i18n("Start KWebGet-Wizard"), selGrp);
		wizBut->setGeometry(10,42,200,15);

		selBut = new QRadioButton(i18n("Select on Startup"), selGrp);
		selBut->setGeometry(10,62,200,15);
	selGrp->setGeometry(30,85,290,85);

}

void PrefDialog::setProxyConf()
{
	QFrame *proxyFrame = new QFrame(proxyConf);
	proxyFrame->setGeometry(2,2,412,268);
	proxyFrame->setFrameStyle(QFrame::Panel | QFrame::Sunken);

	proxyTab = new QTabWidget(proxyFrame);
	proxyTab->setCaption(i18n("Proxy-Setup"));

	proxySetup = new QWidget(0, "proxySetup");

	loginConf = new QWidget(0, "loginConf");

	setProxySetup();
	setLoginConf();

	proxyTab->addTab (proxySetup, i18n("Proxys"));
	proxyTab->addTab (loginConf, i18n("Logins"));
    proxyTab->setGeometry(2,2,408,265);
	proxyTab->show();
}

void PrefDialog::setProxySetup()
{
	QFont fnt (QFont("helvetica",12, QFont::Bold));

	QLabel *proxyInfoLab = new QLabel(i18n("If you have to go through a Proxy, "
			"you can set up\nthis here, so that KWebGet will use it as default"), proxySetup);
	proxyInfoLab->setAlignment(AlignCenter);
	proxyInfoLab->setFont(fnt);
	proxyInfoLab->setGeometry(10,10,380,40);

	httpProxyBox = new QCheckBox(i18n("Use always a HTTP-Proxy"), proxySetup);
	httpProxyBox->setGeometry(10,60,230,20);
	httpProxyBox->setFont(fnt);
	connect(httpProxyBox, SIGNAL(clicked()), this, SLOT(enableHttpProxy()));

	QLabel *httpProxyAdressLab = new QLabel(i18n("HTTP-Proxy :"), proxySetup);
	httpProxyAdressLab->setGeometry(20,85,90,20);

	httpProxyAdressLine = new QLineEdit(proxySetup);
	httpProxyAdressLine->setGeometry(110,85,180,20);
	httpProxyAdressLine->setEnabled(false);

	QLabel *httpProxyPortLab = new QLabel(i18n("Port:"), proxySetup);
	httpProxyPortLab->setGeometry(300,85,30,20);

	httpProxyPortLine = new QLineEdit(proxySetup);
	httpProxyPortLine->setGeometry(330,85,50,20);
	httpProxyPortLine->setEnabled(false);

	ftpProxyBox = new QCheckBox(i18n("Use always a FTP-Proxy"), proxySetup);
	ftpProxyBox->setGeometry(10,125,220,20);
	ftpProxyBox->setFont(fnt);
	connect(ftpProxyBox, SIGNAL(clicked()), this, SLOT(enableFtpProxy()));

	QLabel *ftpProxyAdressLab = new QLabel(i18n("FTP-Proxy :"), proxySetup);
	ftpProxyAdressLab->setGeometry(20,150,90,20);

	ftpProxyAdressLine = new QLineEdit(proxySetup);
	ftpProxyAdressLine->setGeometry(110,150,170,20);
	ftpProxyAdressLine->setEnabled(false);

	QLabel *ftpProxyPortLab = new QLabel(i18n("Port:"), proxySetup);
	ftpProxyPortLab->setGeometry(300,150,30,20);

	ftpProxyPortLine = new QLineEdit(proxySetup);
	ftpProxyPortLine->setGeometry(330,150,50,20);
	ftpProxyPortLine->setEnabled(false);
}

void PrefDialog::setLoginConf()
{
	QFont fnt (QFont("helvetica",12, QFont::Bold));

	httpProxyloginBox = new QCheckBox(i18n("The Proxy requires a login:"), loginConf);
	httpProxyloginBox->setGeometry(10,10,200,20);
	httpProxyloginBox->setEnabled(false);
	connect(httpProxyloginBox, SIGNAL(clicked()), this, SLOT(getHttpProxyLogin()));

	httpProxyusrLab = new QLabel(i18n("UserName :"), loginConf);
	httpProxyusrLab->setGeometry(20,40,80,20);
	httpProxyusrLab->setEnabled(false);

	httpProxypassLab = new QLabel(i18n("Password :"), loginConf);
	httpProxypassLab->setGeometry(20,60,80,20);
	httpProxypassLab->setEnabled(false);

	httpProxyusrLine = new QLineEdit(loginConf);
	httpProxyusrLine->setGeometry(100,40,200,20);
	httpProxyusrLine->setEnabled(false);

	httpProxypassLine = new QLineEdit(loginConf);
	httpProxypassLine->setGeometry(100,60,200,20);
	httpProxypassLine->setEchoMode(QLineEdit::Password);
	httpProxypassLine->setEnabled(false);

	storePassBut = new QCheckBox(i18n("Save Passwords"), loginConf);
	storePassBut->setGeometry(10,200,140,20);
	storePassBut->setEnabled(false);
}

void PrefDialog::getWgetPath()
{
	QString root = QDir::rootDirPath();
	QString tmp = getWget->getOpenFileName(root,"*", this);
	QFile tmpFile (tmp);
	if ( !tmpFile.exists() ) {
		QMessageBox::warning(this, i18n("Wrong path !"),
			i18n("Please check the path !\n"
			"Can't find the file you've entered !"));
		return;
	}
	QFileInfo tmpFileInfo(tmp);
	if ( !tmpFileInfo.isExecutable() ) {
		QMessageBox::warning(this, i18n("Wrong permissions !"),
			i18n("It seems, that you've no rights,\n"
			"to execute the file !\n\n"
			"Please contact your sysadmin !"));
		return;
	}
	wgetBinLine->setText(tmp);
	return;
}

void PrefDialog::enableHttpProxy()
{
	if ( httpProxyBox->isChecked() ) {
		httpProxyAdressLine->setEnabled(true);
		httpProxyPortLine->setEnabled(true);
		httpProxyloginBox->setEnabled(true);
	} else {
		httpProxyAdressLine->setEnabled(false);
		httpProxyPortLine->setEnabled(false);
		httpProxyloginBox->setEnabled(false);
		httpProxyloginBox->setChecked(false);
		getHttpProxyLogin();
	}
}

void PrefDialog::getHttpProxyLogin()
{
	if ( httpProxyloginBox->isChecked() ) {
		httpProxyusrLine->setEnabled(true);
		httpProxypassLine->setEnabled(true);
		httpProxypassLab->setEnabled(true);
		httpProxyusrLab->setEnabled(true);
		storePassBut->setEnabled(true);
	} else {
		httpProxyusrLine->setEnabled(false);
		httpProxypassLine->setEnabled(false);
		httpProxypassLab->setEnabled(false);
		httpProxyusrLab->setEnabled(false);
		storePassBut->setEnabled(false);
		storePassBut->setChecked(false);
	}
}

void PrefDialog::enableFtpProxy()
{
	if ( ftpProxyBox->isChecked() ) {
		ftpProxyAdressLine->setEnabled(true);
		ftpProxyPortLine->setEnabled(true);
	} else {
		ftpProxyAdressLine->setEnabled(false);
		ftpProxyPortLine->setEnabled(false);
	}
}

void PrefDialog::closeEvent(QCloseEvent *ce)
{
  // Nothing happens if the user trys to close the window with the [X]-Button of the Widget !
}