#include "main.h"
#include "piecewidget.h"

#include "kpuzzle.h"
#include "kpuzzleapp.h"

#include <qrect.h>

CPieceWidget::CPieceWidget(QWidget *parent,KPuzzleApp* app) : QWidget(parent)
{
	_app = app;
}

CPieceWidget::~CPieceWidget()
{
}

QPixmap* CPieceWidget::currentPiece()
{
	return _app->currentPieceTurned(); 
}

// 
QRect CPieceWidget::getPieceDrawRect()
{
	QSize sz = _app->pieceSizeDisp();
	QSize own = this->size();
	own -= sz;
	own /= 2;
	QRect rct(own.width(),own.height(),sz.width(),sz.height());
	return rct;
	
}

void CPieceWidget::paintEvent(QPaintEvent* event)
{
	// The piece is already turned
	bitBlt(this,0,0,currentPiece(),0,0,_app->pieceSizeDisp().width(),
		_app->pieceSizeDisp().height());
}

void CPieceWidget::slotNextClicked()
{
	if (_app->setNextPiece()) update();
}

void CPieceWidget::slotPrevClicked()
{
	if (_app->setPrevPiece()) update();
}

void CPieceWidget::slotTurn1Clicked()
{
	if (TOPWIDGET->turnPiecesAround())
		_app->turnCW();
	else
		_app->changeLRTurn();
	update();
}

void CPieceWidget::slotTurn2Clicked()
{
	if (TOPWIDGET->turnPiecesAround())
		_app->turnCCW();
	else
		_app->changeUDTurn();
	update();
}

