#include "main.h"

#include "gamedialog.h"

#include "kpuzzle.h"
#include "kpuzzleapp.h"

#include <qpushbutton.h>
#include <qlabel.h>

CGameDialog::CGameDialog(QWidget* parent) : QDialog(parent,0,true)
{
	QLabel* lb;
	QPushButton* bt;

	_gameType = new QComboBox(false,this);
	_gameType->move(140,20);
	_gameType->setFixedWidth(100);

	lb = new QLabel(_gameType,"&Game Type",this);
	lb->move(20,_gameType->y());
	
	_pieceSize = new QComboBox(false,this);
	_pieceSize->move(140,_gameType->y() + _gameType->height() + 20);
	_pieceSize->setFixedWidth(100);

	lb = new QLabel(_pieceSize,"&Piece Size",this);
	lb->move(20,_pieceSize->y());

	_difficulty = new QComboBox(false,this);
	_difficulty->move(140,_pieceSize->y() + _pieceSize->height() + 20);
	_difficulty->setFixedWidth(100);

	lb = new QLabel(_difficulty,"&Difficulty",this);
	lb->move(20,_difficulty->y());
	
	_useMask = new QCheckBox("Use piece mask",this);
	_useMask->resize(120,_useMask->height());
	_useMask->move(130 - _useMask->width() / 2,_difficulty->y() + _difficulty->height() + 20);
	_useMask->setChecked(TOPWIDGET->usePieceMask());

	bt = new QPushButton("OK",this);
	bt->setDefault(true);
	connect(bt,SIGNAL(clicked()),this,SLOT(accept()));
	bt->setFixedWidth(100);
	bt->move(20,_useMask->y() + _useMask->height() + 30);

	bt = new QPushButton("Cancel",this);
	connect(bt,SIGNAL(clicked()),this,SLOT(reject()));
	bt->setFixedWidth(100);
	bt->move(140,_useMask->y() + _useMask->height() + 30);

	resize(260,bt->y() + bt->height() + 20);

	_gameType->insertItem("Standard");
	_gameType->insertItem("Piece-Time"); // You have got a certain time for every piece
	_gameType->insertItem("Faults-Count"); // You may try every piece n times
	_gameType->insertItem("All-Faults"); // The faults for all pieces are counted together
	_gameType->insertItem("Unbearable"); // The current piece switches automatically
	_gameType->setCurrentItem(0);

	_pieceSize->insertItem("Invisible");
	_pieceSize->insertItem("Small");
	_pieceSize->insertItem("Normal");
	_pieceSize->insertItem("Large");
	_pieceSize->insertItem("Huge");
	_pieceSize->setCurrentItem(2);

	_difficulty->insertItem("Easy");
	_difficulty->insertItem("Medium");
	_difficulty->insertItem("Hard");
}

CGameDialog::~CGameDialog()
{

}

char CGameDialog::gameType()
{
	return _gameType->currentItem() + 1;
}

char CGameDialog::pieceSize()
{
	return _pieceSize->currentItem();
}

char CGameDialog::difficulty()
{
	return _difficulty->currentItem();
}
