/*
   SPDX-FileCopyrightText: 2024 Laurent Montel <montel@kde.org>

   SPDX-License-Identifier: LGPL-2.0-or-later
*/

#pragma once

#include "librocketchatrestapi-qt_export.h"
#include "restapiabstractjob.h"

namespace RocketChatRestApi
{
class LIBROCKETCHATRESTAPI_QT_EXPORT LicensesMaxActiveUsersJob : public RestApiAbstractJob
{
    Q_OBJECT
public:
    explicit LicensesMaxActiveUsersJob(QObject *parent = nullptr);
    ~LicensesMaxActiveUsersJob() override;

    [[nodiscard]] bool requireHttpAuthentication() const override;

    [[nodiscard]] bool start() override;

    [[nodiscard]] QNetworkRequest request() const override;

Q_SIGNALS:
    void licensesMaxActiveUsersDone(const QJsonObject &obj);

private:
    Q_DISABLE_COPY(LicensesMaxActiveUsersJob)
    LIBROCKETCHATRESTAPI_QT_NO_EXPORT void onGetRequestResponse(const QString &replyErrorString, const QJsonDocument &replyJson) override;
};
}
