/*
 * This file is part of telepathy-presence-applet
 *
 * Copyright (C) 2011 Francesco Nwokeka <francesco.nwokeka@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

import Qt 4.7
import org.kde.plasma.graphicswidgets 0.1 as PlasmaWidgets

Item {
    property bool contactlistInstalled: false;

    PlasmaWidgets.IconWidget {
        id: contactlistLauncher;
        height: parent.height;
        width: parent.height
        text: i18n("Contact list");
        enabled: contactlistInstalled;

        anchors {
            left: parent.left;
            leftMargin: 4;
            top: parent.top;
        }

        Component.onCompleted: {
            setIcon("meeting-attending");
        }

        onClicked: {
            plasmoid.runCommand("telepathy-kde-contactlist");
        }
    }


    PlasmaWidgets.IconWidget {
        id: accountConfigurationLauncher;
        height: parent.height;
        width: parent.height;
        text: i18n("Account Manager");

        anchors {
            right: parent.right;
            rightMargin: 4;
            top: parent.top;
        }

        Component.onCompleted: {
            setIcon("telepathy-kde");
        }

        onClicked: {
            plasmoid.runApplication("kcm_telepathy_accounts");
        }
    }
}
