/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
#ifndef SKGPROGRESSBARDESIGNERPLUGIN_H
#define SKGPROGRESSBARDESIGNERPLUGIN_H
/** @file
 * A progress bar with colors
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include <QDesignerCustomWidgetInterface>

/**
 * QDesigner plugin for SKGProgressBar
 */
class SKGProgressBarDesignerPlugin : public QObject, public QDesignerCustomWidgetInterface
{
    Q_OBJECT
    Q_INTERFACES(QDesignerCustomWidgetInterface)

public:
    /**
    * Constructor
    * @param iParent parent
    */
    explicit SKGProgressBarDesignerPlugin(QObject* iParent = 0);

    /**
     * To know if the component is a container
     * @return true or false
     */
    bool isContainer() const Q_DECL_OVERRIDE;

    /**
     * To know if the component is initialized
     * @return true or false
     */
    bool isInitialized() const Q_DECL_OVERRIDE;

    /**
     * To get the icon for this component
     * @return the icon
     */
    QIcon icon() const Q_DECL_OVERRIDE;

    /**
     * To get the icon for this component
     * @return
     */
    QString domXml() const Q_DECL_OVERRIDE;

    /**
     * To get the group for this component
     * @return group
     */
    QString group() const Q_DECL_OVERRIDE;

    /**
     * To get the include file for this component
     * @return the include file
     */
    QString includeFile() const Q_DECL_OVERRIDE;

    /**
     * To get the name for this component
     * @return name
     */
    QString name() const Q_DECL_OVERRIDE;

    /**
     * To get the "tool tip" for this component
     * @return the "tool tip"
     */
    QString toolTip() const Q_DECL_OVERRIDE;

    /**
     * To get the "whats this" for this component
     * @return the "whats this"
     */
    QString whatsThis() const Q_DECL_OVERRIDE;

    /**
     * To get the widget representing the component
     * @param iParent the parent of the widget
     * @return the widget
     */
    QWidget* createWidget(QWidget* iParent) Q_DECL_OVERRIDE;

    /**
     * Initilialize the component
     * @param core interface
     */
    void initialize(QDesignerFormEditorInterface* core) Q_DECL_OVERRIDE;

private:
    bool m_initialized;
};

#endif
