/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * This file is a test script.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include <qfile.h>
#include <qsqldatabase.h>

#include "skgtestmacro.h"

/**
 * The main function of the unit test
 * @param argc the number of arguments
 * @param argv the list of arguments
 */
int main(int argc, char** argv)
{
    Q_UNUSED(argc);
    Q_UNUSED(argv);

    // Init test
    SKGINITTEST(true);
    {
        SKGTESTBOOL("QSQLITE:isDriverAvailable", QSqlDatabase::isDriverAvailable("QSQLITE"), true);
#ifdef SKGCIPHER
        SKGTESTBOOL("SKGSQLCIPHER:isDriverAvailable", QSqlDatabase::isDriverAvailable("SKGSQLCIPHER"), true);
#endif
    }
    {
        // test class SKGDocument / LOAD / SAVE
        QString filename1 = SKGTest::getTestPath("IN") % QString::fromUtf8("/filename1_e.skg");
        qDebug("filename1=%s", filename1.toUtf8().constData());
        {
            SKGDocument document1;
            QFile(filename1).remove();
            SKGTESTERROR("DOC:initialize", document1.initialize(), true);
            SKGTESTERROR("DOC:setLanguage", document1.setLanguage("en"), true);
            SKGTESTERROR("DOC:setLanguage", document1.setLanguage("fr"), true);
            SKGTESTBOOL("DOC:isFileModified", document1.isFileModified(), false);

            SKGTESTERROR("DOC:beginTransaction", document1.beginTransaction("tt"), true);
            SKGTESTERROR("DOC:setParameter", document1.setParameter("ATT3", "VAL3"), true);
            SKGTESTBOOL("DOC:isFileModified", document1.isFileModified(), true);
            SKGTESTERROR("DOC:endTransaction", document1.endTransaction(false), true);
            SKGTESTBOOL("DOC:isFileModified", document1.isFileModified(), false);

            SKGTESTERROR("DOC:beginTransaction", document1.beginTransaction("tt"), true);
            SKGTESTERROR("DOC:setParameter", document1.setParameter("ATT3", "VAL3"), true);
            SKGTESTBOOL("DOC:isFileModified", document1.isFileModified(), true);
            SKGTESTERROR("DOC:endTransaction", document1.endTransaction(true), true);
            SKGTESTBOOL("DOC:isFileModified", document1.isFileModified(), true);

            document1.setFileNotModified();
            SKGTESTBOOL("DOC:isFileModified", document1.isFileModified(), false);

            SKGTEST("DOC:getDisplay", document1.getDisplay("t_name"), "Name");
            SKGTEST("DOC:getDisplay", document1.getDisplay("node.t_name"), "Name");
            SKGTEST("DOC:getDisplay", document1.getDisplay("v_node.t_name"), "Name");
            SKGTEST("DOC:getDisplay", document1.getDisplay("v_node.unknown"), "v_node.unknown");

            QString oResult;
            SKGTESTERROR("DOC:isFileModified", document1.dumpSelectSqliteOrder("select * from parameters", oResult), true);
        }
        {
            SKGDocument document1;
            QFile(filename1).remove();
            SKGTESTERROR("DOC:initialize", document1.initialize(), true);
            SKGTESTBOOL("DOC:isFileModified", document1.isFileModified(), false);

            SKGTESTERROR("DOC:beginTransaction", document1.beginTransaction("tt"), true);
            SKGTESTERROR("DOC:endTransaction", document1.endTransaction(true), true);
            SKGTESTBOOL("DOC:isFileModified", document1.isFileModified(), false);  // because the transaction is empty
        }
        {
            SKGDocument document1;
            QFile(filename1).remove();
            SKGTESTERROR("DOC:load", document1.load(filename1, ""), false);
            SKGTESTERROR("DOC:saveAs+invalid path", document1.saveAs("/notfound/file.skg", true), false);
            SKGTEST("DOC:getCurrentFileName", document1.getCurrentFileName(), "");
            SKGTESTBOOL("DOC:isFileModified", document1.isFileModified(), false);
            SKGTESTERROR("DOC:initialize", document1.initialize(), true);
            SKGTESTBOOL("DOC:isFileModified", document1.isFileModified(), false);
            SKGTESTERROR("DOC:beginTransaction", document1.beginTransaction("t1"), true);
            SKGTEST("DOC:getCurrentFileName", document1.getCurrentFileName(), "");
            SKGTESTERROR("DOC:save", document1.save(), false);
            SKGTEST("DOC:getCurrentFileName", document1.getCurrentFileName(), "");
            SKGTESTBOOL("DOC:isFileModified", document1.isFileModified(), true);  // due to the beginTransaction
            SKGTEST("DOC:getParameter", document1.getParameter("ATT1"), "");
            SKGTESTERROR("DOC:setParameter", document1.setParameter("ATT1", "VAL1"), true);
            SKGTESTBOOL("DOC:isFileModified", document1.isFileModified(), true);
            SKGTEST("DOC:getParameter", document1.getParameter("ATT1"), "VAL1");
            SKGTESTERROR("DOC:endTransaction", document1.endTransaction(true), true);
            SKGTESTERROR("DOC:saveAs+overwrite=false", document1.saveAs(filename1, false), true);
            SKGTESTBOOL("DOC:exist", QFile(filename1).exists(), true);
            SKGTEST("DOC:getCurrentFileName", document1.getCurrentFileName(), filename1);
            SKGTESTERROR("DOC:saveAs+overwrite=false", document1.saveAs(filename1, false), false);
            SKGTESTBOOL("DOC:exist", QFile(filename1).exists(), true);
            SKGTEST("DOC:getCurrentFileName", document1.getCurrentFileName(), filename1);
            SKGTESTERROR("DOC:save", document1.save(), true);
            SKGTESTBOOL("DOC:exist", QFile(filename1).exists(), true);
            SKGTEST("DOC:getCurrentFileName", document1.getCurrentFileName(), filename1);

            SKGTESTERROR("DOC:beginTransaction", document1.beginTransaction("t1"), true);
            SKGTESTBOOL("DOC:isFileModified", document1.isFileModified(), true);  // due to the beginTransaction
            SKGTEST("DOC:getParameter", document1.getParameter("ATT1"), "VAL1");
            SKGTESTERROR("DOC:setParameter", document1.setParameter("ATT1", "VAL2"), true);
            SKGTEST("DOC:getParameter", document1.getParameter("ATT1"), "VAL2");
            SKGTESTBOOL("DOC:isFileModified", document1.isFileModified(), true);
            SKGTESTERROR("DOC:endTransaction", document1.endTransaction(true), true);

            SKGTESTBOOL("DOC:exist", QFile(filename1).exists(), true);
            SKGTESTERROR("DOC:load", document1.load(filename1, ""), true);
            SKGTESTBOOL("DOC:isFileModified", document1.isFileModified(), false);
            SKGTESTBOOL("DOC:getCurrentFileName", (!document1.getCurrentFileName().isEmpty()), true);
            SKGTEST("DOC:getParameter", document1.getParameter("ATT1"), "VAL1");
        }

        {
            SKGDocument document1;
            SKGTESTERROR("DOC:load", document1.load(filename1, ""), true);
            SKGTESTERROR("DOC:beginTransaction", document1.beginTransaction("t3"), true);
            SKGTESTERROR("DOC:setParameter", document1.setParameter("ATT3", "VAL3"), true);
            SKGTESTERROR("DOC:endTransaction", document1.endTransaction(true), true);
            SKGTESTERROR("DOC:save", document1.save(), true);

            SKGTESTERROR("DOC:beginTransaction", document1.beginTransaction("tt"), true);
            SKGTESTERROR("DOC:changePassword", document1.changePassword("pwd"), true);
            SKGTESTERROR("DOC:setParameter", document1.setParameter("SAVE", "1"), true);
            SKGTEST("DOC:getParameter", document1.getParameter("SAVE"), "1");
            SKGTESTERROR("DOC:endTransaction", document1.endTransaction(true), true);
            SKGTESTERROR("DOC:save", document1.save(), true);
        }
        {
            SKGDocument document1;
            SKGTESTERROR("DOC:load", document1.load(filename1, ""), false);
            SKGTEST("DOC:load", document1.load(filename1, "wrong pwd").getReturnCode(), ERR_ENCRYPTION);
            SKGTESTERROR("DOC:load", document1.load(filename1, "pwd"), true);
        }

        {
            SKGDocument document1;
            QFile(filename1).remove();
            SKGTESTERROR("DOC:initialize", document1.initialize(), true);
            document1.setBackupParameters("", "/invalid suffix");
            SKGTESTERROR("DOC:saveAs", document1.saveAs(filename1, true), true);
            SKGTESTERROR("DOC:saveAs", document1.saveAs(filename1, true), true);

            document1.setBackupParameters(".", ".old");
            SKGTEST("DOC:getBackupFile", document1.getBackupFile("/tmp/file.skg"), "/tmp/.file.skg.old");

            document1.setBackupParameters("", "_<DATE>.backup");
            SKGTEST("DOC:getBackupFile", document1.getBackupFile("/tmp/file.skg"), QString("/tmp/file.skg_") % SKGServices::dateToSqlString(QDateTime::currentDateTime().date()) % ".backup");

            document1.setBackupParameters("", "_<TIME>.backup");
            SKGTEST("DOC:getBackupFile", document1.getBackupFile("/tmp/file.skg"), QString("/tmp/file.skg_") % SKGServices::timeToString(QDateTime::currentDateTime()) % ".backup");

            document1.setBackupParameters("/tmp/", ".old");
            SKGTEST("DOC:getBackupFile", document1.getBackupFile("/home/user1/file.skg"), "/tmp/file.skg.old");
        }

        {
            SKGDocument document1;
            SKGTESTERROR("DOC:load", document1.load(filename1, ""), true);
            SKGTESTERROR("DOC:beginTransaction", document1.beginTransaction("tt"), true);
            SKGTESTERROR("DOC:setParameter", document1.setParameter("SAVE", "1"), true);
            SKGTEST("DOC:getParameter", document1.getParameter("SAVE"), "1");
            SKGTESTERROR("DOC:endTransaction", document1.endTransaction(true), true);
            SKGTESTERROR("DOC:save", document1.save(), true);

            // Check save when file system is full
            qputenv("SKGFILESYSTEMFULL", "Y");
            SKGTEST("DOC:getParameter", static_cast<unsigned int>(QFile(filename1).exists()), static_cast<unsigned int>(true));
            SKGTESTERROR("DOC:save", document1.save(), false);
            SKGTEST("DOC:getParameter", static_cast<unsigned int>(QFile(filename1).exists()), static_cast<unsigned int>(true));
        }

        QFile(filename1).remove();
        QFile(filename1 % ".old").remove();
    }
    // End test
    SKGENDTEST();
}
