/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * This file is a test for actions.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgtestactions.h"
#include "skgmainpanel.h"
#include "skgboardwidget.h"
#include "skgdocumentbank.h"
#include "skgtraces.h"
#include "skgtestmacro.h"

void SKGTESTActions::Test()
{
    // Initialize document
    SKGDocumentBank doc;

    // Create main panel
    SKGMainPanel mainpanel(NULL, &doc, QStringList());
    mainpanel.show();

    QVERIFY2(!doc.load(SKGTest::getTestPath("IN") % "/advice.skg"), "Load document failed");

    // Scenario
    QStringList actionsToExecute;
    actionsToExecute
    // Reinitialize document
            << "tab_closeall" << "fullscreen" << "fullscreen" << "fullscreen" << "edit_undolastsave" << "view_unlock" << "view_unlock" << "options_show_menubar" << "options_show_menubar"
            // Bank page
            << "page_Skrooge bank plugin" << "enable_editor" << "edit_select_all" << "edit_copy" << "edit_switch_highlight" << "edit_select_all" << "edit_delete"
            // Undo
            << "edit_undo" << "edit_redo" << "edit_undolastsave" << "edit_clear_history"
            // Clean
            << "edit_select_all" << "open_report" << "edit_find"
            << "page_Skrooge bank plugin" << "edit_select_all" << "edit_reconciliate"
            << "page_Skrooge bank plugin" << "edit_select_all" << "edit_find"

            // Operation
            << "page_Skrooge operation plugin" << "enable_editor" << "fast_edition" << "edit_select_all" << "edit_switch_highlight" << "edit_point_selected_operation"
            << "merge_sub_operations"
            // Too long << "edit_select_all" << "edit_duplicate_operation"
            << "edit_select_all" << "edit_group_operation" << "merge_imported_operation"
            << "edit_select_all" << "open_report"
            << "page_Skrooge operation plugin" << "edit_select_all" << "edit_find"

            // Category
            << "page_Skrooge categories plugin" << "edit_expandall" << "edit_collapseal"
            << "edit_select_all" << "open_report"
            << "page_Skrooge categories plugin" << "edit_select_all" << "edit_find"

            // Search page
            << "page_Skrooge search plugin" << "edit_select_all"
            << "execute_all" << "execute_imported" << "execute_not_validated"
            << "open_report"

            // All other pages
            << "page_Dashboard plugin" << "500"
            << "page_Skrooge budget plugin" << "tool_process_budget_rules" << "edit_select_all" << "open_report"
            << "page_Skrooge budget plugin" << "edit_select_all" << "edit_find"
            << "page_Skrooge calculator plugin"
            << "page_Skrooge payee plugin" << "edit_select_all" << "open_report"
            << "page_Skrooge payee plugin" << "edit_select_all" << "edit_find"
            << "page_Skrooge report plugin"
            << "page_Skrooge scheduled plugin" << "edit_select_all" << "open_report"
            << "page_Skrooge scheduled plugin" << "edit_select_all" << "edit_find"
            << "page_Skrooge tracker plugin" << "edit_select_all" << "open_report"
            << "page_Skrooge tracker plugin" << "edit_select_all" << "edit_find"
            << "page_Skrooge unit plugin" << "edit_select_all" << "open_report"
            << "page_Skrooge unit plugin" << "edit_select_all" << "edit_find"

            // Go
            << "page_Monthly plugin" << "go_previous" << "go_next" << "go_home" << "new_tab"

            // imports
            << "import" << "import_backends" << "import_standard_bookmarks" << "import_standard_categories"

            // Processing
            << "clean_align_comment" << "clean_delete_unused_categories" << "clean_delete_unused_payees" << "clean_delete_unused_units" << "clean_remove_group_with_one_operation"
            << "process_banks" << "process_foundtransfer" << "process_validate" << "processing" << "validate_imported_operation"

            // Views
            << "view_bookmarks" << "view_context" << "view_contextmenu" << "view_lock" << "view_menu" << "view_open_duplicates" << "view_open_highlight"
            << "view_open_last_modified" << "view_open_not_validated" << "view_open_operation_in_group_of_one" << "view_open_operation_with_comment_not_aligned"
            << "view_open_operation_without_category" << "view_open_operation_without_mode" << "view_open_operation_without_payee" << "view_open_suboperations"
            << "view_open_transfers_without_category" << "view_open_transfers_without_payee" << "view_open_very_old_operations" << "view_properties" << "view_transactions"
            // Close
            << "tab_close" << "tab_closeallother" << "tab_closeall"
            // Tabs
            << "tab_reopenlastclosed" << "tab_resetdefaultstate" << "tab_savedefaultstate" << "tab_switchpin" << "tab_overwritebookmark"

            // File
            << "file_save" << "file_new";

    // Dump actions
    QMap< QString, QPointer<QAction> > actions = mainpanel.getGlobalActions();
    QStringList keys = actions.keys();
    foreach(const QString & key, keys) {
        if (!actionsToExecute.contains(key)) {
            SKGTRACE << "  [" << key << "]" << endl;
        }
    }

    // Trigger actions
    foreach(const QString & key, actionsToExecute) {
        if (key == "edit_select_all") {
            SKGTRACE << "      Wait" << endl;
            QTest::qWait(10);
        }
        SKGTRACE << QDateTime::currentDateTime().toString("yyyy-MM-dd hh:mm:ss") << "  [" << key << "]: ";
        QAction* act = mainpanel.getGlobalAction(key);
        if (act) {
            act->trigger();
            SKGTRACESUITE << "DONE" << endl;
        } else {
            SKGTRACESUITE << "UNKNOWN" << endl;
        }

        if (key == "edit_select_all") {
            SKGTabPage* page = mainpanel.currentPage();
            if (page) {
                SKGTRACE << "      Current page:" << page->objectName() << endl;
            }
            SKGTRACE << "      Nb objects selected:" << mainpanel.getNbSelectedObjects() << endl;
        }
    }
}

QTEST_MAIN(SKGTESTActions)

