/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
#ifndef SKGSEARCHPLUGINWIDGET_H
#define SKGSEARCHPLUGINWIDGET_H
/** @file
* A skrooge plugin to search and process operations
*
* @author Stephane MANKOWSKI
*/
#include "ui_skgsearchpluginwidget_base.h"
#include "skgtabpage.h"
#include "skgruleobject.h"

/**
 * A skrooge plugin to search and process operations
 */
class SKGSearchPluginWidget : public SKGTabPage
{
    Q_OBJECT
    /**
     * This enumerate defines the open mode
     */
    Q_ENUMS(OpenMode)
public:
    /**
     * This enumerate defines the open mode
     */
    enum OpenMode {TABLE,   /**< open in a table*/
                   REPORT   /**< open in report page*/
                  };

public:
    /**
     * Default Constructor
     */
    explicit SKGSearchPluginWidget(SKGDocument* iDocument);

    /**
     * Default Destructor
     */
    virtual ~SKGSearchPluginWidget();

    /**
     * Get the current selection
     * @return selected objects
     */
    virtual SKGObjectBase::SKGListSKGObjectBase getSelectedObjects();

    /**
     * Get the number of seleted object
     * @return number of selected objects
     */
    virtual int getNbSelectedObjects();

    /**
     * Get the current state
     * MUST BE OVERWRITTEN
     * @return a string containing all information needed to set the same state.
     * Could be an XML stream
     */
    virtual QString getState();

    /**
     * Set the current state
     * MUST BE OVERWRITTEN
     * @param iState must be interpreted to set the state of the widget
     */
    virtual void setState(const QString& iState);

    /**
     * Get attribute name to save the default state
     * MUST BE OVERWRITTEN
     * @return attribute name to save the default state.
     */
    virtual QString getDefaultStateAttribute();

    /**
     * To know if this page contains an editor. MUST BE OVERWRITTEN
     * @return the editor state
     */
    virtual bool isEditor();

    /**
     * To activate the editor by setting focus on right widget. MUST BE OVERWRITTEN
     */
    virtual void activateEditor();

    /**
     * Get the main widget
     * @return a widget
     */
    virtual QWidget* mainWidget();

    /**
     * Open operations corresponding to a rule
     * @param iRule a rule
     * @param iMode the mode for the open
     */
    static void open(const SKGRuleObject& iRule, OpenMode iMode = TABLE);

protected:
    /**
     * Event filtering
     * @param object object
     * @param event event
     * @return In your reimplementation of this function, if you want to filter the event out, i.e. stop it being handled further, return true; otherwise return false.
     */
    virtual bool eventFilter(QObject* object, QEvent* event);

private Q_SLOTS:
    void dataModified(const QString& iTableName, int iIdTransaction);
    void onAddRule();
    void onModifyRule();
    void onOpen();
    void onSelectionChanged();
    void onTop();
    void onUp();
    void onDown();
    void onBottom();
    void onEditorModified();
    void cleanEditor();

private:
    Q_DISABLE_COPY(SKGSearchPluginWidget)

    QString getXMLActionDefinition();
    Ui::skgsearchplugin_base ui;
};

#endif // SKGSEARCHPLUGINWIDGET_H
