/*
    <one line to give the program's name and a brief idea of what it does.>
    Copyright (C) 2011  Guillaume DE BURE <guillaume.debure@gmail.com>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/


#ifndef SIMULATIONWIDGET_H
#define SIMULATIONWIDGET_H

#include <plasma/applet.h>
#include "skgservices.h"
#include "skgdocumentbank.h"
#include <QGraphicsLinearLayout>
#include <Plasma/DataEngine>
#include <QSignalMapper>


class SimulationWidget : public Plasma::Applet
{

    Q_OBJECT

public:

    /**
     * Default Constructor
     */
    explicit SimulationWidget(QObject* parent, const QVariantList& args);

    /**
     * Default Destructor
     */
    virtual ~SimulationWidget();

    /**
     * Reimplemented from Plasma::Applet
     */
    virtual void init();



private Q_SLOTS:
    /**
     * Opens a new tab with the given account
     * @param accountName The name of the account
     */
    void openAccountTab(QString accountName);

    /**
     * Fetch data from the specified source
     */
    void dataUpdated(const QString& sourceName, const Plasma::DataEngine::Data& engineData);


private:
    /**
     * The primary unit defined for the document
     */
    SKGServices::SKGUnitInfo primary;

    QGraphicsLinearLayout* widgetLayout;

    SKGDocumentBank* doc;

    /**
     * The signal mapper, used to open the account tab
     */
    QSignalMapper* signalMapper;

};

/**
  * For exporting skroogoid as a registered Plasma Applet
  */
K_EXPORT_PLASMA_APPLET(plasma_widget_simulation, SimulationWidget)

#endif // SIMULATIONWIDGET_H
