/*
   Copyright (c) 2020-2021 Laurent Montel <montel@kde.org>

   This library is free software; you can redistribute it and/or modify
   it under the terms of the GNU Library General Public License as published
   by the Free Software Foundation; either version 2 of the License or
   ( at your option ) version 3 or, at the discretion of KDE e.V.
   ( which shall act as a proxy as in section 14 of the GPLv3 ), any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#pragma once

#include <QWidget>

#include "libruqolawidgets_private_export.h"
class ChannelNameValidLineEdit;
class QCheckBox;
class KPasswordLineEdit;
class AddUsersWidget;
class QFormLayout;
class QLineEdit;
class RocketChatAccount;
class LIBRUQOLAWIDGETS_TESTS_EXPORT CreateNewChannelWidget : public QWidget
{
    Q_OBJECT
public:
    enum class Feature {
        None = 0,
        BroadCast = 1,
        Encrypted = 2,
    };
    Q_DECLARE_FLAGS(Features, Feature)
    Q_FLAG(Features)

    explicit CreateNewChannelWidget(RocketChatAccount *account, QWidget *parent = nullptr);
    ~CreateNewChannelWidget() override;

    Q_REQUIRED_RESULT QString channelName() const;
    Q_REQUIRED_RESULT QStringList users() const;
    Q_REQUIRED_RESULT bool encryptedRoom() const;
    Q_REQUIRED_RESULT bool privateChannel() const;
    Q_REQUIRED_RESULT bool broadCast() const;
    Q_REQUIRED_RESULT bool readOnly() const;
    Q_REQUIRED_RESULT QString password() const;
    Q_REQUIRED_RESULT QString topic() const;

    void setFeatures(CreateNewChannelWidget::Features features);
Q_SIGNALS:
    void updateOkButton(bool state);

private:
    void slotChangeOkButtonEnabled(bool state);
    ChannelNameValidLineEdit *const mChannelName;
    AddUsersWidget *const mUsers;
    QCheckBox *const mReadOnly;
    QCheckBox *const mBroadcast;
    QCheckBox *const mPrivate;
    QCheckBox *const mEncryptedRoom;
    KPasswordLineEdit *const mPasswordLineEdit;
    QLineEdit *const mTopicLineEdit;
    QFormLayout *const mMainLayout;
};

