// SPDX-FileCopyrightText: 2021 Carson Black <uhhadd@gmail.com>
// SPDX-License-Identifier: GPL-3.0-or-later

import Qt.labs.platform 1.1 as Labs

import QtQuick 2.15
import QtQuick.Controls 2.12 as QQC2
import QtQuick.Layouts 1.10
import org.kde.kirigami 2.15 as Kirigami
import QtQuick.Window 2.15
import org.kde.kalendar 1.0

Labs.MenuBar {
    id: bar
    property var parentWindow: null
    property var mode: KalendarApplication.Event

    Labs.Menu {
        title: i18nc("@action:menu", "File")

        NativeMenuItemFromAction {
            kalendarAction: 'import_calendar'
        }

        Labs.MenuItem {
            text: i18nc("@action:menu", "Quit Kalendar")
            icon.name: "application-exit"
            shortcut: StandardKey.Quit
            onTriggered: Qt.quit()
        }
    }
    EditMenu {
        id: editMenu
        title: i18nc("@action:menu", "Edit")
        Connections {
            target: parentWindow
            function onActiveFocusItemChanged() {
                if (parentWindow.activeFocusItem instanceof TextEdit || parentWindow.activeFocusItem instanceof TextInput) {
                    editMenu.field = parentWindow.activeFocusItem;
                }
            }
        }
        field: null
    }
    Labs.Menu {
        title: i18nc("@action:menu", "View")

        NativeMenuItemFromAction {
            kalendarAction: 'open_month_view'
        }

        NativeMenuItemFromAction {
            kalendarAction: 'open_week_view'
        }

        NativeMenuItemFromAction {
            kalendarAction: "open_threeday_view"
        }

        NativeMenuItemFromAction {
            kalendarAction: "open_day_view"
        }

        NativeMenuItemFromAction {
            kalendarAction: 'open_schedule_view'
        }

        NativeMenuItemFromAction {
            kalendarAction: 'open_todo_view'
        }

        NativeMenuItemFromAction {
            kalendarAction: 'open_contact_view'
        }

        NativeMenuItemFromAction {
            kalendarAction: 'open_kcommand_bar'
        }

        Labs.MenuSeparator {
        }

        Labs.Menu {
            title: i18nc("@action:menu", "Sort Tasks")
            enabled: mode === KalendarApplication.Todo

            NativeMenuItemFromAction {
                kalendarAction: 'todoview_sort_by_due_date'
            }

            NativeMenuItemFromAction {
                kalendarAction: 'todoview_sort_by_priority'
            }

            NativeMenuItemFromAction {
                kalendarAction: 'todoview_sort_alphabetically'
            }

            Labs.MenuSeparator {
            }

            NativeMenuItemFromAction {
                kalendarAction: 'todoview_order_ascending'
            }

            NativeMenuItemFromAction {
                kalendarAction: 'todoview_order_descending'
            }
        }

        NativeMenuItemFromAction {
            kalendarAction: 'todoview_show_completed'
            enabled: mode === KalendarApplication.Todo
        }

        Labs.MenuSeparator {
        }

        NativeMenuItemFromAction {
            text: switch(mode) {
            case KalendarApplication.Contact:
                return i18n('Refresh All Address Books')
            default:
                return i18n('Refresh All Calendars')
            }
            kalendarAction: "refresh_all"
        }
    }

    Labs.Menu {
        title: i18nc("@action:menu", "Go")

        NativeMenuItemFromAction {
            kalendarAction: "move_view_backwards"
            enabled: mode === KalendarApplication.Event
        }
        NativeMenuItemFromAction {
            kalendarAction: "move_view_forwards"
            enabled: mode === KalendarApplication.Event
        }

        Labs.MenuSeparator {}

        NativeMenuItemFromAction {
            kalendarAction: "move_view_to_today"
            enabled: mode === KalendarApplication.Event
        }
        NativeMenuItemFromAction {
            kalendarAction: "open_date_changer"
            enabled: mode === KalendarApplication.Event
        }
    }

    Labs.Menu {
        title: i18nc("@action:menu", "Create")

        NativeMenuItemFromAction {
            kalendarAction: 'create_event'
        }

        NativeMenuItemFromAction {
            kalendarAction: 'create_todo'
        }
    }
    Labs.Menu {
        title: i18nc("@action:menu", "Window")

        Labs.MenuItem {
            text: root.visibility === Window.FullScreen ? i18nc("@action:menu", "Exit Full Screen") : i18nc("@action:menu", "Enter Full Screen")
            icon.name: "view-fullscreen"
            shortcut: "F11"
            onTriggered: root.visibility === Window.FullScreen ? root.showNormal() : root.showFullScreen()
        }
    }
    Labs.Menu {
        title: i18nc("@action:menu", "Settings")

        NativeMenuItemFromAction {
            kalendarAction: 'toggle_menubar'
            visible: !globalMenuLoader.active
        }
        NativeMenuItemFromAction {
            kalendarAction: 'open_tag_manager'
        }
        Labs.MenuSeparator {
        }
        NativeMenuItemFromAction {
            kalendarAction: 'options_configure_keybinding'
        }
        NativeMenuItemFromAction {
            kalendarAction: 'options_configure'
        }
    }
    Labs.Menu {
        title: i18nc("@action:menu", "Help")

        NativeMenuItemFromAction {
            kalendarAction: 'open_about_page'
            enabled: pageStack.layers.currentItem.objectName != "aboutPage"
        }

        Labs.MenuItem {
            text: i18nc("@action:menu", "Kalendar Handbook") // todo
            visible: false
        }
    }
}

