/*
 * SPDX-FileCopyrightText: 2020 Han Young <hanyoung@protonmail.com>
 * SPDX-FileCopyrightText: 2020 Devin Lin <espidev@gmail.com>
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 */

import QtQuick 2.12
import QtQuick.Controls 2.4
import QtQuick.Layouts 1.2
import org.kde.kirigami 2.12 as Kirigami

Kirigami.ScrollablePage {
    property int yTranslate: 0
    property alias pageIndex: forecastView.currentIndex

    id: page
    title: forecastView.count == 0 ? i18n("Forecast") : weatherLocationListModel.get(forecastView.currentIndex).name
    
    // desktop actions
    actions.contextualActions: [
        Kirigami.Action {
            iconName: "view-refresh"
            onTriggered: weatherLocationListModel.get(forecastView.currentIndex).update()
        },
        Kirigami.Action {
            iconName: "arrow-left"
            onTriggered: forecastView.currentIndex--
            enabled: forecastView.currentIndex > 0
        },
        Kirigami.Action {
            iconName: "arrow-right"
            onTriggered: forecastView.currentIndex++
            enabled: forecastView.currentIndex < forecastView.count-1
        }
    ]

    // individual locations
    SwipeView {
        id: forecastView
        anchors.fill: parent
        transform: Translate { y: yTranslate }
        opacity: mainItem.opacity
        
        Repeater {
            id: forecastViewRepeater
            model: weatherLocationListModel
            anchors.fill: parent

            Loader {
                id: locationLoader
                property bool inView: SwipeView.isCurrentItem
                onInViewChanged: {
                    locationLoader.item["inView"] = inView;
                }

                Component.onCompleted: init()

                function init(){
                    updateForecastStyle();
                    locationLoader.item["inView"] = locationLoader.inView;
                }

                function updateForecastStyle() {
                    if (settingsModel.forecastStyle === "Dynamic") {
                        console.log("loaded dynamic view");
                        locationLoader.setSource("DynamicLocationForecast.qml", {"weatherLocation": location});
                    } else { // "Flat"
                        console.log("loaded flat view");
                        locationLoader.setSource("FlatLocationForecast.qml", {"weatherLocation": location});
                    }
                    locationLoader.item["inView"] = inView;
                }
                
                Connections {
                    target: settingsModel
                    function onForecastStyleChanged() {
                        updateForecastStyle();
                    }
                }
            }
        }
    }
    
    // HACK: the swipeview being the only element causes some sort of freeze
    Item {}
}


