/***************************************************************************
                          kscribbleview.h  -  description
                             -------------------
    begin                : Fri Jul 23 08:25:10 CEST 1999

    copyright            : (C) 1999 by Ralf Nolden
    email                : Ralf.Nolden@post.rwth-aachen.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef KSCRIBBLEVIEW_H
#define KSCRIBBLEVIEW_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include files for Qt
#include <qwidget.h>
#include <qpen.h>
#include <qpoint.h>
#include <qpixmap.h>
#include <qstring.h>
#include <qpointarray.h>

class KScribbleDoc;

/** The KScribbleView class provides the view widget for the KScribbleApp instance.	
	* The View instance inherits QWidget as a base class and represents the view object of a KTMainWindow. As KScribbleView is part of the
	* docuement-view model, it needs a reference to the document object connected with it by the KScribbleApp class to manipulate and display
	* the document structure provided by the KScribbleDoc class.
 	* 	
 	* @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team.
	* @version KDevelop version 0.4 code generation
 	*/
class KScribbleView : public QWidget
{
  Q_OBJECT

public:
  /** Constructor for the main view */
  KScribbleView(QWidget* parent = 0, const char* name=0);
  /** Destructor for the main view */
  ~KScribbleView();

	/** returns a pointer to the document connected to the view instance. Mind that this method requires a KScribbleApp instance as a parent
		* widget to get to the window document pointer by calling the KScribbleApp::getDocument() method.
		*
		* @see KScribbleApp#getDocument
		*/
	KScribbleDoc* getDocument() const;
	
  /** contains the implementation for printing functionality */
	void print(QPrinter* m_pPrinter);
	
	
	void setPenColor( const QColor &c ){ pen.setColor( c ); }

  void setPenWidth( int w ){ pen.setWidth( w ); }

  void setPenStyle( PenStyle s){ pen.setStyle(s);}

  QColor penColor(){ return pen.color(); }

  int penWidth(){ return pen.width(); }

  void clearScreen();

protected:
  void mousePressEvent( QMouseEvent *e );
  void mouseReleaseEvent( QMouseEvent *e );
  void mouseMoveEvent( QMouseEvent *e );
  void resizeEvent( QResizeEvent *e );
  void paintEvent( QPaintEvent *e );

  QPen pen;
  QPointArray polyline;

  bool mousePressed;

  QPixmap buffer;
		
private:
	
};

#endif // KSCRIBBLEVIEW_H














