/* GCompris
 *
 * Copyright (C) 2015 Bruno Coudoin <bruno.coudoin@gcompris.net>
 *
 * Authors:
 *   Bruno Coudoin <bruno.coudoin@gcompris.net> (GTK+ version)
 *   Pulkit Gupta <pulkitgenius@gmail.com> (Qt Quick port)
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, see <https://www.gnu.org/licenses/>.
 */
import QtQuick 2.6

QtObject {
    property string instruction: qsTr("Southern Africa")
    property var levels: [
    {
        "pixmapfile": "africa/all_south_africa.png",
        "type": "SHAPE_BACKGROUND_IMAGE"
    },
    {
        "pixmapfile": "africa/zimbabwe.png",
        "soundFile": "voices-$CA/$LOCALE/geography/zimbabwe.$CA",
        "toolTipText": qsTr("Zimbabwe"),
        "x": "0.515",
        "y": "0.554"
    },
    {
        "pixmapfile": "africa/zambia.png",
        "soundFile": "voices-$CA/$LOCALE/geography/zambia.$CA",
        "toolTipText": qsTr("Zambia"),
        "x": "0.5",
        "y": "0.426"
    },
    {
        "pixmapfile": "africa/uganda.png",
        "soundFile": "voices-$CA/$LOCALE/geography/uganda.$CA",
        "toolTipText": qsTr("Uganda"),
        "x": "0.599",
        "y": "0.105"
    },
    {
        "pixmapfile": "africa/tanzania.png",
        "soundFile": "voices-$CA/$LOCALE/geography/tanzania.$CA",
        "toolTipText": qsTr("Tanzania"),
        "x": "0.658",
        "y": "0.279"
    },
    {
        "pixmapfile": "africa/swaziland.png",
        "soundFile": "voices-$CA/$LOCALE/geography/swaziland.$CA",
        "toolTipText": qsTr("Swaziland"),
        "x": "0.559",
        "y": "0.717"
    },
    {
        "pixmapfile": "africa/south_africa.png",
        "soundFile": "voices-$CA/$LOCALE/geography/south_africa.$CA",
        "toolTipText": qsTr("South Africa"),
        "x": "0.436",
        "y": "0.757"
    },
    {
        "pixmapfile": "africa/rwanda.png",
        "soundFile": "voices-$CA/$LOCALE/geography/rwanda.$CA",
        "toolTipText": qsTr("Rwanda"),
        "x": "0.555",
        "y": "0.188"
    },
    {
        "pixmapfile": "africa/republic_of_congo.png",
        "soundFile": "voices-$CA/$LOCALE/geography/republic_of_congo.$CA",
        "toolTipText": qsTr("Republic of Congo"),
        "x": "0.228",
        "y": "0.143"
    },
    {
        "pixmapfile": "africa/namibia.png",
        "soundFile": "voices-$CA/$LOCALE/geography/namibia.$CA",
        "toolTipText": qsTr("Namibia"),
        "x": "0.298",
        "y": "0.632"
    },
    {
        "pixmapfile": "africa/mozambique.png",
        "soundFile": "voices-$CA/$LOCALE/geography/mozambique.$CA",
        "toolTipText": qsTr("Mozambique"),
        "x": "0.66",
        "y": "0.551"
    },
    {
        "pixmapfile": "africa/malawi.png",
        "soundFile": "voices-$CA/$LOCALE/geography/malawi.$CA",
        "toolTipText": qsTr("Malawi"),
        "x": "0.636",
        "y": "0.435"
    },
    {
        "pixmapfile": "africa/madagascar.png",
        "soundFile": "voices-$CA/$LOCALE/geography/madagascar.$CA",
        "toolTipText": qsTr("Madagascar"),
        "x": "0.886",
        "y": "0.56"
    },
    {
        "pixmapfile": "africa/lesotho.png",
        "soundFile": "voices-$CA/$LOCALE/geography/lesotho.$CA",
        "toolTipText": qsTr("Lesotho"),
        "x": "0.509",
        "y": "0.779"
    },
    {
        "pixmapfile": "africa/kenya.png",
        "soundFile": "voices-$CA/$LOCALE/geography/kenya.$CA",
        "toolTipText": qsTr("Kenya"),
        "x": "0.721",
        "y": "0.127"
    },
    {
        "pixmapfile": "africa/gabon.png",
        "soundFile": "voices-$CA/$LOCALE/geography/gabon.$CA",
        "toolTipText": qsTr("Gabon"),
        "x": "0.162",
        "y": "0.161"
    },
    {
        "pixmapfile": "africa/equatorial_guinea.png",
        "soundFile": "voices-$CA/$LOCALE/geography/equatorial_guinea.$CA",
        "toolTipText": qsTr("Equatorial Guinea"),
        "x": "0.134",
        "y": "0.103"
    },
    {
        "pixmapfile": "africa/democratic_republic_of_congo.png",
        "soundFile": "voices-$CA/$LOCALE/geography/democratic_republic_of_congo.$CA",
        "toolTipText": qsTr("Democratic Republic of Congo"),
        "x": "0.377",
        "y": "0.223"
    },
    {
        "pixmapfile": "africa/burundi.png",
        "soundFile": "voices-$CA/$LOCALE/geography/burundi.$CA",
        "toolTipText": qsTr("Burundi"),
        "x": "0.553",
        "y": "0.225"
    },
    {
        "pixmapfile": "africa/botswana.png",
        "soundFile": "voices-$CA/$LOCALE/geography/botswana.$CA",
        "toolTipText": qsTr("Botswana"),
        "x": "0.43",
        "y": "0.627"
    },
    {
        "pixmapfile": "africa/angola.png",
        "soundFile": "voices-$CA/$LOCALE/geography/angola.$CA",
        "toolTipText": qsTr("Angola"),
        "x": "0.296",
        "y": "0.388"
    }
    ]
}
