/*
    SPDX-FileCopyrightText: 2015 Martin Gräßlin <mgraesslin@kde.org>
    SPDX-FileCopyrightText: 2015 Marco Martin <mart@kde.org>

    SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
*/
#ifndef KWAYLAND_SERVER_CONTRAST_INTERFACE_H
#define KWAYLAND_SERVER_CONTRAST_INTERFACE_H

#include "global.h"
#include "resource.h"

#include <QObject>

#include <KWayland/Server/kwaylandserver_export.h>

namespace KWayland
{
namespace Server
{
class Display;

/**
 * @brief Represents the Global for org_kde_kwin_contrast_manager interface.
 *
 * This class creates ContrastInterfaces and attaches them to SurfaceInterfaces.
 *
 * @see ContrastInterface
 * @see SurfaceInterface
 * @since 5.5
 **/
class KWAYLANDSERVER_EXPORT ContrastManagerInterface : public Global
{
    Q_OBJECT
public:
    ~ContrastManagerInterface() override;

private:
    explicit ContrastManagerInterface(Display *display, QObject *parent = nullptr);
    friend class Display;
    class Private;
};

/**
 * @brief Represents the Resource for the org_kde_kwin_contrast interface.
 *
 * Instances of this class are only generated by the ContrastManagerInterface.
 * The ContrastInterface gets attached to a SurfaceInterface and can be assessed
 * from there using @link SurfaceInterface::contrast() @endlink. Please note that
 * the ContrastInterface is only available on the SurfaceInterface after it has been
 * committed.
 *
 * @see ContrastManagerInterface
 * @see SurfaceInterface
 * @since 5.5
 **/
class KWAYLANDSERVER_EXPORT ContrastInterface : public Resource
{
    Q_OBJECT
public:
    ~ContrastInterface() override;

    QRegion region() const;
    qreal contrast() const;
    qreal intensity() const;
    qreal saturation() const;

private:
    explicit ContrastInterface(ContrastManagerInterface *parent, wl_resource *parentResource);
    friend class ContrastManagerInterface;

    class Private;
    Private *d_func() const;
};

}
}

#endif
