/* ============================================================
 *
 * This file is a part of digiKam project
 * https://www.digikam.org
 *
 * Date        : 2007-02-06
 * Description : Setup view panel for dplugins.
 *
 * SPDX-FileCopyrightText: 2018-2024 by Gilles Caulier <caulier dot gilles at gmail dot com>
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 *
 * ============================================================ */

#ifndef SHOW_FOTO_SETUP_PLUGINS_H
#define SHOW_FOTO_SETUP_PLUGINS_H

// Qt includes

#include <QScrollArea>

namespace ShowFoto
{

class ShowfotoSetupPlugins : public QScrollArea
{
    Q_OBJECT

public:

    enum PluginTab
    {
        Generic = 0,
        Editor,
        Loaders
    };

public:

    explicit ShowfotoSetupPlugins(QWidget* const parent = nullptr);
    ~ShowfotoSetupPlugins() override;

    void setActiveTab(PluginTab tab);
    PluginTab activeTab() const;

    void applySettings();

private:

    class Private;
    Private* const d;
};

} // namespace ShowFoto

#endif // SHOW_FOTO_SETUP_PLUGINS_H
