/*  This file is part of the KDE project
    Copyright (C) 2008 Lukas Appelhans <l.appelhans@gmx.de>
    Copyright (C) 2008 Alessandro Diaferia <alediaferia@gmail.com>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/
#ifndef PKGROUP_H
#define PKGROUP_H

#include "abstractitem.h"

#include <QList>

class Group : public AbstractItem
{
public:
    Group(const QString &title, const QString &internalId, AbstractItem* parent = 0);
    virtual ~Group();

    virtual QVariant data(int column, int datarole);
    virtual bool isGroup() {
        return true;
    }
    virtual QList<AbstractItem*> children();
    virtual AbstractItem* childAt(int) const; // returns the child at the given index (e.g. row)
    virtual void appendChild(AbstractItem*);
    virtual void setTitle(const QString &title);

private:
    QList<AbstractItem*> m_children;
    QString m_title;
    QString m_internalId;
};

#endif /*PKGROUP_H*/
